/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.lda.fragai.SpectrumContainer;
import at.tugraz.genome.lda.vos.SpectrumPointVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.math3.util.Pair;

public class CombinedSpectrumContainer
implements Comparable<CombinedSpectrumContainer> {
    private String lipidClass_;
    private String adduct_;
    private Integer mzTolerance_;
    private ArrayList<SpectrumContainer> containers_;

    public CombinedSpectrumContainer(String lipidClass, String adduct, Integer mzTolerance) {
        this.lipidClass_ = lipidClass;
        this.adduct_ = adduct;
        this.mzTolerance_ = mzTolerance;
        this.containers_ = new ArrayList();
    }

    protected boolean isViableData() {
        HashSet<Double> uniqueMolMasses = new HashSet<Double>();
        Integer count = 0;
        for (SpectrumContainer container : this.containers_) {
            uniqueMolMasses.add(container.getEntry().computeTheoreticalPrecursorMZValue(this.adduct_));
            for (Integer level : container.getScanNrLevelHash().values()) {
                if (level != 2) continue;
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
        }
        return count > 2 && uniqueMolMasses.size() > 1;
    }

    protected void addContainerCopy(SpectrumContainer container) {
        if (container.getEntry().getLipidClass().equalsIgnoreCase(this.lipidClass_) && container.getAdduct().getAdductName().equalsIgnoreCase(this.adduct_)) {
            SpectrumContainer newContainer = new SpectrumContainer(container);
            for (Integer scanNr : newContainer.getScanNrLevelHash().keySet()) {
                ArrayList<Integer> scans = new ArrayList<Integer>();
                scans.add(scanNr);
                ArrayList<SpectrumPointVO> dataPoints = this.clearData(newContainer.getProcessedSpectrum(scanNr));
                newContainer.setProcessedSpectrum(scanNr, dataPoints);
            }
            this.containers_.add(newContainer);
        }
    }

    private ArrayList<SpectrumPointVO> clearData(ArrayList<SpectrumPointVO> dataPoints) {
        ArrayList<SpectrumPointVO> clearedData = new ArrayList<SpectrumPointVO>();
        SpectrumPointVO max = new SpectrumPointVO("", 0.0f);
        for (SpectrumPointVO vo : dataPoints) {
            if (vo.getIntensity() > 0.0f) {
                if (!(vo.getIntensity() > max.getIntensity())) continue;
                max = vo;
                continue;
            }
            if (!(max.getIntensity() > 0.0f)) continue;
            clearedData.add(max);
            max = new SpectrumPointVO("", 0.0f);
        }
        return clearedData;
    }

    protected ArrayList<SpectrumPointVO> computeCombinedSpectrum() {
        ArrayList<SpectrumPointVO> combined = new ArrayList<SpectrumPointVO>();
        HashMap<Pair<Double, Double>, ArrayList<SpectrumPointVO>> groups = new HashMap<Pair<Double, Double>, ArrayList<SpectrumPointVO>>();
        int countScan = 0;
        for (SpectrumContainer container : this.containers_) {
            for (Integer scanNr : container.getScanNrLevelHash().keySet()) {
                if (container.getScanNrLevelHash().get(scanNr) != 2) continue;
                ++countScan;
                ArrayList<SpectrumPointVO> processedSpectrum = container.getProcessedSpectrum(scanNr);
                float highestInt = 0.0f;
                for (SpectrumPointVO spectrumPointVO : processedSpectrum) {
                    highestInt = highestInt < spectrumPointVO.getIntensity() ? spectrumPointVO.getIntensity() : highestInt;
                }
                boolean added = false;
                for (SpectrumPointVO point3 : processedSpectrum) {
                    ArrayList bins = new ArrayList(groups.keySet());
                    for (int i = 0; i < bins.size(); ++i) {
                        Pair bin = (Pair)bins.get(i);
                        if (!((Double)bin.getFirst() <= (double)point3.getMz()) || !((Double)bin.getSecond() >= (double)point3.getMz())) continue;
                        this.addPointToBin(bin, groups, point3, highestInt);
                        added = true;
                    }
                    if (added) continue;
                    this.addPointToBin(null, groups, point3, highestInt);
                }
            }
        }
        System.out.println(countScan);
        System.out.println(countScan / 2 + 1);
        for (Pair bin : groups.keySet()) {
            ArrayList points = (ArrayList)groups.get(bin);
            if (points.size() <= countScan / 2 + 1) continue;
            float averageMZ = 0.0f;
            float averageIntensity = 0.0f;
            for (SpectrumPointVO point : points) {
                averageMZ += point.getMz();
                averageIntensity += point.getIntensity();
            }
            SpectrumPointVO averaged = new SpectrumPointVO(averageMZ /= (float)points.size(), averageIntensity /= (float)points.size());
            combined.add(averaged);
        }
        Collections.sort(combined);
        ArrayList<SpectrumPointVO> combinedTemp = new ArrayList<SpectrumPointVO>();
        HashMap<Pair<Double, Double>, ArrayList<SpectrumPointVO>> groupsTemp = new HashMap<Pair<Double, Double>, ArrayList<SpectrumPointVO>>();
        for (SpectrumContainer container : this.containers_) {
            float precursorMz = new Float(container.getEntry().computeTheoreticalPrecursorMZValue(this.adduct_)).floatValue();
            for (Integer scanNr : container.getScanNrLevelHash().keySet()) {
                if (container.getScanNrLevelHash().get(scanNr) != 2) continue;
                ArrayList<SpectrumPointVO> arrayList = container.getProcessedSpectrum(scanNr);
                float highestInt = 0.0f;
                for (SpectrumPointVO point : arrayList) {
                    highestInt = highestInt < point.getIntensity() ? point.getIntensity() : highestInt;
                }
                boolean added = false;
                for (SpectrumPointVO pointUnadjusted : arrayList) {
                    SpectrumPointVO point = new SpectrumPointVO(precursorMz - pointUnadjusted.getMz(), pointUnadjusted.getIntensity());
                    ArrayList bins2 = new ArrayList(groupsTemp.keySet());
                    for (int i = 0; i < bins2.size(); ++i) {
                        Pair bin = (Pair)bins2.get(i);
                        if (!((Double)bin.getFirst() <= (double)point.getMz()) || !((Double)bin.getSecond() >= (double)point.getMz())) continue;
                        this.addPointToBin(bin, groupsTemp, point, highestInt);
                        added = true;
                    }
                    if (added) continue;
                    this.addPointToBin(null, groupsTemp, point, highestInt);
                }
            }
        }
        System.out.println(countScan);
        System.out.println(countScan / 2 + 1);
        for (Pair bin : groupsTemp.keySet()) {
            ArrayList points = (ArrayList)groupsTemp.get(bin);
            if (points.size() <= countScan / 2 + 1) continue;
            float averageMZ = 0.0f;
            float averageIntensity = 0.0f;
            for (SpectrumPointVO point : points) {
                averageMZ += point.getMz();
                averageIntensity += point.getIntensity();
            }
            SpectrumPointVO spectrumPointVO = new SpectrumPointVO(averageMZ /= (float)points.size(), averageIntensity /= (float)points.size());
            combinedTemp.add(spectrumPointVO);
        }
        Collections.sort(combinedTemp);
        combined.addAll(combinedTemp);
        return combined;
    }

    private void addPointToBin(Pair<Double, Double> bin, HashMap<Pair<Double, Double>, ArrayList<SpectrumPointVO>> groups, SpectrumPointVO newPoint, float highestInt) {
        SpectrumPointVO adjustedInt = new SpectrumPointVO(newPoint.getMz(), newPoint.getIntensity() / highestInt);
        if (bin != null) {
            ArrayList<SpectrumPointVO> points = groups.get(bin);
            groups.remove(bin);
            points.add(adjustedInt);
            float sumMz = 0.0f;
            for (SpectrumPointVO point : points) {
                sumMz += point.getMz();
            }
            float averageMz = sumMz / (float)points.size();
            Pair<Double, Double> newBin = this.computeLowerUpperPair(averageMz);
            groups.put(newBin, points);
        } else {
            ArrayList<SpectrumPointVO> points = new ArrayList<SpectrumPointVO>();
            points.add(adjustedInt);
            Pair<Double, Double> newBin = this.computeLowerUpperPair(adjustedInt.getMz());
            groups.put(newBin, points);
        }
    }

    private Pair<Double, Double> computeLowerUpperPair(float mz) {
        Double tolerance = this.computeTolerance(mz);
        Double lowerLimit = (double)mz - tolerance;
        Double upperLimit = (double)mz + tolerance;
        return new Pair<Double, Double>(lowerLimit, upperLimit);
    }

    private Double computeTolerance(float mz) {
        return mz / 1000000.0f * (float)this.mzTolerance_.intValue();
    }

    public String getLipidClass() {
        return this.lipidClass_;
    }

    public String getAdduct() {
        return this.adduct_;
    }

    @Override
    public int compareTo(CombinedSpectrumContainer other) {
        return Comparator.comparing(CombinedSpectrumContainer::getLipidClass).thenComparing(CombinedSpectrumContainer::getAdduct).compare(this, other);
    }
}

