/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.QuantificationThread;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.IntensityChainVO;
import at.tugraz.genome.lda.msn.vos.IntensityPositionVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.maspectras.quantification.CgAreaStatus;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.Probe3D;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.util.Pair;
import org.dhatim.fastexcel.VisibilityState;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Worksheet;

public class QuantificationResultExporter {
    public static final int EXCEL_SHEET_CHAR_LIMIT = 31;
    public static final String SHEET_CONSTANTS = "About";
    public static final String SHEET_LIPID_CLASS_LOOKUP = "Lipid (sub)classes";
    public static final String ADDUCT_MSN_SHEET = " - MSn";
    public static final String ADDUCT_OMEGA_SHEET = " - Omega";
    public static final String ADDUCT_OVERVIEW_SHEET = " - Overview";
    public static final int HEADER_ROW = 0;
    public static final String HEADER_SPECIES = "Species";
    public static final String HEADER_AREA = "Area";
    public static final String HEADER_ISOTOPE = "Isotope";
    public static final String HEADER_INDEX = "Index";
    public static final String HEADER_NAME = "Name";
    public static final String HEADER_DBS = "Dbs";
    public static final String HEADER_OMEGA_POSITION = "MS1 assigned omega-DB position";
    public static final String HEADER_MODIFICATION = "Modification";
    public static final String HEADER_FORMULA = "Formula";
    public static final String HEADER_MOD_FORMULA = "Mod-Formula";
    public static final String HEADER_RT = "RT";
    public static final String HEADER_AREA_ERROR = "AreaError";
    public static final String HEADER_BACKGROUND = "Background";
    public static final String HEADER_CHARGE = "Charge";
    public static final String HEADER_MZ_MS1 = "Mz";
    public static final String HEADER_MZ_TOLERANCE = "MzTolerance";
    public static final String HEADER_PEAK = "Peak";
    public static final String HEADER_LOWER_VALLEY = "LowerValley";
    public static final String HEADER_UPPER_VALLEY = "UpperValley";
    public static final String HEADER_LOWER_MZ = "LowMz";
    public static final String HEADER_UPPER_MZ = "UpMz";
    public static final String HEADER_ELL_CENT_TIME = "EllCentTime";
    public static final String HEADER_ELL_CENT_MZ = "EllCentMz";
    public static final String HEADER_ELL_STRETCH_TIME = "EllStretchTime";
    public static final String HEADER_ELL_STRETCH_MZ = "EllStretchMz";
    public static final String HEADER_LOWER_RT_HARD_LIMIT = "LowerRtHardLimit";
    public static final String HEADER_UPPER_RT_HARD_LIMIT = "UpperRtHardLimit";
    public static final String HEADER_PERCENTAL_SPLIT = "PercentalSplit";
    public static final String HEADER_RAW_APEX = "Raw Apex";
    public static final String HEADER_LOWER_VALLEY10PC = "LValley10%";
    public static final String HEADER_LOWER_VALLEY50PC = "LValley50%";
    public static final String HEADER_UPPER_VALLEY50PC = "UValley50%";
    public static final String HEADER_UPPER_VALLEY10PC = "UValley10%";
    public static final String HEADER_LOWER_MZ10PC = "LMz10%";
    public static final String HEADER_LOWER_MZ50PC = "LMz50%";
    public static final String HEADER_UPPER_MZ50PC = "UMz50%";
    public static final String HEADER_UPPER_MZ10PC = "UMz10%";
    public static final String HEADER_MS_LEVEL = "level=";
    public static final String HEADER_ALEX123_MSN_TARGETS_USED = "AlexMSnTargetsUsed";
    public static final String HEADER_IDENTIFIER = "Identifier";
    public static final String HEADER_MOLECULAR_SPECIES = "Molecular Species";
    public static final String HEADER_DOUBLE_BOND_POSITION_LEVEL = "Double Bond Position Level";
    public static final String HEADER_ASSIGNED = "Assigned";
    public static final String HEADER_EXPECTED_RT = "Expected RT / min";
    public static final String HEADER_ACCURACY = "Accuracy";
    public static final String HEADER_MZ = "m/z";
    public static final int MSN_ROW_FRAGMENT_NAME = 0;
    public static final int MSN_ROW_FRAGMENT_FORMULA = 1;
    public static final int MSN_ROW_FRAGMENT_OH = 1;
    public static final int MSN_ROW_FRAGMENT_CHAIN_TYPE = 2;
    public static final int MSN_ROW_FRAGMENT_MSLEVEL = 2;
    public static final int MSN_ROW_FRAGMENT_CHARGE = 3;
    public static final int MSN_ROW_FRAGMENT_MZ = 4;
    public static final int MSN_ROW_FRAGMENT_MZ_TOLERANCE = 5;
    public static final int MSN_ROW_FRAGMENT_AREA = 6;
    public static final int MSN_ROW_FRAGMENT_PEAK = 7;
    public static final int MSN_ROW_FRAGMENT_TIME_LOWER = 8;
    public static final int MSN_ROW_FRAGMENT_TIME_UPPER = 9;
    public static final int MSN_ROW_FRAGMENT_MZ_LOWER = 10;
    public static final int MSN_ROW_FRAGMENT_MZ_UPPER = 11;
    public static final int MSN_ROW_FRAGMENT_ELLIPSE_TIME = 12;
    public static final int MSN_ROW_FRAGMENT_ELLIPSE_MZ = 13;
    public static final int MSN_ROW_FRAGMENT_ELLIPSE_TIME_RANGE = 14;
    public static final int MSN_ROW_FRAGMENT_ELLIPSE_MZ_RANGE = 15;
    public static final int MSN_ROW_INTENSITY_RULE = 0;
    public static final int MSN_ROW_INTENSITY_ORIGINAL = 1;
    public static final int MSN_ROW_INTENSITY_VALUES = 2;
    public static final int MSN_ROW_INTENSITY_MISSED = 3;
    private static int amountOfIsotopes_;
    private static boolean hasMSnInformation_;
    private static boolean hasOmegaInformation_;
    private static boolean hasOhInformation_;
    private static double totalArea_;

    public static void writeResultsToExcel(String filePath, QuantificationResult quantRes) throws ExportException {
        QuantificationResultExporter.writeResultsToExcel(filePath, quantRes, null);
    }

    public static void writeResultsToExcel(String filePath, QuantificationResult quantRes, Hashtable<String, Boolean> bestMatchBySpectrumCoverage) throws ExportException {
        ArrayList<LipidParameterSet> removeElements = new ArrayList<LipidParameterSet>();
        for (String string : quantRes.getIdentifications().keySet()) {
            if (!string.contains("ox")) continue;
            for (LipidParameterSet param1 : quantRes.getIdentifications().get(string)) {
                boolean remove = false;
                if (!(param1 instanceof LipidomicsMSnSet)) continue;
                LipidomicsMSnSet msn_param1 = (LipidomicsMSnSet)param1;
                for (int msnp1 : msn_param1.getMsnRetentionTimes().get(2).keySet()) {
                    for (String string2 : quantRes.getIdentifications().keySet()) {
                        if (string2.contains("ox")) continue;
                        for (LipidParameterSet param2 : quantRes.getIdentifications().get(string2)) {
                            if (!(param2 instanceof LipidomicsMSnSet)) continue;
                            LipidomicsMSnSet msn_param2 = (LipidomicsMSnSet)param2;
                            for (int msnp2 : msn_param2.getMsnRetentionTimes().get(2).keySet()) {
                                if (msnp1 != msnp2) continue;
                                remove = true;
                            }
                        }
                    }
                }
                if (!remove) continue;
                removeElements.add(param1);
            }
            for (LipidParameterSet element : removeElements) {
                quantRes.getIdentifications().get(string).remove(element);
            }
        }
        Hashtable<Integer, Vector> duplicates = new Hashtable<Integer, Vector>();
        for (String lipidClass : quantRes.getIdentifications().keySet()) {
            if (!lipidClass.contains("ox") || bestMatchBySpectrumCoverage == null || !bestMatchBySpectrumCoverage.containsKey(lipidClass) || !bestMatchBySpectrumCoverage.get(lipidClass).booleanValue()) continue;
            for (int index = 0; index < quantRes.getIdentifications().get(lipidClass).size() - 1; ++index) {
                LipidParameterSet lms = quantRes.getIdentifications().get(lipidClass).get(index);
                if (!(lms instanceof LipidomicsMSnSet)) continue;
                LipidomicsMSnSet lmn = (LipidomicsMSnSet)lms;
                for (int key3 : lmn.getMsnRetentionTimes().keySet()) {
                    LinkedHashMap<Integer, Float> scan_rt_pair = lmn.getMsnRetentionTimes().get(key3);
                    Iterator iterator = scan_rt_pair.keySet().iterator();
                    while (iterator.hasNext()) {
                        Vector vlps;
                        int key2 = (Integer)iterator.next();
                        if (duplicates.containsKey(key2)) {
                            vlps = (Vector)duplicates.get(key2);
                            vlps.add(new Pair<String, Integer>(lipidClass, index));
                        } else {
                            vlps = new Vector();
                            vlps.add(new Pair<String, Integer>(lipidClass, index));
                        }
                        duplicates.put(key2, vlps);
                    }
                }
            }
        }
        Iterator iterator = duplicates.keySet().iterator();
        while (iterator.hasNext()) {
            LipidomicsMSnSet lps;
            int key4 = (Integer)iterator.next();
            Vector vlps = (Vector)duplicates.get(key4);
            if (vlps.size() <= 1) continue;
            float minDiff = 100.0f;
            float maxCoverage = 0.0f;
            float minMods = 0.0f;
            LipidomicsMSnSet bestMatch = null;
            for (Pair pair : vlps) {
                lps = (LipidomicsMSnSet)quantRes.getIdentifications().get(pair.getKey()).get((Integer)pair.getValue());
                float theoMz = lps.Mz[0];
                float evMz = lps.getIsotopicProbes().get((int)0).get((int)0).Mz;
                float diff = Math.abs(theoMz - evMz);
                float coverage = lps.getCoverage();
                int mods = 0;
                String oxState = lps.getOxState();
                if (!oxState.equals("")) {
                    Pattern p = Pattern.compile("(\\d+)");
                    Matcher m = p.matcher(oxState);
                    if (m.find()) {
                        mods = Integer.parseInt(m.group());
                        while (m.find()) {
                            mods = Integer.parseInt(m.group());
                        }
                    } else {
                        mods = 1;
                    }
                }
                if (coverage > maxCoverage) {
                    maxCoverage = coverage;
                    bestMatch = lps;
                    minDiff = diff;
                    minMods = mods;
                    continue;
                }
                if (coverage == maxCoverage && (float)mods == minMods) {
                    if (!(diff < minDiff)) continue;
                    bestMatch = lps;
                    minDiff = diff;
                    continue;
                }
                if (coverage != maxCoverage || !((float)mods < minMods)) continue;
                bestMatch = lps;
                minMods = mods;
                minDiff = diff;
            }
            for (Pair pair : vlps) {
                lps = (LipidomicsMSnSet)quantRes.getIdentifications().get(pair.getKey()).get((Integer)pair.getValue());
                if (lps == bestMatch) continue;
                Hashtable<Integer, LinkedHashMap<Integer, Float>> scans = lps.getMsnRetentionTimes();
                scans.get(2).remove(key4);
                lps.setMsnRetentionTimes(scans);
                if (lps.getMsnRetentionTimes().get(2).isEmpty()) {
                    lps = null;
                }
                quantRes.getIdentifications().get(pair.getKey()).set((Integer)pair.getValue(), lps);
            }
        }
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(filePath));){
            String s = "2.11.1";
            Workbook wb = new Workbook(bufferedOutputStream, "Lipid Data Analyzer", s.substring(0, s.indexOf(".", s.indexOf(".") + 1)));
            boolean hasRtInfo = QuantificationThread.hasRtInfo(quantRes.getIdentifications());
            LipidomicsConstants constants = quantRes.getConstants();
            if (constants != null) {
                Worksheet ws = wb.newWorksheet(SHEET_CONSTANTS);
                List<Pair<String, String>> propertyRows = constants.getPropertyRowList(quantRes.getFaHydroxyEncoding(), quantRes.getLcbHydroxyEncoding());
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(propertyRows.get(0).getKey());
                arrayList.add(propertyRows.get(0).getValue());
                QuantificationResultExporter.createHeader(ws, arrayList);
                QuantificationResultExporter.writeConstants(ws, propertyRows);
            }
            TreeMap<String, String> sheetNameLookup = new TreeMap<String, String>();
            if (QuantificationResultExporter.isSheetNameOverlength(new ArrayList<String>(quantRes.getIdentifications().keySet()))) {
                Worksheet ws = wb.newWorksheet(SHEET_LIPID_CLASS_LOOKUP);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("ID");
                arrayList.add("Full name");
                QuantificationResultExporter.createHeader(ws, arrayList);
                Integer count = 1;
                for (String sheetName : quantRes.getIdentifications().keySet()) {
                    sheetNameLookup.put(sheetName, count.toString());
                    ws.value((int)count, 0, count.toString());
                    ws.value((int)count, 1, sheetName);
                    Integer diff = count;
                    Integer coverage = count = Integer.valueOf(count + 1);
                }
            }
            for (String string : quantRes.getIdentifications().keySet()) {
                Vector<LipidParameterSet> params = quantRes.getIdentifications().get(string);
                QuantificationResultExporter.iterateParamsForClassVariables(params);
                boolean alex123TargetsUsed = constants.getAlexTargetlistUsed().containsKey(string) && constants.getAlexTargetlistUsed().get(string) != false;
                int msLevel = 1;
                if (quantRes.getMsLevels() != null && quantRes.getMsLevels().containsKey(string)) {
                    msLevel = quantRes.getMsLevels().get(string);
                }
                Worksheet[] sheetsForClass = QuantificationResultExporter.createRequiredSheetsForClass(wb, sheetNameLookup.isEmpty() ? string : (String)sheetNameLookup.get(string));
                Worksheet resultSheet = sheetsForClass[0];
                Worksheet resultSheetMSn = sheetsForClass[1];
                Worksheet resultSheetOmega = sheetsForClass[2];
                Worksheet resultSheetOverview = sheetsForClass[3];
                List<String> mS1HeaderTitles = QuantificationResultExporter.createMS1HeaderTitles(hasOhInformation_, hasRtInfo, msLevel);
                List<String> omegaHeaderTitles = null;
                List<String> overviewHeaderTitles = null;
                QuantificationResultExporter.createHeader(resultSheet, mS1HeaderTitles);
                if (resultSheetMSn != null && alex123TargetsUsed) {
                    QuantificationResultExporter.createHeaderCell(resultSheetMSn, 0, 0, String.format("%s=true", HEADER_ALEX123_MSN_TARGETS_USED));
                }
                if (resultSheetOmega != null) {
                    omegaHeaderTitles = QuantificationResultExporter.createOmegaHeaderTitles();
                    QuantificationResultExporter.createHeader(resultSheetOmega, omegaHeaderTitles);
                }
                if (resultSheetOverview != null) {
                    overviewHeaderTitles = QuantificationResultExporter.createOverviewHeaderTitles();
                    QuantificationResultExporter.createHeader(resultSheetOverview, overviewHeaderTitles);
                }
                int resultCount = 1;
                int ms1RowCount = 0;
                int msnRowCount = 1;
                int omegaRowCount = 1;
                for (LipidParameterSet param : params) {
                    if (param == null) continue;
                    ms1RowCount = QuantificationResultExporter.writeEvidenceMS1(ms1RowCount, resultCount, resultSheet, param, mS1HeaderTitles);
                    if (param instanceof LipidomicsMSnSet) {
                        msnRowCount = QuantificationResultExporter.writeEvidenceMSn(msnRowCount, resultSheetMSn, (LipidomicsMSnSet)param, quantRes.getFaHydroxyEncoding(), quantRes.getLcbHydroxyEncoding());
                    }
                    if (param.hasOmegaInformation()) {
                        omegaRowCount = QuantificationResultExporter.writeEvidenceOmega(omegaRowCount, resultSheetOmega, param, omegaHeaderTitles);
                    }
                    if (Settings.isOverviewInExcelDesired()) {
                        QuantificationResultExporter.writeEvidenceOverview(resultCount, resultSheetOverview, param, overviewHeaderTitles);
                    }
                    ++resultCount;
                }
            }
            wb.finish();
        }
        catch (IOException iOException) {
            throw new ExportException(iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ExportException(exception.getMessage());
        }
    }

    private static boolean isSheetNameOverlength(ArrayList<String> sheetNames) {
        int longestSuffixLength = ADDUCT_OVERVIEW_SHEET.length();
        int max = 31 - longestSuffixLength;
        for (String name : sheetNames) {
            if (name.length() <= max) continue;
            return true;
        }
        return false;
    }

    private static void iterateParamsForClassVariables(Vector<LipidParameterSet> params) {
        amountOfIsotopes_ = 0;
        hasMSnInformation_ = false;
        hasOmegaInformation_ = false;
        hasOhInformation_ = false;
        for (LipidParameterSet param : params) {
            if (param == null) continue;
            int maxIso = param.getIsotopicProbes().size();
            if (maxIso > amountOfIsotopes_) {
                amountOfIsotopes_ = maxIso;
            }
            if (param instanceof LipidomicsMSnSet) {
                hasMSnInformation_ = true;
            }
            if (param.hasOmegaInformation()) {
                hasOmegaInformation_ = true;
            }
            if (param.getOhNumber() <= -1) continue;
            hasOhInformation_ = true;
        }
    }

    private static Worksheet[] createRequiredSheetsForClass(Workbook wb, String className) {
        Worksheet resultSheet = wb.newWorksheet(className);
        Worksheet resultSheetMSn = null;
        Worksheet resultSheetOmega = null;
        Worksheet resultSheetOverview = null;
        if (hasMSnInformation_) {
            resultSheetMSn = wb.newWorksheet(className + ADDUCT_MSN_SHEET);
            resultSheetMSn.setVisibilityState(VisibilityState.HIDDEN);
        }
        if (hasOmegaInformation_) {
            resultSheetOmega = wb.newWorksheet(className + ADDUCT_OMEGA_SHEET);
            resultSheetOmega.setVisibilityState(VisibilityState.HIDDEN);
        }
        if (Settings.isOverviewInExcelDesired()) {
            resultSheetOverview = wb.newWorksheet(className + ADDUCT_OVERVIEW_SHEET);
        }
        return new Worksheet[]{resultSheet, resultSheetMSn, resultSheetOmega, resultSheetOverview};
    }

    private static void createHeader(Worksheet ws, List<String> headerTitles) {
        for (int i = 0; i < headerTitles.size(); ++i) {
            ws.value(0, i, headerTitles.get(i));
        }
        ws.range(0, 0, 0, headerTitles.size()).style().bold().horizontalAlignment("center").fontName("Arial").fontSize(12).set();
    }

    private static List<String> createMS1HeaderTitles(boolean hasOhInfo, boolean hasRtInfo, int msLevel) {
        ArrayList<String> headerTitles = new ArrayList<String>();
        headerTitles.add(HEADER_INDEX);
        headerTitles.add(HEADER_NAME);
        headerTitles.add(HEADER_DBS);
        if (hasOhInfo) {
            headerTitles.add("OH");
        }
        if (hasOmegaInformation_) {
            headerTitles.add(HEADER_OMEGA_POSITION);
        }
        headerTitles.add(HEADER_MODIFICATION);
        headerTitles.add(HEADER_FORMULA);
        headerTitles.add(HEADER_MOD_FORMULA);
        if (hasRtInfo) {
            headerTitles.add(HEADER_RT);
        }
        headerTitles.add(HEADER_ISOTOPE);
        headerTitles.add(HEADER_AREA);
        headerTitles.add(HEADER_AREA_ERROR);
        headerTitles.add(HEADER_BACKGROUND);
        headerTitles.add(HEADER_CHARGE);
        headerTitles.add(HEADER_MZ_MS1);
        headerTitles.add(HEADER_MZ_TOLERANCE);
        headerTitles.add(HEADER_PEAK);
        headerTitles.add(HEADER_LOWER_VALLEY);
        headerTitles.add(HEADER_UPPER_VALLEY);
        headerTitles.add(HEADER_LOWER_MZ);
        headerTitles.add(HEADER_UPPER_MZ);
        headerTitles.add(HEADER_ELL_CENT_TIME);
        headerTitles.add(HEADER_ELL_CENT_MZ);
        headerTitles.add(HEADER_ELL_STRETCH_TIME);
        headerTitles.add(HEADER_ELL_STRETCH_MZ);
        headerTitles.add(HEADER_LOWER_RT_HARD_LIMIT);
        headerTitles.add(HEADER_UPPER_RT_HARD_LIMIT);
        headerTitles.add(HEADER_PERCENTAL_SPLIT);
        headerTitles.add(HEADER_RAW_APEX);
        headerTitles.add(HEADER_LOWER_VALLEY10PC);
        headerTitles.add(HEADER_LOWER_VALLEY50PC);
        headerTitles.add(HEADER_UPPER_VALLEY50PC);
        headerTitles.add(HEADER_UPPER_VALLEY10PC);
        headerTitles.add(HEADER_LOWER_MZ10PC);
        headerTitles.add(HEADER_LOWER_MZ50PC);
        headerTitles.add(HEADER_UPPER_MZ50PC);
        headerTitles.add(HEADER_UPPER_MZ10PC);
        headerTitles.add("PSM");
        headerTitles.add(String.format("%s%s", HEADER_MS_LEVEL, String.valueOf(msLevel)));
        return headerTitles;
    }

    private static List<String> createOmegaHeaderTitles() {
        ArrayList<String> headerTitles = new ArrayList<String>();
        headerTitles.add(HEADER_IDENTIFIER);
        headerTitles.add(HEADER_MOLECULAR_SPECIES);
        headerTitles.add(HEADER_DOUBLE_BOND_POSITION_LEVEL);
        headerTitles.add(HEADER_EXPECTED_RT);
        headerTitles.add(HEADER_ACCURACY);
        headerTitles.add(HEADER_ASSIGNED);
        return headerTitles;
    }

    private static List<String> createOverviewHeaderTitles() {
        ArrayList<String> headerTitles = new ArrayList<String>();
        headerTitles.add(HEADER_SPECIES);
        headerTitles.add(HEADER_AREA);
        if (Settings.isMassInOverviewExcelDesired()) {
            headerTitles.add(HEADER_MZ);
        }
        if (Settings.isIsotopeInOverviewExcelDesired()) {
            for (int i = 0; i != amountOfIsotopes_; ++i) {
                headerTitles.add(String.format("%s %s", HEADER_ISOTOPE, i));
            }
        }
        return headerTitles;
    }

    private static void writeConstants(Worksheet ws, List<Pair<String, String>> propertyRows) {
        for (int row = 1; row < propertyRows.size(); ++row) {
            ws.value(row, 0, propertyRows.get(row).getKey());
            ws.value(row, 1, propertyRows.get(row).getValue());
        }
    }

    private static int writeEvidenceMS1(int row, int resultCount, Worksheet ws, LipidParameterSet param, List<String> headerTitles) {
        Vector<DoubleBondPositionVO> assignedDoubleBondPositionVO;
        int rowFirst = ++row;
        totalArea_ = 0.0;
        Vector<Vector<CgProbe>> isotopicProbes = param.getIsotopicProbes();
        for (int j = 0; j != isotopicProbes.size(); ++j) {
            int chargeState = j;
            Vector<CgProbe> probes = isotopicProbes.get(j);
            float totalIsoArea = 0.0f;
            for (int k = 0; k < probes.size(); ++k) {
                CgProbe probe;
                ++row;
                if (param.getMinIsotope() < 0) {
                    chargeState *= -1;
                }
                boolean areaStatusOK = (probe = probes.get(k)) != null && probe.AreaStatus == CgAreaStatus.OK;
                Probe3D probe3D = null;
                if (probe instanceof Probe3D) {
                    probe3D = (Probe3D)probe;
                }
                totalIsoArea += probe.Area;
                if (areaStatusOK) {
                    ws.value(row, headerTitles.indexOf(HEADER_ISOTOPE), chargeState);
                    ws.value(row, headerTitles.indexOf(HEADER_AREA), QuantificationResultExporter.getDoubleValue(probe.Area));
                    ws.value(row, headerTitles.indexOf(HEADER_AREA_ERROR), QuantificationResultExporter.getDoubleValue(probe.AreaError));
                    ws.value(row, headerTitles.indexOf(HEADER_BACKGROUND), QuantificationResultExporter.getDoubleValue(probe.Background));
                    ws.value(row, headerTitles.indexOf(HEADER_CHARGE), probe.Charge);
                    ws.value(row, headerTitles.indexOf(HEADER_PEAK), QuantificationResultExporter.getDoubleValue(probe.Peak));
                    ws.value(row, headerTitles.indexOf(HEADER_LOWER_VALLEY), QuantificationResultExporter.getDoubleValue(probe.LowerValley));
                    ws.value(row, headerTitles.indexOf(HEADER_UPPER_VALLEY), QuantificationResultExporter.getDoubleValue(probe.UpperValley));
                    if (probe.getLowerValley10() != null) {
                        ws.value(row, headerTitles.indexOf(HEADER_RAW_APEX), QuantificationResultExporter.getDoubleValue(probe.getApexIntensity().floatValue()));
                        ws.value(row, headerTitles.indexOf(HEADER_LOWER_VALLEY10PC), QuantificationResultExporter.getDoubleValue(probe.getLowerValley10().floatValue()));
                        ws.value(row, headerTitles.indexOf(HEADER_LOWER_VALLEY50PC), QuantificationResultExporter.getDoubleValue(probe.getLowerValley50().floatValue()));
                        ws.value(row, headerTitles.indexOf(HEADER_UPPER_VALLEY50PC), QuantificationResultExporter.getDoubleValue(probe.getUpperValley50().floatValue()));
                        ws.value(row, headerTitles.indexOf(HEADER_UPPER_VALLEY10PC), QuantificationResultExporter.getDoubleValue(probe.getUpperValley10().floatValue()));
                    }
                    if (probe3D != null) {
                        ws.value(row, headerTitles.indexOf(HEADER_LOWER_MZ), QuantificationResultExporter.getDoubleValue(probe3D.LowerMzBand));
                        ws.value(row, headerTitles.indexOf(HEADER_UPPER_MZ), QuantificationResultExporter.getDoubleValue(probe3D.UpperMzBand));
                        ws.value(row, headerTitles.indexOf(HEADER_ELL_CENT_TIME), QuantificationResultExporter.getDoubleValue(probe3D.getEllipseTimePosition()));
                        ws.value(row, headerTitles.indexOf(HEADER_ELL_CENT_MZ), QuantificationResultExporter.getDoubleValue(probe3D.getEllipseMzPosition()));
                        ws.value(row, headerTitles.indexOf(HEADER_ELL_STRETCH_TIME), QuantificationResultExporter.getDoubleValue(probe3D.getEllipseTimeStretch()));
                        ws.value(row, headerTitles.indexOf(HEADER_ELL_STRETCH_MZ), QuantificationResultExporter.getDoubleValue(probe3D.getEllipseMzStretch()));
                        if (probe3D.getLowMz10() > -1.0f) {
                            ws.value(row, headerTitles.indexOf(HEADER_LOWER_MZ10PC), QuantificationResultExporter.getDoubleValue(probe3D.getLowMz10()));
                            ws.value(row, headerTitles.indexOf(HEADER_LOWER_MZ50PC), QuantificationResultExporter.getDoubleValue(probe3D.getLowMz50()));
                            ws.value(row, headerTitles.indexOf(HEADER_UPPER_MZ50PC), QuantificationResultExporter.getDoubleValue(probe3D.getUpMz50()));
                            ws.value(row, headerTitles.indexOf(HEADER_UPPER_MZ10PC), QuantificationResultExporter.getDoubleValue(probe3D.getUpMz10()));
                        }
                    }
                } else {
                    ws.value(row, headerTitles.indexOf(HEADER_AREA), new Double(0.0));
                }
                ws.value(row, headerTitles.indexOf(HEADER_MZ_MS1), QuantificationResultExporter.getDoubleValue(probe.Mz));
            }
            totalArea_ += (double)totalIsoArea;
        }
        ws.value(rowFirst, headerTitles.indexOf(HEADER_INDEX), new Integer(resultCount));
        ws.value(rowFirst, headerTitles.indexOf(HEADER_NAME), param.Peptide);
        ws.value(rowFirst, headerTitles.indexOf(HEADER_DBS), String.valueOf(param.getDoubleBonds()));
        if (headerTitles.indexOf("OH") >= 0) {
            ws.value(rowFirst, headerTitles.indexOf("OH"), String.valueOf(param.getOhNumber()));
        }
        if (headerTitles.indexOf(HEADER_OMEGA_POSITION) >= 0 && !(param instanceof LipidomicsMSnSet) && param.hasOmegaInformation() && !(assignedDoubleBondPositionVO = StaticUtils.getAssignedDoubleBondPositions(param.getOmegaInformation())).isEmpty()) {
            int omegaPosition = assignedDoubleBondPositionVO.get(0).getChainCombination().get(0).getOmegaPosition();
            ws.value(rowFirst, headerTitles.indexOf(HEADER_OMEGA_POSITION), String.valueOf(omegaPosition));
        }
        ws.value(rowFirst, headerTitles.indexOf(HEADER_MODIFICATION), param.getModificationName());
        ws.value(rowFirst, headerTitles.indexOf(HEADER_FORMULA), param.getAnalyteFormula());
        ws.value(rowFirst, headerTitles.indexOf(HEADER_MOD_FORMULA), param.getModificationFormula());
        if (headerTitles.indexOf(HEADER_RT) >= 0) {
            ws.style(rowFirst, headerTitles.indexOf(HEADER_RT)).format("0.00").set();
            ws.value(rowFirst, headerTitles.indexOf(HEADER_RT), param.getPreciseRT());
        }
        ws.value(rowFirst, headerTitles.indexOf(HEADER_AREA), totalArea_);
        ws.value(rowFirst, headerTitles.indexOf(HEADER_CHARGE), param.getCharge());
        ws.value(rowFirst, headerTitles.indexOf(HEADER_MZ_MS1), Float.valueOf(param.Mz[0]));
        ws.value(rowFirst, headerTitles.indexOf(HEADER_MZ_TOLERANCE), Float.valueOf(param.LowerMzBand));
        if (param.getLowerRtHardLimit() >= 0.0f) {
            ws.value(rowFirst, headerTitles.indexOf(HEADER_LOWER_RT_HARD_LIMIT), Float.valueOf(param.getLowerRtHardLimit()));
        }
        if (param.getUpperRtHardLimit() >= 0.0f) {
            ws.value(rowFirst, headerTitles.indexOf(HEADER_UPPER_RT_HARD_LIMIT), Float.valueOf(param.getUpperRtHardLimit()));
        }
        if (param.getPercentalSplit() >= 0.0f) {
            ws.value(rowFirst, headerTitles.indexOf(HEADER_PERCENTAL_SPLIT), Float.valueOf(param.getPercentalSplit()));
        }
        if (param.getOxState() != null && !param.getOxState().isEmpty()) {
            ws.value(rowFirst, headerTitles.indexOf("PSM"), param.getOxState());
        }
        return row++;
    }

    private static Double getDoubleValue(float value) {
        Double doubleValue = new Double(value);
        if (doubleValue.isNaN() || doubleValue.isInfinite()) {
            return new Double(0.0);
        }
        return doubleValue;
    }

    private static void writeEvidenceOverview(int row, Worksheet ws, LipidParameterSet param, List<String> headerTitles) {
        Vector<Vector<CgProbe>> isotopicProbes = param.getIsotopicProbes();
        QuantificationResultExporter.createHeaderCell(ws, row, headerTitles.indexOf(HEADER_SPECIES), param.getNamePlusModHumanReadable());
        ws.value(row, headerTitles.indexOf(HEADER_AREA), totalArea_);
        if (Settings.isMassInOverviewExcelDesired()) {
            ws.value(row, headerTitles.indexOf(HEADER_MZ), Float.valueOf(param.Mz[0]));
        }
        if (Settings.isIsotopeInOverviewExcelDesired()) {
            for (int i = 0; i < amountOfIsotopes_; ++i) {
                if (param.getIsotopicProbes().size() <= i) continue;
                Vector<CgProbe> probes = isotopicProbes.get(i);
                float totalIsoArea = 0.0f;
                for (int j = 0; j != probes.size(); ++j) {
                    totalIsoArea += probes.get((int)j).Area;
                }
                ws.value(row, headerTitles.indexOf(String.format("%s %s", HEADER_ISOTOPE, i)), Float.valueOf(totalIsoArea));
            }
        }
    }

    public static int writeEvidenceOmega(int row, Worksheet ws, LipidParameterSet param, List<String> headerTitles) {
        ws.value(row, headerTitles.indexOf(HEADER_IDENTIFIER), param.getNamePlusModHumanReadable());
        Vector<DoubleBondPositionVO> paramOmegaInfo = param.getOmegaInformation();
        for (DoubleBondPositionVO doubleBondPositionVO : paramOmegaInfo) {
            ws.value(row, headerTitles.indexOf(HEADER_MOLECULAR_SPECIES), doubleBondPositionVO.getMolecularSpecies());
            ws.value(row, headerTitles.indexOf(HEADER_DOUBLE_BOND_POSITION_LEVEL), doubleBondPositionVO.getDoubleBondPositionsHumanReadable());
            ws.value(row, headerTitles.indexOf(HEADER_EXPECTED_RT), doubleBondPositionVO.getExpectedRetentionTime());
            ws.value(row, headerTitles.indexOf(HEADER_ACCURACY), doubleBondPositionVO.getAccuracy());
            ws.value(row, headerTitles.indexOf(HEADER_ASSIGNED), doubleBondPositionVO.getIsAssigned());
            ++row;
        }
        return row;
    }

    private static int writeEvidenceMSn(int row, Worksheet ws, LipidomicsMSnSet param, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding) throws RulesException, LipidCombinameEncodingException, ChemicalFormulaException {
        Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posRules;
        Hashtable<String, IntensityChainVO> rules;
        Iterator<IntensityChainVO> fa;
        Hashtable<String, Hashtable<String, CgProbe>> chainFragments;
        int count = row;
        int nameRow = count++;
        int areaRow = nameRow + 1;
        QuantificationResultExporter.createHeaderCell(ws, nameRow, 0, param.getNamePlusModHumanReadable());
        ws.value(areaRow, 0, param.Area);
        ++count;
        Hashtable<String, CgProbe> headGroupFragments = param.getHeadGroupFragments();
        if (headGroupFragments.size() > 0) {
            QuantificationResultExporter.createHeaderCell(ws, count++, 0, "Head group fragments");
            QuantificationResultExporter.writeMSnFragmentHeader(ws, count++, (short)-1);
            for (String name : headGroupFragments.keySet()) {
                QuantificationResultExporter.writeMSnFragment(ws, count++, name, headGroupFragments.get(name), (short)-1, -1);
            }
            Hashtable<String, IntensityRuleVO> headIntRules = param.getHeadIntensityRules();
            if (headIntRules.size() > 0) {
                QuantificationResultExporter.createHeaderCell(ws, count++, 0, "Head group rules");
                QuantificationResultExporter.writeMSnIntensityHeader(ws, count++);
                Hashtable uniqueRules = new Hashtable();
                for (IntensityRuleVO ruleVO : headIntRules.values()) {
                    if (!QuantificationResultExporter.writeMSnIntensity(ws, count, ruleVO, param, uniqueRules, faHydroxyEncoding, lcbHydroxyEncoding)) continue;
                    ++count;
                }
            }
        }
        if ((chainFragments = param.getChainFragments()).size() > 0) {
            QuantificationResultExporter.createHeaderCell(ws, count++, 0, "Chain fragments");
            QuantificationResultExporter.writeMSnFragmentHeader(ws, count++, (short)0);
            for (String faName : chainFragments.keySet()) {
                Hashtable<String, CgProbe> fragments = chainFragments.get(faName);
                for (String name : fragments.keySet()) {
                    fa = StaticUtils.decodeLipidNameForCreatingCombis(faName);
                    String string = StaticUtils.getChainFragmentDisplayName(name, ((FattyAcidVO)((Object)fa)).getCarbonDbsId());
                    QuantificationResultExporter.writeMSnFragment(ws, count++, string, (CgProbe)fragments.get(name), ((FattyAcidVO)((Object)fa)).getChainType(), ((FattyAcidVO)((Object)fa)).getOhNumber());
                }
            }
            Hashtable<String, Hashtable<String, IntensityChainVO>> chainRules = param.getChainIntensityRules();
            if (chainRules.size() > 0) {
                QuantificationResultExporter.createHeaderCell(ws, count++, 0, "Chain rules");
                QuantificationResultExporter.writeMSnIntensityHeader(ws, count++);
                Hashtable uniqueRules = new Hashtable();
                for (String faName : chainRules.keySet()) {
                    rules = chainRules.get(faName);
                    for (IntensityRuleVO intensityRuleVO : rules.values()) {
                        if (!QuantificationResultExporter.writeMSnIntensity(ws, count, intensityRuleVO, param, uniqueRules, faHydroxyEncoding, lcbHydroxyEncoding)) continue;
                        ++count;
                    }
                }
            }
        }
        if ((posRules = param.getPositionEvidence()).size() > 0) {
            for (String combiName : posRules.keySet()) {
                QuantificationResultExporter.createHeaderCell(ws, count++, 0, "Position rules (" + param.getPositionInsensitiveHumanReadableCombiName(combiName) + ")");
                QuantificationResultExporter.writeMSnIntensityHeader(ws, count++);
                Hashtable<String, String> uniqueRules = new Hashtable<String, String>();
                rules = param.getFAsInSequenceAsInRule(combiName);
                fa = ((Vector)((Object)rules)).iterator();
                while (fa.hasNext()) {
                    IntensityRuleVO intensityRuleVO = (IntensityRuleVO)fa.next();
                    if (!QuantificationResultExporter.writeMSnIntensity(ws, count, intensityRuleVO, param, uniqueRules, faHydroxyEncoding, lcbHydroxyEncoding)) continue;
                    ++count;
                }
            }
        }
        int cellCount = 1;
        Vector<DoubleBondPositionVO> assignedDoubleBondPositionVOs = null;
        if (param.hasOmegaInformation()) {
            assignedDoubleBondPositionVOs = StaticUtils.getAssignedDoubleBondPositions(param.getOmegaInformation());
        }
        Vector<String> detected = param.getMSnIdentificationNamesWithSNPositions();
        for (String name : detected) {
            Vector<DoubleBondPositionVO> doubleBondAssignmentsOfMolecularSpecies;
            double d = 0.0;
            d = param.getStatus() == 2 ? (double)param.Area : param.getRelativeIntensity(name) * (double)param.Area;
            if (assignedDoubleBondPositionVOs != null && (doubleBondAssignmentsOfMolecularSpecies = StaticUtils.getDoubleBondAssignmentsOfMolecularSpecies(assignedDoubleBondPositionVOs, name)).size() == 1) {
                name = doubleBondAssignmentsOfMolecularSpecies.get(0).getDoubleBondPositionsHumanReadable();
            }
            QuantificationResultExporter.createHeaderCell(ws, nameRow, cellCount, name);
            ws.value(areaRow, cellCount, d);
            ++cellCount;
        }
        ArrayList<Integer> msLevels = new ArrayList<Integer>(param.getMsnRetentionTimes().keySet());
        Collections.sort(msLevels);
        Iterator iterator = msLevels.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            LinkedHashMap<Integer, Float> rts = param.getMsnRetentionTimes().get(n);
            String rtString = "";
            for (Integer scanNr : rts.keySet()) {
                rtString = rtString + scanNr + "=" + rts.get(scanNr) + ";";
            }
            if (rtString.length() > 0) {
                rtString = rtString.substring(0, rtString.length() - 1);
            }
            QuantificationResultExporter.createHeaderCell(ws, nameRow, cellCount, "MS" + n + " scan RTs");
            ws.value(areaRow, cellCount, rtString);
            ++cellCount;
        }
        return ++count;
    }

    private static void createHeaderCell(Worksheet ws, int row, int column, String value) {
        ws.value(row, column, value);
        ws.style(row, column).bold().horizontalAlignment("center").fontName("Arial").fontSize(12).set();
    }

    private static void writeMSnFragmentHeader(Worksheet ws, int row, short chainType) {
        QuantificationResultExporter.createHeaderCell(ws, row, 0, HEADER_NAME);
        int add = 0;
        if (chainType != -1) {
            QuantificationResultExporter.createHeaderCell(ws, row, 1, "OH");
            QuantificationResultExporter.createHeaderCell(ws, row, 2, "Chain type");
            add = 2;
        }
        QuantificationResultExporter.createHeaderCell(ws, row, 1 + add, HEADER_FORMULA);
        QuantificationResultExporter.createHeaderCell(ws, row, 2 + add, "msLevel");
        QuantificationResultExporter.createHeaderCell(ws, row, 3 + add, HEADER_CHARGE);
        QuantificationResultExporter.createHeaderCell(ws, row, 4 + add, HEADER_MZ_MS1);
        QuantificationResultExporter.createHeaderCell(ws, row, 5 + add, HEADER_MZ_TOLERANCE);
        QuantificationResultExporter.createHeaderCell(ws, row, 6 + add, HEADER_AREA);
        QuantificationResultExporter.createHeaderCell(ws, row, 7 + add, HEADER_PEAK);
        QuantificationResultExporter.createHeaderCell(ws, row, 8 + add, HEADER_LOWER_VALLEY);
        QuantificationResultExporter.createHeaderCell(ws, row, 9 + add, HEADER_UPPER_VALLEY);
        QuantificationResultExporter.createHeaderCell(ws, row, 10 + add, HEADER_LOWER_MZ);
        QuantificationResultExporter.createHeaderCell(ws, row, 11 + add, HEADER_UPPER_MZ);
        QuantificationResultExporter.createHeaderCell(ws, row, 12 + add, HEADER_ELL_CENT_TIME);
        QuantificationResultExporter.createHeaderCell(ws, row, 13 + add, HEADER_ELL_CENT_MZ);
        QuantificationResultExporter.createHeaderCell(ws, row, 14 + add, HEADER_ELL_STRETCH_TIME);
        QuantificationResultExporter.createHeaderCell(ws, row, 15 + add, HEADER_ELL_STRETCH_MZ);
    }

    private static void writeMSnFragment(Worksheet ws, int row, String name, CgProbe probe, short chainType, int oh) throws ChemicalFormulaException {
        ws.value(row, 0, name);
        int add = 0;
        if (chainType != -1) {
            ws.value(row, 1, oh);
            ws.value(row, 2, StaticUtils.getHumanReadableChainType(chainType));
            add = 2;
        }
        String formula = "";
        if (probe.getFormula() != null) {
            formula = StaticUtils.getFormulaInHillNotation(StaticUtils.categorizeFormula(probe.getFormula().trim()), true);
        }
        ws.value(row, 1 + add, formula);
        ws.value(row, 2 + add, probe.getMsLevel());
        ws.value(row, 3 + add, probe.Charge);
        ws.value(row, 4 + add, probe.Mz);
        ws.value(row, 5 + add, probe.LowerMzBand);
        ws.value(row, 6 + add, probe.Area);
        ws.value(row, 7 + add, probe.Peak);
        ws.value(row, 8 + add, probe.LowerValley);
        ws.value(row, 9 + add, probe.UpperValley);
        if (probe instanceof Probe3D) {
            Probe3D probe3D = (Probe3D)probe;
            ws.value(row, 10 + add, probe3D.LowerMzBand);
            ws.value(row, 11 + add, probe3D.UpperMzBand);
            ws.value(row, 12 + add, probe3D.getEllipseTimePosition());
            ws.value(row, 13 + add, probe3D.getEllipseMzPosition());
            ws.value(row, 14 + add, probe3D.getEllipseTimeStretch());
            ws.value(row, 15 + add, probe3D.getEllipseMzStretch());
        }
    }

    private static void writeMSnIntensityHeader(Worksheet ws, int row) {
        ws.value(row, 0, "Rule");
        ws.value(row, 1, "Original");
        ws.value(row, 2, "Values");
        ws.value(row, 3, "Missed");
    }

    private static boolean writeMSnIntensity(Worksheet ws, int row, IntensityRuleVO ruleVO, LipidomicsMSnSet param, Hashtable<String, String> uniqueRules, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding) throws RulesException, LipidCombinameEncodingException {
        String ruleInterpretation = ruleVO.getReadableRuleInterpretation(faHydroxyEncoding, lcbHydroxyEncoding);
        String rule = ruleVO.getRuleIdentifier();
        Hashtable<String, Float> fragmentAreas = param.getFragmentAreas(ruleVO);
        Hashtable<String, String> missedFragments = new Hashtable<String, String>();
        for (String string : fragmentAreas.keySet()) {
            if (!(fragmentAreas.get(string).floatValue() < 0.0f)) continue;
            missedFragments.put(string, string);
            fragmentAreas.put(string, Float.valueOf(0.0f));
        }
        String missed = "";
        for (String name : missedFragments.keySet()) {
            missed = missed + name + ";";
        }
        if (missed.length() > 0) {
            missed = missed.substring(0, missed.length() - 1);
        }
        String string = ruleVO.getRuleValueInterpretation(fragmentAreas, Float.valueOf(param.getBasePeak(ruleVO)));
        String uniqueId = ruleInterpretation + ";" + rule + ";" + string;
        if (uniqueRules.containsKey(uniqueId)) {
            return false;
        }
        uniqueRules.put(uniqueId, uniqueId);
        ws.value(row, 0, ruleInterpretation);
        ws.value(row, 1, rule);
        ws.value(row, 2, string);
        ws.value(row, 3, missed);
        return true;
    }
}

