/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.ClassNamesExtractor;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleStringVO;
import at.tugraz.genome.lda.vos.ResultFileVO;
import at.tugraz.genome.voutils.GeneralComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.Sheet;

public class ComparativeNameExtractor
extends ClassNamesExtractor {
    protected String isSelectionPrefix_;
    protected String esSelectionPrefix_;
    protected Hashtable<String, String> expNames_ = new Hashtable();
    protected Vector<String> expNamesInSequence_ = new Vector();
    protected Vector<String> groups_;
    protected Hashtable<String, Hashtable<String, String>> allISNames_;
    protected Hashtable<String, Hashtable<String, String>> allESNames_;
    protected Hashtable<String, Vector<File>> filesOfGroup_;
    protected Vector<ResultFileVO> resultFileVO_;
    protected Hashtable<String, File> expNameToFile_ = new Hashtable();
    private Hashtable<String, Vector<String>> sortedISNames_;
    private Hashtable<String, Vector<String>> sortedESNames_;
    private Hashtable<String, String> lipidClassesHash_;
    protected Vector<String> expNameCut1_;
    protected Vector<String> expNameCut2_;
    int charsToCut_ = 0;
    int charsToCutPrev_ = 0;

    public ComparativeNameExtractor(Vector<File> resultFiles, String isSelectionPrefix, String esSelectionPrefix) {
        super(resultFiles);
        this.isSelectionPrefix_ = isSelectionPrefix != null && isSelectionPrefix.length() > 0 ? isSelectionPrefix : null;
        this.esSelectionPrefix_ = esSelectionPrefix != null && esSelectionPrefix.length() > 0 ? esSelectionPrefix : null;
        this.groups_ = null;
    }

    public ComparativeNameExtractor(Vector<File> resultFiles, String isSelectionPrefix, String esSelectionPrefix, Vector<String> groups, Hashtable<String, Vector<File>> filesOfGroup) {
        this(resultFiles, isSelectionPrefix, esSelectionPrefix);
        this.groups_ = groups;
        this.filesOfGroup_ = filesOfGroup;
    }

    @Override
    protected void extractInformation(int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        this.expNameCut1_ = new Vector();
        this.expNameCut2_ = new Vector();
        if (this.resultFiles_.size() > 1) {
            Vector<String> expNameFull = new Vector<String>();
            for (Object resultFile : this.resultFiles_) {
                String fileName = StaticUtils.extractFileName(((File)resultFile).getAbsolutePath());
                expNameFull.add(fileName.substring(0, fileName.lastIndexOf(".")));
            }
            int[] limits = StaticUtils.detectNameUnequalitiesBeforeAndAfter(expNameFull);
            this.charsToCutPrev_ = limits[0];
            this.charsToCut_ = limits[1];
            for (String expName : expNameFull) {
                this.expNameCut1_.add(expName.substring(0, expName.length() - this.charsToCut_));
                this.expNameCut2_.add(expName.substring(this.charsToCutPrev_, expName.length() - this.charsToCut_));
            }
        }
        this.allISNames_ = new Hashtable();
        this.allESNames_ = new Hashtable();
        this.sortedISNames_ = new Hashtable();
        this.sortedESNames_ = new Hashtable();
        this.lipidClassesHash_ = new Hashtable();
        this.lipidClasses_ = new Vector();
        this.resultFileVO_ = new Vector();
        for (int i = 0; i != this.resultFiles_.size(); ++i) {
            File resultFile = (File)this.resultFiles_.get(i);
            String fileName = StaticUtils.extractFileName(resultFile.getAbsolutePath());
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            if (this.expNameCut1_.size() > 0) {
                this.expNames_.put(this.expNameCut1_.get(i), this.expNameCut2_.get(i));
                fileName = this.expNameCut1_.get(i);
            } else {
                this.expNames_.put(fileName, fileName);
            }
            this.expNameToFile_.put(fileName, resultFile);
            this.expNamesInSequence_.add(fileName);
            this.parseResultFile(resultFile, fileName, statisticsViewMode, combineOxWithNonOx);
        }
        this.buildResultHashes();
        for (String className : this.sortedISNames_.keySet()) {
            this.sortedISNames_.put(className, this.sortLipidNames(this.sortedISNames_.get(className)));
            this.sortedESNames_.put(className, this.sortLipidNames(this.sortedESNames_.get(className)));
        }
    }

    protected void buildResultHashes() {
    }

    protected void parseResultFile(File resultFile, String fileName, int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        if (!resultFile.getAbsolutePath().endsWith(".xlsx")) {
            new WarningMessage(new JFrame(), "ERROR", "The specified file format is not supported!");
            throw new ExcelInputFileException("The specified file format is not supported!");
        }
        this.parseResultFileFastExcel(resultFile, fileName, statisticsViewMode, combineOxWithNonOx);
    }

    protected void parseResultFileFastExcel(File resultFile, String fileName, int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        try (FileInputStream is = new FileInputStream(resultFile);
             ReadableWorkbook wb = new ReadableWorkbook(is);
             Stream<Sheet> sheets = wb.getSheets();){
            sheets.filter(s -> !s.getName().equals("About") && !s.getName().endsWith(" - Omega") && !s.getName().endsWith(" - Overview") && !s.getName().endsWith(" - MSn")).forEach(s -> this.parseSheet((Sheet)s));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            new WarningMessage(new JFrame(), "ERROR", ex.getMessage());
            throw new ExcelInputFileException(ex);
        }
    }

    protected void parseSheet(Sheet sheet) {
        Hashtable<Object, Object> isNames = new Hashtable();
        Hashtable<Object, Object> esNames = new Hashtable();
        Vector<Object> sortedIS = new Vector();
        Vector<Object> sortedES = new Vector();
        String groupName = sheet.getName();
        if (this.lipidClassesHash_.containsKey(groupName)) {
            isNames = this.allISNames_.get(groupName);
            esNames = this.allESNames_.get(groupName);
            sortedIS = this.sortedISNames_.get(groupName);
            sortedES = this.sortedESNames_.get(groupName);
        } else {
            this.lipidClasses_.add(groupName);
            this.lipidClassesHash_.put(groupName, groupName);
        }
        List<Row> rows = null;
        try {
            rows = sheet.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Row headerRow = rows.get(0);
        List<String> headerTitles = LDAResultReader.readSheetHeaderTitles(headerRow);
        List<Row> contentRows = rows.subList(1, rows.size());
        for (Row row : contentRows) {
            List cells = row.stream().filter(c -> c != null && !c.getType().equals((Object)CellType.ERROR)).collect(Collectors.toList());
            String name = null;
            int dbs = -1;
            String oxState = "";
            for (Cell cell : cells) {
                int index = cell.getColumnIndex();
                String rawValue = cell.getRawValue();
                if (index == headerTitles.indexOf("Name")) {
                    name = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Dbs")) {
                    dbs = (int)Float.parseFloat(rawValue);
                    continue;
                }
                if (index != headerTitles.indexOf("PSM")) continue;
                oxState = rawValue;
            }
            if (name == null || name.length() <= 0) continue;
            Integer doubleBonds = null;
            if (dbs > -1) {
                doubleBonds = dbs;
            } else if (!headerTitles.contains("Modification")) {
                Object[] components = ComparativeNameExtractor.splitOldNameStringToComponents(name);
                name = (String)components[0];
                doubleBonds = (Integer)components[1];
            }
            name = StaticUtils.generateLipidNameString(name, doubleBonds, -1, oxState);
            if (this.isSelectionPrefix_ != null && name.startsWith(this.isSelectionPrefix_)) {
                if (isNames.containsKey(name)) continue;
                isNames.put(name, name);
                sortedIS.add(name);
                continue;
            }
            if (this.esSelectionPrefix_ == null || !name.startsWith(this.esSelectionPrefix_) || esNames.containsKey(name)) continue;
            esNames.put(name, name);
            sortedES.add(name);
        }
        this.allISNames_.put(groupName, isNames);
        this.allESNames_.put(groupName, esNames);
        this.sortedISNames_.put(groupName, sortedIS);
        this.sortedESNames_.put(groupName, sortedES);
    }

    public static String removeChemicalFormula(String name) {
        if (name != null && name.contains("_")) {
            return name.substring(0, name.lastIndexOf("_"));
        }
        if (name != null && name.contains(":")) {
            char[] nameChars = name.toCharArray();
            int idx = name.lastIndexOf(":") + 1;
            String returnName = name.substring(0, idx);
            for (int i = idx; i != nameChars.length && Character.isDigit(nameChars[i]); ++i) {
                returnName = returnName + String.valueOf(nameChars[i]);
            }
            return returnName;
        }
        return name;
    }

    protected int findPositionOfItem(String nameToLook, Vector<String> moleculeNames) {
        int position = -1;
        for (int i = 0; i != moleculeNames.size(); ++i) {
            if (!nameToLook.equalsIgnoreCase(moleculeNames.get(i))) continue;
            position = i;
            break;
        }
        return position;
    }

    @Deprecated
    public static Object[] splitOldNameStringToComponents(String fullNameString) {
        Object[] components = new Object[3];
        String name = "";
        Integer doubleBonds = -1;
        String formula = "";
        String nameAndDoubleBond = ComparativeNameExtractor.removeChemicalFormula(fullNameString);
        formula = fullNameString.substring(nameAndDoubleBond.length());
        if (formula.startsWith("_")) {
            formula = formula.substring(1);
        }
        if (nameAndDoubleBond.lastIndexOf(":") != -1) {
            name = nameAndDoubleBond.substring(0, nameAndDoubleBond.lastIndexOf(":"));
            doubleBonds = new Integer(nameAndDoubleBond.substring(nameAndDoubleBond.lastIndexOf(":") + 1));
        } else {
            name = nameAndDoubleBond;
        }
        components[0] = name;
        components[1] = doubleBonds;
        components[2] = formula;
        return components;
    }

    protected Vector<String> sortLipidNames(Vector<String> moleculeNames) {
        Vector<String> moleculeNamesNewOrder;
        boolean containAllDoubleBonds = true;
        boolean containAllRtValues = true;
        if (moleculeNames.size() == 0) {
            containAllDoubleBonds = false;
            containAllRtValues = false;
        }
        for (String molName : moleculeNames) {
            if (molName.lastIndexOf(":") != -1) continue;
            containAllDoubleBonds = false;
            break;
        }
        for (String molName : moleculeNames) {
            boolean isRt = false;
            if (molName.lastIndexOf("_") != -1) {
                try {
                    new Double(molName.substring(molName.lastIndexOf("_") + 1));
                    isRt = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.isSelectionPrefix_ != null && molName.startsWith(this.isSelectionPrefix_) || this.esSelectionPrefix_ != null && molName.startsWith(this.esSelectionPrefix_)) {
                isRt = true;
            }
            if (isRt) continue;
            containAllRtValues = false;
            break;
        }
        if (containAllDoubleBonds) {
            moleculeNamesNewOrder = new Vector<String>();
            Hashtable mainGroupMembers = new Hashtable();
            Hashtable<String, Hashtable> rtMembers = new Hashtable<String, Hashtable>();
            Vector<String> orderMainGroup = new Vector<String>();
            for (String molName : moleculeNames) {
                String mainGroupName = molName.substring(0, molName.lastIndexOf(":"));
                Object sideChainString = molName.substring(molName.lastIndexOf(":") + 1);
                if (containAllRtValues && molName.indexOf("_") != -1) {
                    sideChainString = ((String)sideChainString).substring(0, ((String)sideChainString).lastIndexOf("_"));
                }
                Integer sideChain = null;
                try {
                    sideChain = new Integer((String)sideChainString);
                }
                catch (NumberFormatException nfx) {
                    return moleculeNames;
                }
                DoubleStringVO rt = null;
                if (containAllRtValues && molName.indexOf("_") != -1) {
                    String rtAsString = molName.substring(molName.lastIndexOf("_") + 1);
                    rt = new DoubleStringVO(rtAsString, new Double(rtAsString));
                }
                Set<Integer> groupMembers = new HashSet();
                Hashtable rtHash = new Hashtable();
                if (!mainGroupMembers.containsKey(mainGroupName)) {
                    orderMainGroup.add(mainGroupName);
                } else {
                    groupMembers = (Set)mainGroupMembers.get(mainGroupName);
                    rtHash = (Hashtable)rtMembers.get(mainGroupName);
                }
                groupMembers.add(sideChain);
                mainGroupMembers.put(mainGroupName, groupMembers);
                if (containAllRtValues && molName.indexOf("_") != -1) {
                    Vector rts = new Vector();
                    if (rtHash.containsKey(sideChain)) {
                        rts = (Vector)rtHash.get(sideChain);
                    }
                    rts.add(rt);
                    rtHash.put(sideChain, rts);
                }
                rtMembers.put(mainGroupName, rtHash);
            }
            orderMainGroup = this.sortMainGroup(orderMainGroup);
            for (String mainGroupName : orderMainGroup) {
                Vector members = new Vector((Collection)mainGroupMembers.get(mainGroupName));
                Collections.sort(members);
                for (Integer member : members) {
                    if (!(!containAllRtValues || this.isSelectionPrefix_ != null && mainGroupName.startsWith(this.isSelectionPrefix_) || this.esSelectionPrefix_ != null && mainGroupName.startsWith(this.esSelectionPrefix_))) {
                        Vector rts = new Vector((Collection)((Hashtable)rtMembers.get(mainGroupName)).get(member));
                        Collections.sort(rts, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
                        for (DoubleStringVO rt : rts) {
                            moleculeNamesNewOrder.add(mainGroupName + ":" + String.valueOf(member) + "_" + rt.getKey());
                        }
                        continue;
                    }
                    moleculeNamesNewOrder.add(mainGroupName + ":" + String.valueOf(member));
                }
            }
            moleculeNames = new Vector(moleculeNamesNewOrder);
        } else if (containAllRtValues) {
            moleculeNamesNewOrder = new Vector();
            Hashtable rtMembers = new Hashtable();
            LinkedHashMap<String, String> mainGroupMembers = new LinkedHashMap<String, String>();
            for (String molName : moleculeNames) {
                if (!molName.startsWith(this.isSelectionPrefix_) && !molName.startsWith(this.esSelectionPrefix_)) {
                    String mainGroupName = molName.substring(0, molName.indexOf("_"));
                    String rtAsString = molName.substring(molName.lastIndexOf("_") + 1);
                    DoubleStringVO rt = new DoubleStringVO(rtAsString, new Double(rtAsString));
                    Vector rts = new Vector();
                    if (!mainGroupMembers.containsKey(mainGroupName)) {
                        mainGroupMembers.put(mainGroupName, mainGroupName);
                    } else {
                        rts = (Vector)rtMembers.get(mainGroupName);
                    }
                    rts.add(rt);
                    rtMembers.put(mainGroupName, rts);
                    continue;
                }
                rtMembers.put(molName, new Vector());
            }
            for (String mainGroupName : rtMembers.keySet()) {
                Vector rts = new Vector((Collection)rtMembers.get(mainGroupName));
                if (rts.size() > 0) {
                    Collections.sort(rts, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
                    for (DoubleStringVO rt : rts) {
                        moleculeNamesNewOrder.add(mainGroupName + "_" + rt.getKey());
                    }
                    continue;
                }
                moleculeNamesNewOrder.add(mainGroupName);
            }
            moleculeNames = new Vector(moleculeNamesNewOrder);
        }
        return moleculeNames;
    }

    protected Vector<String> sortMainGroup(Vector<String> mainGroup) {
        Collections.sort(mainGroup);
        return mainGroup;
    }

    public Hashtable<String, String> getExpNames() {
        return this.expNames_;
    }

    public Vector<String> getExpNamesInSequence() {
        return this.expNamesInSequence_;
    }

    public Vector<String> getGroupNames() {
        return this.groups_;
    }

    public Vector<String> getISNames(String className) {
        return this.sortedISNames_.get(className);
    }

    public Vector<String> getAllClassNames() {
        Vector<String> allClassNames = new Vector<String>(this.lipidClassesHash_.keySet());
        Collections.sort(allClassNames);
        return allClassNames;
    }

    public Vector<String> getESNames(String className) {
        return this.sortedESNames_.get(className);
    }

    public File getFullFilePath(String expName) {
        return this.expNameToFile_.get(expName);
    }

    public Vector<ResultFileVO> getResultFileVOs() {
        return this.resultFileVO_;
    }

    public ResultFileVO getResultFileVO(String filePath) {
        for (ResultFileVO vo : this.getResultFileVOs()) {
            if (!vo.getResultFile().getAbsolutePath().equals(filePath)) continue;
            return vo;
        }
        return null;
    }

    protected void disableRtGrouping() {
    }
}

