/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.MSnAnalyzer;
import at.tugraz.genome.lda.msn.MSnPeakSeparator;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.vos.MSnNamingVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.utils.StringFloatVO;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgAreaStatus;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.voutils.GeneralComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class SingleQuantThread
extends Thread {
    private LipidomicsAnalyzer analyzer_;
    private QuantVO quantSet_;
    private int msLevel_;
    private boolean msnFirst_;
    private boolean finished_ = false;
    private String errorString_ = null;
    private boolean msnSpectraPresent_;
    private Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> results_;
    private Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> ms2RemovedHits_;
    private Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> peaksBeforeSplit_;

    public SingleQuantThread(LipidomicsAnalyzer analyzer, QuantVO quantSet, int msLevel, boolean msnFirst) {
        this.analyzer_ = analyzer;
        this.quantSet_ = quantSet;
        this.msLevel_ = msLevel;
        this.msnFirst_ = msnFirst;
        this.finished_ = false;
        this.errorString_ = null;
        this.msnSpectraPresent_ = false;
    }

    @Override
    public void run() {
        try {
            this.ms2RemovedHits_ = new Hashtable();
            this.peaksBeforeSplit_ = new Hashtable();
            this.results_ = this.startSingleQuantification(this.analyzer_, this.quantSet_, this.msLevel_);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorString_ = ex.toString();
        }
        this.finished_ = true;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> startSingleQuantification(LipidomicsAnalyzer analyzer, QuantVO quantSet, int msLevel) throws CgException, LipidCombinameEncodingException {
        System.out.println("massOfInterest: " + quantSet.getAnalyteMass());
        Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> isotopicProbes = null;
        float defaultRelativeAreaCutoff = analyzer.getRelativeAreaCutoff();
        float defaultRelativeFarAreaCutoff = analyzer.getRelativeFarAreaCutoff();
        int peakDiscardingAreaFactor = analyzer.getPeakDiscardingAreaFactor();
        Vector<QuantVO> quantVOs = new Vector<QuantVO>();
        quantVOs.add(quantSet);
        quantVOs.addAll(quantSet.getOtherIsobaricSpecies());
        String cutoff = null;
        for (QuantVO quant : quantVOs) {
            this.ms2RemovedHits_.put(quant, new Hashtable());
            this.peaksBeforeSplit_.put(quant, new Hashtable());
            if (!LipidomicsConstants.isMS2()) continue;
            try {
                String aCutoff = RulesContainer.getMS1PeakCutoff(StaticUtils.getRuleName(quant.getAnalyteClass(), quant.getModName()));
                if (aCutoff == null || !(Float.parseFloat(aCutoff) < analyzer.getRelativeFarAreaCutoff()) || cutoff != null && !(Float.parseFloat(aCutoff) < Float.parseFloat(cutoff))) continue;
                cutoff = aCutoff;
            }
            catch (NoRuleException aCutoff) {
            }
            catch (RulesException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SpectrummillParserException e) {
                e.printStackTrace();
            }
        }
        if (cutoff != null) {
            float cut = Float.parseFloat(cutoff);
            int peakDiscardingFactor = (int)(1.0f / cut);
            analyzer.setAreaCutoffs(cut, cut, peakDiscardingFactor, true);
        }
        if (this.msnFirst_) {
            try {
                Vector<Float> rts = new Vector<Float>();
                MSnAnalyzer msnAnalyzer = null;
                for (QuantVO quantVO : quantVOs) {
                    float tol = LipidomicsConstants.getMs2PrecursorTolerance((float)quantVO.getAnalyteMass());
                    msnAnalyzer = new MSnAnalyzer(quantVO.getAnalyteClass(), quantVO.getModName(), quantVO.getAnalyteMass(), tol, quantVO.getAnalyteName(), quantVO.getDbs(), quantVO.getOhNumber(), quantVO.getAnalyteFormula(), quantVO.getModFormula(), quantVO.getCharge(), analyzer, false, quantVOs.size() > 1);
                    rts.addAll(msnAnalyzer.getFoundMatchingSpectraTimes());
                }
                if (rts.size() > 0) {
                    isotopicProbes = analyzer.processByMzProbabsAndPossibleRetentionTime((float)quantSet.getAnalyteMass(), quantSet.getCharge(), rts, quantSet.getUsedMinusTime(), quantSet.getUsedPlusTime(), 1, quantSet.getMustMatchProbabs(), quantSet.getProbabs(), msLevel, quantSet.getNegativeStartValue() < 0);
                } else if (msnAnalyzer != null && msnAnalyzer.areMSnSpectraPresent()) {
                    this.msnSpectraPresent_ = true;
                }
            }
            catch (ChemicalFormulaException | HydroxylationEncodingException | RulesException | SpectrummillParserException | IOException e) {
                e.printStackTrace();
            }
        } else {
            isotopicProbes = LipidomicsConstants.isShotgun() == 1 ? analyzer.processShotgunData((float)quantSet.getAnalyteMass(), quantSet.getCharge(), msLevel, quantSet.getProbabs().size(), quantSet.getMustMatchProbabs()) : (LipidomicsConstants.isShotgun() == 2 ? analyzer.processPrmData((float)quantSet.getAnalyteMass(), quantSet.getCharge(), 2, quantSet.getAnalyteClass(), quantSet.getModName(), StaticUtils.generateLipidNameString(quantSet.getAnalyteName(), (Integer)quantSet.getDbs(), -1, quantSet.getOxState()), quantSet.getAnalyteFormula(), quantSet.getOhNumber(), quantSet.getOxState()) : (quantSet.getIsobaricRetTime_() > 0.0f ? (LipidomicsConstants.use3D() ? analyzer.processByMzProbabsAndPossibleRetentionTime((float)quantSet.getAnalyteMass(), quantSet.getCharge(), quantSet.getIsobaricRetTime_(), quantSet.getIsobaricMinusTime_(), quantSet.getUsedPlusTime(), 1, quantSet.getMustMatchProbabs(), quantSet.getProbabs(), msLevel, quantSet.getNegativeStartValue() < 0) : analyzer.processByMzAndRetentionTime((float)quantSet.getAnalyteMass(), quantSet.getCharge(), quantSet.getIsobaricRetTime_(), quantSet.getIsobaricPlusTime_(), quantSet.getUsedPlusTime(), 1, quantSet.getMustMatchProbabs(), quantSet.getProbabs(), msLevel, quantSet.getNegativeStartValue() < 0)) : (LipidomicsConstants.use3D() ? analyzer.processByMzProbabsAndPossibleRetentionTime((float)quantSet.getAnalyteMass(), quantSet.getCharge(), -1.0f, -1.0f, -1.0f, -1, quantSet.getMustMatchProbabs(), quantSet.getProbabs(), msLevel, quantSet.getNegativeStartValue() < 0) : analyzer.processByMzAndProbabs((float)quantSet.getAnalyteMass(), quantSet.getCharge(), quantSet.getMustMatchProbabs(), quantSet.getProbabs(), msLevel, quantSet.getNegativeStartValue() < 0))));
        }
        Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant = new Hashtable<QuantVO, Hashtable<String, LipidParameterSet>>();
        if (isotopicProbes != null && isotopicProbes.size() > 0) {
            Hashtable isobarsOfAllSpecies = new Hashtable();
            for (Integer n : isotopicProbes.keySet()) {
                Hashtable<Integer, Vector<CgProbe>> oneHit = isotopicProbes.get(n);
                Hashtable<QuantVO, LipidParameterSet> isobars = new Hashtable<QuantVO, LipidParameterSet>();
                for (QuantVO oneSet : quantVOs) {
                    LipidParameterSet param = this.createLipidParameterSet(oneHit, oneSet.getNegativeStartValue(), (float)oneSet.getAnalyteMass(), oneSet.getAnalyteName(), oneSet.getDbs(), oneSet.getOhNumber(), oneSet.getModName(), oneSet.getAnalyteFormula(), oneSet.getModFormula(), oneSet.getCharge());
                    if (LipidomicsConstants.isShotgun() == 1) {
                        this.adaptMzValuesOfShotgunHits(param);
                        isobars.put(oneSet, param);
                        continue;
                    }
                    String rt = param.getRt();
                    float rtValue = Float.parseFloat(rt);
                    if (oneSet.getRetTime() > 0.0f && (rtValue < oneSet.getRetTime() - oneSet.getUsedMinusTime() || rtValue > oneSet.getRetTime() + oneSet.getUsedPlusTime())) continue;
                    isobars.put(oneSet, param);
                }
                if (isobars.size() <= 0) continue;
                isobarsOfAllSpecies.put(n, isobars);
            }
            if (LipidomicsConstants.isMS2()) {
                Hashtable foundForQuantVO = new Hashtable();
                for (QuantVO oneSet : quantVOs) {
                    float tol = LipidomicsConstants.getMs2PrecursorTolerance((float)oneSet.getAnalyteMass());
                    float startMz = (float)oneSet.getAnalyteMass() - tol;
                    float stopMz = (float)oneSet.getAnalyteMass() + tol;
                    float lowestTime = Float.MAX_VALUE;
                    float highestTime = 0.0f;
                    if (LipidomicsConstants.isShotgun() == 1) {
                        lowestTime = 0.0f;
                        highestTime = Float.MAX_VALUE;
                    } else {
                        for (Hashtable isobars : isobarsOfAllSpecies.values()) {
                            if (!isobars.containsKey(oneSet)) continue;
                            LipidParameterSet param = (LipidParameterSet)isobars.get(oneSet);
                            float[] startStop = this.analyzer_.getStartStopTimeFromProbes(param.getIsotopicProbes().get(0));
                            if (startStop[0] < lowestTime) {
                                lowestTime = startStop[0];
                            }
                            if (!(startStop[1] > highestTime)) continue;
                            highestTime = startStop[1];
                        }
                    }
                    analyzer.prepareMSnSpectraCache(startMz, stopMz, lowestTime, highestTime);
                    Hashtable<Integer, LipidParameterSet> sameRt = new Hashtable<Integer, LipidParameterSet>();
                    for (Integer key : isobarsOfAllSpecies.keySet()) {
                        Hashtable isobars = (Hashtable)isobarsOfAllSpecies.get(key);
                        if (!isobars.containsKey(oneSet)) continue;
                        LipidParameterSet param = (LipidParameterSet)isobars.get(oneSet);
                        boolean addHit = true;
                        if (LipidomicsConstants.isMS2()) {
                            try {
                                MSnAnalyzer msnAnalyzer = new MSnAnalyzer(oneSet.getAnalyteClass(), oneSet.getModName(), param, this.analyzer_, oneSet, false, quantVOs.size() > 1);
                                int msIdentOrder = 0;
                                try {
                                    msIdentOrder = RulesContainer.getMSIdentificationOrder(StaticUtils.getRuleName(oneSet.getAnalyteClass(), oneSet.getModName()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (msnAnalyzer.checkStatus() == 1 || msIdentOrder == 2 && msnAnalyzer.checkStatus() < 2) {
                                    addHit = false;
                                } else {
                                    param = msnAnalyzer.getResult();
                                }
                            }
                            catch (RulesException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (SpectrummillParserException e) {
                                e.printStackTrace();
                            }
                            catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                        if (addHit) {
                            sameRt.put(key, param);
                            continue;
                        }
                        try {
                            if (LipidomicsConstants.isShotgun() == 1 || !RulesContainer.isRtPostprocessing(StaticUtils.getRuleName(oneSet.getAnalyteClass(), oneSet.getModName())) || !RulesContainer.correctRtForParallelModel(StaticUtils.getRuleName(oneSet.getAnalyteClass(), oneSet.getModName()))) continue;
                            String rt = param.getRt();
                            this.ms2RemovedHits_.get(oneSet).put(rt, param);
                        }
                        catch (NoRuleException rt) {
                        }
                        catch (RulesException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (SpectrummillParserException e) {
                            e.printStackTrace();
                        }
                    }
                    if (sameRt.size() <= 0) continue;
                    foundForQuantVO.put(oneSet, sameRt);
                }
                Hashtable<Integer, Hashtable> hashtable = new Hashtable<Integer, Hashtable>();
                for (QuantVO oneSet : foundForQuantVO.keySet()) {
                    Hashtable sameRt = (Hashtable)foundForQuantVO.get(oneSet);
                    for (Integer key : sameRt.keySet()) {
                        LipidParameterSet param = (LipidParameterSet)sameRt.get(key);
                        Hashtable isobars = new Hashtable();
                        if (hashtable.containsKey(key)) {
                            isobars = (Hashtable)hashtable.get(key);
                        }
                        isobars.put(oneSet, param);
                        hashtable.put(key, isobars);
                    }
                }
                isobarsOfAllSpecies = hashtable;
            }
            for (Hashtable hashtable : isobarsOfAllSpecies.values()) {
                void var13_33;
                if (hashtable.size() == 1) {
                    boolean addHit = true;
                    QuantVO oneSet = (QuantVO)hashtable.keySet().iterator().next();
                    LipidParameterSet param = (LipidParameterSet)hashtable.get(oneSet);
                    Hashtable<QuantVO, LipidParameterSet> hashtable2 = new Hashtable<QuantVO, LipidParameterSet>();
                    if (LipidomicsConstants.isMS2()) {
                        try {
                            MSnAnalyzer msnAnalyzer = new MSnAnalyzer(oneSet.getAnalyteClass(), oneSet.getModName(), param, this.analyzer_, oneSet, true, false);
                            if (msnAnalyzer.checkStatus() == 1) {
                                addHit = false;
                            } else {
                                param = msnAnalyzer.getResult();
                            }
                        }
                        catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | RulesException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (SpectrummillParserException e) {
                            e.printStackTrace();
                        }
                    }
                    if (addHit) {
                        hashtable2.put(oneSet, param);
                    } else if (LipidomicsConstants.isMS2()) {
                        try {
                            if (LipidomicsConstants.isShotgun() != 1 && RulesContainer.isRtPostprocessing(StaticUtils.getRuleName(oneSet.getAnalyteClass(), oneSet.getModName())) && RulesContainer.correctRtForParallelModel(StaticUtils.getRuleName(oneSet.getAnalyteClass(), oneSet.getModName()))) {
                                this.ms2RemovedHits_.get(oneSet).put(param.getRt(), param);
                            }
                        }
                        catch (NoRuleException e) {
                        }
                        catch (RulesException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (SpectrummillParserException e) {
                            e.printStackTrace();
                        }
                    }
                }
                for (QuantVO quant2 : var13_33.keySet()) {
                    LipidParameterSet set = (LipidParameterSet)var13_33.get(quant2);
                    set.setOxState(quant2.getOxState());
                    Hashtable<Object, Object> hitsOfOneMod = new Hashtable();
                    if (hitsAccordingToQuant.containsKey(quant2)) {
                        hitsOfOneMod = hitsAccordingToQuant.get(quant2);
                    }
                    String rt = "";
                    if (LipidomicsConstants.isShotgun() != 1) {
                        rt = set.getRt();
                    }
                    hitsOfOneMod.put(rt, set);
                    hitsAccordingToQuant.put(quant2, hitsOfOneMod);
                }
            }
        }
        if (quantVOs.size() > 1) {
            HashSet<String> adductsThatRequireOtherAdducts = new HashSet<String>();
            for (QuantVO quant : hitsAccordingToQuant.keySet()) {
                try {
                    String rule = StaticUtils.getRuleName(quant.getAnalyteClass(), quant.getModName());
                    if (!RulesContainer.requiresOtherValidAdduct(rule)) continue;
                    adductsThatRequireOtherAdducts.add(rule);
                }
                catch (NoRuleException quant2) {
                }
                catch (RulesException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SpectrummillParserException e) {
                    e.printStackTrace();
                }
            }
            MSnPeakSeparator mSnPeakSeparator = new MSnPeakSeparator(hitsAccordingToQuant, this.peaksBeforeSplit_, analyzer, msLevel, adductsThatRequireOtherAdducts);
            hitsAccordingToQuant = mSnPeakSeparator.disentagleSharedMS1Peaks();
        }
        for (QuantVO oneSet : hitsAccordingToQuant.keySet()) {
            Hashtable<String, LipidParameterSet> hashtable = hitsAccordingToQuant.get(oneSet);
            if (LipidomicsConstants.isShotgun() == 1 || !LipidomicsConstants.isMS2() || hashtable.size() <= 0) continue;
            try {
                float unionTime;
                String unionTimeString = RulesContainer.getPeakUnionTime(StaticUtils.getRuleName(oneSet.getAnalyteClass(), oneSet.getModName()));
                if (unionTimeString == null || unionTimeString.length() <= 0 || !((unionTime = Float.parseFloat(unionTimeString)) > 0.0f)) continue;
                boolean ignorePositionalEvidence = RulesContainer.isUnionWithoutPosition(StaticUtils.getRuleName(oneSet.getAnalyteClass(), oneSet.getModName()));
                Hashtable<String, LipidParameterSet> hashtable3 = this.uniteHits(analyzer, hashtable, unionTime, oneSet, ignorePositionalEvidence);
                hitsAccordingToQuant.put(oneSet, hashtable3);
            }
            catch (LipidCombinameEncodingException | NoRuleException | RulesException | SpectrummillParserException | IOException exception) {}
        }
        if (LipidomicsConstants.isMS2() && cutoff != null) {
            analyzer.setAreaCutoffs(defaultRelativeAreaCutoff, defaultRelativeFarAreaCutoff, peakDiscardingAreaFactor, false);
        }
        return hitsAccordingToQuant;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<String, LipidParameterSet> uniteHits(LipidomicsAnalyzer analyzer, Hashtable<String, LipidParameterSet> hits, float unionTime, QuantVO quantSet, boolean ignorePositionalEvidence) throws CgException, LipidCombinameEncodingException {
        void var8_11;
        ArrayList<StringFloatVO> rts = new ArrayList<StringFloatVO>();
        for (String string : hits.keySet()) {
            rts.add(new StringFloatVO(string));
        }
        Collections.sort(rts, new GeneralComparator("at.tugraz.genome.lda.utils.StringFloatVO", "getFloatValue", "java.lang.Float"));
        Vector<MSnNamingVO> candidates = new Vector<MSnNamingVO>();
        for (StringFloatVO vo : rts) {
            LipidParameterSet ms1Set = hits.get(vo.getStringValue());
            if (!(ms1Set instanceof LipidomicsMSnSet)) continue;
            candidates.add(new MSnNamingVO((LipidomicsMSnSet)ms1Set, unionTime));
        }
        if (candidates.size() == 0) {
            return hits;
        }
        Vector vector = new Vector();
        int highestRegardedEvidence = 4;
        if (ignorePositionalEvidence) {
            highestRegardedEvidence = 3;
        }
        for (int status = highestRegardedEvidence; status >= 2; --status) {
            Vector toAnalyze = new Vector(var8_11);
            Vector<MSnNamingVO> smallerStatus = new Vector<MSnNamingVO>();
            HashSet<Integer> combined = new HashSet<Integer>();
            if (var8_11.size() == 0) {
                toAnalyze = new Vector(candidates);
            }
            Vector<MSnNamingVO> vector2 = new Vector<MSnNamingVO>();
            for (int i = 0; i != toAnalyze.size(); ++i) {
                int j;
                int j2;
                Object other;
                if (combined.contains(i)) continue;
                MSnNamingVO cand = (MSnNamingVO)toAnalyze.get(i);
                if (cand.getStatus() < status) {
                    smallerStatus.add(cand);
                    continue;
                }
                for (int j22 = i + 1; j22 < toAnalyze.size(); ++j22) {
                    if (combined.contains(j22) || ((MSnNamingVO)(other = (MSnNamingVO)toAnalyze.get(j22))).getStatus() < status || !cand.insideRange((MSnNamingVO)other) || !cand.hasSameEvidence(status, (MSnNamingVO)other)) continue;
                    cand.mergeWithOther((MSnNamingVO)other);
                    combined.add(j22);
                }
                for (j2 = i + 1; j2 < toAnalyze.size(); ++j2) {
                    if (combined.contains(j2) || ((MSnNamingVO)(other = (MSnNamingVO)toAnalyze.get(j2))).getStatus() < status || !cand.insideCombinedRtRange((MSnNamingVO)other)) continue;
                    cand.mergeWithOther((MSnNamingVO)other);
                    combined.add(j2);
                }
                for (j2 = i + 1; j2 < toAnalyze.size(); ++j2) {
                    if (combined.contains(j2) || ((MSnNamingVO)(other = (MSnNamingVO)toAnalyze.get(j2))).getStatus() < status || !cand.insideRange((MSnNamingVO)other) || cand.hasSameEvidence(status, (MSnNamingVO)other) || status >= 4 && !cand.hasSameEvidence(3, (MSnNamingVO)other)) continue;
                    cand.setHigherLevelLimits((MSnNamingVO)other);
                }
                boolean isCovered = false;
                other = vector2.iterator();
                while (other.hasNext()) {
                    MSnNamingVO result = (MSnNamingVO)other.next();
                    if (!result.insideCombinedRtRange(cand)) continue;
                    result.mergeWithOther(cand);
                    System.out.println("ATTENTION: a result in the merging process is covered by an added one - this should not be the case!!!");
                    break;
                }
                if (isCovered) continue;
                Vector resultsToRemove = new Vector();
                for (j = 0; j != vector2.size(); ++j) {
                    MSnNamingVO result = (MSnNamingVO)vector2.get(j);
                    if (!cand.insideCombinedRtRange(result)) continue;
                    cand.mergeWithOther(result);
                    resultsToRemove.add(j);
                    System.out.println("ATTENTION: a candidate covers an already added result - this should not be the case!!!");
                    break;
                }
                for (j = resultsToRemove.size() - 1; j != -1; --j) {
                    vector2.remove(resultsToRemove.get(j));
                }
                vector2.add(cand);
            }
            vector2.addAll(smallerStatus);
        }
        Hashtable<String, LipidParameterSet> finalHits = new Hashtable();
        if (var8_11.size() > 0) {
            Hashtable<MSnNamingVO, Hashtable> grouped = new Hashtable<MSnNamingVO, Hashtable>();
            for (MSnNamingVO rangeVO : var8_11) {
                grouped.put(rangeVO, new Hashtable());
            }
            for (String rtString : hits.keySet()) {
                float rt = Float.parseFloat(rtString);
                LipidParameterSet set = hits.get(rtString);
                Vector<MSnNamingVO> insideRanges = new Vector<MSnNamingVO>();
                for (MSnNamingVO rangeVO : grouped.keySet()) {
                    if (!rangeVO.insideRange(rt) || !rangeVO.getMs1Name().equalsIgnoreCase(set.getNameStringWithoutRt())) continue;
                    insideRanges.add(rangeVO);
                }
                if (insideRanges.size() == 0) {
                    finalHits.put(rtString, set);
                    continue;
                }
                MSnNamingVO rangeVO = this.detectClosestRange(Float.parseFloat(rtString), insideRanges);
                Hashtable toMerge = (Hashtable)grouped.get(rangeVO);
                toMerge.put(rtString, set);
                grouped.put(rangeVO, toMerge);
            }
            for (Hashtable forMerging : grouped.values()) {
                if (forMerging.size() == 1) {
                    String rt = (String)forMerging.keySet().iterator().next();
                    finalHits.put(rt, (LipidParameterSet)forMerging.get(rt));
                    continue;
                }
                LipidParameterSet set = this.createLipidParameterSet(analyzer.mergeIdentifications(forMerging.values()), quantSet.getNegativeStartValue(), (float)quantSet.getAnalyteMass(), quantSet.getAnalyteName(), quantSet.getDbs(), quantSet.getOhNumber(), quantSet.getModName(), quantSet.getAnalyteFormula(), quantSet.getModFormula(), quantSet.getCharge());
                try {
                    MSnAnalyzer msnAnalyzer = new MSnAnalyzer(quantSet.getAnalyteClass(), quantSet.getModName(), set, this.analyzer_, quantSet, true, false);
                    if (msnAnalyzer.checkStatus() != 1) {
                        set = msnAnalyzer.getResult();
                    }
                }
                catch (ChemicalFormulaException | HydroxylationEncodingException | RulesException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SpectrummillParserException e) {
                    e.printStackTrace();
                }
                finalHits.put(set.getRt(), set);
            }
        } else {
            finalHits = new Hashtable<String, LipidParameterSet>(hits);
        }
        return finalHits;
    }

    private LipidParameterSet createLipidParameterSet(Hashtable<Integer, Vector<CgProbe>> oneHit, int negativeStartValue, float analyteMass, String analyteName, int dbs, int ohNumber, String modName, String analyteFormula, String modFormula, int charge) {
        Vector<Vector<CgProbe>> isotopicProbes2 = new Vector<Vector<CgProbe>>();
        float totalArea = 0.0f;
        Double rt = 0.0;
        for (int k = 0; k != oneHit.size(); ++k) {
            Vector<CgProbe> probes = oneHit.get(k);
            if (probes == null) continue;
            isotopicProbes2.add(probes);
            Vector<Double> rts = new Vector<Double>();
            for (int j = 0; j != probes.size(); ++j) {
                CgProbe probe = probes.get(j);
                if (negativeStartValue < 0) {
                    probe.isotopeNumber *= -1;
                }
                if (probe == null || probe.AreaStatus != CgAreaStatus.OK) continue;
                totalArea += probe.Area;
                if (LipidomicsConstants.isShotgun() == 1) continue;
                rts.add(Double.valueOf(probe.Peak));
            }
            if (LipidomicsConstants.isShotgun() == 1 || k != 0) continue;
            rt = (double)Calculator.mean(rts) / 60.0;
        }
        if (LipidomicsConstants.isShotgun() == 1) {
            rt = null;
        }
        LipidParameterSet param = new LipidParameterSet(analyteMass, analyteName, dbs, modName, rt, analyteFormula, modFormula, charge, ohNumber);
        param.LowerMzBand = LipidomicsConstants.getCoarseChromMzTolerance(analyteMass);
        param.UpperMzBand = LipidomicsConstants.getCoarseChromMzTolerance(analyteMass);
        param.Area = totalArea;
        param.setIsotopicProbes(isotopicProbes2);
        return param;
    }

    public boolean finished() {
        return this.finished_;
    }

    public String getErrorString() {
        return this.errorString_;
    }

    public Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> getResults() {
        return this.results_;
    }

    public Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> getMs2Removedhits() {
        return this.ms2RemovedHits_;
    }

    public boolean areMSnSpectraPresent() {
        return this.msnSpectraPresent_;
    }

    public boolean isMsnFirst() {
        return this.msnFirst_;
    }

    public QuantVO getQuantSet() {
        return this.quantSet_;
    }

    private MSnNamingVO detectClosestRange(float rt, Vector<MSnNamingVO> ranges) {
        float closest = Float.MAX_VALUE;
        MSnNamingVO close = null;
        for (MSnNamingVO range : ranges) {
            float dist = range.absoluteDistanceToHardRange(rt);
            if (!(dist < closest)) continue;
            closest = dist;
            close = range;
        }
        return close;
    }

    public Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> getPeaksBeforeSplit() {
        return this.peaksBeforeSplit_;
    }

    private void adaptMzValuesOfShotgunHits(LipidParameterSet param) {
        Vector<Vector<CgProbe>> isoProbes = param.getIsotopicProbes();
        Vector<Vector<CgProbe>> correctedProbes = new Vector<Vector<CgProbe>>();
        float mzTolerance = 0.0f;
        for (int i = 0; i != isoProbes.size(); ++i) {
            Vector<CgProbe> probes = isoProbes.get(i);
            Vector<CgProbe> corrected = new Vector<CgProbe>();
            float mz = param.Mz[0] + (float)i * LipidomicsConstants.getNeutronMass() / (float)param.getCharge().intValue();
            for (CgProbe aProbe : probes) {
                if (i == 0) {
                    mzTolerance = aProbe.LowerMzBand;
                }
                CgProbe probe = new CgProbe(aProbe);
                probe.Mz = mz;
                corrected.add(probe);
            }
            correctedProbes.add(corrected);
        }
        param.setIsotopicProbes(correctedProbes);
        param.LowerMzBand = mzTolerance;
        param.UpperMzBand = mzTolerance;
    }

    public LipidomicsAnalyzer getAnalyzer() {
        return this.analyzer_;
    }
}

