/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.parser.MzXMLMergerForWaters;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.io.BufferedInputStream;
import java.io.File;

public class RawToMzxmlThread
extends Thread {
    String[] params_;
    boolean isMassPlusPlus_;
    boolean watersMsConvert_;
    boolean finished_ = false;
    String errorString_;

    public RawToMzxmlThread(String[] params, boolean isMassPlusPlus, boolean watersMsConvert) {
        this.params_ = params;
        this.isMassPlusPlus_ = isMassPlusPlus;
        this.watersMsConvert_ = watersMsConvert;
    }

    private static void startRawToMzxmlTranslation(String[] params) throws Exception {
        Process process = Runtime.getRuntime().exec(params);
        if (params.length > 2 && params[2].endsWith(".d")) {
            BufferedInputStream in = new BufferedInputStream(process.getInputStream());
            in.close();
        }
        process.waitFor();
    }

    public static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    @Override
    public void run() {
        try {
            RawToMzxmlThread.startRawToMzxmlTranslation(this.params_);
            if (this.isMassPlusPlus_ || this.watersMsConvert_) {
                int i;
                File[] files = new File(this.params_[2]).listFiles();
                int msLevels = 0;
                for (int i2 = 0; i2 != files.length; ++i2) {
                    if (!files[i2].getName().startsWith("_FUN") || !files[i2].getAbsolutePath().endsWith(".DAT")) continue;
                    ++msLevels;
                }
                String outputBaseFile = "";
                if (this.isMassPlusPlus_) {
                    outputBaseFile = new String(this.params_[5]);
                    for (i = 2; i <= msLevels; ++i) {
                        this.params_[5] = outputBaseFile + String.valueOf(i);
                        this.params_[7] = String.valueOf(i - 1);
                        RawToMzxmlThread.startRawToMzxmlTranslation(this.params_);
                    }
                }
                if (this.watersMsConvert_) {
                    outputBaseFile = this.params_[2].substring(0, this.params_[2].lastIndexOf(".")) + "." + LipidomicsConstants.getIntermediateFileFormat();
                    for (i = 2; i <= msLevels; ++i) {
                        this.params_[this.params_.length - 1] = "msLevel " + i;
                        this.params_[4] = StaticUtils.extractDirName(this.params_[2]) + "/" + i;
                        RawToMzxmlThread.startRawToMzxmlTranslation(this.params_);
                        String fileName = StaticUtils.extractFileName(this.params_[2]);
                        fileName = fileName.substring(0, fileName.lastIndexOf(".")) + "." + LipidomicsConstants.getIntermediateFileFormat();
                        File outputFile = new File(this.params_[4] + "/" + fileName);
                        outputFile.renameTo(new File(outputBaseFile + String.valueOf(i)));
                        File oldDir = new File(this.params_[4]);
                        oldDir.delete();
                    }
                }
                if (msLevels > 1 && Settings.mergeMultipleMSMSFiles()) {
                    int mergingLevels = msLevels;
                    if (Settings.skipLastMzXML()) {
                        --mergingLevels;
                    }
                    MzXMLMergerForWaters merger = new MzXMLMergerForWaters(outputBaseFile, mergingLevels);
                    if (mergingLevels > 1) {
                        merger.merge();
                    } else {
                        File mergedFile = new File(outputBaseFile);
                        mergedFile.renameTo(new File(merger.getMergedFileName()));
                    }
                    for (int i3 = 1; i3 <= msLevels; ++i3) {
                        String fileName = new String(outputBaseFile);
                        if (i3 > 1) {
                            fileName = fileName + String.valueOf(i3);
                        }
                        new File(fileName).delete();
                    }
                    File mergedFile = new File(merger.getMergedFileName());
                    mergedFile.renameTo(new File(outputBaseFile));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorString_ = ex.toString();
        }
        this.finished_ = true;
    }

    public boolean finished() {
        return this.finished_;
    }

    public String getErrorString() {
        return this.errorString_;
    }

    public static void deleteMzXMLFiles(String baseMzxmlPath) {
        File mzXMLFile = new File(baseMzxmlPath);
        mzXMLFile.delete();
        int count = 2;
        mzXMLFile = new File(baseMzxmlPath + String.valueOf(count));
        while (mzXMLFile.exists()) {
            mzXMLFile.delete();
            mzXMLFile = new File(baseMzxmlPath + String.valueOf(++count));
        }
    }
}

