/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidDataAnalyzer;
import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.swing.BatchQuantificationTable;
import at.tugraz.genome.lda.swing.BatchQuantificationTableModel;
import at.tugraz.genome.lda.verifier.IntegerMaxVerifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;

public class QuantificationMenu
extends JPanel {
    private static final long serialVersionUID = 1L;
    JTextField selectedMzxmlDirectory_;
    JTextField selectedQuantDir_;
    JTextField timeMinusTol_;
    JTextField timePlusTol_;
    JTextField cutoff_;
    JTextField rtShift_;
    JCheckBox isoValidation_;
    JTextField amountOfIsotopes_;
    JTextField amountOfMatchingSearchIsotopes_;
    JCheckBox searchUnknownTime_;
    JTextField nrProcessorsChrom_;
    JTextField nrProcessors_;
    JComboBox<String> ionMode_;
    JButton startQuantification_;
    JPanel quantifyingPanel_;
    JLabel quantifyingLabel_;
    JProgressBar progressBar_;
    JLabel spinnerLabel_;
    BatchQuantificationTableModel batchQuantTableModel_;
    BatchQuantificationTable batchQuantTable_;

    public QuantificationMenu(boolean isBatch, LipidDataAnalyzer parent) {
        Serializable ionModeLabel;
        Serializable settingsPanel6;
        this.setLayout(new GridBagLayout());
        Integer y = 0;
        y = y + 1;
        JPanel selectionPanel = this.addJPanelToQuantMenu(y, this);
        JLabel mzXMLLabel = new JLabel(isBatch ? "Folder with raw file(s): " : "Raw file: ");
        mzXMLLabel.setToolTipText(isBatch ? "<html>Enter a folder containing the raw files of your experiment!<br>The following file types are accepted as input:<br>RAW-file:   XCalibur RAW files (XCalibur must be installed)<<br>RAW-dir:    MassLynx RAW directory (MassLynx must be installed)<br>mzXML:      mzXML format<br>mzML:       mzML format<br>chrom:      LDA quant file format</html>" : "<html>Enter the raw file of your experiment!<br>The following file types are accepted:<br>RAW-file:   XCalibur RAW files (XCalibur must be installed)<br>RAW-dir:    MassLynx RAW directory (MassLynx must be installed)<br>mzXML:      mzXML format<br>mzML:       mzML format<br>chrom:      LDA quant file format</html>");
        selectionPanel.add((Component)mzXMLLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.selectedMzxmlDirectory_ = new JTextField(54);
        this.selectedMzxmlDirectory_.setMinimumSize(this.selectedMzxmlDirectory_.getPreferredSize());
        this.selectedMzxmlDirectory_.setToolTipText(isBatch ? "<html>Enter a folder containing the raw files of your experiment!<br>The following file types are accepted as input:<br>RAW-file:   XCalibur RAW files (XCalibur must be installed)<<br>RAW-dir:    MassLynx RAW directory (MassLynx must be installed)<br>mzXML:      mzXML format<br>mzML:       mzML format<br>chrom:      LDA quant file format</html>" : "<html>Enter the raw file of your experiment!<br>The following file types are accepted:<br>RAW-file:   XCalibur RAW files (XCalibur must be installed)<br>RAW-dir:    MassLynx RAW directory (MassLynx must be installed)<br>mzXML:      mzXML format<br>mzML:       mzML format<br>chrom:      LDA quant file format</html>");
        selectionPanel.add((Component)this.selectedMzxmlDirectory_, new GridBagConstraints(1, y, 6, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        JButton jButtonMzXMLOpen = new JButton("Select");
        jButtonMzXMLOpen.addActionListener(parent);
        jButtonMzXMLOpen.setActionCommand(isBatch ? "showMzxmlDirChooser" : "showMzxmlFileChooser");
        jButtonMzXMLOpen.setToolTipText(isBatch ? "<html>Enter a folder containing the raw files of your experiment!<br>The following file types are accepted as input:<br>RAW-file:   XCalibur RAW files (XCalibur must be installed)<<br>RAW-dir:    MassLynx RAW directory (MassLynx must be installed)<br>mzXML:      mzXML format<br>mzML:       mzML format<br>chrom:      LDA quant file format</html>" : "<html>Enter the raw file of your experiment!<br>The following file types are accepted:<br>RAW-file:   XCalibur RAW files (XCalibur must be installed)<br>RAW-dir:    MassLynx RAW directory (MassLynx must be installed)<br>mzXML:      mzXML format<br>mzML:       mzML format<br>chrom:      LDA quant file format</html>");
        selectionPanel.add((Component)jButtonMzXMLOpen, new GridBagConstraints(7, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel quantChromLabel = new JLabel(isBatch ? "Folder with mass list or RT-DB file(s): " : "Mass list or RT-DB file: ");
        quantChromLabel.setToolTipText(isBatch ? "<html>Enter a folder containing the mass list file with the analytes of interest!<br>The file type must be Microsoft Excel (xls or xlsx).<br>A detailed description how to prepare such a file can be found in the<br>user manual Appendix A or in the Help component.<br>Examples are provided in the \"examples\" directory of the installation</html>" : "<html>Enter the mass list file containing the analytes of interest!<br>The file type must be Microsoft Excel (xls or xlsx).<br>A detailed description how to prepare such a file can be found in the<br>user manual Appendix A or in the Help component.<br>Examples are provided in the \"examples\" directory of the installation</html>");
        Integer n = y;
        Integer n2 = y = Integer.valueOf(y + 1);
        selectionPanel.add((Component)quantChromLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        JButton jButtonQuantOpen = new JButton("Select");
        jButtonQuantOpen.addActionListener(parent);
        jButtonQuantOpen.setActionCommand(isBatch ? "showQuantDirChooser" : "showQuantFileChooser");
        jButtonQuantOpen.setToolTipText(isBatch ? "<html>Enter a folder containing the mass list file with the analytes of interest!<br>The file type must be Microsoft Excel (xls or xlsx).<br>A detailed description how to prepare such a file can be found in the<br>user manual Appendix A or in the Help component.<br>Examples are provided in the \"examples\" directory of the installation</html>" : "<html>Enter the mass list file containing the analytes of interest!<br>The file type must be Microsoft Excel (xls or xlsx).<br>A detailed description how to prepare such a file can be found in the<br>user manual Appendix A or in the Help component.<br>Examples are provided in the \"examples\" directory of the installation</html>");
        selectionPanel.add((Component)jButtonQuantOpen, new GridBagConstraints(7, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.selectedQuantDir_ = new JTextField(54);
        this.selectedQuantDir_.setMinimumSize(this.selectedQuantDir_.getPreferredSize());
        this.selectedQuantDir_.setToolTipText(isBatch ? "<html>Enter a folder containing the mass list file with the analytes of interest!<br>The file type must be Microsoft Excel (xls or xlsx).<br>A detailed description how to prepare such a file can be found in the<br>user manual Appendix A or in the Help component.<br>Examples are provided in the \"examples\" directory of the installation</html>" : "<html>Enter the mass list file containing the analytes of interest!<br>The file type must be Microsoft Excel (xls or xlsx).<br>A detailed description how to prepare such a file can be found in the<br>user manual Appendix A or in the Help component.<br>Examples are provided in the \"examples\" directory of the installation</html>");
        selectionPanel.add((Component)this.selectedQuantDir_, new GridBagConstraints(1, y, 6, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        y = y + 1;
        JPanel settingsPanel1 = this.addJPanelToQuantMenu(y, this);
        JLabel timeMinusTolLabel = new JLabel("Retention time tolerance before reference: ");
        timeMinusTolLabel.setToolTipText("<html>Retention time tolerance in minutes.<br>Specification of a time tolerance to allow quantitation<br/>before the expected retention time entered in the Excel file.<br/>If no time is entered in the Excel, this field has no effect!</html>");
        settingsPanel1.add((Component)timeMinusTolLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.timeMinusTol_ = new JTextField(4);
        this.timeMinusTol_.setMinimumSize(this.timeMinusTol_.getPreferredSize());
        this.timeMinusTol_.setText("5");
        this.timeMinusTol_.setHorizontalAlignment(4);
        this.timeMinusTol_.setToolTipText("<html>Retention time tolerance in minutes.<br>Specification of a time tolerance to allow quantitation<br/>before the expected retention time entered in the Excel file.<br/>If no time is entered in the Excel, this field has no effect!</html>");
        settingsPanel1.add((Component)this.timeMinusTol_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel timeMinusUnit = new JLabel("min, ");
        timeMinusUnit.setToolTipText("<html>Retention time tolerance in minutes.<br>Specification of a time tolerance to allow quantitation<br/>before the expected retention time entered in the Excel file.<br/>If no time is entered in the Excel, this field has no effect!</html>");
        settingsPanel1.add((Component)timeMinusUnit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel timePlusTolLabel = new JLabel("after reference: ");
        timePlusTolLabel.setToolTipText("<html>Retention time tolerance in minutes.<br>Specification of a time tolerance to allow quantitation<br/>after the expected retention time entered in the Excel file.<br/>If no time is entered in the Excel, this field has no effect!</html>");
        settingsPanel1.add((Component)timePlusTolLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.timePlusTol_ = new JTextField(4);
        this.timePlusTol_.setMinimumSize(this.timePlusTol_.getPreferredSize());
        this.timePlusTol_.setText("5");
        this.timePlusTol_.setHorizontalAlignment(4);
        this.timePlusTol_.setToolTipText("<html>Retention time tolerance in minutes.<br>Specification of a time tolerance to allow quantitation<br/>after the expected retention time entered in the Excel file.<br/>If no time is entered in the Excel, this field has no effect!</html>");
        settingsPanel1.add((Component)this.timePlusTol_, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel timePlusUnit = new JLabel("min, ");
        timePlusUnit.setToolTipText("<html>Retention time tolerance in minutes.<br>Specification of a time tolerance to allow quantitation<br/>after the expected retention time entered in the Excel file.<br/>If no time is entered in the Excel, this field has no effect!</html>");
        settingsPanel1.add((Component)timePlusUnit, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel rtShiftLabel = new JLabel("RT-shift: ");
        rtShiftLabel.setToolTipText("<html>Retention time shift in minutes relative to the one<br>entered in the mass list Excel file</html>");
        settingsPanel1.add((Component)rtShiftLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.rtShift_ = new JTextField(4);
        this.rtShift_.setMinimumSize(this.rtShift_.getPreferredSize());
        this.rtShift_.setText("0.0");
        this.rtShift_.setHorizontalAlignment(4);
        this.rtShift_.setToolTipText("<html>Retention time shift in minutes relative to the one<br>entered in the mass list Excel file</html>");
        settingsPanel1.add((Component)this.rtShift_, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel rtShiftUnit = new JLabel("min");
        rtShiftUnit.setToolTipText("<html>Retention time shift in minutes relative to the one<br>entered in the mass list Excel file</html>");
        settingsPanel1.add((Component)rtShiftUnit, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        y = y + 1;
        JPanel settingsPanel2 = this.addJPanelToQuantMenu(y, this);
        JLabel cutoffLabel = new JLabel("Relative base-peak cutoff: ");
        cutoffLabel.setToolTipText("<html>Peaks smaller than \"highest peak area\" times this <br>value in per mille are automatically discared.</html>");
        settingsPanel2.add((Component)cutoffLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.cutoff_ = new JTextField(4);
        this.cutoff_.setMinimumSize(this.cutoff_.getPreferredSize());
        this.cutoff_.setText(LipidomicsConstants.getBasePeakDefaultCutoff());
        this.cutoff_.setHorizontalAlignment(4);
        this.cutoff_.setToolTipText("<html>Peaks smaller than \"highest peak area\" times this <br>value in per mille are automatically discared.</html>");
        settingsPanel2.add((Component)this.cutoff_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel cutoffUnit = new JLabel("\u2030");
        cutoffUnit.setToolTipText("<html>Peaks smaller than \"highest peak area\" times this <br>value in per mille are automatically discared.</html>");
        settingsPanel2.add((Component)cutoffUnit, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        y = y + 1;
        JPanel settingsPanel3 = this.addJPanelToQuantMenu(y, this);
        this.isoValidation_ = new JCheckBox("Isotopic quantitation of ");
        this.isoValidation_.setSelected(true);
        LipidDataAnalyzer lipidDataAnalyzer = parent;
        lipidDataAnalyzer.getClass();
        this.isoValidation_.addItemListener(lipidDataAnalyzer.new LipidDataAnalyzer.LipidomicsItemListener("endisableAmountOfBatchIsotopes"));
        this.isoValidation_.setToolTipText("<html>How many isotopic peaks should be quantified additional to the base peak.<br/>The first input field defines the amount of isotpes.<br/>The second one the amount of isotopes that must match the<br/>isotopic distribution (otherwise hit is discarded).</html>");
        settingsPanel3.add((Component)this.isoValidation_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.amountOfIsotopes_ = new JTextField(4);
        this.amountOfIsotopes_.setMinimumSize(this.amountOfIsotopes_.getPreferredSize());
        this.amountOfIsotopes_.setText("2");
        this.amountOfIsotopes_.setHorizontalAlignment(4);
        this.amountOfIsotopes_.setToolTipText("<html>How many isotopic peaks should be quantified additional to the base peak.<br/>The first input field defines the amount of isotpes.<br/>The second one the amount of isotopes that must match the<br/>isotopic distribution (otherwise hit is discarded).</html>");
        settingsPanel3.add((Component)this.amountOfIsotopes_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel isotopePeaks = new JLabel("isotopes where ");
        isotopePeaks.setToolTipText("<html>How many isotopic peaks should be quantified additional to the base peak.<br/>The first input field defines the amount of isotpes.<br/>The second one the amount of isotopes that must match the<br/>isotopic distribution (otherwise hit is discarded).</html>");
        settingsPanel3.add((Component)isotopePeaks, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.amountOfMatchingSearchIsotopes_ = new JTextField(4);
        this.amountOfMatchingSearchIsotopes_.setMinimumSize(this.amountOfMatchingSearchIsotopes_.getPreferredSize());
        this.amountOfMatchingSearchIsotopes_.setText("1");
        this.amountOfMatchingSearchIsotopes_.setHorizontalAlignment(4);
        this.amountOfMatchingSearchIsotopes_.setToolTipText("<html>How many isotopic peaks should be quantified additional to the base peak.<br/>The first input field defines the amount of isotpes.<br/>The second one the amount of isotopes that must match the<br/>isotopic distribution (otherwise hit is discarded).</html>");
        settingsPanel3.add((Component)this.amountOfMatchingSearchIsotopes_, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel isotopeMatchPeaks = new JLabel("isotopic peak(s) must match");
        isotopeMatchPeaks.setToolTipText("<html>How many isotopic peaks should be quantified additional to the base peak.<br/>The first input field defines the amount of isotpes.<br/>The second one the amount of isotopes that must match the<br/>isotopic distribution (otherwise hit is discarded).</html>");
        settingsPanel3.add((Component)isotopeMatchPeaks, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        y = y + 1;
        JPanel settingsPanel4 = this.addJPanelToQuantMenu(y, this);
        this.searchUnknownTime_ = new JCheckBox("Find molecules where retention time is unknown");
        this.searchUnknownTime_.setSelected(true);
        this.searchUnknownTime_.setToolTipText("<html>Specifies wether or not a molecule should be quantified where no <br/>retention time has been entered in the mass list Excel file.</html>");
        settingsPanel4.add((Component)this.searchUnknownTime_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        y = y + 1;
        JPanel settingsPanel5 = this.addJPanelToQuantMenu(y, this);
        JLabel maxProcessorsChrom = new JLabel("Processors for file translation:");
        maxProcessorsChrom.setToolTipText("<html>The number of processors to be used for file translation.<br/>It is recommended to use 1 processor.</html>");
        settingsPanel5.add((Component)maxProcessorsChrom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.nrProcessorsChrom_ = new JTextField(3);
        this.nrProcessorsChrom_.setMinimumSize(this.nrProcessorsChrom_.getPreferredSize());
        this.nrProcessorsChrom_.setText(String.valueOf(1));
        this.nrProcessorsChrom_.setHorizontalAlignment(4);
        this.nrProcessorsChrom_.setToolTipText("<html>The number of processors to be used for file translation.<br/>It is recommended to use 1 processor.</html>");
        this.nrProcessorsChrom_.setInputVerifier(new IntegerMaxVerifier(true, 1, this.getMaxProcessors()));
        settingsPanel5.add((Component)this.nrProcessorsChrom_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        JLabel maxProcessors = new JLabel("Processors for quantitation:");
        maxProcessors.setToolTipText("<html>The number of processors to be used for quantitation.<br/>It is recommended to use n-1 processors.<br/>In this way the remaining system can run properly.</html>");
        settingsPanel5.add((Component)maxProcessors, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.nrProcessors_ = new JTextField(3);
        this.nrProcessors_.setMinimumSize(this.nrProcessors_.getPreferredSize());
        this.nrProcessors_.setText(String.valueOf(this.getAmountOfProcessorsPreferred()));
        this.nrProcessors_.setHorizontalAlignment(4);
        this.nrProcessors_.setToolTipText("<html>The number of processors to be used for quantitation.<br/>It is recommended to use n-1 processors.<br/>In this way the remaining system can run properly.</html>");
        this.nrProcessors_.setInputVerifier(new IntegerMaxVerifier(true, 1, this.getMaxProcessors()));
        settingsPanel5.add((Component)this.nrProcessors_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 0, 0), 0, 0));
        if (Settings.useAlex()) {
            y = y + 1;
            settingsPanel6 = this.addJPanelToQuantMenu(y, this);
            ionModeLabel = new JLabel("Ion mode:");
            ((JComponent)ionModeLabel).setToolTipText("<html>The used ion mode for this search.<br/>Alex123 target lists contain both ion modes, thus,<br/>the one for the search has to be selected.</html>");
            ((Container)settingsPanel6).add((Component)ionModeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.ionMode_ = new JComboBox();
            this.ionMode_.addItem("+");
            this.ionMode_.addItem("-");
            this.ionMode_.setToolTipText("<html>The used ion mode for this search.<br/>Alex123 target lists contain both ion modes, thus,<br/>the one for the search has to be selected.</html>");
            this.ionMode_.setFont(LipidDataAnalyzer.SELECT_FIELD_FONT);
            ((Container)settingsPanel6).add(this.ionMode_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
            JLabel ionModeInfo = new JLabel("(selection required for Alex123 target lists)");
            ionModeInfo.setToolTipText("<html>The used ion mode for this search.<br/>Alex123 target lists contain both ion modes, thus,<br/>the one for the search has to be selected.</html>");
            ((Container)settingsPanel6).add(ionModeInfo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        }
        settingsPanel6 = y;
        y = y + 1;
        ionModeLabel = y;
        this.startQuantification_ = new JButton("Start Quantitation");
        this.startQuantification_.addActionListener(parent);
        this.startQuantification_.setActionCommand(isBatch ? "startBatchQuantification" : "startQuantification");
        this.startQuantification_.setToolTipText("<html>Starts the quantitation.<br/>Before the quantitation can start a RAW and an Excel files have to be selected!</html>");
        this.add((Component)this.startQuantification_, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.quantifyingLabel_ = new JLabel("Quantifying");
        this.quantifyingLabel_.setToolTipText("Current quantitation status");
        this.progressBar_ = new JProgressBar();
        this.progressBar_.setMaximum(100);
        this.progressBar_.setToolTipText("Quantitation progress");
        ImageIcon icon = new ImageIcon(LipidDataAnalyzer.class.getResource("/images/spinner.gif"));
        this.spinnerLabel_ = new JLabel(icon);
        if (isBatch) {
            this.quantifyingPanel_ = new JPanel();
            this.quantifyingPanel_.setLayout(new BorderLayout());
            y = y + 1;
            this.add((Component)this.quantifyingPanel_, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
            this.batchQuantTableModel_ = new BatchQuantificationTableModel();
            this.batchQuantTable_ = new BatchQuantificationTable(this.batchQuantTableModel_);
            TableColumnModel tcm = this.batchQuantTable_.getColumnModel();
            tcm.getColumn(0).setPreferredWidth(15);
            tcm.getColumn(0).setMaxWidth(15);
            tcm.getColumn(1).setPreferredWidth(170);
            tcm.getColumn(2).setPreferredWidth(200);
            tcm.getColumn(3).setPreferredWidth(170);
            JScrollPane scrollPane = new JScrollPane(this.batchQuantTable_);
            scrollPane.setPreferredSize(new Dimension(650, 200));
            this.quantifyingPanel_.add((Component)scrollPane, "Center");
            JPanel quantProgressPanel = new JPanel();
            quantProgressPanel.setLayout(new GridBagLayout());
            this.quantifyingPanel_.add((Component)quantProgressPanel, "South");
            quantProgressPanel.add((Component)this.quantifyingLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
            quantProgressPanel.add((Component)this.progressBar_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
            quantProgressPanel.add((Component)this.spinnerLabel_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        } else {
            y = y + 1;
            this.quantifyingPanel_ = this.addJPanelToQuantMenu(y, this);
            this.quantifyingPanel_.add((Component)this.quantifyingLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.quantifyingPanel_.add((Component)this.progressBar_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.quantifyingPanel_.add((Component)this.spinnerLabel_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        }
        this.quantifyingPanel_.setVisible(false);
    }

    private JPanel addJPanelToQuantMenu(int y, JPanel quantMenu) {
        JPanel toAdd = new JPanel();
        toAdd.setLayout(new GridBagLayout());
        quantMenu.add((Component)toAdd, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
        return toAdd;
    }

    private int getMaxProcessors() {
        int maxProcessors = Runtime.getRuntime().availableProcessors();
        if (maxProcessors < 1) {
            maxProcessors = Integer.MAX_VALUE;
        }
        return maxProcessors;
    }

    private int getAmountOfProcessorsPreferred() {
        int procs;
        int maxProcessors = this.getMaxProcessors();
        if (maxProcessors == Integer.MAX_VALUE) {
            maxProcessors = 1;
        }
        if ((procs = maxProcessors - 1) < 1) {
            procs = 1;
        }
        return procs;
    }

    public JTextField getSelectedMzxmlDirectory() {
        return this.selectedMzxmlDirectory_;
    }

    public void setSelectedMzxmlDirectory(JTextField selectedMzxmlDirectory) {
        this.selectedMzxmlDirectory_ = selectedMzxmlDirectory;
    }

    public JTextField getSelectedQuantDir() {
        return this.selectedQuantDir_;
    }

    public void setSelectedQuantDir(JTextField selectedQuantDir) {
        this.selectedQuantDir_ = selectedQuantDir;
    }

    public JTextField getTimeMinusTol() {
        return this.timeMinusTol_;
    }

    public void setTimeMinusTol(JTextField timeMinusTol) {
        this.timeMinusTol_ = timeMinusTol;
    }

    public JTextField getTimePlusTol() {
        return this.timePlusTol_;
    }

    public void setTimePlusTol(JTextField timePlusTol) {
        this.timePlusTol_ = timePlusTol;
    }

    public JTextField getCutoff() {
        return this.cutoff_;
    }

    public void setCutoff(JTextField cutoff) {
        this.cutoff_ = cutoff;
    }

    public JTextField getRtShift() {
        return this.rtShift_;
    }

    public void setRtShift(JTextField rtShift) {
        this.rtShift_ = rtShift;
    }

    public JCheckBox getIsoValidation() {
        return this.isoValidation_;
    }

    public void setIsoValidation(JCheckBox isoValidation) {
        this.isoValidation_ = isoValidation;
    }

    public JTextField getAmountOfIsotopes() {
        return this.amountOfIsotopes_;
    }

    public void setAmountOfIsotopes(JTextField amountOfIsotopes) {
        this.amountOfIsotopes_ = amountOfIsotopes;
    }

    public JTextField getAmountOfMatchingSearchIsotopes() {
        return this.amountOfMatchingSearchIsotopes_;
    }

    public void setAmountOfMatchingSearchIsotopes(JTextField amountOfMatchingSearchIsotopes) {
        this.amountOfMatchingSearchIsotopes_ = amountOfMatchingSearchIsotopes;
    }

    public JCheckBox getSearchUnknownTime() {
        return this.searchUnknownTime_;
    }

    public void setSearchUnknownTime(JCheckBox searchUnknownTime) {
        this.searchUnknownTime_ = searchUnknownTime;
    }

    public Integer getNrProcessorsChrom() {
        return Integer.parseInt(this.nrProcessorsChrom_.getText());
    }

    public void setNrProcessorsChrom(Integer nrProcessorsChrom) {
        this.nrProcessorsChrom_.setText(String.valueOf(nrProcessorsChrom));
    }

    public Integer getNrProcessors() {
        return Integer.parseInt(this.nrProcessors_.getText());
    }

    public void setNrProcessors(Integer nrProcessors) {
        this.nrProcessors_.setText(String.valueOf(nrProcessors));
    }

    public JComboBox<String> getIonMode() {
        return this.ionMode_;
    }

    public void setIonMode(JComboBox<String> ionMode) {
        this.ionMode_ = ionMode;
    }

    public JButton getStartQuantification() {
        return this.startQuantification_;
    }

    public void setStartQuantification(JButton startQuantification) {
        this.startQuantification_ = startQuantification;
    }

    public JPanel getQuantifyingPanel() {
        return this.quantifyingPanel_;
    }

    public void setQuantifyingPanel(JPanel quantifyingPanel) {
        this.quantifyingPanel_ = quantifyingPanel;
    }

    public JLabel getQuantifyingLabel() {
        return this.quantifyingLabel_;
    }

    public void setQuantifyingLabel(JLabel quantifyingLabel) {
        this.quantifyingLabel_ = quantifyingLabel;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar_;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar_ = progressBar;
    }

    public JLabel getSpinnerLabel() {
        return this.spinnerLabel_;
    }

    public void setSpinnerLabel(JLabel spinnerLabel) {
        this.spinnerLabel_ = spinnerLabel;
    }

    public BatchQuantificationTableModel getBatchQuantTableModel() {
        return this.batchQuantTableModel_;
    }

    public void setBatchQuantTableModel(BatchQuantificationTableModel batchQuantTableModel) {
        this.batchQuantTableModel_ = batchQuantTableModel;
    }

    public BatchQuantificationTable getBatchQuantTable() {
        return this.batchQuantTable_;
    }

    public void setBatchQuantTable(BatchQuantificationTable batchQuantTable) {
        this.batchQuantTable_ = batchQuantTable;
    }

    public void setBatchQuantTableForSingleQuant(QuantificationMenu theBatchQuantMenu) {
        this.batchQuantTableModel_ = theBatchQuantMenu.getBatchQuantTableModel();
        this.batchQuantTable_ = theBatchQuantMenu.getBatchQuantTable();
    }
}

