/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.errors;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.ebi.pride.jmztab2.utils.errors.CrossCheckErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorType;

public final class MZTabErrorTypeMap {
    private final Map<Integer, MZTabErrorType> typeMap = new TreeMap<Integer, MZTabErrorType>();

    private void add(MZTabErrorType type) {
        this.typeMap.put(type.getCode(), type);
    }

    public MZTabErrorTypeMap() {
        Arrays.stream(FormatErrorType.getValues()).forEach(error -> this.add((MZTabErrorType)error));
        Arrays.stream(LogicalErrorType.getValues()).forEach(error -> this.add((MZTabErrorType)error));
        Arrays.stream(CrossCheckErrorType.getValues()).forEach(error -> this.add((MZTabErrorType)error));
    }

    public MZTabErrorType getType(int code) {
        return this.typeMap.get(code);
    }

    public Map<Integer, MZTabErrorType> getTypeMap() {
        return this.typeMap;
    }
}

