/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Specification of study_variable. (empty) name: A name for each study variable (experimental condition or factor), to serve as a list of the study variables that MUST be reported in the following tables. For software that does not capture study variables, a single study variable MUST be reported, linking to all assays. This single study variable MUST have the identifier \u201cundefined\u201c. assay_refs: Bar-separated references to the IDs of assays grouped in the study variable. average_function: The function used to calculate the study variable quantification value and the operation used is not arithmetic mean (default) e.g. \u201cgeometric mean\u201d, \u201cmedian\u201d. The 1-n refers to different study variables. variation_function: The function used to calculate the study variable quantification variation value if it is reported and the operation used is not coefficient of variation (default) e.g. \u201cstandard error\u201d. description: A textual description of the study variable. factors: Additional parameters or factors, separated by bars, that are known about study variables allowing the capture of more complex, such as nested designs.   ")
@XmlRootElement(name="StudyVariable")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="StudyVariable")
public class StudyVariable
extends IndexedElement {
    @JsonProperty(value="name")
    @JacksonXmlProperty(localName="name")
    @XmlElement(name="name")
    private String name = null;
    @JsonProperty(value="assay_refs")
    @XmlElement(name="assayRefs")
    private List<Assay> assayRefs = null;
    @JsonProperty(value="average_function")
    @JacksonXmlProperty(localName="average_function")
    @XmlElement(name="average_function")
    private Parameter averageFunction = null;
    @JsonProperty(value="variation_function")
    @JacksonXmlProperty(localName="variation_function")
    @XmlElement(name="variation_function")
    private Parameter variationFunction = null;
    @JsonProperty(value="description")
    @JacksonXmlProperty(localName="description")
    @XmlElement(name="description")
    private String description = null;
    @JsonProperty(value="factors")
    @XmlElement(name="factors")
    private List<Parameter> factors = null;

    @Override
    public StudyVariable id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public StudyVariable elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public StudyVariable name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The study variable name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StudyVariable assayRefs(List<Assay> assayRefs) {
        this.assayRefs = assayRefs;
        return this;
    }

    public StudyVariable addAssayRefsItem(Assay assayRefsItem) {
        if (this.assayRefs == null) {
            this.assayRefs = new ArrayList<Assay>();
        }
        this.assayRefs.add(assayRefsItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="The assays referenced by this study variable.")
    public List<Assay> getAssayRefs() {
        return this.assayRefs;
    }

    public void setAssayRefs(List<Assay> assayRefs) {
        this.assayRefs = assayRefs;
    }

    public StudyVariable averageFunction(Parameter averageFunction) {
        this.averageFunction = averageFunction;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The function used to calculate summarised small molecule quantities over the assays referenced by this study variable.")
    public Parameter getAverageFunction() {
        return this.averageFunction;
    }

    public void setAverageFunction(Parameter averageFunction) {
        this.averageFunction = averageFunction;
    }

    public StudyVariable variationFunction(Parameter variationFunction) {
        this.variationFunction = variationFunction;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The function used to calculate the variation of small molecule quantities over the assays referenced by this study variable.")
    public Parameter getVariationFunction() {
        return this.variationFunction;
    }

    public void setVariationFunction(Parameter variationFunction) {
        this.variationFunction = variationFunction;
    }

    public StudyVariable description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A free-form description of this study variable.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StudyVariable factors(List<Parameter> factors) {
        this.factors = factors;
        return this;
    }

    public StudyVariable addFactorsItem(Parameter factorsItem) {
        if (this.factors == null) {
            this.factors = new ArrayList<Parameter>();
        }
        this.factors.add(factorsItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Parameters indicating which factors were used for the assays referenced by this study variable, and at which levels.")
    public List<Parameter> getFactors() {
        return this.factors;
    }

    public void setFactors(List<Parameter> factors) {
        this.factors = factors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StudyVariable studyVariable = (StudyVariable)o;
        return Objects.equals(this.name, studyVariable.name) && Objects.equals(this.assayRefs, studyVariable.assayRefs) && Objects.equals(this.averageFunction, studyVariable.averageFunction) && Objects.equals(this.variationFunction, studyVariable.variationFunction) && Objects.equals(this.description, studyVariable.description) && Objects.equals(this.factors, studyVariable.factors) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.assayRefs, this.averageFunction, this.variationFunction, this.description, this.factors, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StudyVariable {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    assayRefs: ").append(this.toIndentedString(this.assayRefs)).append("\n");
        sb.append("    averageFunction: ").append(this.toIndentedString(this.averageFunction)).append("\n");
        sb.append("    variationFunction: ").append(this.toIndentedString(this.variationFunction)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    factors: ").append(this.toIndentedString(this.factors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        name("name"),
        assayRefs("assay_refs"),
        averageFunction("average_function"),
        variationFunction("variation_function"),
        description("description"),
        factors("factors");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

