/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Comment;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.SpectraRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="The small molecule evidence section is table-based, representing evidence for identifications of small molecules/features, from database search or any other process used to give putative identifications to molecules. In a typical case, each row represents one result from a single search or intepretation of a piece of evidence e.g. a database search with a fragmentation spectrum. Multiple results from a given input data item (e.g. one fragment spectrum) SHOULD share the same value under evidence_input_id.  The small molecule evidence section MUST always come after the Small Molecule Feature Table. All table columns MUST be Tab separated. There MUST NOT be any empty cells. Missing values MUST be reported using \u201cnull\u201d.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for \u201copt_\u201d columns. ")
@XmlRootElement(name="SmallMoleculeEvidence")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="SmallMoleculeEvidence")
public class SmallMoleculeEvidence {
    @JsonProperty(value="prefix")
    @JacksonXmlProperty(localName="prefix")
    @XmlElement(name="prefix")
    private PrefixEnum prefix = PrefixEnum.SME;
    @JsonProperty(value="header_prefix")
    @JacksonXmlProperty(localName="header_prefix")
    @XmlElement(name="header_prefix")
    private HeaderPrefixEnum headerPrefix = HeaderPrefixEnum.SEH;
    @JsonProperty(value="sme_id")
    @JacksonXmlProperty(localName="sme_id")
    @XmlElement(name="sme_id")
    private Integer smeId = null;
    @JsonProperty(value="evidence_input_id")
    @JacksonXmlProperty(localName="evidence_input_id")
    @XmlElement(name="evidence_input_id")
    private String evidenceInputId = null;
    @JsonProperty(value="database_identifier")
    @JacksonXmlProperty(localName="database_identifier")
    @XmlElement(name="database_identifier")
    private String databaseIdentifier = null;
    @JsonProperty(value="chemical_formula")
    @JacksonXmlProperty(localName="chemical_formula")
    @XmlElement(name="chemical_formula")
    private String chemicalFormula = null;
    @JsonProperty(value="smiles")
    @JacksonXmlProperty(localName="smiles")
    @XmlElement(name="smiles")
    private String smiles = null;
    @JsonProperty(value="inchi")
    @JacksonXmlProperty(localName="inchi")
    @XmlElement(name="inchi")
    private String inchi = null;
    @JsonProperty(value="chemical_name")
    @JacksonXmlProperty(localName="chemical_name")
    @XmlElement(name="chemical_name")
    private String chemicalName = null;
    @JsonProperty(value="uri")
    @JacksonXmlProperty(localName="uri")
    @XmlElement(name="uri")
    private String uri = null;
    @JsonProperty(value="derivatized_form")
    @JacksonXmlProperty(localName="derivatized_form")
    @XmlElement(name="derivatized_form")
    private Parameter derivatizedForm = null;
    @JsonProperty(value="adduct_ion")
    @JacksonXmlProperty(localName="adduct_ion")
    @XmlElement(name="adduct_ion")
    private String adductIon = null;
    @JsonProperty(value="exp_mass_to_charge")
    @JacksonXmlProperty(localName="exp_mass_to_charge")
    @XmlElement(name="exp_mass_to_charge")
    private Double expMassToCharge = null;
    @JsonProperty(value="charge")
    @JacksonXmlProperty(localName="charge")
    @XmlElement(name="charge")
    private Integer charge = null;
    @JsonProperty(value="theoretical_mass_to_charge")
    @JacksonXmlProperty(localName="theoretical_mass_to_charge")
    @XmlElement(name="theoretical_mass_to_charge")
    private Double theoreticalMassToCharge = null;
    @JsonProperty(value="spectra_ref")
    @XmlElement(name="spectraRef")
    private List<SpectraRef> spectraRef = new ArrayList<SpectraRef>();
    @JsonProperty(value="identification_method")
    @JacksonXmlProperty(localName="identification_method")
    @XmlElement(name="identification_method")
    private Parameter identificationMethod = null;
    @JsonProperty(value="ms_level")
    @JacksonXmlProperty(localName="ms_level")
    @XmlElement(name="ms_level")
    private Parameter msLevel = null;
    @JsonProperty(value="id_confidence_measure")
    @XmlElement(name="idConfidenceMeasure")
    private List<Double> idConfidenceMeasure = null;
    @JsonProperty(value="rank")
    @JacksonXmlProperty(localName="rank")
    @XmlElement(name="rank")
    private Integer rank = 1;
    @JsonProperty(value="opt")
    @XmlElement(name="opt")
    private List<OptColumnMapping> opt = null;
    @JsonProperty(value="comment")
    @XmlElement(name="comment")
    private List<Comment> comment = null;

    @ApiModelProperty(value="The small molecule evidence table row prefix. SME MUST be used for rows of the small molecule evidence table.")
    public PrefixEnum getPrefix() {
        return this.prefix;
    }

    @ApiModelProperty(value="The small molecule evidence table header prefix. SEH MUST be used for the small molecule evidence table header line (the column labels).")
    public HeaderPrefixEnum getHeaderPrefix() {
        return this.headerPrefix;
    }

    public SmallMoleculeEvidence smeId(Integer smeId) {
        this.smeId = smeId;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="A within file unique identifier for the small molecule evidence result.")
    public Integer getSmeId() {
        return this.smeId;
    }

    public void setSmeId(Integer smeId) {
        this.smeId = smeId;
    }

    public SmallMoleculeEvidence evidenceInputId(String evidenceInputId) {
        this.evidenceInputId = evidenceInputId;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="A within file unique identifier for the input data used to support this identification e.g. fragment spectrum, RT and m/z pair, isotope profile that was used for the identification process, to serve as a grouping mechanism, whereby multiple rows of results from the same input data share the same ID. The identifiers may be human readable but should not be assumed to be interpretable. For example, if fragmentation spectra have been searched then the ID may be the spectrum reference, or for accurate mass search, the ms_run[2]:458.75.")
    public String getEvidenceInputId() {
        return this.evidenceInputId;
    }

    public void setEvidenceInputId(String evidenceInputId) {
        this.evidenceInputId = evidenceInputId;
    }

    public SmallMoleculeEvidence databaseIdentifier(String databaseIdentifier) {
        this.databaseIdentifier = databaseIdentifier;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The putative identification for the small molecule sourced from an external database, using the same prefix specified in database[1-n]-prefix.  This could include additionally a chemical class or an identifier to a spectral library entity, even if its actual identity is unknown.  For the \u201cno database\u201d case, \"null\" must be used. The unprefixed use of \"null\" is prohibited for any other case. If no putative identification can be reported for a particular database, it MUST be reported as the database prefix followed by null. ")
    public String getDatabaseIdentifier() {
        return this.databaseIdentifier;
    }

    public void setDatabaseIdentifier(String databaseIdentifier) {
        this.databaseIdentifier = databaseIdentifier;
    }

    public SmallMoleculeEvidence chemicalFormula(String chemicalFormula) {
        this.chemicalFormula = chemicalFormula;
        return this;
    }

    @ApiModelProperty(value="The chemical formula of the identified compound e.g. in a database, assumed to match the theoretical mass to charge (in some cases this will be the derivatized form, including adducts and protons).  This should be specified in Hill notation (EA Hill 1900), i.e. elements in the order C, H and then alphabetically all other elements. Counts of one may be omitted. Elements should be capitalized properly to avoid confusion (e.g., \u201cCO\u201d vs. \u201cCo\u201d). The chemical formula reported should refer to the neutral form. Charge state is reported by the charge field.  Example N-acetylglucosamine would be encoded by the string \u201cC8H15NO6\u201d ")
    public String getChemicalFormula() {
        return this.chemicalFormula;
    }

    public void setChemicalFormula(String chemicalFormula) {
        this.chemicalFormula = chemicalFormula;
    }

    public SmallMoleculeEvidence smiles(String smiles) {
        this.smiles = smiles;
        return this;
    }

    @ApiModelProperty(value="The potential molecule\u2019s structure in the simplified molecular-input line-entry system (SMILES) for the small molecule.")
    public String getSmiles() {
        return this.smiles;
    }

    public void setSmiles(String smiles) {
        this.smiles = smiles;
    }

    public SmallMoleculeEvidence inchi(String inchi) {
        this.inchi = inchi;
        return this;
    }

    @ApiModelProperty(value="A standard IUPAC International Chemical Identifier (InChI) for the given substance.")
    public String getInchi() {
        return this.inchi;
    }

    public void setInchi(String inchi) {
        this.inchi = inchi;
    }

    public SmallMoleculeEvidence chemicalName(String chemicalName) {
        this.chemicalName = chemicalName;
        return this;
    }

    @ApiModelProperty(value="The small molecule\u2019s chemical/common name, or general description if a chemical name is unavailable.")
    public String getChemicalName() {
        return this.chemicalName;
    }

    public void setChemicalName(String chemicalName) {
        this.chemicalName = chemicalName;
    }

    public SmallMoleculeEvidence uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="A URI pointing to the small molecule\u2019s entry in a database (e.g., the small molecule\u2019s HMDB, Chebi or KEGG entry).")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public SmallMoleculeEvidence derivatizedForm(Parameter derivatizedForm) {
        this.derivatizedForm = derivatizedForm;
        return this;
    }

    @Valid
    @ApiModelProperty(value="If a derivatized form has been analysed by MS, then the functional group attached to the molecule should be reported here using suitable userParam or CV terms as appropriate.")
    public Parameter getDerivatizedForm() {
        return this.derivatizedForm;
    }

    public void setDerivatizedForm(Parameter derivatizedForm) {
        this.derivatizedForm = derivatizedForm;
    }

    public SmallMoleculeEvidence adductIon(String adductIon) {
        this.adductIon = adductIon;
        return this;
    }

    @Pattern(regexp="^\\[\\d*M([-][\\w]*)\\]\\d*[+-]$")
    @ApiModelProperty(value="The assumed classification of this molecule\u2019s adduct ion after detection, following the general style in the 2013 IUPAC recommendations on terms relating to MS e.g. [M+H]+, [M+Na]1+, [M+NH4]1+, [M-H]1-, [M+Cl]1-. If the adduct classification is ambiguous with regards to identification evidence it MAY be null.")
    public @Pattern(regexp="^\\[\\d*M([-][\\w]*)\\]\\d*[+-]$") String getAdductIon() {
        return this.adductIon;
    }

    public void setAdductIon(String adductIon) {
        this.adductIon = adductIon;
    }

    public SmallMoleculeEvidence expMassToCharge(Double expMassToCharge) {
        this.expMassToCharge = expMassToCharge;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The experimental mass/charge value for the precursor ion. If multiple adduct forms have been combined into a single identification event/search, then a single value e.g. for the protonated form SHOULD be reported here.")
    public Double getExpMassToCharge() {
        return this.expMassToCharge;
    }

    public void setExpMassToCharge(Double expMassToCharge) {
        this.expMassToCharge = expMassToCharge;
    }

    public SmallMoleculeEvidence charge(Integer charge) {
        this.charge = charge;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The small molecule evidence\u2019s charge value using positive integers both for positive and negative polarity modes.")
    public Integer getCharge() {
        return this.charge;
    }

    public void setCharge(Integer charge) {
        this.charge = charge;
    }

    public SmallMoleculeEvidence theoreticalMassToCharge(Double theoreticalMassToCharge) {
        this.theoreticalMassToCharge = theoreticalMassToCharge;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The theoretical mass/charge value for the small molecule or the database mass/charge value (for a spectral library match).")
    public Double getTheoreticalMassToCharge() {
        return this.theoreticalMassToCharge;
    }

    public void setTheoreticalMassToCharge(Double theoreticalMassToCharge) {
        this.theoreticalMassToCharge = theoreticalMassToCharge;
    }

    public SmallMoleculeEvidence spectraRef(List<SpectraRef> spectraRef) {
        this.spectraRef = spectraRef;
        return this;
    }

    public SmallMoleculeEvidence addSpectraRefItem(SpectraRef spectraRefItem) {
        this.spectraRef.add(spectraRefItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Reference to a spectrum in a spectrum file, for example a fragmentation spectrum has been used to support the identification. If a separate spectrum file has been used for fragmentation spectrum, this MUST be reported in the metadata section as additional ms_runs. The reference must be in the format ms_run[1-n]:{SPECTRA_REF} where SPECTRA_REF MUST follow the format defined in 5.2 (including references to chromatograms where these are used to inform identification). Multiple spectra MUST be referenced using a \u201c|\u201d delimited list for the (rare) cases in which search engines have combined or aggregated multiple spectra in advance of the search to make identifications.  If a fragmentation spectrum has not been used, the value should indicate the ms_run to which is identification is mapped e.g. \u201cms_run[1]\u201d. ")
    public List<SpectraRef> getSpectraRef() {
        return this.spectraRef;
    }

    public void setSpectraRef(List<SpectraRef> spectraRef) {
        this.spectraRef = spectraRef;
    }

    public SmallMoleculeEvidence identificationMethod(Parameter identificationMethod) {
        this.identificationMethod = identificationMethod;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The database search, search engine or process that was used to identify this small molecule e.g. the name of software, database or manual curation etc. If manual validation has been performed quality, the following CV term SHOULD be used: 'quality estimation by manual validation' MS:1001058.")
    public Parameter getIdentificationMethod() {
        return this.identificationMethod;
    }

    public void setIdentificationMethod(Parameter identificationMethod) {
        this.identificationMethod = identificationMethod;
    }

    public SmallMoleculeEvidence msLevel(Parameter msLevel) {
        this.msLevel = msLevel;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The highest MS level used to inform identification e.g. MS1 (accurate mass only) = \u201cms level=1\u201d or from an MS2 fragmentation spectrum = \u201cms level=2\u201d. For direct fragmentation or data independent approaches where fragmentation data is used, appropriate CV terms SHOULD be used .")
    public Parameter getMsLevel() {
        return this.msLevel;
    }

    public void setMsLevel(Parameter msLevel) {
        this.msLevel = msLevel;
    }

    public SmallMoleculeEvidence idConfidenceMeasure(List<Double> idConfidenceMeasure) {
        this.idConfidenceMeasure = idConfidenceMeasure;
        return this;
    }

    public SmallMoleculeEvidence addIdConfidenceMeasureItem(Double idConfidenceMeasureItem) {
        if (this.idConfidenceMeasure == null) {
            this.idConfidenceMeasure = new ArrayList<Double>();
        }
        this.idConfidenceMeasure.add(idConfidenceMeasureItem);
        return this;
    }

    @ApiModelProperty(value="Any statistical value or score for the identification. The metadata section reports the type of score used, as id_confidence_measure[1-n] of type Param.")
    public List<Double> getIdConfidenceMeasure() {
        return this.idConfidenceMeasure;
    }

    public void setIdConfidenceMeasure(List<Double> idConfidenceMeasure) {
        this.idConfidenceMeasure = idConfidenceMeasure;
    }

    public SmallMoleculeEvidence rank(Integer rank) {
        this.rank = rank;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @ApiModelProperty(required=true, value="The rank of this identification from this approach as increasing integers from 1 (best ranked identification). Ties (equal score) are represented by using the same rank \u2013 defaults to 1 if there is no ranking system used.")
    public @NotNull @Min(value=1L) Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public SmallMoleculeEvidence opt(List<OptColumnMapping> opt) {
        this.opt = opt;
        return this;
    }

    public SmallMoleculeEvidence addOptItem(OptColumnMapping optItem) {
        if (this.opt == null) {
            this.opt = new ArrayList<OptColumnMapping>();
        }
        this.opt.add(optItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Additional columns can be added to the end of the small molecule evidence table. These column headers MUST start with the prefix \u201copt_\u201d followed by the {identifier} of the object they reference: assay, study variable, MS run or \u201cglobal\u201d (if the value relates to all replicates). Column names MUST only contain the following characters: \u2018A\u2019-\u2018Z\u2019, \u2018a\u2019-\u2018z\u2019, \u20180\u2019-\u20189\u2019, \u2018\u2019, \u2018-\u2019, \u2018[\u2019, \u2018]\u2019, and \u2018:\u2019. CV parameter accessions MAY be used for optional columns following the format: opt{identifier}_cv_{accession}_\\{parameter name}. Spaces within the parameter\u2019s name MUST be replaced by \u2018_\u2019. ")
    public List<OptColumnMapping> getOpt() {
        return this.opt;
    }

    public void setOpt(List<OptColumnMapping> opt) {
        this.opt = opt;
    }

    public SmallMoleculeEvidence comment(List<Comment> comment) {
        this.comment = comment;
        return this;
    }

    public SmallMoleculeEvidence addCommentItem(Comment commentItem) {
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }
        this.comment.add(commentItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<Comment> getComment() {
        return this.comment;
    }

    public void setComment(List<Comment> comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmallMoleculeEvidence smallMoleculeEvidence = (SmallMoleculeEvidence)o;
        return Objects.equals((Object)this.prefix, (Object)smallMoleculeEvidence.prefix) && Objects.equals((Object)this.headerPrefix, (Object)smallMoleculeEvidence.headerPrefix) && Objects.equals(this.smeId, smallMoleculeEvidence.smeId) && Objects.equals(this.evidenceInputId, smallMoleculeEvidence.evidenceInputId) && Objects.equals(this.databaseIdentifier, smallMoleculeEvidence.databaseIdentifier) && Objects.equals(this.chemicalFormula, smallMoleculeEvidence.chemicalFormula) && Objects.equals(this.smiles, smallMoleculeEvidence.smiles) && Objects.equals(this.inchi, smallMoleculeEvidence.inchi) && Objects.equals(this.chemicalName, smallMoleculeEvidence.chemicalName) && Objects.equals(this.uri, smallMoleculeEvidence.uri) && Objects.equals(this.derivatizedForm, smallMoleculeEvidence.derivatizedForm) && Objects.equals(this.adductIon, smallMoleculeEvidence.adductIon) && Objects.equals(this.expMassToCharge, smallMoleculeEvidence.expMassToCharge) && Objects.equals(this.charge, smallMoleculeEvidence.charge) && Objects.equals(this.theoreticalMassToCharge, smallMoleculeEvidence.theoreticalMassToCharge) && Objects.equals(this.spectraRef, smallMoleculeEvidence.spectraRef) && Objects.equals(this.identificationMethod, smallMoleculeEvidence.identificationMethod) && Objects.equals(this.msLevel, smallMoleculeEvidence.msLevel) && Objects.equals(this.idConfidenceMeasure, smallMoleculeEvidence.idConfidenceMeasure) && Objects.equals(this.rank, smallMoleculeEvidence.rank) && Objects.equals(this.opt, smallMoleculeEvidence.opt) && Objects.equals(this.comment, smallMoleculeEvidence.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.headerPrefix, this.smeId, this.evidenceInputId, this.databaseIdentifier, this.chemicalFormula, this.smiles, this.inchi, this.chemicalName, this.uri, this.derivatizedForm, this.adductIon, this.expMassToCharge, this.charge, this.theoreticalMassToCharge, this.spectraRef, this.identificationMethod, this.msLevel, this.idConfidenceMeasure, this.rank, this.opt, this.comment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmallMoleculeEvidence {\n");
        sb.append("    prefix: ").append(this.toIndentedString((Object)this.prefix)).append("\n");
        sb.append("    headerPrefix: ").append(this.toIndentedString((Object)this.headerPrefix)).append("\n");
        sb.append("    smeId: ").append(this.toIndentedString(this.smeId)).append("\n");
        sb.append("    evidenceInputId: ").append(this.toIndentedString(this.evidenceInputId)).append("\n");
        sb.append("    databaseIdentifier: ").append(this.toIndentedString(this.databaseIdentifier)).append("\n");
        sb.append("    chemicalFormula: ").append(this.toIndentedString(this.chemicalFormula)).append("\n");
        sb.append("    smiles: ").append(this.toIndentedString(this.smiles)).append("\n");
        sb.append("    inchi: ").append(this.toIndentedString(this.inchi)).append("\n");
        sb.append("    chemicalName: ").append(this.toIndentedString(this.chemicalName)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    derivatizedForm: ").append(this.toIndentedString(this.derivatizedForm)).append("\n");
        sb.append("    adductIon: ").append(this.toIndentedString(this.adductIon)).append("\n");
        sb.append("    expMassToCharge: ").append(this.toIndentedString(this.expMassToCharge)).append("\n");
        sb.append("    charge: ").append(this.toIndentedString(this.charge)).append("\n");
        sb.append("    theoreticalMassToCharge: ").append(this.toIndentedString(this.theoreticalMassToCharge)).append("\n");
        sb.append("    spectraRef: ").append(this.toIndentedString(this.spectraRef)).append("\n");
        sb.append("    identificationMethod: ").append(this.toIndentedString(this.identificationMethod)).append("\n");
        sb.append("    msLevel: ").append(this.toIndentedString(this.msLevel)).append("\n");
        sb.append("    idConfidenceMeasure: ").append(this.toIndentedString(this.idConfidenceMeasure)).append("\n");
        sb.append("    rank: ").append(this.toIndentedString(this.rank)).append("\n");
        sb.append("    opt: ").append(this.toIndentedString(this.opt)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HeaderPrefixEnum {
        SEH("SEH");

        private String value;

        private HeaderPrefixEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HeaderPrefixEnum fromValue(String text) {
            for (HeaderPrefixEnum b : HeaderPrefixEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PrefixEnum {
        SME("SME");

        private String value;

        private PrefixEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrefixEnum fromValue(String text) {
            for (PrefixEnum b : PrefixEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum Properties {
        prefix("prefix"),
        headerPrefix("header_prefix"),
        smeId("sme_id"),
        evidenceInputId("evidence_input_id"),
        databaseIdentifier("database_identifier"),
        chemicalFormula("chemical_formula"),
        smiles("smiles"),
        inchi("inchi"),
        chemicalName("chemical_name"),
        uri("uri"),
        derivatizedForm("derivatized_form"),
        adductIon("adduct_ion"),
        expMassToCharge("exp_mass_to_charge"),
        charge("charge"),
        theoreticalMassToCharge("theoretical_mass_to_charge"),
        spectraRef("spectra_ref"),
        identificationMethod("identification_method"),
        msLevel("ms_level"),
        idConfidenceMeasure("id_confidence_measure"),
        rank("rank"),
        opt("opt"),
        comment("comment");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

