/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="A publication item, defined by a qualifier and a native accession, e.g. pubmed id.")
@XmlRootElement(name="PublicationItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="PublicationItem")
public class PublicationItem {
    @JsonProperty(value="type")
    @JacksonXmlProperty(localName="type")
    @XmlElement(name="type")
    private TypeEnum type = TypeEnum.DOI;
    @JsonProperty(value="accession")
    @JacksonXmlProperty(localName="accession")
    @XmlElement(name="accession")
    private String accession = null;

    public PublicationItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The type qualifier of this publication item.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PublicationItem accession(String accession) {
        this.accession = accession;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The native accession id for this publication item.")
    public String getAccession() {
        return this.accession;
    }

    public void setAccession(String accession) {
        this.accession = accession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicationItem publicationItem = (PublicationItem)o;
        return Objects.equals((Object)this.type, (Object)publicationItem.type) && Objects.equals(this.accession, publicationItem.accession);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.accession});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PublicationItem {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    accession: ").append(this.toIndentedString(this.accession)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        DOI("doi"),
        PUBMED("pubmed"),
        URI("uri");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum Properties {
        type("type"),
        accession("accession");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

