/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Specification of databases. (empty): The description of databases used. For cases, where a known database has not been used for identification, a userParam SHOULD be inserted to describe any identification performed e.g. de novo. If no identification has been performed at all then \"no database\" should be inserted followed by null. prefix: The prefix used in the \u201cidentifier\u201d column of data tables. For the \u201cno database\u201d case \"null\" must be used. version: The database version is mandatory where identification has been performed. This may be a formal version number e.g. \u201c1.4.1\u201d, a date of access \u201c2016-10-27\u201d (ISO-8601 format) or \u201cUnknown\u201d if there is no suitable version that can be annotated. uri: The URI to the database. For the \u201cno database\u201d case, \"null\" must be reported. ")
@XmlRootElement(name="Database")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Database")
public class Database
extends IndexedElement {
    @JsonProperty(value="param")
    @JacksonXmlProperty(localName="param")
    @XmlElement(name="param")
    private Parameter param = null;
    @JsonProperty(value="prefix")
    @JacksonXmlProperty(localName="prefix")
    @XmlElement(name="prefix")
    private String prefix = "null";
    @JsonProperty(value="version")
    @JacksonXmlProperty(localName="version")
    @XmlElement(name="version")
    private String version = null;
    @JsonProperty(value="uri")
    @JacksonXmlProperty(localName="uri")
    @XmlElement(name="uri")
    private String uri = null;

    @Override
    public Database id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public Database elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public Database param(Parameter param) {
        this.param = param;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The parameter to identify this database.")
    public Parameter getParam() {
        return this.param;
    }

    public void setParam(Parameter param) {
        this.param = param;
    }

    public Database prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The database prefix.")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Database version(String version) {
        this.version = version;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The database version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Database uri(String uri) {
        this.uri = uri;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The URI to the online database.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Database database = (Database)o;
        return Objects.equals(this.param, database.param) && Objects.equals(this.prefix, database.prefix) && Objects.equals(this.version, database.version) && Objects.equals(this.uri, database.uri) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.param, this.prefix, this.version, this.uri, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Database {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    param: ").append(this.toIndentedString(this.param)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        param("param"),
        prefix("prefix"),
        version("version"),
        uri("uri");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

