/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.Sample;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Specification of assay. (empty) name: A name for each assay, to serve as a list of the assays that MUST be reported in the following tables.  custom: Additional custom parameters or values for a given assay.  external_uri: An external reference uri to further information about the assay, for example via a reference to an object within an ISA-TAB file.  sample_ref: An association from a given assay to the sample analysed.  ms_run_ref: An association from a given assay to the source MS run. All assays MUST reference exactly one ms_run unless a workflow with pre-fractionation is being encoded, in which case each assay MUST reference n ms_runs where n fractions have been collected. Multiple assays SHOULD reference the same ms_run to capture multiplexed experimental designs.       ")
@XmlRootElement(name="Assay")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Assay")
public class Assay
extends IndexedElement {
    @JsonProperty(value="name")
    @JacksonXmlProperty(localName="name")
    @XmlElement(name="name")
    private String name = null;
    @JsonProperty(value="custom")
    @XmlElement(name="custom")
    private List<Parameter> custom = null;
    @JsonProperty(value="external_uri")
    @JacksonXmlProperty(localName="external_uri")
    @XmlElement(name="external_uri")
    private String externalUri = null;
    @JsonProperty(value="sample_ref")
    @JacksonXmlProperty(localName="sample_ref")
    @XmlElement(name="sample_ref")
    private Sample sampleRef = null;
    @JsonProperty(value="ms_run_ref")
    @XmlElement(name="msRunRef")
    private List<MsRun> msRunRef = new ArrayList<MsRun>();

    @Override
    public Assay id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public Assay elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public Assay name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The assay name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Assay custom(List<Parameter> custom) {
        this.custom = custom;
        return this;
    }

    public Assay addCustomItem(Parameter customItem) {
        if (this.custom == null) {
            this.custom = new ArrayList<Parameter>();
        }
        this.custom.add(customItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Additional user or cv parameters.")
    public List<Parameter> getCustom() {
        return this.custom;
    }

    public void setCustom(List<Parameter> custom) {
        this.custom = custom;
    }

    public Assay externalUri(String externalUri) {
        this.externalUri = externalUri;
        return this;
    }

    @ApiModelProperty(value="An external URI to further information about this assay.")
    public String getExternalUri() {
        return this.externalUri;
    }

    public void setExternalUri(String externalUri) {
        this.externalUri = externalUri;
    }

    public Assay sampleRef(Sample sampleRef) {
        this.sampleRef = sampleRef;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The sample referenced by this assay.")
    public Sample getSampleRef() {
        return this.sampleRef;
    }

    public void setSampleRef(Sample sampleRef) {
        this.sampleRef = sampleRef;
    }

    public Assay msRunRef(List<MsRun> msRunRef) {
        this.msRunRef = msRunRef;
        return this;
    }

    public Assay addMsRunRefItem(MsRun msRunRefItem) {
        this.msRunRef.add(msRunRefItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="The ms run(s) referenced by this assay.")
    public @NotNull @Valid @Size(min=1) List<MsRun> getMsRunRef() {
        return this.msRunRef;
    }

    public void setMsRunRef(List<MsRun> msRunRef) {
        this.msRunRef = msRunRef;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assay assay = (Assay)o;
        return Objects.equals(this.name, assay.name) && Objects.equals(this.custom, assay.custom) && Objects.equals(this.externalUri, assay.externalUri) && Objects.equals(this.sampleRef, assay.sampleRef) && Objects.equals(this.msRunRef, assay.msRunRef) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.custom, this.externalUri, this.sampleRef, this.msRunRef, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Assay {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    externalUri: ").append(this.toIndentedString(this.externalUri)).append("\n");
        sb.append("    sampleRef: ").append(this.toIndentedString(this.sampleRef)).append("\n");
        sb.append("    msRunRef: ").append(this.toIndentedString(this.msRunRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        name("name"),
        custom("custom"),
        externalUri("external_uri"),
        sampleRef("sample_ref"),
        msRunRef("ms_run_ref");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

