/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.streaming.GZIPSheetDataWriter;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SheetDataWriter;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SXSSFWorkbook
implements Workbook {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    XSSFWorkbook _wb;
    HashMap<SXSSFSheet, XSSFSheet> _sxFromXHash = new HashMap();
    HashMap<XSSFSheet, SXSSFSheet> _xFromSxHash = new HashMap();
    private int _randomAccessWindowSize = 100;
    private boolean _compressTmpFiles = false;
    private SharedStringsTable _sharedStringSource = null;

    public SXSSFWorkbook() {
        this(null);
    }

    public SXSSFWorkbook(XSSFWorkbook workbook) {
        this(workbook, 100);
    }

    public SXSSFWorkbook(XSSFWorkbook workbook, int rowAccessWindowSize) {
        this(workbook, rowAccessWindowSize, false);
    }

    public SXSSFWorkbook(XSSFWorkbook workbook, int rowAccessWindowSize, boolean compressTmpFiles) {
        this(workbook, rowAccessWindowSize, compressTmpFiles, false);
    }

    public SXSSFWorkbook(XSSFWorkbook workbook, int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        this.setRandomAccessWindowSize(rowAccessWindowSize);
        this.setCompressTempFiles(compressTmpFiles);
        if (workbook == null) {
            this._wb = new XSSFWorkbook();
            if (useSharedStringsTable) {
                this._sharedStringSource = this._wb.getSharedStringSource();
            }
        } else {
            this._wb = workbook;
            if (useSharedStringsTable) {
                this._sharedStringSource = this._wb.getSharedStringSource();
            }
            for (int i = 0; i < this._wb.getNumberOfSheets(); ++i) {
                XSSFSheet sheet = this._wb.getSheetAt(i);
                this.createAndRegisterSXSSFSheet(sheet);
            }
        }
    }

    public SXSSFWorkbook(int rowAccessWindowSize) {
        this(null, rowAccessWindowSize);
    }

    public int getRandomAccessWindowSize() {
        return this._randomAccessWindowSize;
    }

    private void setRandomAccessWindowSize(int rowAccessWindowSize) {
        if (rowAccessWindowSize == 0 || rowAccessWindowSize < -1) {
            throw new IllegalArgumentException("rowAccessWindowSize must be greater than 0 or -1");
        }
        this._randomAccessWindowSize = rowAccessWindowSize;
    }

    public void setCompressTempFiles(boolean compress) {
        this._compressTmpFiles = compress;
    }

    SheetDataWriter createSheetDataWriter() throws IOException {
        if (this._compressTmpFiles) {
            return new GZIPSheetDataWriter(this._sharedStringSource);
        }
        return new SheetDataWriter(this._sharedStringSource);
    }

    XSSFSheet getXSSFSheet(SXSSFSheet sheet) {
        XSSFSheet result = this._sxFromXHash.get(sheet);
        return result;
    }

    SXSSFSheet getSXSSFSheet(XSSFSheet sheet) {
        SXSSFSheet result = this._xFromSxHash.get(sheet);
        return result;
    }

    void registerSheetMapping(SXSSFSheet sxSheet, XSSFSheet xSheet) {
        this._sxFromXHash.put(sxSheet, xSheet);
        this._xFromSxHash.put(xSheet, sxSheet);
    }

    void deregisterSheetMapping(XSSFSheet xSheet) {
        SXSSFSheet sxSheet = this.getSXSSFSheet(xSheet);
        try {
            sxSheet.getSheetDataWriter().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._sxFromXHash.remove(sxSheet);
        this._xFromSxHash.remove(xSheet);
    }

    private XSSFSheet getSheetFromZipEntryName(String sheetRef) {
        for (XSSFSheet sheet : this._sxFromXHash.values()) {
            if (!sheetRef.equals(sheet.getPackagePart().getPartName().getName().substring(1))) continue;
            return sheet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectData(File zipfile, OutputStream out) throws IOException {
        ZipFile zip = new ZipFile(zipfile);
        try {
            ZipOutputStream zos = new ZipOutputStream(out);
            try {
                Enumeration<? extends ZipEntry> en = zip.entries();
                while (en.hasMoreElements()) {
                    ZipEntry ze = en.nextElement();
                    zos.putNextEntry(new ZipEntry(ze.getName()));
                    InputStream is = zip.getInputStream(ze);
                    XSSFSheet xSheet = this.getSheetFromZipEntryName(ze.getName());
                    if (xSheet != null) {
                        SXSSFSheet sxSheet = this.getSXSSFSheet(xSheet);
                        InputStream xis = sxSheet.getWorksheetXMLInputStream();
                        try {
                            SXSSFWorkbook.copyStreamAndInjectWorksheet(is, zos, xis);
                        }
                        finally {
                            xis.close();
                        }
                    } else {
                        SXSSFWorkbook.copyStream(is, zos);
                    }
                    is.close();
                }
            }
            finally {
                zos.close();
            }
        }
        finally {
            zip.close();
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] chunk = new byte[1024];
        while ((count = in.read(chunk)) >= 0) {
            out.write(chunk, 0, count);
        }
    }

    private static void copyStreamAndInjectWorksheet(InputStream in, OutputStream out, InputStream worksheetData) throws IOException {
        int c;
        InputStreamReader inReader = new InputStreamReader(in, "UTF-8");
        OutputStreamWriter outWriter = new OutputStreamWriter(out, "UTF-8");
        boolean needsStartTag = true;
        int pos = 0;
        String s = "<sheetData";
        int n = s.length();
        while ((c = inReader.read()) != -1) {
            if (c == s.charAt(pos)) {
                if (++pos != n) continue;
                if (!"<sheetData".equals(s)) break;
                c = inReader.read();
                if (c == -1) {
                    outWriter.write(s);
                    break;
                }
                if (c == 62) {
                    outWriter.write(s);
                    outWriter.write(c);
                    s = "</sheetData>";
                    n = s.length();
                    pos = 0;
                    needsStartTag = false;
                    continue;
                }
                if (c == 47) {
                    c = inReader.read();
                    if (c == -1) {
                        outWriter.write(s);
                        break;
                    }
                    if (c == 62) break;
                    outWriter.write(s);
                    outWriter.write(47);
                    outWriter.write(c);
                    pos = 0;
                    continue;
                }
                outWriter.write(s);
                outWriter.write(47);
                outWriter.write(c);
                pos = 0;
                continue;
            }
            if (pos > 0) {
                outWriter.write(s, 0, pos);
            }
            if (c == s.charAt(0)) {
                pos = 1;
                continue;
            }
            outWriter.write(c);
            pos = 0;
        }
        outWriter.flush();
        if (needsStartTag) {
            outWriter.write("<sheetData>\n");
            outWriter.flush();
        }
        SXSSFWorkbook.copyStream(worksheetData, out);
        outWriter.write("</sheetData>");
        outWriter.flush();
        while ((c = inReader.read()) != -1) {
            outWriter.write(c);
        }
        outWriter.flush();
    }

    public XSSFWorkbook getXSSFWorkbook() {
        return this._wb;
    }

    public int getActiveSheetIndex() {
        return this._wb.getActiveSheetIndex();
    }

    public void setActiveSheet(int sheetIndex) {
        this._wb.setActiveSheet(sheetIndex);
    }

    public int getFirstVisibleTab() {
        return this._wb.getFirstVisibleTab();
    }

    public void setFirstVisibleTab(int sheetIndex) {
        this._wb.setFirstVisibleTab(sheetIndex);
    }

    public void setSheetOrder(String sheetname, int pos) {
        this._wb.setSheetOrder(sheetname, pos);
    }

    public void setSelectedTab(int index) {
        this._wb.setSelectedTab(index);
    }

    public void setSheetName(int sheet, String name) {
        this._wb.setSheetName(sheet, name);
    }

    public String getSheetName(int sheet) {
        return this._wb.getSheetName(sheet);
    }

    public int getSheetIndex(String name) {
        return this._wb.getSheetIndex(name);
    }

    public int getSheetIndex(Sheet sheet) {
        return this._wb.getSheetIndex(this.getXSSFSheet((SXSSFSheet)sheet));
    }

    public Sheet createSheet() {
        return this.createAndRegisterSXSSFSheet(this._wb.createSheet());
    }

    SXSSFSheet createAndRegisterSXSSFSheet(XSSFSheet xSheet) {
        SXSSFSheet sxSheet = null;
        try {
            sxSheet = new SXSSFSheet(this, xSheet);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.registerSheetMapping(sxSheet, xSheet);
        return sxSheet;
    }

    public Sheet createSheet(String sheetname) {
        return this.createAndRegisterSXSSFSheet(this._wb.createSheet(sheetname));
    }

    public Sheet cloneSheet(int sheetNum) {
        throw new RuntimeException("NotImplemented");
    }

    public int getNumberOfSheets() {
        return this._wb.getNumberOfSheets();
    }

    public Sheet getSheetAt(int index) {
        return this.getSXSSFSheet(this._wb.getSheetAt(index));
    }

    public Sheet getSheet(String name) {
        return this.getSXSSFSheet(this._wb.getSheet(name));
    }

    public void removeSheetAt(int index) {
        XSSFSheet xSheet = this._wb.getSheetAt(index);
        SXSSFSheet sxSheet = this.getSXSSFSheet(xSheet);
        this._wb.removeSheetAt(index);
        this.deregisterSheetMapping(xSheet);
        sxSheet.dispose();
    }

    @Deprecated
    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        this._wb.setRepeatingRowsAndColumns(sheetIndex, startColumn, endColumn, startRow, endRow);
    }

    public Font createFont() {
        return this._wb.createFont();
    }

    public Font findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        return this._wb.findFont(boldWeight, color, fontHeight, name, italic, strikeout, typeOffset, underline);
    }

    public short getNumberOfFonts() {
        return this._wb.getNumberOfFonts();
    }

    public Font getFontAt(short idx) {
        return this._wb.getFontAt(idx);
    }

    public CellStyle createCellStyle() {
        return this._wb.createCellStyle();
    }

    public short getNumCellStyles() {
        return this._wb.getNumCellStyles();
    }

    public CellStyle getCellStyleAt(short idx) {
        return this._wb.getCellStyleAt(idx);
    }

    public void close() throws IOException {
        for (SXSSFSheet sheet : this._xFromSxHash.values()) {
            try {
                sheet.getSheetDataWriter().close();
            }
            catch (IOException iOException) {}
        }
        this._wb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream stream) throws IOException {
        for (SXSSFSheet sheet : this._xFromSxHash.values()) {
            sheet.flushRows();
        }
        File tmplFile = TempFile.createTempFile((String)"poi-sxssf-template", (String)".xlsx");
        try {
            FileOutputStream os = new FileOutputStream(tmplFile);
            try {
                this._wb.write(os);
            }
            finally {
                os.close();
            }
            this.injectData(tmplFile, stream);
        }
        finally {
            if (!tmplFile.delete()) {
                throw new IOException("Could not delete temporary file after processing: " + tmplFile);
            }
        }
    }

    public boolean dispose() {
        boolean success = true;
        for (SXSSFSheet sheet : this._sxFromXHash.keySet()) {
            success = sheet.dispose() && success;
        }
        return success;
    }

    public int getNumberOfNames() {
        return this._wb.getNumberOfNames();
    }

    public Name getName(String name) {
        return this._wb.getName(name);
    }

    public Name getNameAt(int nameIndex) {
        return this._wb.getNameAt(nameIndex);
    }

    public Name createName() {
        return this._wb.createName();
    }

    public int getNameIndex(String name) {
        return this._wb.getNameIndex(name);
    }

    public void removeName(int index) {
        this._wb.removeName(index);
    }

    public void removeName(String name) {
        this._wb.removeName(name);
    }

    public void setPrintArea(int sheetIndex, String reference) {
        this._wb.setPrintArea(sheetIndex, reference);
    }

    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        this._wb.setPrintArea(sheetIndex, startColumn, endColumn, startRow, endRow);
    }

    public String getPrintArea(int sheetIndex) {
        return this._wb.getPrintArea(sheetIndex);
    }

    public void removePrintArea(int sheetIndex) {
        this._wb.removePrintArea(sheetIndex);
    }

    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this._wb.getMissingCellPolicy();
    }

    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this._wb.setMissingCellPolicy(missingCellPolicy);
    }

    public DataFormat createDataFormat() {
        return this._wb.createDataFormat();
    }

    public int addPicture(byte[] pictureData, int format) {
        return this._wb.addPicture(pictureData, format);
    }

    public List<? extends PictureData> getAllPictures() {
        return this._wb.getAllPictures();
    }

    public CreationHelper getCreationHelper() {
        return this._wb.getCreationHelper();
    }

    public boolean isHidden() {
        return this._wb.isHidden();
    }

    public void setHidden(boolean hiddenFlag) {
        this._wb.setHidden(hiddenFlag);
    }

    public boolean isSheetHidden(int sheetIx) {
        return this._wb.isSheetHidden(sheetIx);
    }

    public boolean isSheetVeryHidden(int sheetIx) {
        return this._wb.isSheetVeryHidden(sheetIx);
    }

    public void setSheetHidden(int sheetIx, boolean hidden) {
        this._wb.setSheetHidden(sheetIx, hidden);
    }

    public void setSheetHidden(int sheetIx, int hidden) {
        this._wb.setSheetHidden(sheetIx, hidden);
    }

    public int linkExternalWorkbook(String name, Workbook workbook) {
        throw new RuntimeException("NotImplemented");
    }

    public void addToolPack(UDFFinder toopack) {
        this._wb.addToolPack(toopack);
    }

    public void setForceFormulaRecalculation(boolean value) {
        this._wb.setForceFormulaRecalculation(value);
    }

    public boolean getForceFormulaRecalculation() {
        return this._wb.getForceFormulaRecalculation();
    }
}

