/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.SmallMoleculeFeature;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.jmztab2.model.AbundanceColumn;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.ISmallMoleculeFeatureColumn;
import uk.ac.ebi.pride.jmztab2.model.MZBoolean;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.OptionColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeFeatureColumn;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabDataLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;
import uk.ac.ebi.pride.jmztab2.utils.parser.PositionMapping;

public class SMFLineParser
extends MZTabDataLineParser<SmallMoleculeFeature> {
    private SmallMoleculeFeature smallMoleculeFeature;

    public SMFLineParser(MZTabParserContext context, MZTabColumnFactory factory, PositionMapping positionMapping, Metadata metadata, MZTabErrorList errorList) {
        super(context, factory, positionMapping, metadata, errorList);
    }

    @Override
    protected int checkData() {
        int physicalPosition;
        this.smallMoleculeFeature = new SmallMoleculeFeature();
        for (physicalPosition = 1; physicalPosition < this.items.length; ++physicalPosition) {
            String logicalPosition = this.positionMapping.get(physicalPosition);
            IMZTabColumn column = (IMZTabColumn)this.factory.getColumnMapping().get(logicalPosition);
            if (column == null) continue;
            String columnName = column.getName();
            String target = this.items[physicalPosition];
            if (column instanceof ISmallMoleculeFeatureColumn) {
                SmallMoleculeFeatureColumn.Stable stableColumn = SmallMoleculeFeatureColumn.Stable.forName(columnName);
                switch (stableColumn) {
                    case ADDUCT_ION: {
                        String adductIon = this.checkString(column, target);
                        this.checkRegexMatches(this.errorList, this.lineNumber, SmallMoleculeFeature.Properties.adductIon, "^\\[\\d*M([+-][\\w\\d]+)*\\]\\d*[+-]$", Arrays.asList(adductIon));
                        this.smallMoleculeFeature.adductIon(adductIon);
                        break;
                    }
                    case CHARGE: {
                        this.smallMoleculeFeature.charge(this.checkInteger(column, this.checkData(column, target, false)));
                        break;
                    }
                    case EXP_MASS_TO_CHARGE: {
                        this.smallMoleculeFeature.expMassToCharge(this.checkDouble(column, this.checkData(column, target, false)));
                        break;
                    }
                    case ISOTOPOMER: {
                        this.smallMoleculeFeature.isotopomer(this.checkParameter(column, target, true));
                        break;
                    }
                    case RETENTION_TIME_IN_SECONDS: {
                        this.smallMoleculeFeature.retentionTimeInSeconds(this.checkDouble(column, target));
                        break;
                    }
                    case RETENTION_TIME_IN_SECONDS_END: {
                        this.smallMoleculeFeature.retentionTimeInSecondsEnd(this.checkDouble(column, target));
                        break;
                    }
                    case RETENTION_TIME_IN_SECONDS_START: {
                        this.smallMoleculeFeature.retentionTimeInSecondsStart(this.checkDouble(column, target));
                        break;
                    }
                    case SME_ID_REFS: {
                        this.smallMoleculeFeature.smeIdRefs(this.checkIntegerList(column, target, '|'));
                        break;
                    }
                    case SME_ID_REF_AMBIGUITY_CODE: {
                        this.smallMoleculeFeature.smeIdRefAmbiguityCode(this.checkInteger(column, target));
                        break;
                    }
                    case SMF_ID: {
                        this.smallMoleculeFeature.smfId(this.checkInteger(column, this.checkData(column, target, false)));
                    }
                }
                continue;
            }
            if (column instanceof AbundanceColumn) {
                if (!columnName.startsWith(SmallMoleculeFeature.Properties.abundanceAssay.getPropertyName())) continue;
                this.smallMoleculeFeature.addAbundanceAssayItem(this.checkDouble(column, target));
                continue;
            }
            if (!(column instanceof OptionColumn) || !columnName.startsWith("opt_")) continue;
            Class<?> dataType = column.getDataType();
            OptColumnMapping optColMapping = new OptColumnMapping();
            optColMapping.identifier(columnName.substring("opt_".length()));
            if (dataType.equals(String.class)) {
                optColMapping.value(this.checkString(column, target));
            } else if (dataType.equals(Double.class)) {
                optColMapping.value(Double.toString(this.checkDouble(column, target)));
            } else if (dataType.equals(MZBoolean.class)) {
                optColMapping.value(Boolean.toString(this.checkMZBoolean(column, target).toBoolean()));
            }
            this.smallMoleculeFeature.addOptItem(optColMapping);
        }
        return physicalPosition;
    }

    protected void checkRegexMatches(MZTabErrorList errorList, int lineNumber, SmallMoleculeFeature.Properties elementProperty, String regularExpression, List<String> elements) {
        if (!elements.isEmpty()) {
            Pattern p = Pattern.compile(regularExpression);
            for (int i = 0; i < elements.size(); ++i) {
                Matcher m;
                String element = elements.get(i);
                if ("null".equals(element) || (m = p.matcher(element)).matches()) continue;
                errorList.add(new MZTabError(FormatErrorType.RegexMismatch, lineNumber, new String[]{elementProperty.getPropertyName(), element, "" + (i + 1), regularExpression}));
            }
        }
    }

    @Override
    public SmallMoleculeFeature getRecord() {
        if (this.smallMoleculeFeature == null) {
            this.smallMoleculeFeature = new SmallMoleculeFeature();
        }
        return this.smallMoleculeFeature;
    }
}

