/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.SmallMoleculeEvidence;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.ISmallMoleculeColumn;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeEvidenceColumn;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabHeaderLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class SEHLineParser
extends MZTabHeaderLineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SEHLineParser.class);
    private Map<Integer, String> physPositionToOrder;

    public SEHLineParser(MZTabParserContext context, Metadata metadata) {
        super(context, MZTabColumnFactory.getInstance(Section.Small_Molecule_Evidence_Header), metadata);
    }

    @Override
    protected int parseColumns() throws MZTabException {
        SortedMap<String, IMZTabColumn> columnMapping = this.factory.getColumnMapping();
        SortedMap<String, IMZTabColumn> optionalMapping = this.factory.getOptionalColumnMapping();
        SortedMap<String, IMZTabColumn> stableMapping = this.factory.getStableColumnMapping();
        this.physPositionToOrder = this.generateHeaderPhysPositionToOrderMap(this.items);
        Integer physicalPosition = 1;
        while (physicalPosition < this.items.length) {
            IMZTabColumn column = null;
            String header = this.items[physicalPosition];
            if (header.startsWith(SmallMoleculeEvidence.Properties.idConfidenceMeasure.getPropertyName())) {
                this.checkIdConfidenceMeasure(header);
            } else if (header.startsWith("opt_")) {
                this.checkOptColumnName(header);
            } else {
                try {
                    column = SmallMoleculeEvidenceColumn.Stable.columnFor(header);
                }
                catch (IllegalArgumentException ex) {
                    throw new MZTabException(new MZTabError(LogicalErrorType.ColumnNotValid, this.lineNumber, new String[]{header, this.section.getName()}));
                }
            }
            if (column != null) {
                if (!column.getOrder().equals(this.physPositionToOrder.get(physicalPosition))) {
                    column.setOrder(this.physPositionToOrder.get(physicalPosition));
                    LOGGER.debug(column.toString());
                }
                if (column.isOptional()) {
                    optionalMapping.put(column.getLogicPosition(), column);
                } else {
                    stableMapping.put(column.getLogicPosition(), column);
                }
                columnMapping.put(column.getLogicPosition(), column);
            }
            Integer n = physicalPosition;
            Integer n2 = physicalPosition = Integer.valueOf(physicalPosition + 1);
        }
        return physicalPosition;
    }

    private void checkIdConfidenceMeasure(String header) throws MZTabException {
        String valueLabel = header;
        Pattern pattern = Pattern.compile(SmallMoleculeEvidence.Properties.idConfidenceMeasure.getPropertyName() + "\\[(\\d+)\\]");
        Matcher matcher = pattern.matcher(valueLabel);
        if (!matcher.find()) {
            MZTabError error = new MZTabError(FormatErrorType.StableColumn, this.lineNumber, new String[]{header});
            throw new MZTabException(error);
        }
        int id = this.parseIndex(header, matcher.group(1));
        Parameter p = (Parameter)this.metadata.getIdConfidenceMeasure().get(id - 1);
        this.factory.addIdConfidenceMeasureColumn(p, id, Double.class);
    }

    private Map<Integer, String> generateHeaderPhysPositionToOrderMap(String[] items) {
        LinkedHashMap<Integer, String> physicalPositionToOrder = new LinkedHashMap<Integer, String>();
        int order = 0;
        Integer physicalPosition = 1;
        while (physicalPosition < items.length) {
            physicalPositionToOrder.put(physicalPosition, this.fromIndexToOrder(++order));
            Integer n = physicalPosition;
            Integer n2 = physicalPosition = Integer.valueOf(physicalPosition + 1);
        }
        return physicalPositionToOrder;
    }

    @Override
    protected void refine() throws MZTabException {
        ArrayList<String> mandatoryColumnHeaders = new ArrayList<String>();
        for (ISmallMoleculeColumn iSmallMoleculeColumn : SmallMoleculeEvidenceColumn.Stable.columns()) {
            mandatoryColumnHeaders.add(iSmallMoleculeColumn.getName());
        }
        IntStream.range(0, this.metadata.getIdConfidenceMeasure().size()).forEachOrdered(i -> mandatoryColumnHeaders.add(SmallMoleculeEvidence.Properties.idConfidenceMeasure.getPropertyName() + "[" + (i + 1) + "]"));
        for (String string : mandatoryColumnHeaders) {
            if (this.factory.findColumnByHeader(string) != null) continue;
            throw new MZTabException(new MZTabError(FormatErrorType.StableColumn, this.lineNumber, new String[]{string}));
        }
    }
}

