/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import java.util.Collection;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;

public final class PositionMapping {
    private final SortedMap<Integer, String> mappings = new TreeMap<Integer, String>();

    public PositionMapping(MZTabColumnFactory factory, String headerLine) {
        this(factory, headerLine.split("\t"));
    }

    public PositionMapping(MZTabColumnFactory factory, String[] headerList) {
        for (int physicalPosition = 0; physicalPosition < headerList.length; ++physicalPosition) {
            String header = headerList[physicalPosition];
            IMZTabColumn column = factory.findColumnByHeader(header);
            if (column == null) continue;
            this.put(physicalPosition, column.getLogicPosition());
        }
    }

    public void put(Integer physicalPosition, String logicalPosition) {
        this.mappings.put(physicalPosition, logicalPosition);
    }

    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    public int size() {
        return this.mappings.size();
    }

    public boolean containsKey(Integer key) {
        return this.mappings.containsKey(key);
    }

    public Set<Integer> keySet() {
        return this.mappings.keySet();
    }

    public Collection<String> values() {
        return this.mappings.values();
    }

    public String get(Integer key) {
        return (String)this.mappings.get(key);
    }

    public SortedMap<String, Integer> reverse() {
        TreeMap<String, Integer> reverseMappings = new TreeMap<String, Integer>();
        for (Integer physicalPosition : this.mappings.keySet()) {
            String logicalPosition = (String)this.mappings.get(physicalPosition);
            reverseMappings.put(logicalPosition, physicalPosition);
        }
        return reverseMappings;
    }
}

