/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.SmallMoleculeSummary;
import de.isas.mztab2.model.StudyVariable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.jmztab2.model.MZBoolean;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public abstract class MZTabHeaderLineParser
extends MZTabLineParser {
    protected MZTabColumnFactory factory;
    protected Metadata metadata;

    protected MZTabHeaderLineParser(MZTabParserContext context, MZTabColumnFactory factory, Metadata metadata) {
        super(context);
        if (factory == null) {
            throw new NullPointerException("Header line should be parsed first!");
        }
        this.factory = factory;
        if (metadata == null) {
            throw new NullPointerException("Metadata should be created first!");
        }
        this.metadata = metadata;
    }

    @Override
    public void parse(int lineNumber, String line, MZTabErrorList errorList) throws MZTabException {
        super.parse(lineNumber, line, errorList);
        int offset = this.parseColumns();
        if (offset != this.items.length) {
            this.errorList.add(new MZTabError(LogicalErrorType.HeaderLine, lineNumber, new String[]{this.section.getName(), "" + offset, "" + this.items.length}));
        }
        this.refine();
    }

    protected abstract int parseColumns() throws MZTabException;

    protected abstract void refine() throws MZTabException;

    protected void refineOptionalColumn(Section section, String columnHeader) throws MZTabException {
        if (this.factory.findColumnByHeader(columnHeader) == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NotDefineInHeader, this.lineNumber, new String[]{columnHeader, section.getName()}));
        }
    }

    protected String fromIndexToOrder(Integer index) {
        return String.format("%02d", index);
    }

    protected boolean checkOptColumnName(String nameLabel) throws MZTabException {
        nameLabel = nameLabel.trim();
        String regexp = "opt_((assay|study_variable|ms_run)\\[(\\w+)\\]|global)_([A-Za-z0-9_\\-\\[\\]:\\.]+)";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(nameLabel);
        if (matcher.find()) {
            String object_id = matcher.group(1);
            String value = matcher.group(4);
            Parameter param = null;
            if (value.startsWith("cv_")) {
                param = this.checkCVParamOptColumnName(nameLabel, value);
            }
            Class dataType = this.getDataType(param);
            if (object_id.contains("global")) {
                if (param == null) {
                    this.factory.addOptionalColumn(value, dataType);
                } else {
                    this.factory.addOptionalColumn(param, dataType);
                }
            } else {
                Integer id = this.parseIndex(nameLabel, matcher.group(3));
                if (object_id.contains(Metadata.Properties.assay.getPropertyName())) {
                    Assay element = (Assay)this.context.getAssayMap().get(id);
                    if (element == null) {
                        MZTabError error = new MZTabError(LogicalErrorType.AssayNotDefined, this.lineNumber, new String[]{nameLabel});
                        throw new MZTabException(error);
                    }
                    if (param == null) {
                        this.factory.addOptionalColumn(element, value, dataType);
                    } else {
                        this.factory.addOptionalColumn(element, param, dataType);
                    }
                } else if (object_id.contains(Metadata.Properties.studyVariable.getPropertyName())) {
                    StudyVariable element = (StudyVariable)this.context.getStudyVariableMap().get(id);
                    if (element == null) {
                        MZTabError error = new MZTabError(LogicalErrorType.StudyVariableNotDefined, this.lineNumber, new String[]{nameLabel});
                        throw new MZTabException(error);
                    }
                    if (param == null) {
                        this.factory.addOptionalColumn(element, value, dataType);
                    } else {
                        this.factory.addOptionalColumn(element, param, dataType);
                    }
                } else if (object_id.contains(Metadata.Properties.msRun.getPropertyName())) {
                    MsRun element = (MsRun)this.context.getMsRunMap().get(id);
                    if (element == null) {
                        MZTabError error = new MZTabError(LogicalErrorType.MsRunNotDefined, this.lineNumber, new String[]{nameLabel});
                        throw new MZTabException(error);
                    }
                    if (param == null) {
                        this.factory.addOptionalColumn(element, value, dataType);
                    } else {
                        this.factory.addOptionalColumn(element, param, dataType);
                    }
                }
            }
            return true;
        }
        throw new MZTabException(new MZTabError(FormatErrorType.OptionalCVParamColumn, this.lineNumber, new String[]{nameLabel}));
    }

    private Parameter checkCVParamOptColumnName(String nameLabel, String valueLabel) throws MZTabException {
        nameLabel = nameLabel.trim();
        valueLabel = valueLabel.trim();
        String regexp = "cv(_([A-Za-z0-9\\-\\[\\]:\\.]+))?(_([A-Za-z0-9_\\-\\[\\]:\\.]+)*)";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(valueLabel);
        if (!matcher.find() || matcher.end() != valueLabel.length()) {
            throw new MZTabException(new MZTabError(FormatErrorType.OptionalCVParamColumn, this.lineNumber, new String[]{nameLabel}));
        }
        String accession = matcher.group(2);
        String name = matcher.group(4);
        if (name == null || name.trim().length() == 0) {
            throw new MZTabException(new MZTabError(FormatErrorType.OptionalCVParamColumn, this.lineNumber, new String[]{nameLabel}));
        }
        Parameter param = matcher.group(4) == null ? null : new Parameter().cvAccession(accession).name(name);
        return param;
    }

    private Class getDataType(Parameter param) {
        Class dataType = param == null ? String.class : (param.getCvAccession().equals("MS:1001905") ? Double.class : (param.getCvAccession().equals("MS:1002217") ? MZBoolean.class : (param.getCvAccession().equals("PRIDE:0000303") ? MZBoolean.class : String.class)));
        return dataType;
    }

    protected int checkAbundanceColumns(int offset, String order) throws MZTabException {
        String headerString = this.items[offset];
        if (headerString.contains(SmallMoleculeSummary.Properties.abundanceAssay.getPropertyName())) {
            this.checkAbundanceAssayColumn(headerString, order);
            return offset;
        }
        if (headerString.contains(SmallMoleculeSummary.Properties.abundanceStudyVariable.getPropertyName()) || headerString.contains(SmallMoleculeSummary.Properties.abundanceVariationStudyVariable.getPropertyName())) {
            this.checkAbundanceStudyVariableColumns(headerString, order);
            return offset;
        }
        MZTabError error = new MZTabError(FormatErrorType.AbundanceColumn, this.lineNumber, new String[]{headerString});
        throw new MZTabException(error);
    }

    private String checkAbundanceSection(String abundanceHeader) throws MZTabException {
        abundanceHeader = abundanceHeader.trim().toLowerCase();
        Pattern pattern = Pattern.compile("abundance_(.+)");
        Matcher matcher = pattern.matcher(abundanceHeader);
        if (matcher.find()) {
            return matcher.group(1);
        }
        MZTabError error = new MZTabError(FormatErrorType.AbundanceColumn, this.lineNumber, new String[]{abundanceHeader});
        throw new MZTabException(error);
    }

    private void checkAbundanceAssayColumn(String abundanceHeader, String order) throws MZTabException {
        String valueLabel = this.checkAbundanceSection(abundanceHeader);
        Pattern pattern = Pattern.compile("assay\\[(\\d+)\\]");
        Matcher matcher = pattern.matcher(valueLabel);
        if (!matcher.find()) {
            MZTabError error = new MZTabError(FormatErrorType.AbundanceColumn, this.lineNumber, new String[]{abundanceHeader});
            throw new MZTabException(error);
        }
        int id = this.parseIndex(abundanceHeader, matcher.group(1));
        Assay assay = (Assay)this.context.getAssayMap().get(id);
        if (assay == null) {
            MZTabError error = new MZTabError(LogicalErrorType.AssayNotDefined, this.lineNumber, new String[]{abundanceHeader});
            throw new MZTabException(error);
        }
        this.factory.addAbundanceOptionalColumn(assay, order);
    }

    private void checkAbundanceStudyVariableColumns(String header, String order) throws MZTabException {
        if (!(header = header.trim().toLowerCase()).contains(SmallMoleculeSummary.Properties.abundanceStudyVariable.getPropertyName()) && !header.contains(SmallMoleculeSummary.Properties.abundanceVariationStudyVariable.getPropertyName())) {
            MZTabError error = new MZTabError(FormatErrorType.AbundanceColumn, this.lineNumber, new String[]{header});
            throw new MZTabException(error);
        }
        StudyVariable abundanceStudyVariable = this.checkAbundanceStudyVariableColumn(header);
        this.factory.addAbundanceOptionalColumn(abundanceStudyVariable, this.checkAbundanceSection(header), order);
    }

    private StudyVariable checkAbundanceStudyVariableColumn(String abundanceHeader) throws MZTabException {
        String valueLabel = this.checkAbundanceSection(abundanceHeader);
        Pattern pattern = Pattern.compile("study_variable\\[(\\d+)\\]");
        Matcher matcher = pattern.matcher(valueLabel);
        if (!matcher.find()) {
            MZTabError error = new MZTabError(FormatErrorType.AbundanceColumn, this.lineNumber, new String[]{abundanceHeader});
            throw new MZTabException(error);
        }
        int id = this.parseIndex(abundanceHeader, matcher.group(1));
        StudyVariable studyVariable = (StudyVariable)this.context.getStudyVariableMap().get(id);
        if (studyVariable == null) {
            MZTabError error = new MZTabError(LogicalErrorType.StudyVariableNotDefined, this.lineNumber, new String[]{abundanceHeader});
            throw new MZTabException(error);
        }
        return studyVariable;
    }

    protected int parseIndex(String header, String id) throws MZTabException {
        try {
            Integer index = Integer.parseInt(id);
            if (index < 1) {
                throw new NumberFormatException();
            }
            return index;
        }
        catch (NumberFormatException e) {
            MZTabError error = new MZTabError(LogicalErrorType.IdNumber, this.lineNumber, new String[]{header, id});
            throw new MZTabException(error);
        }
    }

    public MZTabColumnFactory getFactory() {
        return this.factory;
    }
}

