/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.model;

import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.StudyVariable;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.ac.ebi.pride.jmztab2.model.AbundanceColumn;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.OptionColumn;
import uk.ac.ebi.pride.jmztab2.model.ParameterOptionColumn;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class MZTabColumnFactory {
    private final SortedMap<String, IMZTabColumn> stableColumnMapping = new TreeMap<String, IMZTabColumn>();
    private final SortedMap<String, IMZTabColumn> optionalColumnMapping = new TreeMap<String, IMZTabColumn>();
    private final SortedMap<String, IMZTabColumn> abundanceColumnMapping = new TreeMap<String, IMZTabColumn>();
    private final SortedMap<String, IMZTabColumn> columnMapping = new TreeMap<String, IMZTabColumn>();
    private Section section;

    private MZTabColumnFactory() {
    }

    public static MZTabColumnFactory getInstance(Section section) {
        if ((section = Section.toHeaderSection(section)) == null) {
            throw new IllegalArgumentException("Section should use Protein_Header, Peptide_Header, PSM_Header, Small_Molecule_Header, Small_Molecule_Feature_Header, or Small_Molecule_Evidence_Header.");
        }
        MZTabColumnFactory factory = new MZTabColumnFactory();
        factory.section = section;
        return factory;
    }

    public SortedMap<String, IMZTabColumn> getStableColumnMapping() {
        return this.stableColumnMapping;
    }

    public SortedMap<String, IMZTabColumn> getOptionalColumnMapping() {
        return this.optionalColumnMapping;
    }

    public SortedMap<String, IMZTabColumn> getColumnMapping() {
        return this.columnMapping;
    }

    private String getColumnOrder(String position) {
        return position.substring(0, 2);
    }

    private void checkOptionalColumn(IMZTabColumn column) throws IllegalArgumentException {
        if (this.optionalColumnMapping.containsKey(column.getLogicPosition())) {
            throw new IllegalArgumentException("Key " + column.getLogicPosition() + " for column " + column.getName() + " is already assigned to: " + ((IMZTabColumn)this.optionalColumnMapping.get(column.getLogicPosition())).getName());
        }
        this.optionalColumnMapping.put(column.getLogicPosition(), column);
        if (this.columnMapping.containsKey(column.getLogicPosition())) {
            throw new IllegalArgumentException("Key " + column.getLogicPosition() + " for column " + column.getName() + " is already assigned to: " + ((IMZTabColumn)this.columnMapping.get(column.getLogicPosition())).getName());
        }
        this.columnMapping.put(column.getLogicPosition(), column);
    }

    private void checkAbundanceOptionalColumn(IMZTabColumn column) throws IllegalArgumentException {
        if (this.abundanceColumnMapping.containsKey(column.getLogicPosition())) {
            throw new IllegalArgumentException("Key " + column.getLogicPosition() + " for column " + column.getName() + " is already assigned to: " + ((IMZTabColumn)this.abundanceColumnMapping.get(column.getLogicPosition())).getName());
        }
        this.abundanceColumnMapping.put(column.getLogicPosition(), column);
    }

    private String addOptionColumn(IMZTabColumn column) {
        this.checkOptionalColumn(column);
        return column.getLogicPosition();
    }

    private String addOptionColumn(IMZTabColumn column, String order) {
        column.setOrder(order);
        this.checkOptionalColumn(column);
        return column.getLogicPosition();
    }

    public String addOptionalColumn(String name, Class columnType) {
        OptionColumn column = new OptionColumn(null, name, columnType, Integer.parseInt(this.getColumnOrder(this.columnMapping.lastKey())));
        return this.addOptionColumn(column);
    }

    public <T extends IndexedElement> String addOptionalColumn(T columnEntity, String name, Class columnType) {
        OptionColumn column = new OptionColumn(columnEntity, name, columnType, Integer.parseInt(this.getColumnOrder(this.columnMapping.lastKey())));
        return this.addOptionColumn(column);
    }

    public String addOptionalColumn(Parameter param, Class columnType) {
        ParameterOptionColumn column = new ParameterOptionColumn(null, param, columnType, Integer.parseInt(this.getColumnOrder(this.columnMapping.lastKey())));
        return this.addOptionColumn(column);
    }

    public <T extends IndexedElement> String addOptionalColumn(T columnEntity, Parameter param, Class columnType) {
        ParameterOptionColumn column = new ParameterOptionColumn(columnEntity, param, columnType, Integer.parseInt(this.getColumnOrder(this.columnMapping.lastKey())));
        return this.addOptionColumn(column);
    }

    public String addAbundanceOptionalColumn(Assay assay, String order) {
        MZTabColumn column = AbundanceColumn.createOptionalColumn(this.section, assay, Integer.parseInt(order));
        this.checkAbundanceOptionalColumn(column);
        return this.addOptionColumn(column, order);
    }

    public String addAbundanceOptionalColumn(StudyVariable studyVariable, String columnHeader, String order) {
        SortedMap<String, MZTabColumn> columns = AbundanceColumn.createOptionalColumns(this.section, studyVariable, columnHeader, order);
        for (IMZTabColumn iMZTabColumn : columns.values()) {
            this.checkAbundanceOptionalColumn(iMZTabColumn);
            this.checkOptionalColumn(iMZTabColumn);
        }
        return columns.lastKey();
    }

    public String addIdConfidenceMeasureColumn(Parameter parameter, Integer index, Class columnType) {
        if (this.section != Section.Small_Molecule_Evidence_Header && this.section != Section.Small_Molecule_Evidence) {
            throw new IllegalArgumentException("Section should be SmallMoleculeEvidence, but is " + this.section.getName());
        }
        if (parameter == null) {
            throw new NullPointerException("Parameter should not be null!");
        }
        TreeMap<String, MZTabColumn> columns = new TreeMap<String, MZTabColumn>();
        MZTabColumn column = new MZTabColumn("id_confidence_measure", columnType, false, Integer.parseInt(this.getColumnOrder(this.columnMapping.lastKey())) + "", index);
        columns.put(column.getLogicPosition(), column);
        for (IMZTabColumn col : columns.values()) {
            this.checkOptionalColumn(col);
        }
        return (String)columns.lastKey();
    }

    public SortedMap<Integer, IMZTabColumn> getOffsetColumnsMap() {
        TreeMap<Integer, IMZTabColumn> map = new TreeMap<Integer, IMZTabColumn>();
        int offset = 1;
        for (IMZTabColumn column : this.columnMapping.values()) {
            map.put(offset++, column);
        }
        return map;
    }

    public IMZTabColumn findColumnByHeader(String header) {
        header = header.trim();
        for (IMZTabColumn column : this.columnMapping.values()) {
            if (!header.equalsIgnoreCase(column.getHeader())) continue;
            return column;
        }
        return null;
    }
}

