/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.model;

import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import uk.ac.ebi.pride.jmztab2.model.AbundanceColumn;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.MZTabStringUtils;
import uk.ac.ebi.pride.jmztab2.model.Section;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeEvidenceColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeFeatureColumn;

public class MZTabColumn
implements IMZTabColumn {
    private final String name;
    private String order;
    private Integer id;
    private String header;
    private String logicPosition;
    private Class dataType;
    private boolean optional;
    private IndexedElement element;

    public MZTabColumn(String name, Class dataType, boolean optional, String order) {
        this(name, dataType, optional, order, null);
    }

    public MZTabColumn(String name, Class dataType, boolean optional, String order, Integer id) {
        if (MZTabStringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Column name should not empty.");
        }
        this.name = name;
        if (dataType == null) {
            throw new NullPointerException("Column data type should not set null!");
        }
        this.dataType = dataType;
        this.optional = optional;
        this.order = order;
        this.id = id;
        this.header = this.generateHeader(name);
        this.logicPosition = this.generateLogicalPosition();
    }

    private String generateHeader(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (this.id != null) {
            sb.append("[").append(this.id).append("]");
        }
        return sb.toString();
    }

    private String generateLogicalPosition() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.order);
        if (this.id != null) {
            sb.append(String.format("%02d", this.id));
        } else {
            sb.append("00");
        }
        if (this.element != null) {
            sb.append(String.format("%02d", this.element.getId()));
        } else {
            sb.append("00");
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
        this.logicPosition = this.generateLogicalPosition();
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(String header) {
        this.header = header;
    }

    @Override
    public String getLogicPosition() {
        this.generateLogicalPosition();
        return this.logicPosition;
    }

    @Override
    public void setLogicPosition(String logicPosition) {
        this.logicPosition = logicPosition;
    }

    public Class getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public IndexedElement getElement() {
        return this.element;
    }

    @Override
    public void setElement(IndexedElement element) {
        if (element == null) {
            throw new NullPointerException("Can not set null indexed element for optional column!");
        }
        this.element = element;
        this.logicPosition = this.generateLogicalPosition();
        StringBuilder sb = new StringBuilder();
        if (this instanceof AbundanceColumn) {
            sb.append(this.header).append("[").append(element.getId()).append("]");
        } else {
            sb.append(this.header).append("_").append(Serializers.getReference(element, element.getId()));
        }
        this.header = sb.toString();
    }

    static IMZTabColumn createOptionalColumn(Section section, IMZTabColumn column, Integer id, IndexedElement element) {
        if (!column.isOptional()) {
            throw new IllegalArgumentException(column + " is not optional column!");
        }
        IMZTabColumn optionColumn = null;
        switch (section) {
            case Small_Molecule_Header: {
                optionColumn = new SmallMoleculeColumn(column.getName(), column.getDataType(), column.isOptional(), column.getOrder(), id);
                break;
            }
            case Small_Molecule_Feature_Header: {
                optionColumn = new SmallMoleculeFeatureColumn(column.getName(), column.getDataType(), column.isOptional(), column.getOrder(), id);
                break;
            }
            case Small_Molecule_Evidence_Header: {
                optionColumn = new SmallMoleculeEvidenceColumn(column.getName(), column.getDataType(), column.isOptional(), column.getOrder(), id);
            }
        }
        if (optionColumn != null && element != null) {
            optionColumn.setElement(element);
        }
        return optionColumn;
    }

    public String toString() {
        return "MZTabColumn{header='" + this.header + '\'' + ", logicPosition='" + this.logicPosition + '\'' + ", dataType=" + this.dataType + ", optional=" + this.optional + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MZTabColumn column = (MZTabColumn)o;
        if (this.optional != column.optional) {
            return false;
        }
        if (this.dataType != null ? !this.dataType.equals(column.dataType) : column.dataType != null) {
            return false;
        }
        return (this.header != null ? this.header.equals(column.header) : column.header == null) && (this.logicPosition != null ? this.logicPosition.equals(column.logicPosition) : column.logicPosition == null);
    }

    public int hashCode() {
        int result = this.header != null ? this.header.hashCode() : 0;
        result = 31 * result + (this.logicPosition != null ? this.logicPosition.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + (this.optional ? 1 : 0);
        return result;
    }
}

