/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.model;

import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.StudyVariable;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class AbundanceColumn
extends MZTabColumn {
    private AbundanceColumn(Section section, Field field, IndexedElement element, int offset) {
        super(field.name, field.columnType, true, offset + field.position + "");
        this.setElement(element);
    }

    public static MZTabColumn createOptionalColumn(Section section, Assay assay, int offset) {
        if (section.isComment() || section.isMetadata()) {
            throw new IllegalArgumentException("Section should be Protein, Peptide, PSM or SmallMolecule.");
        }
        if (assay == null) {
            throw new NullPointerException("Assay should not be null!");
        }
        return new AbundanceColumn(Section.toDataSection(section), Field.ABUNDANCE_ASSAY, (IndexedElement)assay, offset);
    }

    public static SortedMap<String, MZTabColumn> createOptionalColumns(Section section, StudyVariable studyVariable, String columnHeader, String order) {
        if (section.isComment() || section.isMetadata()) {
            throw new IllegalArgumentException("Section should be Protein, Peptide, PSM, SmallMolecule, SmallMoleculeFeature or SmallMoleculeEvidence.");
        }
        if (studyVariable == null) {
            throw new NullPointerException("Study Variable should not be null!");
        }
        int offset = new Integer(order) - 1;
        TreeMap<String, MZTabColumn> columns = new TreeMap<String, MZTabColumn>();
        Section dataSection = Section.toDataSection(section);
        if (columnHeader.startsWith("study_variable")) {
            AbundanceColumn column = new AbundanceColumn(dataSection, Field.ABUNDANCE_STUDY_VARIABLE, (IndexedElement)studyVariable, offset);
            columns.put(column.getLogicPosition(), column);
        } else if (columnHeader.startsWith("variation_study_variable")) {
            AbundanceColumn column = new AbundanceColumn(dataSection, Field.ABUNDANCE_VARIATION_STUDY_VARIABLE, (IndexedElement)studyVariable, offset);
            columns.put(column.getLogicPosition(), column);
        } else {
            throw new IllegalArgumentException("column header " + columnHeader + " is not allowed for abundance definition!");
        }
        return columns;
    }

    public static SortedMap<String, MZTabColumn> createOptionalColumns(Section section, StudyVariable studyVariable, Integer lastOrder) {
        if (section.isComment() || section.isMetadata()) {
            throw new IllegalArgumentException("Section should be Protein, Peptide, PSM or SmallMolecule.");
        }
        if (studyVariable == null) {
            throw new NullPointerException("Study Variable should not be null!");
        }
        TreeMap<String, MZTabColumn> columns = new TreeMap<String, MZTabColumn>();
        Section dataSection = Section.toDataSection(section);
        AbundanceColumn column = new AbundanceColumn(dataSection, Field.ABUNDANCE_STUDY_VARIABLE, (IndexedElement)studyVariable, lastOrder);
        columns.put(column.getLogicPosition(), column);
        column = new AbundanceColumn(dataSection, Field.ABUNDANCE_VARIATION_STUDY_VARIABLE, (IndexedElement)studyVariable, lastOrder);
        columns.put(column.getLogicPosition(), column);
        return columns;
    }

    public static enum Field {
        ABUNDANCE_ASSAY("abundance_assay", Double.class, 1),
        ABUNDANCE_STUDY_VARIABLE("abundance_study_variable", Double.class, 2),
        ABUNDANCE_VARIATION_STUDY_VARIABLE("abundance_variation_study_variable", Double.class, 3);

        private String name;
        private Class columnType;
        private int position;

        private Field(String name, Class columnType, int position) {
            this.name = name;
            this.columnType = columnType;
            this.position = position;
        }

        public String toString() {
            return this.name;
        }
    }
}

