/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.validators;

import de.isas.mztab2.io.validators.RefiningValidator;
import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.StudyVariable;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class StudyVariableValidator
implements RefiningValidator<Metadata> {
    @Override
    public List<MZTabError> validateRefine(Metadata metadata, MZTabParserContext parserContext) {
        SortedMap<Integer, Assay> assayMap = parserContext.getAssayMap();
        SortedMap<Integer, StudyVariable> svMap = parserContext.getStudyVariableMap();
        LinkedList<MZTabError> errorList = new LinkedList<MZTabError>();
        if (svMap.isEmpty()) {
            errorList.add(new MZTabError(LogicalErrorType.SingleStudyVariableName, -1, new String[0]));
        } else if (svMap.size() == 1 && assayMap.size() > 0) {
            StudyVariable sv = (StudyVariable)svMap.get(1);
            if (sv.getName() == null || sv.getName().isEmpty()) {
                errorList.add(new MZTabError(LogicalErrorType.SingleStudyVariableName, -1, new String[0]));
            }
        } else {
            boolean undefinedDefined = false;
            for (Integer id : svMap.keySet()) {
                StudyVariable sv = (StudyVariable)svMap.get(id);
                if (sv == null) {
                    errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.studyVariable + "[" + id + "]\t<NAME>"}));
                    continue;
                }
                if (sv.getName() == null) {
                    errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.studyVariable + "[" + id + "]\t<NAME>"}));
                } else if (sv.getName().equals("undefined")) {
                    if (undefinedDefined) {
                        errorList.add(new MZTabError(LogicalErrorType.UndefinedStudyVariableNameOnceOnly, -1, new String[]{Metadata.Properties.studyVariable + "[" + id + "]\t<NAME>"}));
                    } else {
                        undefinedDefined = true;
                    }
                }
                if (sv.getDescription() == null) {
                    errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.studyVariable + "[" + id + "]-" + StudyVariable.Properties.description + "\t<DESCRIPTION>"}));
                }
                if (sv.getAssayRefs() != null && !sv.getAssayRefs().isEmpty()) continue;
                errorList.add(new MZTabError(LogicalErrorType.AssayRefs, -1, new String[]{Metadata.Properties.studyVariable + "[" + id + "]-" + StudyVariable.Properties.assayRefs}));
            }
        }
        return errorList;
    }
}

