/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.validators;

import de.isas.mztab2.io.validators.RefiningValidator;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class MsRunValidator
implements RefiningValidator<Metadata> {
    @Override
    public List<MZTabError> validateRefine(Metadata metadata, MZTabParserContext parserContext) {
        SortedMap<Integer, MsRun> runMap = parserContext.getMsRunMap();
        LinkedList<MZTabError> errorList = new LinkedList<MZTabError>();
        for (Integer id : runMap.keySet()) {
            List scanPolarity;
            if (((MsRun)runMap.get(id)).getLocation() == null) {
                errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.msRun + "[" + id + "]-" + MsRun.Properties.location}));
            }
            if ((scanPolarity = ((MsRun)runMap.get(id)).getScanPolarity()) != null && !scanPolarity.isEmpty()) continue;
            errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.msRun + "[" + id + "]-" + MsRun.Properties.scanPolarity}));
        }
        return errorList;
    }
}

