/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.validators;

import de.isas.mztab2.io.validators.RefiningValidator;
import de.isas.mztab2.model.CV;
import de.isas.mztab2.model.Metadata;
import java.util.LinkedList;
import java.util.List;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class CvValidator
implements RefiningValidator<Metadata> {
    @Override
    public List<MZTabError> validateRefine(Metadata metadata, MZTabParserContext parserContext) {
        LinkedList<MZTabError> errorList = new LinkedList<MZTabError>();
        if (metadata.getCv() == null || metadata.getCv().isEmpty()) {
            errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.cv + ""}));
        } else {
            for (CV cv : metadata.getCv()) {
                if (cv.getLabel() == null || cv.getLabel().isEmpty()) {
                    errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.cv + "[" + cv.getId() + "]-" + CV.Properties.label}));
                }
                if (cv.getFullName() == null || cv.getFullName().isEmpty()) {
                    errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.cv + "[" + cv.getId() + "]-" + CV.Properties.fullName}));
                }
                if (cv.getVersion() == null || cv.getVersion().isEmpty()) {
                    errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.cv + "[" + cv.getId() + "]-" + CV.Properties.version}));
                }
                if (cv.getUri() != null && !cv.getUri().isEmpty()) continue;
                errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.cv + "[" + cv.getId() + "]-" + CV.Properties.uri}));
            }
        }
        return errorList;
    }
}

