/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.SmallMoleculeFeature;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.AbundanceColumn;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeFeatureColumn;

public class SmallMoleculeFeatureSerializer
extends StdSerializer<SmallMoleculeFeature> {
    private static final Logger log = LoggerFactory.getLogger(SmallMoleculeFeatureSerializer.class);

    public SmallMoleculeFeatureSerializer() {
        this(null);
    }

    public SmallMoleculeFeatureSerializer(Class<SmallMoleculeFeature> t) {
        super(t);
    }

    public void serializeWithType(SmallMoleculeFeature value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(SmallMoleculeFeature smallMoleculeFeature, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (smallMoleculeFeature != null) {
            jg.writeStartObject();
            Serializers.writeString(SmallMoleculeFeature.HeaderPrefixEnum.SFH.getValue(), jg, SmallMoleculeFeature.PrefixEnum.SMF.getValue());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.SMF_ID), jg, smallMoleculeFeature.getSmfId());
            Serializers.writeAsNumberArray(SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.SME_ID_REFS), jg, Optional.ofNullable(smallMoleculeFeature.getSmeIdRefs()).orElse(Collections.emptyList()));
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.SME_ID_REF_AMBIGUITY_CODE), jg, smallMoleculeFeature.getSmeIdRefAmbiguityCode());
            Serializers.writeString(SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.ADDUCT_ION), jg, smallMoleculeFeature.getAdductIon());
            Serializers.writeObject(SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.ISOTOPOMER), jg, sp, (Object)smallMoleculeFeature.getIsotopomer());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.EXP_MASS_TO_CHARGE), jg, smallMoleculeFeature.getExpMassToCharge());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.CHARGE), jg, smallMoleculeFeature.getCharge());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.RETENTION_TIME_IN_SECONDS), jg, smallMoleculeFeature.getRetentionTimeInSeconds());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.RETENTION_TIME_IN_SECONDS_START), jg, smallMoleculeFeature.getRetentionTimeInSecondsStart());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeFeatureColumn.Stable.columnFor(SmallMoleculeFeatureColumn.Stable.RETENTION_TIME_IN_SECONDS_END), jg, smallMoleculeFeature.getRetentionTimeInSecondsEnd());
            Serializers.writeIndexedDoubles(AbundanceColumn.Field.ABUNDANCE_ASSAY.toString(), jg, Optional.ofNullable(smallMoleculeFeature.getAbundanceAssay()).orElse(Collections.emptyList()));
            Serializers.writeOptColumnMappings(smallMoleculeFeature.getOpt(), jg, sp);
            jg.writeEndObject();
        } else {
            log.debug(SmallMoleculeFeature.class.getSimpleName(), (Object)" is null!");
        }
    }
}

