/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.databind.util.StdConverter;
import de.isas.mztab2.model.Parameter;
import java.util.ArrayList;

public class ParameterConverter
extends StdConverter<Parameter, String> {
    public String convert(Parameter in) {
        return this.toString(in);
    }

    private static void printReserveString(String name, StringBuilder sb) {
        ArrayList<String> charList = new ArrayList<String>();
        charList.add(",");
        boolean containReserveChar = false;
        for (String c : charList) {
            if (!name.contains(c)) continue;
            containReserveChar = true;
            break;
        }
        if (containReserveChar) {
            sb.append("\"").append(name).append("\"");
        } else {
            sb.append(name);
        }
    }

    private String removeReservedChars(String value) {
        if (value != null) {
            value = value.trim();
            ArrayList<String> reserveCharList = new ArrayList<String>();
            reserveCharList.add(",");
            for (String c : reserveCharList) {
                value = value.replaceAll(c, "");
            }
        }
        return value;
    }

    private String toString(Parameter param) {
        if (param == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (param.getCvLabel() != null) {
            sb.append(param.getCvLabel());
        }
        sb.append(", ");
        if (param.getCvAccession() != null) {
            sb.append(param.getCvAccession());
        }
        sb.append(", ");
        ParameterConverter.printReserveString(param.getName(), sb);
        sb.append(", ");
        if (param.getValue() != null) {
            ParameterConverter.printReserveString(param.getValue(), sb);
        }
        sb.append("]");
        return sb.toString();
    }
}

