/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.ParameterConverter;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Metadata;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.MetadataElement;
import uk.ac.ebi.pride.jmztab2.model.MetadataProperty;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class MetadataSerializer
extends StdSerializer<Metadata> {
    private static final Logger log = LoggerFactory.getLogger(MetadataSerializer.class);

    public MetadataSerializer() {
        this(null);
    }

    public MetadataSerializer(Class<Metadata> t) {
        super(t);
    }

    public static <T extends IndexedElement> void serializeListWithMetadataElement(List<T> list, MetadataElement mtdElement, JsonGenerator jg, SerializerProvider sp, Comparator<? super T> comparator) {
        list.stream().sorted(comparator).forEach(object -> {
            if (object == null) {
                throw new NullPointerException("Object in list for metadata element " + mtdElement.getName() + " must not be null!");
            }
            Serializers.addIndexedLine(jg, sp, Section.Metadata.getPrefix(), (Object)(mtdElement.getName() + "[" + object.getId() + "]"), object);
        });
    }

    public static <T> void serializeList(List<T> list, JsonGenerator jg, SerializerProvider sp, Comparator<? super T> comparator) {
        list.stream().sorted(comparator).forEach(object -> MetadataSerializer.serializeObject(object, jg, sp));
    }

    public static void serializeObject(Object object, JsonGenerator jg, SerializerProvider sp) {
        try {
            log.debug("Serializing element " + Serializers.getElementName(object).orElse("undefined"));
            sp.findValueSerializer(object.getClass()).serialize(object, jg, sp);
        }
        catch (IOException ex) {
            log.error("Caught IO exception while trying to serialize " + object, (Throwable)ex);
        }
    }

    public void serialize(Metadata t, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (t != null) {
            String prefix = t.getPrefix().name();
            if (t.getMzTabVersion() == null || t.getMzTabVersion().isEmpty()) {
                t.setMzTabVersion("2.0.0-M");
            }
            Serializers.addLine(jg, prefix, Metadata.Properties.mzTabVersion.getPropertyName(), t.getMzTabVersion());
            Serializers.addLine(jg, prefix, Metadata.Properties.mzTabID.getPropertyName(), t.getMzTabID());
            Serializers.addLine(jg, prefix, Metadata.Properties.title.getPropertyName(), t.getTitle());
            Serializers.addLine(jg, prefix, Metadata.Properties.description.getPropertyName(), t.getDescription());
            if (t.getContact() != null) {
                MetadataSerializer.serializeList(t.getContact(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Contacts are null!");
            }
            if (t.getPublication() != null) {
                MetadataSerializer.serializeList(t.getPublication(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Publications are null!");
            }
            if (t.getUri() != null) {
                MetadataSerializer.serializeListWithMetadataElement(t.getUri(), MetadataElement.URI, jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("External Study is null!");
            }
            if (t.getExternalStudyUri() != null) {
                MetadataSerializer.serializeListWithMetadataElement(t.getExternalStudyUri(), MetadataElement.EXTERNAL_STUDY_URI, jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("External Study is null!");
            }
            if (t.getInstrument() != null) {
                MetadataSerializer.serializeList(t.getInstrument(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Instruments are null!");
            }
            if (t.getQuantificationMethod() != null) {
                Serializers.addLineWithParameters(jg, prefix, "quantification_method", Arrays.asList(t.getQuantificationMethod()));
            } else {
                log.debug("Quantification method is null!");
            }
            if (t.getSample() != null) {
                MetadataSerializer.serializeList(t.getSample(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Samples are null!");
            }
            if (t.getSampleProcessing() != null) {
                MetadataSerializer.serializeList(t.getSampleProcessing(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Sample processing is null!");
            }
            if (t.getSoftware() != null) {
                MetadataSerializer.serializeList(t.getSoftware(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Software is null!");
            }
            if (t.getDerivatizationAgent() != null) {
                MetadataSerializer.serializeListWithMetadataElement(t.getDerivatizationAgent(), MetadataElement.DERIVATIZATION_AGENT, jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Derivatization agent is null!");
            }
            if (t.getMsRun() != null) {
                MetadataSerializer.serializeList(t.getMsRun(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("MS runs are null!");
            }
            if (t.getAssay() != null) {
                MetadataSerializer.serializeList(t.getAssay(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Assays are null!");
            }
            if (t.getStudyVariable() != null) {
                MetadataSerializer.serializeList(t.getStudyVariable(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Study Variable is null!");
            }
            if (t.getCustom() != null) {
                MetadataSerializer.serializeListWithMetadataElement(t.getCustom(), MetadataElement.CUSTOM, jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Custom is null!");
            }
            if (t.getCv() != null) {
                MetadataSerializer.serializeList(t.getCv(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("CVs are null!");
            }
            if (t.getSmallMoleculeQuantificationUnit() != null) {
                Serializers.addLineWithMetadataProperty(jg, prefix, MetadataProperty.SMALL_MOLECULE_QUANTIFICATION_UNIT, (Object)MetadataElement.SMALL_MOLECULE, t.getSmallMoleculeQuantificationUnit());
            } else {
                log.debug("Small molecule quantification unit is null!");
            }
            if (t.getSmallMoleculeFeatureQuantificationUnit() != null) {
                Serializers.addLineWithMetadataProperty(jg, prefix, MetadataProperty.SMALL_MOLECULE_FEATURE_QUANTIFICATION_UNIT, (Object)MetadataElement.SMALL_MOLECULE_FEATURE, t.getSmallMoleculeFeatureQuantificationUnit());
            } else {
                log.debug("Small molecule feature quantification unit is null!");
            }
            if (t.getSmallMoleculeIdentificationReliability() != null) {
                Serializers.addLineWithMetadataProperty(jg, prefix, MetadataProperty.SMALL_MOLECULE_IDENTIFICATION_RELIABILITY, (Object)MetadataElement.SMALL_MOLECULE, t.getSmallMoleculeIdentificationReliability());
            } else {
                log.debug("Small molecule identification reliability is null!");
            }
            if (t.getDatabase() != null) {
                MetadataSerializer.serializeList(t.getDatabase(), jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Databases are null!");
            }
            if (t.getIdConfidenceMeasure() != null) {
                MetadataSerializer.serializeListWithMetadataElement(t.getIdConfidenceMeasure(), MetadataElement.ID_CONFIDENCE_MEASURE, jg, sp, Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                log.debug("Id confidence measure is null!");
            }
            if (t.getColunitSmallMolecule() != null) {
                t.getColunitSmallMolecule().forEach(colUnit -> Serializers.addLine(jg, prefix, (Object)MetadataElement.COLUNIT_SMALL_MOLECULE, colUnit.getColumnName() + "=" + new ParameterConverter().convert(colUnit.getParam())));
            } else {
                log.debug("Colunit small molecule is null!");
            }
            if (t.getColunitSmallMoleculeFeature() != null) {
                t.getColunitSmallMoleculeFeature().forEach(colUnit -> Serializers.addLine(jg, prefix, (Object)MetadataElement.COLUNIT_SMALL_MOLECULE_FEATURE, colUnit.getColumnName() + "=" + new ParameterConverter().convert(colUnit.getParam())));
            } else {
                log.debug("Colunit small molecule feature is null!");
            }
            if (t.getColunitSmallMoleculeEvidence() != null) {
                t.getColunitSmallMoleculeEvidence().forEach(colUnit -> Serializers.addLine(jg, prefix, (Object)MetadataElement.COLUNIT_SMALL_MOLECULE_EVIDENCE, colUnit.getColumnName() + "=" + new ParameterConverter().convert(colUnit.getParam())));
            } else {
                log.debug("Colunit small molecule evidence is null!");
            }
        }
    }
}

