/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.Database;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Parameter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class DatabaseSerializer
extends StdSerializer<Database> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSerializer.class);

    public DatabaseSerializer() {
        this(null);
    }

    public DatabaseSerializer(Class<Database> t) {
        super(t);
    }

    public void serializeWithType(Database value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(Database database, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (database != null) {
            Serializers.checkIndexedElement((IndexedElement)database);
            Serializers.addLineWithPropertyParameters(jg, Section.Metadata.getPrefix(), null, database, Arrays.asList(database.getParam()));
            Optional<Parameter> dbParam = Optional.ofNullable(database.getParam());
            if (dbParam.isPresent() && dbParam.get().getName().equals("no database")) {
                Serializers.addLineWithNullProperty(jg, Section.Metadata.getPrefix(), Database.Properties.prefix.getPropertyName(), database);
                Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Database.Properties.uri.getPropertyName(), database, "null");
            } else {
                Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Database.Properties.prefix.getPropertyName(), database, database.getPrefix());
                Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Database.Properties.uri.getPropertyName(), database, database.getUri());
            }
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Database.Properties.version.getPropertyName(), database, Optional.ofNullable(database.getVersion()).orElse("Unknown"));
        } else {
            log.debug(Database.class.getSimpleName() + " is null!");
        }
    }
}

