/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.Contact;
import de.isas.mztab2.model.IndexedElement;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class ContactSerializer
extends StdSerializer<Contact> {
    private static final Logger log = LoggerFactory.getLogger(ContactSerializer.class);

    public ContactSerializer() {
        this(null);
    }

    public ContactSerializer(Class<Contact> t) {
        super(t);
    }

    public void serializeWithType(Contact value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(Contact contact, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (contact != null) {
            Serializers.checkIndexedElement((IndexedElement)contact);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Contact.Properties.name.getPropertyName(), contact, contact.getName());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Contact.Properties.email.getPropertyName(), contact, contact.getEmail());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Contact.Properties.affiliation.getPropertyName(), contact, contact.getAffiliation());
        } else {
            log.debug(Contact.class.getSimpleName() + " is null!");
        }
    }
}

