/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import de.isas.mztab2.io.MzTabWriter;
import de.isas.mztab2.io.MzTabWriterDefaults;
import de.isas.mztab2.model.MzTab;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;

public class MzTabNonValidatingWriter
implements MzTabWriter<Void> {
    private static final Logger log = LoggerFactory.getLogger(MzTabNonValidatingWriter.class);
    private final MzTabWriterDefaults writerDefaults;

    public MzTabNonValidatingWriter() {
        this.writerDefaults = new MzTabWriterDefaults();
    }

    public MzTabNonValidatingWriter(MzTabWriterDefaults writerDefaults) {
        this.writerDefaults = writerDefaults;
    }

    @Override
    public Optional<Void> write(OutputStreamWriter writer, MzTab mzTab) throws IOException {
        if (!writer.getEncoding().equals("UTF8")) {
            throw new IllegalArgumentException("OutputStreamWriter encoding must be UTF8 but is " + writer.getEncoding());
        }
        this.writeMzTab(mzTab, writer);
        return Optional.empty();
    }

    @Override
    public Optional<Void> write(Path path, MzTab mzTab) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.writeMzTab(mzTab, writer);
        }
        return Optional.empty();
    }

    void writeMzTab(MzTab mzTab, Writer writer) throws IOException {
        this.writeMetadataWithJackson(mzTab, writer);
        writer.write("\n");
        this.writeSmallMoleculeSummaryWithJackson(mzTab, writer);
        writer.write("\n");
        this.writeSmallMoleculeFeaturesWithJackson(mzTab, writer);
        writer.write("\n");
        this.writeSmallMoleculeEvidenceWithJackson(mzTab, writer);
        writer.flush();
    }

    void writeMetadataWithJackson(MzTab mztabfile, Writer writer) throws IOException {
        CsvMapper mapper = this.writerDefaults.metadataMapper();
        CsvSchema schema = this.writerDefaults.metaDataSchema(mapper);
        try {
            mapper.writer((FormatSchema)schema).writeValue(writer, (Object)mztabfile.getMetadata());
        }
        catch (JsonProcessingException ex) {
            throw new IOException(ex);
        }
    }

    void writeSmallMoleculeSummaryWithJackson(MzTab mztabfile, Writer writer) throws IOException {
        CsvMapper mapper = this.writerDefaults.smallMoleculeSummaryMapper();
        try {
            CsvSchema schema = this.writerDefaults.smallMoleculeSummarySchema(mapper, mztabfile);
            mapper.writer((FormatSchema)schema).writeValue(writer, (Object)mztabfile.getSmallMoleculeSummary());
        }
        catch (JsonProcessingException | MZTabException ex) {
            throw new IOException(ex);
        }
    }

    void writeSmallMoleculeFeaturesWithJackson(MzTab mztabfile, Writer writer) throws IOException {
        CsvMapper mapper = this.writerDefaults.smallMoleculeFeatureMapper();
        try {
            CsvSchema schema = this.writerDefaults.smallMoleculeFeatureSchema(mapper, mztabfile);
            mapper.writer((FormatSchema)schema).writeValue(writer, (Object)mztabfile.getSmallMoleculeFeature());
        }
        catch (JsonProcessingException | MZTabException ex) {
            throw new IOException(ex);
        }
    }

    void writeSmallMoleculeEvidenceWithJackson(MzTab mztabfile, Writer writer) throws IOException {
        CsvMapper mapper = this.writerDefaults.smallMoleculeEvidenceMapper();
        try {
            CsvSchema schema = this.writerDefaults.smallMoleculeEvidenceSchema(mapper, mztabfile);
            mapper.writer((FormatSchema)schema).writeValue(writer, (Object)mztabfile.getSmallMoleculeEvidence());
        }
        catch (JsonProcessingException | MZTabException ex) {
            throw new IOException(ex);
        }
    }
}

