/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io;

import de.isas.mztab2.model.ColumnParameterMapping;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.MzTab;
import de.isas.mztab2.model.SmallMoleculeEvidence;
import de.isas.mztab2.model.SmallMoleculeFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;
import uk.ac.ebi.pride.jmztab2.utils.MZTabProperties;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorOverflowException;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class MzTabFileParser {
    private MzTab mzTabFile;
    private URI tabFile;
    private MZTabErrorList errorList;
    private MZTabParserContext context;

    public MzTabFileParser(File tabFile) throws IllegalArgumentException {
        this(tabFile.toURI());
    }

    public MzTabFileParser(URI tabFileUri) throws IllegalArgumentException {
        if (tabFileUri == null) {
            throw new IllegalArgumentException("MZTab file uri must not be null!");
        }
        if ("file".equals(tabFileUri.getScheme()) && !new File(tabFileUri).exists()) {
            throw new IllegalArgumentException("MZTab File URI " + tabFileUri.toASCIIString() + " does not exist!");
        }
        this.tabFile = tabFileUri;
    }

    public MZTabErrorList parse(OutputStream out, MZTabErrorType.Level level, int maxErrorCount) throws IOException {
        try {
            this.context = new MZTabParserContext();
            this.errorList = new MZTabErrorList(level, maxErrorCount);
            this.check();
            this.refine();
        }
        catch (MZTabException e) {
            out.write(e.getMessage().getBytes());
            try (PrintStream ps = new PrintStream(out);){
                e.printStackTrace(ps);
            }
            this.errorList.add(e.getError());
        }
        catch (MZTabErrorOverflowException e) {
            try (PrintStream ps = new PrintStream(out);){
                e.printStackTrace(ps);
            }
            out.write(e.getMessage().getBytes());
        }
        this.errorList.print(out);
        if (this.mzTabFile != null && this.errorList.isEmpty()) {
            out.write(("No structural or logical errors in " + this.tabFile + " file!" + "\r\n").getBytes());
        }
        return this.errorList;
    }

    public MZTabErrorList parse(OutputStream out, MZTabErrorType.Level level) throws IOException {
        return this.parse(out, level, MZTabProperties.MAX_ERROR_COUNT);
    }

    public MZTabErrorList parse(OutputStream out) throws IOException {
        return this.parse(out, MZTabProperties.LEVEL, MZTabProperties.MAX_ERROR_COUNT);
    }

    public MZTabErrorList getErrorList() {
        return this.errorList;
    }

    private Section getSection(String line) {
        String[] items = line.split("\\s*\t\\s*");
        String section = items[0].trim();
        return Section.findSection(section);
    }

    private BufferedReader readFile(URI tabFile) throws IOException {
        InputStream is;
        File file = new File(tabFile);
        if (file.isFile()) {
            is = new FileInputStream(file);
        } else {
            URL tabFileUrl = tabFile.toURL();
            is = tabFileUrl.openStream();
        }
        BufferedReader reader = tabFile.getPath().endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(is), MZTabProperties.ENCODE)) : new BufferedReader(new InputStreamReader(is, MZTabProperties.ENCODE));
        return reader;
    }

    private String subString(String source) {
        int length = 20;
        if (length >= source.length()) {
            return source;
        }
        return source.substring(0, length - 1) + "...";
    }

    private void refine() throws MZTabException, MZTabErrorOverflowException {
        if (this.mzTabFile == null) {
            return;
        }
        Metadata metadata = this.mzTabFile.getMetadata();
        for (MsRun msRun : metadata.getMsRun()) {
            if (msRun.getHash() == null || msRun.getHashMethod() != null) continue;
            throw new MZTabException(new MZTabError(LogicalErrorType.MsRunHashMethodNotDefined, -1, new String[]{msRun.getId().toString()}));
        }
    }

    /*
     * Exception decompiling
     */
    private void check() throws IOException, MZTabException, MZTabErrorOverflowException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkColunitMapping(MZTabColumnFactory columnFactory, Optional<Collection<ColumnParameterMapping>> columnParameterMapping, Metadata.Properties colUnitProperty, MzTab.Properties mzTabSection) {
        ((Collection)columnParameterMapping.orElse(Collections.emptyList())).forEach(colUnit -> {
            String columnName = colUnit.getColumnName();
            IMZTabColumn column = columnFactory.findColumnByHeader(columnName);
            if (column == null) {
                this.errorList.add(new MZTabError(FormatErrorType.ColUnit, -1, new String[]{colUnitProperty.getPropertyName(), columnName, mzTabSection.getPropertyName()}));
            }
        });
    }

    public MzTab getMZTabFile() {
        return this.mzTabFile;
    }

    private static /* synthetic */ Integer lambda$check$1(SmallMoleculeEvidence t) {
        return t.getSmeId();
    }

    private static /* synthetic */ Integer lambda$check$0(SmallMoleculeFeature t) {
        return t.getSmfId();
    }
}

