/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector4f;

class TexCoordGenerationRetained
extends NodeComponentRetained {
    private static final int ENABLE_CHANGED = 1;
    private static final int PLANE_S_CHANGED = 2;
    private static final int PLANE_T_CHANGED = 4;
    private static final int PLANE_R_CHANGED = 8;
    private static final int PLANE_Q_CHANGED = 16;
    int genMode = 0;
    int format = 0;
    Vector4f planeS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    Vector4f planeT = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    Vector4f planeR = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    Vector4f planeQ = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    boolean enable = true;
    boolean mirrorCompDirty = false;

    TexCoordGenerationRetained() {
    }

    final void initEnable(boolean state) {
        this.enable = state;
    }

    final void setEnable(boolean state) {
        this.initEnable(state);
        this.sendMessage(1, state ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.enable;
    }

    final void initFormat(int format) {
        this.format = format;
    }

    final int getFormat() {
        return this.format;
    }

    final void initGenMode(int genMode) {
        this.genMode = genMode;
    }

    final int getGenMode() {
        return this.genMode;
    }

    final void setPlaneS(Vector4f planeS) {
        this.initPlaneS(planeS);
        this.sendMessage(2, new Vector4f(planeS));
    }

    final void initPlaneS(Vector4f planeS) {
        this.planeS.set((Tuple4f)planeS);
    }

    final void getPlaneS(Vector4f planeS) {
        planeS.set((Tuple4f)this.planeS);
    }

    final void setPlaneT(Vector4f planeT) {
        this.initPlaneT(planeT);
        this.sendMessage(4, new Vector4f(planeT));
    }

    final void initPlaneT(Vector4f planeT) {
        this.planeT.set((Tuple4f)planeT);
    }

    final void getPlaneT(Vector4f planeT) {
        planeT.set((Tuple4f)this.planeT);
    }

    final void setPlaneR(Vector4f planeR) {
        this.initPlaneR(planeR);
        this.sendMessage(8, new Vector4f(planeR));
    }

    final void initPlaneR(Vector4f planeR) {
        this.planeR.set((Tuple4f)planeR);
    }

    final void getPlaneR(Vector4f planeR) {
        planeR.set((Tuple4f)this.planeR);
    }

    final void setPlaneQ(Vector4f planeQ) {
        this.initPlaneQ(planeQ);
        this.sendMessage(16, new Vector4f(planeQ));
    }

    final void initPlaneQ(Vector4f planeQ) {
        this.planeQ.set((Tuple4f)planeQ);
    }

    final void getPlaneQ(Vector4f planeQ) {
        planeQ.set((Tuple4f)this.planeQ);
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TexCoordGenerationRetained mirrorTg = new TexCoordGenerationRetained();
                mirrorTg.set(this);
                mirrorTg.source = this.source;
                this.mirror = mirrorTg;
            }
        } else {
            ((TexCoordGenerationRetained)this.mirror).set(this);
        }
    }

    void updateNative(Canvas3D cv) {
        int gMode = this.genMode;
        Transform3D m = cv.vworldToEc;
        if ((cv.textureExtendedFeatures & 0x80) == 0 && (this.genMode == 3 || this.genMode == 4)) {
            gMode = 2;
        }
        Pipeline.getPipeline().updateTexCoordGeneration(cv.ctx, this.enable, gMode, this.format, this.planeS.x, this.planeS.y, this.planeS.z, this.planeS.w, this.planeT.x, this.planeT.y, this.planeT.z, this.planeT.w, this.planeR.x, this.planeR.y, this.planeR.z, this.planeR.w, this.planeQ.x, this.planeQ.y, this.planeQ.z, this.planeQ.w, m.mat);
    }

    @Override
    synchronized void initMirrorObject() {
        ((TexCoordGenerationRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        TexCoordGenerationRetained mirrorTc = (TexCoordGenerationRetained)this.mirror;
        mirrorTc.mirrorCompDirty = true;
        if ((component & 1) != 0) {
            mirrorTc.enable = (Boolean)value;
        } else if ((component & 2) != 0) {
            mirrorTc.planeS = (Vector4f)value;
        } else if ((component & 4) != 0) {
            mirrorTc.planeT = (Vector4f)value;
        } else if ((component & 8) != 0) {
            mirrorTc.planeR = (Vector4f)value;
        } else if ((component & 0x10) != 0) {
            mirrorTc.planeQ = (Vector4f)value;
        }
    }

    boolean equivalent(TexCoordGenerationRetained tr) {
        if (tr == null) {
            return false;
        }
        if (this.changedFrequent != 0 || tr.changedFrequent != 0) {
            return this == tr;
        }
        return tr.genMode == this.genMode && tr.format == this.format && tr.enable == this.enable && tr.planeS.equals((Tuple4f)this.planeS) && tr.planeT.equals((Tuple4f)this.planeT) && tr.planeR.equals((Tuple4f)this.planeR);
    }

    @Override
    protected Object clone() {
        TexCoordGenerationRetained tr = (TexCoordGenerationRetained)super.clone();
        tr.planeS = new Vector4f(this.planeS);
        tr.planeT = new Vector4f(this.planeT);
        tr.planeR = new Vector4f(this.planeR);
        return tr;
    }

    protected void set(TexCoordGenerationRetained tr) {
        super.set(tr);
        this.genMode = tr.genMode;
        this.format = tr.format;
        this.enable = tr.enable;
        this.planeS.set((Tuple4f)tr.planeS);
        this.planeT.set((Tuple4f)tr.planeT);
        this.planeR.set((Tuple4f)tr.planeR);
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 14;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 14;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        switch (bit) {
            case 1: 
            case 5: {
                this.setFrequencyChangeMask(bit, bit);
            }
        }
    }
}

