/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.ShaderAttribute;
import org.jogamp.java3d.ShaderAttributeRetained;
import org.jogamp.java3d.ShaderProgramRetained;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.VirtualUniverse;

class ShaderAttributeSetRetained
extends NodeComponentRetained {
    private Map<String, ShaderAttributeRetained> attrs = new HashMap<String, ShaderAttributeRetained>();
    private ArrayList<ShaderAttributeRetained> attrsValues = new ArrayList();
    Object liveStateLock = new Object();

    ShaderAttributeSetRetained() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(ShaderAttribute attr) {
        Object object = this.liveStateLock;
        synchronized (object) {
            ShaderAttributeRetained sAttr = (ShaderAttributeRetained)attr.retained;
            assert (sAttr != null);
            this.attrs.put(sAttr.attrName, sAttr);
            this.attrsValues.add(sAttr);
            if (this.source.isLive()) {
                sAttr.setLive(this.inBackgroundGroup, this.refCount);
                sAttr.copyMirrorUsers(this);
                this.sendMessage(1, sAttr.mirror);
            }
        }
    }

    ShaderAttribute get(String attrName) {
        ShaderAttributeRetained sAttr = this.attrs.get(attrName);
        if (sAttr != null) {
            return (ShaderAttribute)this.attrs.get((Object)attrName).source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String attrName) {
        Object object = this.liveStateLock;
        synchronized (object) {
            ShaderAttributeRetained sAttr = this.attrs.get(attrName);
            this.attrs.remove(attrName);
            this.attrsValues.remove(sAttr);
            if (this.source.isLive()) {
                sAttr.clearLive(this.refCount);
                sAttr.removeMirrorUsers(this);
                this.sendMessage(2, attrName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ShaderAttribute attr) {
        Object object = this.liveStateLock;
        synchronized (object) {
            String attrName = attr.getAttributeName();
            if (this.attrs.get(attrName) == attr.retained) {
                this.attrsValues.remove(this.attrs.remove(attrName));
                if (this.source.isLive()) {
                    ((ShaderAttributeRetained)attr.retained).clearLive(this.refCount);
                    ((ShaderAttributeRetained)attr.retained).removeMirrorUsers(this);
                    this.sendMessage(2, attrName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ShaderAttributeRetained[] sAttrs = new ShaderAttributeRetained[this.attrs.size()];
                sAttrs = this.attrs.values().toArray(sAttrs);
                for (int i = 0; i < sAttrs.length; ++i) {
                    sAttrs[i].clearLive(this.refCount);
                    sAttrs[i].removeMirrorUsers(this);
                }
                this.sendMessage(4, null);
            }
            this.attrs.clear();
            this.attrsValues.clear();
        }
    }

    ShaderAttribute[] getAll() {
        ShaderAttributeRetained[] sAttrsRetained = new ShaderAttributeRetained[this.attrs.size()];
        ShaderAttribute[] sAttrs = new ShaderAttribute[sAttrsRetained.length];
        sAttrsRetained = this.attrs.values().toArray(sAttrsRetained);
        for (int i = 0; i < sAttrsRetained.length; ++i) {
            sAttrs[i] = (ShaderAttribute)sAttrsRetained[i].source;
        }
        return sAttrs;
    }

    int size() {
        return this.attrs.size();
    }

    void updateNative(Canvas3D cv, ShaderProgramRetained shaderProgram) {
        shaderProgram.setShaderAttributes(cv, this);
    }

    Map<String, ShaderAttributeRetained> getAttrs() {
        return this.attrs;
    }

    List<ShaderAttributeRetained> getAttrValues() {
        return this.attrsValues;
    }

    @Override
    void setLive(boolean backgroundGroup, int refCount) {
        ShaderAttributeRetained[] sAttrsRetained = new ShaderAttributeRetained[this.attrs.size()];
        sAttrsRetained = this.attrs.values().toArray(sAttrsRetained);
        for (int i = 0; i < sAttrsRetained.length; ++i) {
            sAttrsRetained[i].setLive(backgroundGroup, refCount);
        }
        super.doSetLive(backgroundGroup, refCount);
        super.markAsLive();
    }

    @Override
    synchronized void addAMirrorUser(Shape3DRetained shape) {
        super.addAMirrorUser(shape);
        ShaderAttributeRetained[] sAttrsRetained = new ShaderAttributeRetained[this.attrs.size()];
        sAttrsRetained = this.attrs.values().toArray(sAttrsRetained);
        for (int i = 0; i < sAttrsRetained.length; ++i) {
            sAttrsRetained[i].addAMirrorUser(shape);
        }
    }

    @Override
    synchronized void removeAMirrorUser(Shape3DRetained shape) {
        super.removeAMirrorUser(shape);
        ShaderAttributeRetained[] sAttrsRetained = new ShaderAttributeRetained[this.attrs.size()];
        sAttrsRetained = this.attrs.values().toArray(sAttrsRetained);
        for (int i = 0; i < sAttrsRetained.length; ++i) {
            sAttrsRetained[i].removeAMirrorUser(shape);
        }
    }

    @Override
    synchronized void removeMirrorUsers(NodeComponentRetained node) {
        super.removeMirrorUsers(node);
        ShaderAttributeRetained[] sAttrsRetained = new ShaderAttributeRetained[this.attrs.size()];
        sAttrsRetained = this.attrs.values().toArray(sAttrsRetained);
        for (int i = 0; i < sAttrsRetained.length; ++i) {
            sAttrsRetained[i].removeMirrorUsers(node);
        }
    }

    @Override
    synchronized void copyMirrorUsers(NodeComponentRetained node) {
        super.copyMirrorUsers(node);
        ShaderAttributeRetained[] sAttrsRetained = new ShaderAttributeRetained[this.attrs.size()];
        sAttrsRetained = this.attrs.values().toArray(sAttrsRetained);
        for (int i = 0; i < sAttrsRetained.length; ++i) {
            sAttrsRetained[i].copyMirrorUsers(node);
        }
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        ShaderAttributeRetained[] sAttrsRetained = new ShaderAttributeRetained[this.attrs.size()];
        sAttrsRetained = this.attrs.values().toArray(sAttrsRetained);
        for (int i = 0; i < sAttrsRetained.length; ++i) {
            sAttrsRetained[i].clearLive(refCount);
        }
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeSetRetained mirrorSAS = new ShaderAttributeSetRetained();
            this.mirror = mirrorSAS;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    @Override
    void initMirrorObject() {
        ShaderAttributeRetained[] sAttrs = new ShaderAttributeRetained[this.attrs.size()];
        sAttrs = this.attrs.values().toArray(sAttrs);
        for (int i = 0; i < sAttrs.length; ++i) {
            ShaderAttributeRetained mirrorSA = (ShaderAttributeRetained)sAttrs[i].mirror;
            assert (mirrorSA != null);
            ((ShaderAttributeSetRetained)this.mirror).attrs.put(mirrorSA.attrName, mirrorSA);
            ((ShaderAttributeSetRetained)this.mirror).attrsValues.add(mirrorSA);
        }
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        ShaderAttributeSetRetained mirrorSAS = (ShaderAttributeSetRetained)this.mirror;
        if ((component & 1) != 0) {
            ShaderAttributeRetained mirrorSA = (ShaderAttributeRetained)value;
            assert (mirrorSA != null);
            ((ShaderAttributeSetRetained)this.mirror).attrs.put(mirrorSA.attrName, mirrorSA);
            ((ShaderAttributeSetRetained)this.mirror).attrsValues.add(mirrorSA);
        } else if ((component & 2) != 0) {
            ((ShaderAttributeSetRetained)this.mirror).attrsValues.remove(((ShaderAttributeSetRetained)this.mirror).attrs.remove((String)value));
        } else if ((component & 4) != 0) {
            ((ShaderAttributeSetRetained)this.mirror).attrs.clear();
            ((ShaderAttributeSetRetained)this.mirror).attrsValues.clear();
        } else assert (false);
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 64;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 64;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void setFrequencyChangeMask(int bit, int mask) {
        if (this.source.getCapability(bit)) {
            this.changedFrequent |= mask;
        } else if (!this.source.isLive()) {
            this.changedFrequent &= ~mask;
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }
}

