/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.utils.geometry;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.utils.geometry.PrimitiveState;

public class SphereState
extends PrimitiveState {
    private float radius;
    private int divisions;
    private int bodyAppearance;

    public SphereState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.bodyAppearance = control.getSymbolTable().addReference((SceneGraphObject)((Sphere)this.node).getShape(0).getAppearance());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.bodyAppearance);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.bodyAppearance = in.readInt();
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeFloat(((Sphere)this.node).getRadius());
        out.writeInt(((Sphere)this.node).getDivisions());
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.radius = in.readFloat();
        this.divisions = in.readInt();
    }

    @Override
    public void buildGraph() {
        ((Sphere)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        Object[] objectArray = new Object[4];
        objectArray[0] = new Float(this.radius);
        objectArray[1] = new Integer(this.primflags);
        objectArray[2] = new Integer(this.divisions);
        Sphere sphere = (Sphere)this.createNode(j3dClass, new Class[]{Float.TYPE, Integer.TYPE, Integer.TYPE, Appearance.class}, objectArray);
        return sphere;
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Sphere(this.radius, this.primflags, this.divisions, null);
    }
}

