/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.geometry.compression.CompressedGeometryRetained;
import org.jogamp.java3d.utils.geometry.compression.GeometryDecompressorShape3D;
import org.jogamp.vecmath.Point3d;

public class CompressedGeometryData {
    private Header cgHeader;
    private CompressedGeometryRetained retained;

    public CompressedGeometryData(Header hdr, byte[] compressedGeometry) {
        this(hdr, compressedGeometry, false);
    }

    public CompressedGeometryData(Header hdr, byte[] compressedGeometry, boolean byReference) {
        if (hdr.size + hdr.start > compressedGeometry.length) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("CompressedGeometry0"));
        }
        this.cgHeader = new Header();
        hdr.copy(this.cgHeader);
        this.retained = new CompressedGeometryRetained();
        this.retained.createCompressedGeometry(this.cgHeader, compressedGeometry, byReference);
        if (!byReference) {
            this.cgHeader.start = 0;
        }
    }

    public CompressedGeometryData(Header hdr, J3DBuffer compressedGeometry) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getByteCount() {
        return this.cgHeader.size;
    }

    public void getCompressedGeometryHeader(Header hdr) {
        this.cgHeader.copy(hdr);
    }

    public void getCompressedGeometry(byte[] compressedGeometry) {
        if (this.isByReference()) {
            throw new IllegalStateException(J3dUtilsI18N.getString("CompressedGeometry7"));
        }
        if (this.cgHeader.size > compressedGeometry.length) {
            throw new ArrayIndexOutOfBoundsException(J3dUtilsI18N.getString("CompressedGeometry4"));
        }
        this.retained.copy(compressedGeometry);
    }

    public Shape3D[] decompress() {
        CompressedGeometryRetained cgr = this.retained;
        GeometryDecompressorShape3D decompressor = new GeometryDecompressorShape3D();
        return decompressor.toTriangleStripArrays(cgr);
    }

    public boolean isByReference() {
        return this.retained.isByReference();
    }

    public byte[] getCompressedGeometryRef() {
        if (!this.isByReference()) {
            throw new IllegalStateException(J3dUtilsI18N.getString("CompressedGeometry8"));
        }
        return this.retained.getReference();
    }

    public J3DBuffer getCompressedGeometryBuffer() {
        return null;
    }

    public static class Header {
        public static final int POINT_BUFFER = 0;
        public static final int LINE_BUFFER = 1;
        public static final int TRIANGLE_BUFFER = 2;
        public static final int NORMAL_IN_BUFFER = 1;
        public static final int COLOR_IN_BUFFER = 2;
        public static final int ALPHA_IN_BUFFER = 4;
        public int majorVersionNumber;
        public int minorVersionNumber;
        public int minorMinorVersionNumber;
        public int bufferType;
        public int bufferDataPresent;
        public int size;
        public int start;
        public Point3d lowerBound = null;
        public Point3d upperBound = null;

        void copy(Header hdr) {
            hdr.majorVersionNumber = this.majorVersionNumber;
            hdr.minorVersionNumber = this.minorVersionNumber;
            hdr.minorMinorVersionNumber = this.minorMinorVersionNumber;
            hdr.bufferType = this.bufferType;
            hdr.bufferDataPresent = this.bufferDataPresent;
            hdr.size = this.size;
            hdr.start = this.start;
            hdr.lowerBound = this.lowerBound;
            hdr.upperBound = this.upperBound;
        }

        public String toString() {
            String type = "UNKNOWN";
            switch (this.bufferType) {
                case 0: {
                    type = "POINT_BUFFER";
                    break;
                }
                case 1: {
                    type = "LINE_BUFFER";
                    break;
                }
                case 2: {
                    type = "TRIANGLE_BUFFER";
                }
            }
            String data = "";
            if ((this.bufferDataPresent & 1) != 0) {
                data = String.valueOf(data) + "NORMALS ";
            }
            if ((this.bufferDataPresent & 2) != 0) {
                data = String.valueOf(data) + "COLORS ";
            }
            if ((this.bufferDataPresent & 4) != 0) {
                data = String.valueOf(data) + "ALPHA ";
            }
            String lbound = "null";
            if (this.lowerBound != null) {
                lbound = this.lowerBound.toString();
            }
            String ubound = "null";
            if (this.upperBound != null) {
                ubound = this.upperBound.toString();
            }
            return "majorVersionNumber: " + this.majorVersionNumber + "  " + "minorVersionNumber: " + this.minorVersionNumber + "  " + "minorMinorVersionNumber: " + this.minorMinorVersionNumber + "\n" + "bufferType: " + type + "  " + "bufferDataPresent: " + data + "\n" + "size: " + this.size + "  " + "start: " + this.start + "\n" + "lower bound: " + lbound + "\n" + "upper bound: " + ubound + "  ";
        }
    }
}

