/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import java.util.Hashtable;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.utils.geometry.GeomBuffer;
import org.jogamp.vecmath.Color3f;

public abstract class Primitive
extends Group {
    public static final int GENERATE_NORMALS = 1;
    public static final int GENERATE_TEXTURE_COORDS = 2;
    public static final int GENERATE_NORMALS_INWARD = 4;
    public static final int GENERATE_TEXTURE_COORDS_Y_UP = 8;
    public static final int GEOMETRY_NOT_SHARED = 16;
    public static final int ENABLE_GEOMETRY_PICKING = 32;
    public static final int ENABLE_APPEARANCE_MODIFY = 64;
    static final int SPHERE = 1;
    static final int CYLINDER = 2;
    static final int CONE = 4;
    static final int BOX = 8;
    static final int TOP_DISK = 16;
    static final int BOTTOM_DISK = 32;
    static final int CONE_DIVISIONS = 64;
    int numTris = 0;
    int numVerts = 0;
    int flags = 0;
    static Hashtable geomCache = new Hashtable();

    public Primitive() {
        this.setCapability(1);
        this.setCapability(12);
    }

    public int getNumTriangles() {
        return this.numTris;
    }

    public void setNumTriangles(int num) {
        System.err.println("Warning: setNumTriangles has no effect");
    }

    public int getNumVertices() {
        return this.numVerts;
    }

    public void setNumVertices(int num) {
        System.err.println("Warning: setNumVertices has no effect");
    }

    public int getPrimitiveFlags() {
        return this.flags;
    }

    public void setPrimitiveFlags(int fl) {
        System.err.println("Warning: setPrimitiveFlags has no effect");
    }

    public abstract Shape3D getShape(int var1);

    public Appearance getAppearance() {
        return this.getShape(0).getAppearance();
    }

    public abstract Appearance getAppearance(int var1);

    public void setAppearance(int partid, Appearance ap) {
        this.getShape(partid).setAppearance(ap);
    }

    public abstract void setAppearance(Appearance var1);

    public void setAppearance() {
        Color3f aColor = new Color3f(0.1f, 0.1f, 0.1f);
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f dColor = new Color3f(0.6f, 0.6f, 0.6f);
        Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
        Material m = new Material(aColor, eColor, dColor, sColor, 100.0f);
        Appearance a = new Appearance();
        m.setLightingEnable(true);
        a.setMaterial(m);
        this.setAppearance(a);
    }

    String strfloat(float x) {
        return new Float(x).toString();
    }

    protected void cacheGeometry(int kind, float a, float b, float c, int d, int e, int flags, GeomBuffer geo) {
        String key = new String(String.valueOf(kind) + this.strfloat(a) + this.strfloat(b) + this.strfloat(c) + d + e + flags);
        geomCache.put(key, geo);
    }

    protected GeomBuffer getCachedGeometry(int kind, float a, float b, float c, int d, int e, int flags) {
        String key = new String(String.valueOf(kind) + this.strfloat(a) + this.strfloat(b) + this.strfloat(c) + d + e + flags);
        Object cache = geomCache.get(key);
        return (GeomBuffer)cache;
    }

    public static void clearGeometryCache() {
        geomCache.clear();
    }
}

