/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedQuadArray;
import org.jogamp.java3d.IndexedTriangleArray;
import org.jogamp.java3d.IndexedTriangleFanArray;
import org.jogamp.java3d.IndexedTriangleStripArray;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.geometry.GeometryInfoGenerator;
import org.jogamp.java3d.utils.geometry.NormalGenerator;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Color3b;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4b;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;
import org.jogamp.vecmath.TexCoord4f;
import org.jogamp.vecmath.Tuple2f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector3f;

public class GeometryInfo {
    public static final int TRIANGLE_ARRAY = 1;
    public static final int QUAD_ARRAY = 2;
    public static final int TRIANGLE_FAN_ARRAY = 3;
    public static final int TRIANGLE_STRIP_ARRAY = 4;
    public static final int POLYGON_ARRAY = 5;
    private int prim;
    private static final int DEBUG = 0;
    private Point3f[] coordinates = null;
    private Color3f[] colors3 = null;
    private Color4f[] colors4 = null;
    private Vector3f[] normals = null;
    private Object[][] texCoordSets = null;
    private int[] coordinateIndices = null;
    private int[] colorIndices = null;
    private int[] normalIndices = null;
    private int[][] texCoordIndexSets = null;
    private int[] texCoordSetMap = null;
    private int texCoordSetCount = 0;
    private int texCoordDim = 0;
    private int[] stripCounts = null;
    private int[] contourCounts = null;
    private Triangulator tr = null;
    private NormalGenerator ng = null;
    private int oldPrim = 0;
    private int[] oldStripCounts = null;
    private boolean coordOnly = false;
    private int vertexAttrCount = 0;
    private int[] vertexAttrSizes = null;

    public GeometryInfo(int primitive) {
        if (primitive < 1 || primitive > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = primitive;
    }

    public GeometryInfo(GeometryArray ga) {
        GeometryInfoGenerator.create(this, ga);
    }

    public void reset(int primitive) {
        if (primitive < 1 || primitive > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = primitive;
        this.coordinates = null;
        this.colors3 = null;
        this.colors4 = null;
        this.normals = null;
        this.coordinateIndices = null;
        this.colorIndices = null;
        this.normalIndices = null;
        this.stripCounts = null;
        this.contourCounts = null;
        this.oldPrim = 0;
        this.oldStripCounts = null;
        this.texCoordDim = 0;
        this.texCoordSetCount = 0;
        this.texCoordSets = null;
        this.texCoordIndexSets = null;
        this.texCoordSetMap = null;
        this.coordOnly = false;
    }

    public void reset(GeometryArray ga) {
        GeometryInfoGenerator.create(this, ga);
    }

    private int[] expandQuad(int[] indices) {
        int[] triangles = new int[indices.length / 4 * 6];
        int i = 0;
        while (i < indices.length / 4) {
            triangles[i * 6 + 0] = indices[i * 4];
            triangles[i * 6 + 1] = indices[i * 4 + 1];
            triangles[i * 6 + 2] = indices[i * 4 + 2];
            triangles[i * 6 + 3] = indices[i * 4];
            triangles[i * 6 + 4] = indices[i * 4 + 2];
            triangles[i * 6 + 5] = indices[i * 4 + 3];
            ++i;
        }
        return triangles;
    }

    private int[] expandTriFan(int numTris, int[] indices) {
        int[] triangles = new int[numTris * 3];
        int p = 0;
        int base = 0;
        int f = 0;
        while (f < this.stripCounts.length) {
            int t = 0;
            while (t < this.stripCounts[f] - 2) {
                triangles[p++] = indices[base];
                triangles[p++] = indices[base + t + 1];
                triangles[p++] = indices[base + t + 2];
                ++t;
            }
            base += this.stripCounts[f];
            ++f;
        }
        return triangles;
    }

    private int[] expandTriStrip(int numTris, int[] indices) {
        int[] triangles = new int[numTris * 3];
        int p = 0;
        int base = 0;
        int s = 0;
        while (s < this.stripCounts.length) {
            int t = 0;
            while (t < this.stripCounts[s] - 2) {
                if (t % 2 == 0) {
                    triangles[p++] = indices[base + t + 0];
                    triangles[p++] = indices[base + t + 1];
                    triangles[p++] = indices[base + t + 2];
                } else {
                    triangles[p++] = indices[base + t + 0];
                    triangles[p++] = indices[base + t + 2];
                    triangles[p++] = indices[base + t + 1];
                }
                ++t;
            }
            base += this.stripCounts[s];
            ++s;
        }
        return triangles;
    }

    void rememberOldPrim() {
        this.oldPrim = this.prim;
        this.oldStripCounts = this.stripCounts;
    }

    int getOldPrim() {
        return this.oldPrim;
    }

    void forgetOldPrim() {
        this.oldPrim = 0;
        this.oldStripCounts = null;
    }

    private void changeBackToOldPrim() {
        if (this.oldPrim != 0) {
            this.convertToIndexedTriangles();
            if (this.ng == null) {
                this.ng = new NormalGenerator();
            }
            this.ng.convertBackToOldPrim(this, this.oldPrim, this.oldStripCounts);
            this.oldPrim = 0;
            this.oldStripCounts = null;
        }
    }

    public void convertToIndexedTriangles() {
        int triangles = 0;
        this.indexify();
        if (this.prim == 1) {
            return;
        }
        switch (this.prim) {
            case 2: {
                this.coordinateIndices = this.expandQuad(this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandQuad(this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandQuad(this.normalIndices);
                }
                int i = 0;
                while (i < this.texCoordSetCount) {
                    this.texCoordIndexSets[i] = this.expandQuad(this.texCoordIndexSets[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.stripCounts.length) {
                    triangles += this.stripCounts[i] - 2;
                    ++i;
                }
                this.coordinateIndices = this.expandTriFan(triangles, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriFan(triangles, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriFan(triangles, this.normalIndices);
                }
                i = 0;
                while (i < this.texCoordSetCount) {
                    this.texCoordIndexSets[i] = this.expandTriFan(triangles, this.texCoordIndexSets[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.stripCounts.length) {
                    triangles += this.stripCounts[i] - 2;
                    ++i;
                }
                this.coordinateIndices = this.expandTriStrip(triangles, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriStrip(triangles, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriStrip(triangles, this.normalIndices);
                }
                i = 0;
                while (i < this.texCoordSetCount) {
                    this.texCoordIndexSets[i] = this.expandTriStrip(triangles, this.texCoordIndexSets[i]);
                    ++i;
                }
                break;
            }
            case 5: {
                if (this.tr == null) {
                    this.tr = new Triangulator();
                }
                this.tr.triangulate(this);
            }
        }
        this.prim = 1;
        this.stripCounts = null;
    }

    public int getPrimitive() {
        return this.prim;
    }

    void setPrimitive(int primitive) {
        if (this.prim < 1 || this.prim > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = primitive;
    }

    public void setCoordinates(Point3f[] coordinates) {
        this.coordinates = coordinates;
    }

    public void setCoordinates(Point3d[] coordinates) {
        if (coordinates == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[coordinates.length];
            int i = 0;
            while (i < coordinates.length) {
                this.coordinates[i] = new Point3f((float)coordinates[i].x, (float)coordinates[i].y, (float)coordinates[i].z);
                ++i;
            }
        }
    }

    public void setCoordinates(float[] coordinates) {
        if (coordinates == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[coordinates.length / 3];
            int i = 0;
            while (i < this.coordinates.length) {
                this.coordinates[i] = new Point3f(coordinates[i * 3], coordinates[i * 3 + 1], coordinates[i * 3 + 2]);
                ++i;
            }
        }
    }

    public void setCoordinates(double[] coordinates) {
        if (coordinates == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[coordinates.length / 3];
            int i = 0;
            while (i < coordinates.length / 3) {
                this.coordinates[i] = new Point3f((float)coordinates[i * 3], (float)coordinates[i * 3 + 1], (float)coordinates[i * 3 + 2]);
                ++i;
            }
        }
    }

    public Point3f[] getCoordinates() {
        return this.coordinates;
    }

    public void setColors(Color3f[] colors) {
        this.colors3 = colors;
        this.colors4 = null;
    }

    public void setColors(Color4f[] colors) {
        this.colors3 = null;
        this.colors4 = colors;
    }

    public void setColors(Color3b[] colors) {
        if (colors == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[colors.length];
            this.colors4 = null;
            int i = 0;
            while (i < colors.length) {
                this.colors3[i] = new Color3f((float)(colors[i].x & 0xFF) / 255.0f, (float)(colors[i].y & 0xFF) / 255.0f, (float)(colors[i].z & 0xFF) / 255.0f);
                ++i;
            }
        }
    }

    public void setColors(Color4b[] colors) {
        if (colors == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[colors.length];
            int i = 0;
            while (i < colors.length) {
                this.colors4[i] = new Color4f((float)(colors[i].x & 0xFF) / 255.0f, (float)(colors[i].y & 0xFF) / 255.0f, (float)(colors[i].z & 0xFF) / 255.0f, (float)(colors[i].w & 0xFF) / 255.0f);
                ++i;
            }
        }
    }

    public void setColors3(float[] colors) {
        if (colors == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[colors.length / 3];
            this.colors4 = null;
            int i = 0;
            while (i < colors.length / 3) {
                this.colors3[i] = new Color3f(colors[i * 3], colors[i * 3 + 1], colors[i * 3 + 2]);
                ++i;
            }
        }
    }

    public void setColors4(float[] colors) {
        if (colors == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[colors.length / 4];
            int i = 0;
            while (i < colors.length / 4) {
                this.colors4[i] = new Color4f(colors[i * 4], colors[i * 4 + 1], colors[i * 4 + 2], colors[i * 4 + 3]);
                ++i;
            }
        }
    }

    public void setColors3(byte[] colors) {
        if (colors == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[colors.length / 3];
            this.colors4 = null;
            int i = 0;
            while (i < colors.length / 3) {
                this.colors3[i] = new Color3f((float)(colors[i * 3] & 0xFF) / 255.0f, (float)(colors[i * 3 + 1] & 0xFF) / 255.0f, (float)(colors[i * 3 + 2] & 0xFF) / 255.0f);
                ++i;
            }
        }
    }

    public void setColors4(byte[] colors) {
        if (colors == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[colors.length / 4];
            int i = 0;
            while (i < colors.length / 4) {
                this.colors4[i] = new Color4f((float)(colors[i * 4] & 0xFF) / 255.0f, (float)(colors[i * 4 + 1] & 0xFF) / 255.0f, (float)(colors[i * 4 + 2] & 0xFF) / 255.0f, (float)(colors[i * 4 + 3] & 0xFF) / 255.0f);
                ++i;
            }
        }
    }

    public Object[] getColors() {
        if (this.colors3 != null) {
            return this.colors3;
        }
        return this.colors4;
    }

    public int getNumColorComponents() {
        if (this.colors3 != null) {
            return 3;
        }
        if (this.colors4 != null) {
            return 4;
        }
        return 0;
    }

    public void setNormals(Vector3f[] normals) {
        this.normals = normals;
    }

    public void setNormals(float[] normals) {
        if (normals == null) {
            this.normals = null;
        } else {
            this.normals = new Vector3f[normals.length / 3];
            int i = 0;
            while (i < this.normals.length) {
                this.normals[i] = new Vector3f(normals[i * 3], normals[i * 3 + 1], normals[i * 3 + 2]);
                ++i;
            }
        }
    }

    public Vector3f[] getNormals() {
        return this.normals;
    }

    public void setTextureCoordinateParams(int numSets, int dim) {
        if (dim == 2) {
            this.texCoordSets = new TexCoord2f[numSets][];
        } else if (dim == 3) {
            this.texCoordSets = new TexCoord3f[numSets][];
        } else if (dim == 4) {
            this.texCoordSets = new TexCoord4f[numSets][];
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo9"));
        }
        this.texCoordIndexSets = new int[numSets][];
        this.texCoordDim = dim;
        this.texCoordSetCount = numSets;
    }

    public int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    public int getNumTexCoordComponents() {
        return this.texCoordDim;
    }

    public void setTexCoordSetMap(int[] map) {
        this.texCoordSetMap = map;
    }

    public int[] getTexCoordSetMap() {
        return this.texCoordSetMap;
    }

    public void setTextureCoordinates(int texCoordSet, TexCoord2f[] texCoords) {
        if (this.texCoordDim != 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo15"));
        }
        if (texCoordSet >= this.texCoordSetCount || texCoordSet < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[texCoordSet] = texCoords;
    }

    public void setTextureCoordinates(Point2f[] texCoords) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 2;
        this.texCoordSets = new TexCoord2f[1][];
        if (texCoords != null) {
            TexCoord2f[] tex = new TexCoord2f[texCoords.length];
            int i = 0;
            while (i < texCoords.length) {
                tex[i] = new TexCoord2f((Tuple2f)texCoords[i]);
                ++i;
            }
            this.texCoordSets[0] = tex;
        }
    }

    public void setTextureCoordinates(int texCoordSet, TexCoord3f[] texCoords) {
        if (this.texCoordDim != 3) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo16"));
        }
        if (texCoordSet >= this.texCoordSetCount || texCoordSet < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[texCoordSet] = texCoords;
    }

    public void setTextureCoordinates(Point3f[] texCoords) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 3;
        this.texCoordSets = new TexCoord3f[1][];
        if (texCoords != null) {
            TexCoord3f[] tex = new TexCoord3f[texCoords.length];
            int i = 0;
            while (i < texCoords.length) {
                tex[i] = new TexCoord3f((Tuple3f)texCoords[i]);
                ++i;
            }
            this.texCoordSets[0] = tex;
        }
    }

    public void setTextureCoordinates(int texCoordSet, TexCoord4f[] texCoords) {
        if (this.texCoordDim != 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo17"));
        }
        if (texCoordSet >= this.texCoordSetCount || texCoordSet < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[texCoordSet] = texCoords;
    }

    public void setTextureCoordinates(int texCoordSet, float[] texCoords) {
        if (texCoords.length % this.texCoordDim != 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo2"));
        }
        if (this.texCoordDim == 2) {
            TexCoord2f[] tcoords = new TexCoord2f[texCoords.length / 2];
            int i = 0;
            while (i < tcoords.length) {
                tcoords[i] = new TexCoord2f(texCoords[i * 2], texCoords[i * 2 + 1]);
                ++i;
            }
            this.setTextureCoordinates(texCoordSet, tcoords);
        } else if (this.texCoordDim == 3) {
            TexCoord3f[] tcoords = new TexCoord3f[texCoords.length / 3];
            int i = 0;
            while (i < tcoords.length) {
                tcoords[i] = new TexCoord3f(texCoords[i * 3], texCoords[i * 3 + 1], texCoords[i * 3 + 2]);
                ++i;
            }
            this.setTextureCoordinates(texCoordSet, tcoords);
        } else if (this.texCoordDim == 4) {
            TexCoord4f[] tcoords = new TexCoord4f[texCoords.length / 4];
            int i = 0;
            while (i < tcoords.length) {
                tcoords[i] = new TexCoord4f(texCoords[i * 4], texCoords[i * 4 + 1], texCoords[i * 4 + 2], texCoords[i * 4 + 3]);
                ++i;
            }
            this.setTextureCoordinates(texCoordSet, tcoords);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo21"));
        }
    }

    public void setTextureCoordinates2(float[] texCoords) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 2;
        this.texCoordSets = new TexCoord2f[1][];
        this.setTextureCoordinates(0, texCoords);
    }

    public void setTextureCoordinates3(float[] texCoords) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 3;
        this.texCoordSets = new TexCoord3f[1][];
        this.setTextureCoordinates(0, texCoords);
    }

    public Object[] getTextureCoordinates(int texCoordSet) {
        if (texCoordSet >= this.texCoordSetCount || texCoordSet < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        return this.texCoordSets[texCoordSet];
    }

    public Object[] getTextureCoordinates() {
        return this.texCoordSets[0];
    }

    public void setCoordinateIndices(int[] coordinateIndices) {
        this.coordinateIndices = coordinateIndices;
    }

    public int[] getCoordinateIndices() {
        return this.coordinateIndices;
    }

    public void setColorIndices(int[] colorIndices) {
        this.colorIndices = colorIndices;
    }

    public int[] getColorIndices() {
        return this.colorIndices;
    }

    public void setNormalIndices(int[] normalIndices) {
        this.normalIndices = normalIndices;
    }

    public int[] getNormalIndices() {
        return this.normalIndices;
    }

    public void setTextureCoordinateIndices(int texCoordSet, int[] texIndices) {
        if (texCoordSet >= this.texCoordSetCount || texCoordSet < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordIndexSets[texCoordSet] = texIndices;
    }

    public void setTextureCoordinateIndices(int[] texIndices) {
        if (this.texCoordSetCount > 1) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo1"));
        }
        this.texCoordIndexSets = new int[1][];
        this.texCoordIndexSets[0] = texIndices;
    }

    public int[] getTextureCoordinateIndices(int texCoordSet) {
        return this.texCoordIndexSets[texCoordSet];
    }

    public int[] getTextureCoordinateIndices() {
        if (this.texCoordIndexSets == null) {
            return null;
        }
        return this.texCoordIndexSets[0];
    }

    public void setStripCounts(int[] stripCounts) {
        this.stripCounts = stripCounts;
    }

    public int[] getStripCounts() {
        return this.stripCounts;
    }

    public void setContourCounts(int[] contourCounts) {
        this.contourCounts = contourCounts;
    }

    public void setVertexAttributes(int vertexAttrCount, int[] vertexAttrSizes) {
        this.vertexAttrCount = vertexAttrCount;
        this.vertexAttrSizes = vertexAttrSizes;
    }

    public int[] getContourCounts() {
        return this.contourCounts;
    }

    int[] getListIndices(Object[] list) {
        int[] indices = new int[list.length];
        HashMap<Object, Integer> table = new HashMap<Object, Integer>(list.length);
        int i = 0;
        while (i < list.length) {
            Integer idx = (Integer)table.get(list[i]);
            if (idx == null) {
                indices[i] = i;
                table.put(list[i], new Integer(i));
            } else {
                indices[i] = idx;
            }
            ++i;
        }
        return indices;
    }

    public void indexify(boolean useCoordIndexOnly) {
        this.checkForBadData();
        if (useCoordIndexOnly) {
            int j;
            if (this.coordOnly) {
                return;
            }
            this.indexify(false);
            int numLists = 1;
            if (this.colorIndices != null) {
                ++numLists;
            }
            if (this.normalIndices != null) {
                ++numLists;
            }
            numLists += this.texCoordSetCount;
            int n = this.coordinateIndices.length;
            Object[] ir = new IndexRow[n];
            int i = 0;
            while (i < n) {
                ir[i] = new IndexRow(numLists);
                j = 0;
                ((IndexRow)ir[i]).set(j++, this.coordinateIndices[i]);
                if (this.colorIndices != null) {
                    ((IndexRow)ir[i]).set(j++, this.colorIndices[i]);
                }
                if (this.normalIndices != null) {
                    ((IndexRow)ir[i]).set(j++, this.normalIndices[i]);
                }
                int k = 0;
                while (k < this.texCoordSetCount) {
                    ((IndexRow)ir[i]).set(j++, this.texCoordIndexSets[k][i]);
                    ++k;
                }
                ++i;
            }
            int[] coordOnlyIndices = this.getListIndices(ir);
            int[] newInd = new int[coordOnlyIndices.length];
            ir = (IndexRow[])this.compactData(coordOnlyIndices, ir, newInd);
            coordOnlyIndices = newInd;
            Point3f[] newCoords = new Point3f[ir.length];
            Color3f[] newColors3 = null;
            Color4f[] newColors4 = null;
            Vector3f[] newNormals = null;
            TexCoord2f[][] newTexCoordSets = null;
            if (this.colors3 != null) {
                newColors3 = new Color3f[ir.length];
            } else if (this.colors4 != null) {
                newColors4 = new Color4f[ir.length];
            }
            if (this.normals != null) {
                newNormals = new Vector3f[ir.length];
            }
            int i2 = 0;
            while (i2 < this.texCoordSetCount) {
                if (this.texCoordDim == 2) {
                    if (i2 == 0) {
                        newTexCoordSets = new TexCoord2f[this.texCoordSetCount][];
                    }
                    newTexCoordSets[i2] = new TexCoord2f[ir.length];
                } else if (this.texCoordDim == 3) {
                    if (i2 == 0) {
                        newTexCoordSets = new TexCoord3f[this.texCoordSetCount][];
                    }
                    newTexCoordSets[i2] = new TexCoord3f[ir.length];
                } else if (this.texCoordDim == 4) {
                    if (i2 == 0) {
                        newTexCoordSets = new TexCoord4f[this.texCoordSetCount][];
                    }
                    newTexCoordSets[i2] = new TexCoord4f[ir.length];
                }
                ++i2;
            }
            n = ir.length;
            i2 = 0;
            while (i2 < n) {
                j = 0;
                newCoords[i2] = this.coordinates[((IndexRow)ir[i2]).get(j++)];
                if (this.colors3 != null) {
                    newColors3[i2] = this.colors3[((IndexRow)ir[i2]).get(j++)];
                } else if (this.colors4 != null) {
                    newColors4[i2] = this.colors4[((IndexRow)ir[i2]).get(j++)];
                }
                if (this.normals != null) {
                    newNormals[i2] = this.normals[((IndexRow)ir[i2]).get(j++)];
                }
                int k = 0;
                while (k < this.texCoordSetCount) {
                    newTexCoordSets[k][i2] = this.texCoordSets[k][((IndexRow)ir[i2]).get(j++)];
                    ++k;
                }
                ++i2;
            }
            this.coordinates = newCoords;
            this.colors3 = newColors3;
            this.colors4 = newColors4;
            this.normals = newNormals;
            this.texCoordSets = newTexCoordSets;
            this.coordinateIndices = coordOnlyIndices;
            this.colorIndices = null;
            this.normalIndices = null;
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            this.coordOnly = true;
        } else if (this.coordOnly) {
            int i;
            int n = this.coordinateIndices.length;
            if (this.colors3 != null || this.colors4 != null) {
                this.colorIndices = new int[n];
                i = 0;
                while (i < n) {
                    this.colorIndices[i] = this.coordinateIndices[i];
                    ++i;
                }
            }
            if (this.normals != null) {
                this.normalIndices = new int[n];
                i = 0;
                while (i < n) {
                    this.normalIndices[i] = this.coordinateIndices[i];
                    ++i;
                }
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            i = 0;
            while (i < this.texCoordSetCount) {
                this.texCoordIndexSets[i] = new int[n];
                int j = 0;
                while (j < n) {
                    this.texCoordIndexSets[i][j] = this.coordinateIndices[j];
                    ++j;
                }
                ++i;
            }
            this.coordOnly = false;
        } else {
            if (this.coordinateIndices != null) {
                return;
            }
            this.coordinateIndices = this.getListIndices(this.coordinates);
            if (this.colors3 != null) {
                this.colorIndices = this.getListIndices(this.colors3);
            } else if (this.colors4 != null) {
                this.colorIndices = this.getListIndices(this.colors4);
            }
            if (this.normals != null) {
                this.normalIndices = this.getListIndices(this.normals);
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            int i = 0;
            while (i < this.texCoordSetCount) {
                this.texCoordIndexSets[i] = this.getListIndices(this.texCoordSets[i]);
                ++i;
            }
            this.coordOnly = false;
        }
    }

    public void indexify() {
        this.indexify(false);
    }

    Object[] allocateArray(Object[] data, int num) {
        Object[] newData = null;
        if (data instanceof Point3f[]) {
            newData = new Point3f[num];
        } else if (data instanceof Vector3f[]) {
            newData = new Vector3f[num];
        } else if (data instanceof Color3f[]) {
            newData = new Color3f[num];
        } else if (data instanceof Color4f[]) {
            newData = new Color4f[num];
        } else if (data instanceof TexCoord2f[]) {
            newData = new TexCoord2f[num];
        } else if (data instanceof TexCoord3f[]) {
            newData = new TexCoord3f[num];
        } else if (data instanceof TexCoord4f[]) {
            newData = new TexCoord4f[num];
        } else if (data instanceof IndexRow[]) {
            newData = new IndexRow[num];
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo9"));
        }
        return newData;
    }

    private Object[] compactData(int[] indices, Object[] data, int[] newInd) {
        Object[] newData = null;
        int numUnique = 0;
        int[] translationTable = new int[data.length];
        int i = 0;
        while (i < indices.length) {
            if (translationTable[indices[i]] == 0) {
                ++numUnique;
                translationTable[indices[i]] = 1;
            }
            ++i;
        }
        newData = this.allocateArray(data, numUnique);
        int newIdx = 0;
        int i2 = 0;
        while (i2 < translationTable.length) {
            if (translationTable[i2] != 0) {
                newData[newIdx] = data[i2];
                translationTable[i2] = newIdx++;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < indices.length) {
            newInd[i2] = translationTable[indices[i2]];
            ++i2;
        }
        return newData;
    }

    public void compact() {
        this.checkForBadData();
        if (this.coordinateIndices == null) {
            return;
        }
        if (this.coordOnly) {
            return;
        }
        int[] newInd = new int[this.coordinateIndices.length];
        this.coordinates = (Point3f[])this.compactData(this.coordinateIndices, this.coordinates, newInd);
        this.coordinateIndices = newInd;
        if (this.colorIndices != null) {
            newInd = new int[this.colorIndices.length];
            if (this.colors3 != null) {
                this.colors3 = (Color3f[])this.compactData(this.colorIndices, this.colors3, newInd);
            } else if (this.colors4 != null) {
                this.colors4 = (Color4f[])this.compactData(this.colorIndices, this.colors4, newInd);
            }
            this.colorIndices = newInd;
        }
        if (this.normalIndices != null) {
            newInd = new int[this.normalIndices.length];
            this.normals = (Vector3f[])this.compactData(this.normalIndices, this.normals, newInd);
            this.normalIndices = newInd;
        }
        int i = 0;
        while (i < this.texCoordSetCount) {
            newInd = new int[this.texCoordIndexSets[i].length];
            this.texCoordSets[i] = this.compactData(this.texCoordIndexSets[i], this.texCoordSets[i], newInd);
            this.texCoordIndexSets[i] = newInd;
            ++i;
        }
    }

    private void checkForBadData() {
        int i;
        int i2;
        boolean badData = false;
        if (this.coordinates == null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo3"));
        }
        if (this.colors3 == null && this.colors4 == null && this.colorIndices != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo4"));
        }
        if (this.normals == null && this.normalIndices != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo11"));
        }
        int i3 = 0;
        while (i3 < this.texCoordSetCount) {
            if (this.texCoordSets[i3] == null) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo10"));
            }
            ++i3;
        }
        boolean texInds = false;
        if (this.texCoordIndexSets != null) {
            i2 = 0;
            while (i2 < this.texCoordSetCount) {
                if (this.texCoordIndexSets[i2] != null) {
                    texInds = true;
                }
                ++i2;
            }
        }
        if (this.coordinateIndices != null || this.colorIndices != null || this.normalIndices != null || texInds) {
            if (this.coordinateIndices == null) {
                badData = true;
            } else if (this.coordOnly) {
                if (this.colorIndices != null || this.normalIndices != null || texInds) {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo20"));
                }
            } else if ((this.colors3 != null || this.colors4 != null) && this.colorIndices == null) {
                badData = true;
            } else if (this.normals != null && this.normalIndices == null) {
                badData = true;
            } else if (this.texCoordSetCount > 0 && !texInds) {
                badData = true;
            }
            if (badData) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo19"));
            }
        }
        if (this.coordinateIndices != null && !this.coordOnly) {
            if ((this.colors3 != null || this.colors4 != null) && this.colorIndices.length != this.coordinateIndices.length) {
                badData = true;
            } else if (this.normals != null && this.normalIndices.length != this.coordinateIndices.length) {
                badData = true;
            } else {
                i2 = 0;
                while (i2 < this.texCoordSetCount) {
                    if (this.texCoordIndexSets[i2].length != this.coordinateIndices.length) {
                        badData = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (badData) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo5"));
            }
        }
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            if (this.stripCounts == null) {
                badData = true;
            }
        } else if (this.stripCounts != null) {
            badData = true;
        }
        if (badData) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo6"));
        }
        int count = this.coordinateIndices == null ? this.coordinates.length : this.coordinateIndices.length;
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            int sum = 0;
            i = 0;
            while (i < this.stripCounts.length) {
                sum += this.stripCounts[i];
                ++i;
            }
            if (sum != count) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo7"));
            }
        } else if (this.prim == 1) {
            if (count % 3 != 0) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo12"));
            }
        } else if (this.prim == 2 && count % 4 != 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo13"));
        }
        if (this.prim == 5) {
            if (this.contourCounts != null) {
                int c = 0;
                i = 0;
                while (i < this.contourCounts.length) {
                    c += this.contourCounts[i];
                    ++i;
                }
                if (c != this.stripCounts.length) {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo8"));
                }
            }
        } else if (this.contourCounts != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo14"));
        }
    }

    public void unindexify() {
        this.checkForBadData();
        if (this.coordinateIndices != null) {
            if (this.coordOnly) {
                this.indexify(false);
            }
            this.coordinates = (Point3f[])this.unindexifyData(this.coordinates, this.coordinateIndices);
            this.coordinateIndices = null;
            if (this.colors3 != null) {
                this.colors3 = (Color3f[])this.unindexifyData(this.colors3, this.colorIndices);
            } else if (this.colors4 != null) {
                this.colors4 = (Color4f[])this.unindexifyData(this.colors4, this.colorIndices);
            }
            this.colorIndices = null;
            if (this.normals != null) {
                this.normals = (Vector3f[])this.unindexifyData(this.normals, this.normalIndices);
                this.normalIndices = null;
            }
            int i = 0;
            while (i < this.texCoordSetCount) {
                this.texCoordSets[i] = this.unindexifyData(this.texCoordSets[i], this.texCoordIndexSets[i]);
                ++i;
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
        }
    }

    private Object[] unindexifyData(Object[] data, int[] index) {
        Object[] newData = this.allocateArray(data, index.length);
        int i = 0;
        while (i < index.length) {
            newData[i] = data[index[i]];
            ++i;
        }
        return newData;
    }

    private int getVertexFormat() {
        int vertexFormat = 1;
        if (this.colors3 != null) {
            vertexFormat |= 4;
        } else if (this.colors4 != null) {
            vertexFormat |= 0xC;
        }
        if (this.normals != null) {
            vertexFormat |= 2;
        }
        if (this.texCoordDim == 2) {
            vertexFormat |= 0x20;
        } else if (this.texCoordDim == 3) {
            vertexFormat |= 0x40;
        } else if (this.texCoordDim == 4) {
            vertexFormat |= 0x400;
        }
        if (this.vertexAttrCount > 0) {
            vertexFormat |= 0x1000;
        }
        return vertexFormat;
    }

    private int getVertexCount() {
        int vertexCount = this.coordinates.length;
        if (this.colors3 != null) {
            if (this.colors3.length > vertexCount) {
                vertexCount = this.colors3.length;
            }
        } else if (this.colors4 != null && this.colors4.length > vertexCount) {
            vertexCount = this.colors4.length;
        }
        if (this.normals != null && this.normals.length > vertexCount) {
            vertexCount = this.normals.length;
        }
        int i = 0;
        while (i < this.texCoordSetCount) {
            if (this.texCoordSets[i].length > vertexCount) {
                vertexCount = this.texCoordSets[i].length;
            }
            ++i;
        }
        return vertexCount;
    }

    private float[] vecmathToFloat(Object[] ar) {
        if (ar[0] instanceof Tuple2f) {
            float[] p = new float[ar.length * 2];
            Tuple2f[] a = (Tuple2f[])ar;
            int i = 0;
            while (i < ar.length) {
                p[i * 2] = a[i].x;
                p[i * 2 + 1] = a[i].y;
                ++i;
            }
            return p;
        }
        if (ar[0] instanceof Tuple3f) {
            float[] p = new float[ar.length * 3];
            Tuple3f[] a = (Tuple3f[])ar;
            int i = 0;
            while (i < ar.length) {
                p[i * 3] = a[i].x;
                p[i * 3 + 1] = a[i].y;
                p[i * 3 + 2] = a[i].z;
                ++i;
            }
            return p;
        }
        if (ar[0] instanceof Tuple4f) {
            float[] p = new float[ar.length * 4];
            Tuple4f[] a = (Tuple4f[])ar;
            int i = 0;
            while (i < ar.length) {
                p[i * 4] = a[i].x;
                p[i * 4 + 1] = a[i].y;
                p[i * 4 + 2] = a[i].z;
                p[i * 4 + 3] = a[i].w;
                ++i;
            }
            return p;
        }
        return null;
    }

    private void fillIn(GeometryArray ga, boolean byRef, boolean interleaved, boolean nio) {
        if (interleaved) {
            int wpv = 3;
            if (this.normals != null) {
                wpv += 3;
            }
            if (this.colors3 != null) {
                wpv += 3;
            } else if (this.colors4 != null) {
                wpv += 4;
            }
            float[] d = new float[(wpv += this.texCoordSetCount * this.texCoordDim) * this.coordinates.length];
            int offset = 0;
            int i = 0;
            while (i < this.coordinates.length) {
                int j;
                if (this.texCoordDim == 2) {
                    j = 0;
                    while (j < this.texCoordSetCount) {
                        d[offset++] = ((TexCoord2f)this.texCoordSets[j][i]).x;
                        d[offset++] = ((TexCoord2f)this.texCoordSets[j][i]).y;
                        ++j;
                    }
                } else if (this.texCoordDim == 3) {
                    j = 0;
                    while (j < this.texCoordSetCount) {
                        d[offset++] = ((TexCoord3f)this.texCoordSets[j][i]).x;
                        d[offset++] = ((TexCoord3f)this.texCoordSets[j][i]).y;
                        d[offset++] = ((TexCoord3f)this.texCoordSets[j][i]).z;
                        ++j;
                    }
                } else if (this.texCoordDim == 4) {
                    j = 0;
                    while (j < this.texCoordSetCount) {
                        d[offset++] = ((TexCoord4f)this.texCoordSets[j][i]).x;
                        d[offset++] = ((TexCoord4f)this.texCoordSets[j][i]).y;
                        d[offset++] = ((TexCoord4f)this.texCoordSets[j][i]).z;
                        d[offset++] = ((TexCoord4f)this.texCoordSets[j][i]).w;
                        ++j;
                    }
                }
                if (this.colors3 != null) {
                    d[offset++] = this.colors3[i].x;
                    d[offset++] = this.colors3[i].y;
                    d[offset++] = this.colors3[i].z;
                } else if (this.colors4 != null) {
                    d[offset++] = this.colors4[i].x;
                    d[offset++] = this.colors4[i].y;
                    d[offset++] = this.colors4[i].z;
                    d[offset++] = this.colors4[i].w;
                }
                if (this.normals != null) {
                    d[offset++] = this.normals[i].x;
                    d[offset++] = this.normals[i].y;
                    d[offset++] = this.normals[i].z;
                }
                d[offset++] = this.coordinates[i].x;
                d[offset++] = this.coordinates[i].y;
                d[offset++] = this.coordinates[i].z;
                ++i;
            }
            if (nio) {
                ByteBuffer b = ByteBuffer.allocateDirect(d.length * 4);
                FloatBuffer f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                f.put(d);
                ga.setInterleavedVertexBuffer(new J3DBuffer((Buffer)f));
            } else {
                ga.setInterleavedVertices(d);
            }
        } else if (nio) {
            ByteBuffer b = ByteBuffer.allocateDirect(this.coordinates.length * 4 * 3);
            FloatBuffer f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
            f.put(this.vecmathToFloat(this.coordinates));
            ga.setCoordRefBuffer(new J3DBuffer((Buffer)f));
            if (this.colors3 != null) {
                b = ByteBuffer.allocateDirect(this.colors3.length * 4 * 3);
                f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                f.put(this.vecmathToFloat(this.colors3));
                ga.setColorRefBuffer(new J3DBuffer((Buffer)f));
            } else if (this.colors4 != null) {
                b = ByteBuffer.allocateDirect(this.colors4.length * 4 * 4);
                f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                f.put(this.vecmathToFloat(this.colors4));
                ga.setColorRefBuffer(new J3DBuffer((Buffer)f));
            }
            if (this.normals != null) {
                b = ByteBuffer.allocateDirect(this.normals.length * 4 * 3);
                f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                f.put(this.vecmathToFloat(this.normals));
                ga.setNormalRefBuffer(new J3DBuffer((Buffer)f));
            }
            int i = 0;
            while (i < this.texCoordSetCount) {
                b = ByteBuffer.allocateDirect(this.texCoordSets[i].length * 4 * this.texCoordDim);
                f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                f.put(this.vecmathToFloat(this.texCoordSets[i]));
                ga.setTexCoordRefBuffer(i, new J3DBuffer((Buffer)f));
                ++i;
            }
        } else if (byRef) {
            ga.setCoordRefFloat(this.vecmathToFloat(this.coordinates));
            if (this.colors3 != null) {
                ga.setColorRefFloat(this.vecmathToFloat(this.colors3));
            } else if (this.colors4 != null) {
                ga.setColorRefFloat(this.vecmathToFloat(this.colors4));
            }
            if (this.normals != null) {
                ga.setNormalRefFloat(this.vecmathToFloat(this.normals));
            }
            int i = 0;
            while (i < this.texCoordSetCount) {
                ga.setTexCoordRefFloat(i, this.vecmathToFloat(this.texCoordSets[i]));
                ++i;
            }
        } else {
            ga.setCoordinates(0, this.coordinates);
            if (this.colors3 != null) {
                ga.setColors(0, this.colors3);
            } else if (this.colors4 != null) {
                ga.setColors(0, this.colors4);
            }
            if (this.normals != null) {
                ga.setNormals(0, this.normals);
            }
            int i = 0;
            while (i < this.texCoordSetCount) {
                if (this.texCoordDim == 2) {
                    ga.setTextureCoordinates(i, 0, (TexCoord2f[])this.texCoordSets[i]);
                } else if (this.texCoordDim == 3) {
                    ga.setTextureCoordinates(i, 0, (TexCoord3f[])this.texCoordSets[i]);
                } else if (this.texCoordDim == 4) {
                    ga.setTextureCoordinates(i, 0, (TexCoord4f[])this.texCoordSets[i]);
                }
                ++i;
            }
        }
        if (this.coordinateIndices != null) {
            IndexedGeometryArray iga = null;
            iga = (IndexedGeometryArray)ga;
            iga.setCoordinateIndices(0, this.coordinateIndices);
            if (!this.coordOnly) {
                if (this.colorIndices != null) {
                    iga.setColorIndices(0, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    iga.setNormalIndices(0, this.normalIndices);
                }
                int i = 0;
                while (i < this.texCoordSetCount) {
                    iga.setTextureCoordinateIndices(i, 0, this.texCoordIndexSets[i]);
                    ++i;
                }
            }
        }
    }

    public void recomputeIndices() {
        boolean remember = this.coordOnly;
        this.unindexify();
        this.indexify(remember);
    }

    private void reverseList(int[] list) {
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length / 2) {
            int t = list[i];
            list[i] = list[list.length - i - 1];
            list[list.length - i - 1] = t;
            ++i;
        }
    }

    public void reverse() {
        this.indexify();
        this.reverseList(this.stripCounts);
        this.reverseList(this.oldStripCounts);
        this.reverseList(this.contourCounts);
        this.reverseList(this.coordinateIndices);
        this.reverseList(this.colorIndices);
        this.reverseList(this.normalIndices);
        int i = 0;
        while (i < this.texCoordSetCount) {
            this.reverseList(this.texCoordIndexSets[i]);
            ++i;
        }
    }

    public boolean getUseCoordIndexOnly() {
        return this.coordOnly;
    }

    public void setUseCoordIndexOnly(boolean useCoordIndexOnly) {
        this.coordOnly = useCoordIndexOnly;
    }

    public GeometryArray getGeometryArray(boolean byRef, boolean interleaved, boolean nio) {
        this.checkForBadData();
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        this.unindexify();
        int vertexFormat = this.getVertexFormat();
        if (nio) {
            vertexFormat |= 0x880;
        }
        if (interleaved) {
            vertexFormat |= 0x180;
        }
        if (byRef) {
            vertexFormat |= 0x80;
        }
        int vertexCount = this.coordinates.length;
        if (this.texCoordSetCount > 0 && this.texCoordSetMap == null) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 0;
        }
        TriangleArray ga = null;
        switch (this.prim) {
            case 1: {
                TriangleArray ta;
                ga = ta = new TriangleArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
                break;
            }
            case 2: {
                QuadArray qa = new QuadArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
                ga = qa;
                break;
            }
            case 4: {
                TriangleStripArray tsa = new TriangleStripArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes, this.stripCounts);
                ga = tsa;
                break;
            }
            case 3: {
                TriangleFanArray tfa = new TriangleFanArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes, this.stripCounts);
                ga = tfa;
            }
        }
        this.fillIn((GeometryArray)ga, byRef, interleaved, nio);
        return ga;
    }

    public GeometryArray getGeometryArray() {
        return this.getGeometryArray(false, false, false);
    }

    public IndexedGeometryArray getIndexedGeometryArray(boolean compact, boolean byRef, boolean interleaved, boolean useCoordIndexOnly, boolean nio) {
        this.indexify(useCoordIndexOnly);
        if (compact) {
            this.compact();
        }
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        if (useCoordIndexOnly && !this.coordOnly) {
            boolean canUseCoordIndexOnly = true;
            if (this.coordinateIndices != null) {
                if (this.colorIndices != null && this.colorIndices.length != this.coordinateIndices.length) {
                    canUseCoordIndexOnly = false;
                }
                if (this.normalIndices != null && this.normalIndices.length != this.coordinateIndices.length) {
                    canUseCoordIndexOnly = false;
                }
                int i = 0;
                while (i < this.texCoordSetCount) {
                    if (this.texCoordIndexSets[i] != null && this.texCoordIndexSets[i].length != this.coordinateIndices.length) {
                        canUseCoordIndexOnly = false;
                        break;
                    }
                    ++i;
                }
                if (canUseCoordIndexOnly && (this.colorIndices != null || this.normalIndices != null || this.texCoordSetCount > 0)) {
                    i = 0;
                    while (i < this.coordinateIndices.length) {
                        int indexValue = this.coordinateIndices[i];
                        if (this.colorIndices != null && this.colorIndices[i] != indexValue) {
                            canUseCoordIndexOnly = false;
                            break;
                        }
                        if (this.normalIndices != null && this.normalIndices[i] != indexValue) {
                            canUseCoordIndexOnly = false;
                            break;
                        }
                        int j = 0;
                        while (j < this.texCoordSetCount) {
                            if (this.texCoordIndexSets[j] != null && this.texCoordIndexSets[j][i] != indexValue) {
                                canUseCoordIndexOnly = false;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            this.coordOnly = canUseCoordIndexOnly;
        }
        int vertexFormat = this.getVertexFormat();
        if (nio) {
            vertexFormat |= 0x880;
        }
        if (interleaved) {
            vertexFormat |= 0x180;
        }
        if (byRef) {
            vertexFormat |= 0x80;
        }
        if (this.coordOnly) {
            vertexFormat |= 0x200;
        }
        int vertexCount = this.getVertexCount();
        if (this.texCoordSetCount > 0 && this.texCoordSetMap == null) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 0;
        }
        IndexedTriangleArray ga = null;
        switch (this.prim) {
            case 1: {
                IndexedTriangleArray ta;
                ga = ta = new IndexedTriangleArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes, this.coordinateIndices.length);
                break;
            }
            case 2: {
                IndexedQuadArray qa = new IndexedQuadArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes, this.coordinateIndices.length);
                ga = qa;
                break;
            }
            case 4: {
                IndexedTriangleStripArray tsa = new IndexedTriangleStripArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes, this.coordinateIndices.length, this.stripCounts);
                ga = tsa;
                break;
            }
            case 3: {
                IndexedTriangleFanArray tfa = new IndexedTriangleFanArray(vertexCount, vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes, this.coordinateIndices.length, this.stripCounts);
                ga = tfa;
            }
        }
        this.fillIn((GeometryArray)ga, byRef, interleaved, nio);
        return ga;
    }

    public IndexedGeometryArray getIndexedGeometryArray(boolean compact) {
        return this.getIndexedGeometryArray(compact, false, false, false, false);
    }

    public IndexedGeometryArray getIndexedGeometryArray() {
        return this.getIndexedGeometryArray(false, false, false, false, false);
    }

    private class IndexRow {
        int[] val;
        int size;

        public int hashCode() {
            return Arrays.hashCode(this.val);
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.val, ((IndexRow)obj).val);
        }

        public int get(int index) {
            return this.val[index];
        }

        public void set(int index, int value) {
            this.val[index] = value;
        }

        IndexRow(int numColumns) {
            this.size = numColumns;
            this.val = new int[this.size];
        }
    }
}

