/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.sensor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.behaviors.sensor.SensorButtonListener;
import org.jogamp.java3d.utils.behaviors.sensor.SensorEvent;
import org.jogamp.java3d.utils.behaviors.sensor.SensorReadListener;
import org.jogamp.java3d.utils.timer.J3DTimer;

public class SensorEventAgent {
    private long t0 = 0L;
    private Object source = null;
    private SensorEvent e = new SensorEvent();
    private List bindingsList = new ArrayList();
    private SensorBinding[] bindings = new SensorBinding[0];
    private boolean listsDirty = false;

    public SensorEventAgent(Object source) {
        this.source = source;
    }

    private SensorBinding getSensorBinding(Sensor sensor) {
        int i = 0;
        while (i < this.bindingsList.size()) {
            SensorBinding sb = (SensorBinding)this.bindingsList.get(i);
            if (sb.sensor == sensor) {
                return sb;
            }
            ++i;
        }
        return null;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, int button, SensorButtonListener buttonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (button >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + button + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        SensorButtonListener[] listeners = new SensorButtonListener[sb.buttons.length];
        listeners[button] = buttonListener;
        SensorButtonBinding sbb = new SensorButtonBinding(listeners, true);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, SensorButtonListener buttonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        SensorButtonListener[] listeners = new SensorButtonListener[sb.buttons.length];
        int i = 0;
        while (i < sb.buttons.length) {
            listeners[i] = buttonListener;
            ++i;
        }
        SensorButtonBinding sbb = new SensorButtonBinding(listeners, true);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListeners(Sensor sensor, SensorButtonListener[] buttonListeners) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        if (sb.buttons.length != buttonListeners.length) {
            throw new IllegalArgumentException("\nbuttonListeners length " + buttonListeners.length + " must equal sensor button count " + sb.buttons.length);
        }
        SensorButtonBinding sbb = new SensorButtonBinding(buttonListeners, false);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public SensorButtonListener[] getSensorButtonListeners(Sensor sensor, int button) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (button >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + button + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return null;
        }
        ArrayList<SensorButtonListener> listeners = new ArrayList<SensorButtonListener>();
        int i = 0;
        while (i < sb.buttonBindingsList.size()) {
            SensorButtonBinding sbb = (SensorButtonBinding)sb.buttonBindingsList.get(i);
            if (sbb.listeners[button] != null) {
                listeners.add(sbb.listeners[button]);
            }
            ++i;
        }
        if (listeners.size() == 0) {
            return null;
        }
        return listeners.toArray(new SensorButtonListener[listeners.size()]);
    }

    private void removeSensorButtonListener(SensorBinding sb, SensorButtonListener listener) {
        Iterator i = sb.buttonBindingsList.iterator();
        while (i.hasNext()) {
            int instanceCount = 0;
            SensorButtonBinding sbb = (SensorButtonBinding)i.next();
            int j = 0;
            while (j < sbb.listeners.length) {
                if (sbb.listeners[j] == listener) {
                    sbb.listeners[j] = null;
                } else if (sbb.listeners[j] != null) {
                    ++instanceCount;
                }
                ++j;
            }
            if (instanceCount != 0) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(Sensor sensor, SensorButtonListener listener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return;
        }
        this.removeSensorButtonListener(sb, listener);
        if (sb.buttonBindingsList.size() == 0 && sb.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(SensorButtonListener listener) {
        Iterator i = this.bindingsList.iterator();
        while (i.hasNext()) {
            SensorBinding sb = (SensorBinding)i.next();
            this.removeSensorButtonListener(sb, listener);
            if (sb.buttonBindingsList.size() != 0 || sb.readBindingsList.size() != 0) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void addSensorReadListener(Sensor sensor, SensorReadListener readListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        sb.readBindingsList.add(readListener);
        this.listsDirty = true;
    }

    public SensorReadListener[] getSensorReadListeners(Sensor sensor) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return null;
        }
        if (sb.readBindingsList.size() == 0) {
            return null;
        }
        return sb.readBindingsList.toArray(new SensorReadListener[sb.readBindingsList.size()]);
    }

    private void removeSensorReadListener(SensorBinding sb, SensorReadListener listener) {
        Iterator i = sb.readBindingsList.iterator();
        while (i.hasNext()) {
            if ((SensorReadListener)i.next() != listener) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(Sensor sensor, SensorReadListener listener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return;
        }
        this.removeSensorReadListener(sb, listener);
        if (sb.buttonBindingsList.size() == 0 && sb.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(SensorReadListener listener) {
        Iterator i = this.bindingsList.iterator();
        while (i.hasNext()) {
            SensorBinding sb = (SensorBinding)i.next();
            this.removeSensorReadListener(sb, listener);
            if (sb.buttonBindingsList.size() != 0 || sb.readBindingsList.size() != 0) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorBinding(Sensor sensor) {
        Iterator i = this.bindingsList.iterator();
        while (i.hasNext()) {
            SensorBinding sb = (SensorBinding)i.next();
            if (sb.sensor != sensor) continue;
            i.remove();
            break;
        }
        this.listsDirty = true;
    }

    public Sensor[] getSensors() {
        if (this.bindingsList.size() == 0) {
            return null;
        }
        Sensor[] s = new Sensor[this.bindingsList.size()];
        int i = 0;
        while (i < this.bindingsList.size()) {
            s[i] = ((SensorBinding)this.bindingsList.get((int)i)).sensor;
            ++i;
        }
        return s;
    }

    private synchronized void updateArrays() {
        this.bindings = this.bindingsList.toArray(new SensorBinding[this.bindingsList.size()]);
        int i = 0;
        while (i < this.bindings.length) {
            this.bindings[i].updateArrays();
            ++i;
        }
    }

    public void dispatchEvents() {
        long t1 = this.t0;
        this.t0 = J3DTimer.getValue();
        if (this.listsDirty) {
            this.updateArrays();
            this.listsDirty = false;
        }
        int k = 0;
        while (k < this.bindings.length) {
            SensorBinding sb = this.bindings[k];
            Sensor s = sb.sensor;
            Transform3D read = sb.read;
            int[] buttons = sb.buttons;
            int dragButton = 0;
            boolean callReadListeners = true;
            boolean callDraggedListener = false;
            s.getRead(read);
            s.lastButtons(buttons);
            int j = 0;
            while (j < sb.buttonBindings.length) {
                SensorButtonBinding sbb = sb.buttonBindings[j];
                int i = 0;
                while (i < buttons.length) {
                    if (sbb.listeners[i] != null) {
                        if (sbb.prevButtons[i]) {
                            if (buttons[i] == 0) {
                                this.e.set(this.source, 2, s, read, buttons, i, this.t0, t1);
                                sbb.listeners[i].released(this.e);
                                sbb.prevButtons[i] = false;
                                --sbb.buttonsHandled;
                            } else {
                                callDraggedListener = true;
                                dragButton = i;
                            }
                            callReadListeners = false;
                        } else if (buttons[i] == 1 && (sbb.buttonsHandled == 0 || sbb.multiButton)) {
                            this.e.set(this.source, 1, s, read, buttons, i, this.t0, t1);
                            sbb.listeners[i].pressed(this.e);
                            sbb.prevButtons[i] = true;
                            ++sbb.buttonsHandled;
                            callReadListeners = false;
                        }
                    }
                    ++i;
                }
                if (callDraggedListener) {
                    this.e.set(this.source, 3, s, read, buttons, -1, this.t0, t1);
                    sbb.listeners[dragButton].dragged(this.e);
                }
                ++j;
            }
            if (callReadListeners) {
                this.e.set(this.source, 4, s, read, buttons, -1, this.t0, t1);
                int r = 0;
                while (r < sb.readBindings.length) {
                    sb.readBindings[r].read(this.e);
                    ++r;
                }
            }
            ++k;
        }
    }

    public String toString() {
        String s = "SensorEventAgent@" + Integer.toHexString(this.hashCode());
        s = String.valueOf(s) + "\nsensor bindings:\n\n";
        int i = 0;
        while (i < this.bindingsList.size()) {
            s = String.valueOf(s) + ((SensorBinding)this.bindingsList.get(i)).toString() + "\n";
            ++i;
        }
        return s;
    }

    private static class SensorBinding {
        Sensor sensor = null;
        int[] buttons = null;
        Transform3D read = null;
        List buttonBindingsList = new ArrayList();
        SensorButtonBinding[] buttonBindings = new SensorButtonBinding[0];
        List readBindingsList = new ArrayList();
        SensorReadListener[] readBindings = new SensorReadListener[0];

        SensorBinding(Sensor sensor) {
            this.sensor = sensor;
            this.buttons = new int[sensor.getSensorButtonCount()];
            this.read = new Transform3D();
        }

        void updateArrays() {
            this.buttonBindings = this.buttonBindingsList.toArray(new SensorButtonBinding[this.buttonBindingsList.size()]);
            this.readBindings = this.readBindingsList.toArray(new SensorReadListener[this.readBindingsList.size()]);
        }

        public String toString() {
            String s = new String();
            s = "sensor " + this.sensor + "\nbutton listener arrays:\n";
            int i = 0;
            while (i < this.buttonBindingsList.size()) {
                s = String.valueOf(s) + (SensorButtonBinding)this.buttonBindingsList.get(i);
                ++i;
            }
            s = String.valueOf(s) + "read listeners:\n";
            i = 0;
            while (i < this.readBindingsList.size()) {
                s = String.valueOf(s) + "  " + (SensorReadListener)this.readBindingsList.get(i) + "\n";
                ++i;
            }
            return s;
        }
    }

    private static class SensorButtonBinding {
        int buttonsHandled = 0;
        boolean[] prevButtons = null;
        boolean multiButton = false;
        SensorButtonListener[] listeners = null;

        SensorButtonBinding(SensorButtonListener[] listeners, boolean multiButtonEnable) {
            this.prevButtons = new boolean[listeners.length];
            this.listeners = new SensorButtonListener[listeners.length];
            int i = 0;
            while (i < listeners.length) {
                this.prevButtons[i] = false;
                this.listeners[i] = listeners[i];
                ++i;
            }
            this.multiButton = multiButtonEnable;
        }

        public String toString() {
            String s = new String();
            s = "  length " + this.listeners.length + ", mutual exclusion " + !this.multiButton + "\n";
            int i = 0;
            while (i < this.listeners.length) {
                s = String.valueOf(s) + "    " + (this.listeners[i] == null ? "null" : this.listeners[i].toString()) + "\n";
                ++i;
            }
            return s;
        }
    }
}

