/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import test.common.LocaleSwitcher;
import test.common.LookAndFeelSwitcher;
import test.svg.transcoded.edit_paste;

public class TestCommandToggleButtons
extends JFrame {
    protected ResourceBundle resourceBundle;
    protected Locale currLocale;
    private JPanel buttonPanel;

    public TestCommandToggleButtons() {
        super("Command button test");
        this.setIconImage(new BufferedImage(1, 1, 2));
        this.setLayout(new BorderLayout());
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", this.currLocale);
        this.buttonPanel = this.getButtonPanel();
        this.add((Component)this.buttonPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        this.configureControlPanel(controlPanel);
        this.add((Component)controlPanel, "South");
    }

    private JPanel getButtonPanel() {
        FormLayout lm = new FormLayout("right:pref, 10dlu, center:pref, 4dlu, center:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm);
        builder.setDefaultDialogBorder();
        builder.append("");
        builder.append("Short text");
        builder.append("Long text");
        this.addButtons(builder, CommandButtonDisplayState.BIG);
        this.addButtons(builder, CommandButtonDisplayState.TILE);
        this.addButtons(builder, CommandButtonDisplayState.MEDIUM);
        this.addButtons(builder, CommandButtonDisplayState.SMALL);
        JPanel buttonsPanel = builder.getPanel();
        return buttonsPanel;
    }

    protected static String stamp() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    private void addButtons(DefaultFormBuilder builder, CommandButtonDisplayState state) {
        builder.append(state.getDisplayName() + " state");
        JCommandToggleButton buttonWithShortText = this.createToggleButton(state, this.resourceBundle.getString("Short.text"));
        builder.append((Component)buttonWithShortText);
        JCommandToggleButton buttonWithLongText = this.createToggleButton(state, this.resourceBundle.getString("LongerLines.text"));
        builder.append((Component)buttonWithLongText);
    }

    protected JCommandToggleButton createToggleButton(CommandButtonDisplayState state, String title) {
        final JCommandToggleButton mainButton = new JCommandToggleButton(title, new edit_paste());
        mainButton.setDisabledIcon(new FilteredResizableIcon(new edit_paste(), new ColorConvertOp(ColorSpace.getInstance(1003), null)));
        mainButton.setExtraText(this.resourceBundle.getString("SelectAll.textExtra"));
        mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandToggleButtons.stamp() + ": button activated, selection state is " + mainButton.getActionModel().isSelected());
            }
        });
        mainButton.setDisplayState(state);
        mainButton.setFlat(false);
        return mainButton;
    }

    protected void configureControlPanel(JPanel controlPanel) {
        controlPanel.add(LookAndFeelSwitcher.getLookAndFeelSwitcher(this));
        final JCheckBox enabled = new JCheckBox("enabled");
        enabled.setSelected(true);
        enabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandToggleButtons.this);
                        TestCommandToggleButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandToggleButton) {
                                child.setEnabled(enabled.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(enabled);
        final JCheckBox actionEnabled = new JCheckBox("action enabled");
        actionEnabled.setSelected(true);
        actionEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandToggleButtons.this);
                        TestCommandToggleButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandToggleButton) {
                                ((JCommandToggleButton)child).getActionModel().setEnabled(actionEnabled.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(actionEnabled);
        final JCheckBox actionOnPress = new JCheckBox("action on press");
        actionOnPress.setSelected(false);
        actionOnPress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandToggleButtons.this);
                        TestCommandToggleButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandToggleButton) {
                                ((JCommandToggleButton)child).getActionModel().setFireActionOnPress(actionOnPress.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(actionOnPress);
        final JCheckBox flat = new JCheckBox("flat");
        flat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandToggleButtons.this);
                        TestCommandToggleButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        for (int i = 0; i < c.getComponentCount(); ++i) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandToggleButton) {
                                ((JCommandToggleButton)child).setFlat(flat.isSelected());
                            }
                            if (!(child instanceof Container)) continue;
                            this.scan((Container)child);
                        }
                    }
                });
            }
        });
        controlPanel.add(flat);
        JComboBox localeSwitcher = LocaleSwitcher.getLocaleSwitcher(new LocaleSwitcher.LocaleCallback(){

            @Override
            public void onLocaleSelected(Locale selected) {
                TestCommandToggleButtons.this.currLocale = selected;
                TestCommandToggleButtons.this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", TestCommandToggleButtons.this.currLocale);
                TestCommandToggleButtons.this.remove(TestCommandToggleButtons.this.buttonPanel);
                TestCommandToggleButtons.this.buttonPanel = TestCommandToggleButtons.this.getButtonPanel();
                TestCommandToggleButtons.this.add((Component)TestCommandToggleButtons.this.buttonPanel, "Center");
                Window window = SwingUtilities.getWindowAncestor(TestCommandToggleButtons.this.buttonPanel);
                window.applyComponentOrientation(ComponentOrientation.getOrientation(TestCommandToggleButtons.this.currLocale));
                SwingUtilities.updateComponentTreeUI(window);
            }
        });
        controlPanel.add(localeSwitcher);
    }

    public static void main(String[] args) {
        UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        UIManager.installLookAndFeel("JGoodies PlasticXP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
        UIManager.installLookAndFeel("Synthetica base", "de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackMoon", "de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackStar", "de.javasoft.plaf.synthetica.SyntheticaBlackStarLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueIce", "de.javasoft.plaf.synthetica.SyntheticaBlueIceLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueMoon", "de.javasoft.plaf.synthetica.SyntheticaBlueMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueSteel", "de.javasoft.plaf.synthetica.SyntheticaBlueSteelLookAndFeel");
        UIManager.installLookAndFeel("Synthetica GreenDream", "de.javasoft.plaf.synthetica.SyntheticaGreenDreamLookAndFeel");
        UIManager.installLookAndFeel("Synthetica MauveMetallic", "de.javasoft.plaf.synthetica.SyntheticaMauveMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica OrangeMetallic", "de.javasoft.plaf.synthetica.SyntheticaOrangeMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SkyMetallic", "de.javasoft.plaf.synthetica.SyntheticaSkyMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SilverMoon", "de.javasoft.plaf.synthetica.SyntheticaSilverMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica WhiteVision", "de.javasoft.plaf.synthetica.SyntheticaWhiteVisionLookAndFeel");
        UIManager.installLookAndFeel("A03", "a03.swing.plaf.A03LookAndFeel");
        UIManager.installLookAndFeel("Liquid", "com.birosoft.liquid.LiquidLookAndFeel");
        UIManager.installLookAndFeel("Napkin", "net.sourceforge.napkinlaf.NapkinLookAndFeel");
        UIManager.installLookAndFeel("Pagosoft", "com.pagosoft.plaf.PgsLookAndFeel");
        UIManager.installLookAndFeel("Squareness", "net.beeger.squareness.SquarenessLookAndFeel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception e) {
                    // empty catch block
                }
                TestCommandToggleButtons frame = new TestCommandToggleButtons();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }
}

