/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import test.common.TestCommandButtons;
import test.svg.transcoded.edit_paste;

public class TestCommandButtonsNoIcon
extends TestCommandButtons {
    @Override
    protected JCommandButton createActionButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(this.resourceBundle.getString("Paste.text"));
        result.setExtraText(this.resourceBundle.getString("Paste.textExtra"));
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Main paste");
            }
        });
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        result.setDisplayState(state);
        result.setFlat(false);
        return result;
    }

    @Override
    protected JCommandButton createActionAndPopupMainActionButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(this.resourceBundle.getString("Cut.text"));
        result.setExtraText(this.resourceBundle.getString("Cut.textExtra"));
        result.setPopupCallback(new TestCommandButtons.TestPopupCallback());
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        result.setDisplayState(state);
        result.setFlat(false);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Cut");
            }
        });
        return result;
    }

    @Override
    protected JCommandButton createActionAndPopupMainPopupButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(this.resourceBundle.getString("Copy.text"));
        result.setExtraText(this.resourceBundle.getString("Copy.textExtra"));
        result.setPopupCallback(new TestCommandButtons.TestPopupCallback());
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        result.setDisplayState(state);
        result.setFlat(false);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(TestCommandButtons.stamp() + ": Copy");
            }
        });
        return result;
    }

    @Override
    protected JCommandButton createPopupButton(CommandButtonDisplayState state) {
        JCommandButton result = new JCommandButton(this.resourceBundle.getString("SelectAll.text"));
        result.setExtraText(this.resourceBundle.getString("SelectAll.textExtra"));
        result.setPopupCallback(new TestCommandButtons.TestPopupCallback());
        result.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        result.setDisplayState(state);
        result.setFlat(false);
        return result;
    }

    @Override
    protected void configureControlPanel(JPanel controlPanel) {
        super.configureControlPanel(controlPanel);
        final JCheckBox noIcon = new JCheckBox("no icon");
        noIcon.setSelected(true);
        noIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TestCommandButtonsNoIcon.apply(TestCommandButtonsNoIcon.this, new Command(){

                            @Override
                            public void apply(JCommandButton button) {
                                button.setIcon(noIcon.isSelected() ? null : new edit_paste());
                            }
                        });
                        TestCommandButtonsNoIcon.this.getContentPane().invalidate();
                        TestCommandButtonsNoIcon.this.getContentPane().validate();
                    }
                });
            }
        });
        controlPanel.add(noIcon);
    }

    private static void apply(Container cont, Command cmd) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component comp = cont.getComponent(i);
            if (comp instanceof JCommandButton) {
                JCommandButton cb = (JCommandButton)comp;
                cmd.apply(cb);
            }
            if (!(comp instanceof Container)) continue;
            TestCommandButtonsNoIcon.apply((Container)comp, cmd);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception e) {
                    // empty catch block
                }
                TestCommandButtonsNoIcon frame = new TestCommandButtonsNoIcon();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static interface Command {
        public void apply(JCommandButton var1);
    }
}

