/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.util.exchange.importer.glycontainer2glycan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.linkage.Bond;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.glycontainer2glycan.Edge2Bond;
import org.glycoinfo.application.glycanbuilder.util.exchange.importer.glycontainer2glycan.NodeAnalyzer;

public class EdgeAnalyzer {
    private final HashMap<Node, Residue> residue2node;

    public EdgeAnalyzer(HashMap<Node, Residue> _residue2node) {
        this.residue2node = _residue2node;
    }

    public void start(Node _acceptor) throws Exception {
        Residue acceptor = this.residue2node.get(_acceptor);
        Edge2Bond edge2Bond = new Edge2Bond();
        NodeAnalyzer nodeAnalyzer = new NodeAnalyzer();
        _acceptor = nodeAnalyzer.start(_acceptor, acceptor);
        for (Edge edge : _acceptor.getChildEdges()) {
            Residue donor = this.residue2node.get(edge.getChild());
            Substituent sub = null;
            if (edge.getSubstituent() != null) {
                sub = (Substituent)edge.getSubstituent();
            }
            if (sub != null) {
                if (sub.getSubstituent() instanceof BaseSubstituentTemplate) {
                    Residue donorSub = this.makeSubstituent(sub);
                    ArrayList<Bond> bonds = edge2Bond.startForNormalLinkage(edge);
                    acceptor.addChild(donorSub, bonds);
                    donorSub.getParentLinkage().setChildLinkageType(LinkageType.UNVALIDATED);
                    donorSub.getParentLinkage().setParentLinkageType(LinkageType.UNVALIDATED);
                }
                if (sub instanceof GlycanRepeatModification) {
                    this.makeRepeatingUnit(edge, sub, acceptor, donor);
                    continue;
                }
                if (!(sub.getSubstituent() instanceof BaseCrossLinkedTemplate)) continue;
                if (edge.getChild() != null) {
                    donor = this.residue2node.get(edge.getChild());
                    acceptor = this.residue2node.get(edge.getParent());
                    this.makeCrossLinkedSubstituent(donor, this.makeSubstituent(sub), acceptor, edge2Bond.startForBridgeLinkage(edge));
                    continue;
                }
                this.makeCyclicSubstituent(acceptor, this.makeSubstituent(sub), edge2Bond.startForCyclicSubLinkage(edge));
                continue;
            }
            if (edge.getChild() == null) continue;
            ArrayList<Bond> bonds = edge2Bond.startForNormalLinkage(edge);
            acceptor.addChild(donor, bonds);
            donor.getParentLinkage().setChildLinkageType(LinkageType.UNVALIDATED);
            donor.getParentLinkage().setParentLinkageType(LinkageType.UNVALIDATED);
        }
    }

    private void makeRepeatingUnit(Edge _edge, Substituent _sub, Residue _acceptor, Residue _donor) throws Exception {
        Edge2Bond edge2Bond = new Edge2Bond();
        GlycanRepeatModification repMod = (GlycanRepeatModification)_edge.getSubstituent();
        ArrayList<Bond> bonds = edge2Bond.startForNormalLinkage(_edge);
        Residue startRep = null;
        Residue endRep = null;
        if (_edge.isRepeat()) {
            startRep = new Residue(ResidueType.createStartRepetition());
            endRep = new Residue(ResidueType.createEndRepetition());
        }
        if (_edge.isCyclic()) {
            startRep = new Residue(ResidueType.createStartCyclic());
            endRep = new Residue(ResidueType.createEndCyclic());
        }
        endRep.setMaxRepetitions(String.valueOf(repMod.getMaxRepeatCount()));
        endRep.setMinRepetitions(String.valueOf(repMod.getMinRepeatCount()));
        if (_sub.getSubstituent() != null) {
            Residue bridge = this.makeSubstituent(_sub);
            this.makeCrossLinkedSubstituent(_acceptor, bridge, startRep, edge2Bond.startForBridgeLinkage(_edge));
        }
        _acceptor.setEndRepitionResidue(endRep);
        _acceptor.addChild(endRep, bonds);
        _donor.setStartRepetiionResidue(startRep);
        startRep.addChild(_donor, bonds);
    }

    private Residue makeSubstituent(Node _node) throws Exception {
        Substituent sub = (Substituent)_node;
        Residue residue = ResidueDictionary.newResidue(sub.getSubstituent().getIUPACnotation());
        return residue;
    }

    private void makeCyclicSubstituent(Residue _acceptor, Residue _sub, ArrayList<char[]> _bonds) {
        _acceptor.addChild(_sub);
        Linkage toCyclic = new Linkage(_acceptor, _sub, _bonds.get(2), _bonds.get(1), _bonds.get(0)[0]);
        _sub.setParentLinkage(toCyclic);
    }

    private void makeCrossLinkedSubstituent(Residue _donor, Residue _bridge, Residue _acceptor, ArrayList<ArrayList<Bond>> _bonds) {
        _acceptor.addChild(_bridge);
        _bridge.addChild(_donor);
        Linkage toBridge = new Linkage(_acceptor, _bridge, (Collection<Bond>)_bonds.get(0));
        Linkage toMonosaccharide = new Linkage(_bridge, _donor, (Collection<Bond>)_bonds.get(1));
        _donor.setParentLinkage(toMonosaccharide);
        _bridge.setParentLinkage(toBridge);
    }
}

