/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.application.glycanbuilder.util.exchange.exporter;

import java.util.Collection;
import java.util.LinkedList;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.glycoinfo.WURCSFramework.util.property.AtomicProperties;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.application.glycanbuilder.util.exchange.exporter.ResidueAnalyzer;
import org.glycoinfo.application.glycanbuilder.util.exchange.exporter.ResidueToModification;

public class ResidueToBackbone {
    private Backbone backbone;
    private char anomSymbol = (char)63;
    private int anomPosition = 0;
    private char configuration = (char)63;
    private Residue residue;
    private boolean a_bIsRootOfFragment = false;
    private LinkedList<Modification> unknownModPos = new LinkedList();

    public Residue getResidue() {
        return this.residue;
    }

    public Backbone getBackbone() {
        return this.backbone;
    }

    public LinkedList<Modification> getCoreModifications() {
        return this.unknownModPos;
    }

    public void setRootOfFramgents() {
        this.a_bIsRootOfFragment = true;
    }

    public void start(Residue _residue) throws Exception {
        int carbon;
        if (_residue.getType().getSuperclass().equals("Unknown")) {
            throw new Exception(_residue.getTypeName() + " can not be converted to SkeletonCode.");
        }
        this.residue = _residue;
        this.anomPosition = this.checkAnomericSymbolCharactor(_residue.getAnomericCarbon());
        this.anomSymbol = (char)(_residue.isAldehyde() || _residue.isAlditol() ? 111 : (int)_residue.getAnomericState());
        this.configuration = _residue.getChirality();
        String classNotation = _residue.getType().getCompositionClass().equals("Sugar") ? "sug" : _residue.getType().getCompositionClass();
        Superclass superClass = Superclass.forName(classNotation.toLowerCase());
        if (_residue.getType().getName().equals("Assigned")) {
            superClass = Superclass.SUG;
        }
        if ((carbon = superClass.getCAtomCount()) == 0) {
            this.backbone = new Backbone();
            this.backbone.setAnomericSymbol(this.anomSymbol);
            return;
        }
        ResidueAnalyzer residueAnalyzer = new ResidueAnalyzer();
        residueAnalyzer.ResidueToSkeletonCode(_residue);
        this.anomPosition = residueAnalyzer.getAnomericPosition();
        this.anomSymbol = residueAnalyzer.getAnomericSymbol();
        this.configuration = residueAnalyzer.getConfiguration();
        String skeletonCode = residueAnalyzer.getSkeletonCode();
        for (String string : residueAnalyzer.getUnknownMAPs()) {
            this.unknownModPos.add(new Modification(string));
        }
        if (this.anomPosition == 0 && this.anomSymbol == '?') {
            if (!this.hasParent()) {
                if (!_residue.isAldehyde() && !_residue.isAlditol()) {
                    skeletonCode = skeletonCode.replaceAll("o", "u");
                    skeletonCode = skeletonCode.replaceAll("O", "U");
                }
            } else if (!(this.hasParent() && _residue.getParent().getType().getSuperclass().equals("Bridge") || _residue.isAldehyde())) {
                if (skeletonCode.contains("o")) {
                    this.anomPosition = skeletonCode.indexOf("o") + 1;
                    skeletonCode = skeletonCode.replaceFirst("o", "a");
                } else if (skeletonCode.contains("O")) {
                    this.anomPosition = skeletonCode.indexOf("O") + 1;
                    skeletonCode = skeletonCode.replaceFirst("O", "a");
                }
            }
        }
        StringBuilder scNotation = new StringBuilder(skeletonCode);
        if (_residue.getParentLinkage() != null) {
            this.replaceCarbonDescriptorByLinkage(scNotation, _residue.getParentLinkage(), true);
        }
        for (Linkage linkage : _residue.getChildrenLinkages()) {
            this.replaceCarbonDescriptorByLinkage(scNotation, linkage, false);
        }
        Backbone backbone = new Backbone();
        backbone.setAnomericPosition(this.anomPosition);
        backbone.setAnomericSymbol(this.anomSymbol);
        for (int i = 0; i < carbon; ++i) {
            char carbonDescriptor = scNotation.charAt(i);
            CarbonDescriptor carbonDescriptor_tbd = CarbonDescriptor.forCharacter(carbonDescriptor, i == 0 || i == carbon - 1);
            BackboneCarbon _backboneCarbon = new BackboneCarbon(backbone, carbonDescriptor_tbd);
            backbone.addBackboneCarbon(_backboneCarbon);
        }
        this.backbone = backbone;
    }

    private void replaceCarbonDescriptorByLinkage(StringBuilder _scNotation, Linkage _linkage, boolean _isParent) throws Exception {
        char a_cAnomStereo;
        LinkageType type1;
        char cd;
        int pos;
        Residue residue = _isParent ? _linkage.getParentResidue() : _linkage.getChildResidue();
        Residue substituent = residue.isSubstituent() ? residue : null;
        boolean isSwap = false;
        Collection<Character> positions = _linkage.getParentPositions();
        if (positions.size() > 1) {
            return;
        }
        isSwap = this.compareConnectAtom(_linkage, substituent, _isParent) < 0;
        Linkage parentLink = _linkage;
        if (_linkage.getParentResidue().isRepetition()) {
            parentLink = _linkage.getParentResidue().getParentLinkage();
        }
        int n = pos = positions.iterator().next().charValue() == '?' ? -1 : Integer.parseInt(String.valueOf(positions.iterator().next()));
        if (pos == -1) {
            return;
        }
        char newCD = cd = _scNotation.charAt(pos - 1);
        LinkageType type0 = _isParent ? _linkage.getChildLinkageType() : parentLink.getParentLinkageType();
        LinkageType linkageType = type1 = _isParent ? parentLink.getParentLinkageType() : _linkage.getChildLinkageType();
        if (type0 == LinkageType.H_LOSE) {
            newCD = this.replaceCarbonDescriptorByHydrogenLose(cd, isSwap);
        } else if (type0 == LinkageType.DEOXY && type1 != LinkageType.H_AT_OH) {
            newCD = cd == 'c' ? (char)'x' : (cd == 'C' ? (char)'X' : newCD);
        }
        _scNotation.replace(pos - 1, pos, newCD + "");
        if (!_isParent) {
            return;
        }
        if (this.anomPosition == 0 || this.anomPosition == -1) {
            return;
        }
        if (this.anomSymbol != 'a' || this.anomSymbol != 'b') {
            return;
        }
        char a_cAnomCD = _scNotation.charAt(this.anomPosition - 1);
        if (a_cAnomCD == 'x' || a_cAnomCD == 'X') {
            return;
        }
        char c = a_cAnomStereo = this.anomSymbol == 'a' ? (char)'1' : '2';
        if (this.configuration == 'L') {
            char c2 = a_cAnomStereo = a_cAnomStereo == '1' ? (char)'2' : '1';
        }
        if (isSwap) {
            char c3 = a_cAnomStereo = a_cAnomStereo == '1' ? (char)'2' : '1';
        }
        if (a_cAnomCD == 'X') {
            a_cAnomStereo = a_cAnomStereo == '1' ? (char)'5' : '6';
        }
        _scNotation.replace(this.anomPosition - 1, this.anomPosition, a_cAnomStereo + "");
    }

    private char replaceCarbonDescriptorByHydrogenLose(char _carbonDescriptor, boolean _isSwap) {
        int newCarbonDescriptor;
        int n = _carbonDescriptor == '1' ? 53 : (_carbonDescriptor == '2' ? 54 : (_carbonDescriptor == '3' ? 55 : (_carbonDescriptor == '4' ? 56 : (_carbonDescriptor == 'x' ? 88 : (_carbonDescriptor == 'C' ? 67 : (_carbonDescriptor == 'm' ? 104 : (newCarbonDescriptor = _carbonDescriptor == 'h' ? 99 : (int)_carbonDescriptor)))))));
        if (_isSwap) {
            newCarbonDescriptor = newCarbonDescriptor == 53 ? 54 : (newCarbonDescriptor == 54 ? 53 : (newCarbonDescriptor == 55 ? 56 : (newCarbonDescriptor == 56 ? 55 : newCarbonDescriptor)));
        }
        return (char)newCarbonDescriptor;
    }

    private int compareConnectAtom(Linkage _linkage, Residue _substituent, boolean _isParent) throws Exception {
        LinkageType childLinkType;
        LinkageType parentLinkType = _isParent ? _linkage.getChildLinkageType() : _linkage.getParentLinkageType();
        LinkageType linkageType = childLinkType = _isParent ? _linkage.getParentLinkageType() : _linkage.getChildLinkageType();
        if (parentLinkType == LinkageType.H_AT_OH || childLinkType == LinkageType.H_AT_OH) {
            return 0;
        }
        if (_substituent == null) {
            return 0;
        }
        return this.compareConnectAtomOfSubstituent(_substituent, _isParent);
    }

    private int compareConnectAtomOfSubstituent(Residue _substituent, boolean _isParent) throws Exception {
        ResidueToModification res2mod = new ResidueToModification();
        res2mod.setSubstituentTemplate(_substituent);
        res2mod.start(_substituent);
        String a_sConnAtom = _isParent ? res2mod.getTailAtom() : res2mod.getHeadAtom();
        int a_iNumberOfFirstAtom = AtomicProperties.forSymbol(a_sConnAtom).getAtomicNumber();
        if (a_iNumberOfFirstAtom > 16) {
            return 1;
        }
        return -1;
    }

    private int checkAnomericSymbolCharactor(char _anomericPosition) {
        if (_anomericPosition == '?') {
            return 0;
        }
        return Integer.parseInt(String.valueOf(_anomericPosition));
    }

    private boolean hasParent() {
        return this.residue.getParent() != null && !this.residue.getParent().isReducingEnd() && !this.residue.isComposition();
    }
}

