/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.oldUtil;

import java.util.ArrayList;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.array.WURCSImporter;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.glycoinfo.WURCSFramework.util.oldUtil.SubstituentAnalyzer;
import org.glycoinfo.WURCSFramework.util.residuecontainer.ResidueContainer;
import org.glycoinfo.WURCSFramework.util.residuecontainer.SuperClass;
import org.glycoinfo.WURCSFramework.util.subsumption.MSStateDeterminationUtility;
import org.glycoinfo.WURCSFramework.util.subsumption.WURCSSubsumptionConverter;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.GRES;

public class GRESToResidueData {
    private WURCSSubsumptionConverter a_oWSC = new WURCSSubsumptionConverter();
    private MSStateDeterminationUtility a_oMSSDU = new MSStateDeterminationUtility();
    private SubstituentAnalyzer a_oSubAnalyze = new SubstituentAnalyzer();
    private ResidueContainer a_oRC;

    public ResidueContainer getResidueContainer() {
        return this.a_oRC;
    }

    public void start(GRES a_oGRES) throws WURCSFormatException, ConverterExchangeException {
        int a_iAnomericPosition = a_oGRES.getMS().getCoreStructure().getAnomericPosition();
        char a_cSymbol = a_oGRES.getMS().getCoreStructure().getAnomericSymbol();
        String a_sMS = a_oGRES.getMS().getString();
        String a_sSkeletonCode = a_oGRES.getMS().getCoreStructure().getSkeletonCode();
        MS a_oMS = new WURCSImporter().extractMS(a_sMS);
        if (a_sMS.contains("<Q>")) {
            this.a_oRC = new ResidueContainer("?", ' ', "sugar");
            this.a_oRC.setAnomerSymbol(a_cSymbol);
            this.a_oRC.setSubstituent(this.a_oSubAnalyze.getSubstituents(this.a_oRC, a_oGRES, a_oMS));
            return;
        }
        SuperClass a_enumSuperClass = SuperClass.getSize(a_oMS.getSkeletonCode().length());
        LinkedList<String> a_aStereos = this.a_oMSSDU.extractStereo(a_oMS);
        if (a_aStereos.isEmpty()) {
            a_aStereos = this.retryStereo(a_oMS);
        }
        ResidueContainer a_oRC = new ResidueContainer();
        a_oRC.setBackBoneSize(a_enumSuperClass.getSize());
        a_oRC.setRingSize(this.checkRingSize(a_oMS));
        for (String a_sStereo : a_aStereos) {
            String a_sConfiguration = this.defineDLcofiguration(a_sStereo);
            String a_sCoreName = this.defineNameOfMonosaccharide(a_sStereo, a_sConfiguration);
            a_oRC.addDLconfiguration(a_sConfiguration);
            a_oRC.addCommonName(a_sCoreName);
        }
        a_oRC.setAnomerPosition(a_iAnomericPosition);
        a_oRC.setAnomerSymbol(a_cSymbol);
        a_oRC.setSuperClass(a_enumSuperClass.getSuperClass());
        a_oRC.setAcidicSugar(this.isAcidicSugar(a_oMS));
        a_oRC.setModification(this.extractModification(a_oMS, a_oRC));
        a_oRC.setSubstituent(this.a_oSubAnalyze.getSubstituents(a_oRC, a_oGRES, a_oMS));
        a_oRC.setMotif(this.checkSuperClass(a_sSkeletonCode, a_oRC));
        a_oRC.setAlditol(this.isAnomerStatuswithAlcohol(a_oMS));
        a_oRC.setAldehydo(this.isAnomerStatuswithAldehydo(a_oMS));
        this.a_oRC = a_oRC;
    }

    private ArrayList<String> extractModification(MS a_oMS, ResidueContainer a_oRC) throws ConverterExchangeException {
        ArrayList<String> a_aModifications = new ArrayList<String>();
        char[] a_aSkeletonCode = a_oMS.getSkeletonCode().toCharArray();
        int a_iAnomericPosition = a_oMS.getAnomericPosition();
        for (int i = 0; i < a_aSkeletonCode.length; ++i) {
            if (String.valueOf(a_aSkeletonCode[i]).matches("\\d")) continue;
            if (a_aSkeletonCode[i] == 'e' || a_aSkeletonCode[i] == 'f' || a_aSkeletonCode[i] == 'z') {
                a_aModifications.add(i + 1 + "*d");
                if (!a_aModifications.contains(i + "*en")) {
                    a_aModifications.add(i + 1 + "*en");
                }
            }
            if (a_aSkeletonCode[i] == 'E' && a_aSkeletonCode[i + 1] == 'E' || a_aSkeletonCode[i] == 'F' && a_aSkeletonCode[i + 1] == 'F' || a_aSkeletonCode[i] == 'Z' && a_aSkeletonCode[i + 1] == 'Z') {
                a_aModifications.add(i + 1 + "*en");
            }
            if (a_iAnomericPosition == 2 && i == 1 && a_aSkeletonCode[i] == 'a') {
                a_aModifications.add(i + 1 + "*ulo");
            }
            if (i == 1 && a_aSkeletonCode[i] == 'U') {
                a_aModifications.add(i + 1 + "*ulo");
            }
            if (a_iAnomericPosition != i + 1 && a_aSkeletonCode[i] == 'O') {
                a_aModifications.add(i + 1 + "*ulo");
            }
            if (i == 0 && a_aSkeletonCode[i] == 'A') {
                a_oRC.setONIC(true);
                a_aModifications.add(i + 1 + "*a");
            }
            if (i + 1 == a_aSkeletonCode.length && a_aSkeletonCode[i] == 'A' && a_oRC.isAcidicSugar() && a_oRC.isONIC()) {
                a_oRC.setARIC(true);
                a_oRC.setAcidicSugar(false);
                a_aModifications.add(i + 1 + "*a");
            }
            if (a_aSkeletonCode[i] != 'd' && a_aSkeletonCode[i] != 'm') continue;
            a_aModifications.add(i + 1 + "*" + a_aSkeletonCode[i]);
        }
        return a_aModifications;
    }

    private boolean isAnomerStatuswithAlcohol(MS a_oMS) {
        if (a_oMS.getAnomericPosition() == 2) {
            return false;
        }
        if (a_oMS.getAnomericPosition() == 0 && a_oMS.getSkeletonCode().contains("U")) {
            return false;
        }
        String a_sSkeltonCode = a_oMS.getSkeletonCode();
        return a_sSkeltonCode.startsWith("h") && this.a_oWSC.convertCarbonylGroupToHydroxyl(a_oMS) == null;
    }

    private boolean isAnomerStatuswithAldehydo(MS a_oMS) {
        int a_iAnomericPosition = a_oMS.getAnomericPosition();
        if (a_oMS.getSkeletonCode().indexOf("o") == a_iAnomericPosition) {
            return true;
        }
        return a_oMS.getSkeletonCode().indexOf("O") == a_iAnomericPosition;
    }

    private LinkedList<String> retryStereo(MS a_oMS) throws ConverterExchangeException {
        LinkedList<String> a_aStereo = new LinkedList<String>();
        String a_sSkeletonCode = a_oMS.getSkeletonCode();
        SuperClass enum_class = SuperClass.getSize(a_oMS.getSkeletonCode().length());
        if (a_sSkeletonCode.contains("1") && a_sSkeletonCode.contains("2")) {
            for (String s : this.a_oMSSDU.extractStereo(this.a_oWSC.convertConfigurationUnknownToAbsolutes(a_oMS).getFirst())) {
                if (a_sSkeletonCode.endsWith("xh") && s.contains("gro")) {
                    a_aStereo.addLast(this.checkDLconfiguration(s));
                    continue;
                }
                a_aStereo.addLast(s);
            }
        }
        if (a_sSkeletonCode.contains("3") || a_sSkeletonCode.contains("4")) {
            a_aStereo = this.a_oMSSDU.extractStereo(this.a_oWSC.convertConfigurationRelativeToD(a_oMS));
        }
        if (a_aStereo.isEmpty()) {
            if (enum_class.getSuperClass().equals("Tet")) {
                throw new ConverterExchangeException(a_oMS.getSkeletonCode() + " could not handled");
            }
            if (enum_class.getSuperClass().equals("Tri")) {
                MS a_oGrose = this.a_oWSC.convertConfigurationUnknownToAbsolutes(a_oMS).getFirst();
                a_aStereo.add(this.checkDLconfiguration(this.a_oMSSDU.extractStereo(a_oGrose).getFirst()));
            } else {
                a_aStereo.add(enum_class.getSuperClass());
            }
        }
        return a_aStereo;
    }

    private boolean isAcidicSugar(MS a_oMS) {
        int a_iLength = a_oMS.getSkeletonCode().length();
        return a_iLength - 1 == a_oMS.getSkeletonCode().lastIndexOf("A");
    }

    private boolean checkSuperClass(String a_sSkeletonCode, ResidueContainer a_oRC) {
        boolean a_isMotif = false;
        if (SuperClass.getSuperClass(a_oRC.getCommonName().getFirst()) != null) {
            return a_isMotif;
        }
        char[] a_SC = a_sSkeletonCode.toCharArray();
        for (int i = 0; i < a_SC.length; ++i) {
            if (a_oRC.getAnomerPosition() != i && (a_SC[i] == 'o' || a_SC[i] == 'O')) {
                a_isMotif = true;
            }
            if (a_SC[i] == 'd') {
                a_isMotif = true;
            }
            if (a_SC[i] != 'e' && a_SC[i] != 'f' && a_SC[i] != 'z' && a_SC[i] != 'E' && a_SC[i] != 'F' && a_SC[i] != 'Z') continue;
            a_isMotif = true;
        }
        if (a_sSkeletonCode.length() > 6 && a_oRC.getCommonName().size() > 1) {
            a_isMotif = true;
        }
        return a_isMotif;
    }

    private String defineNameOfMonosaccharide(String a_sTrivialName, String a_sConfiguration) {
        if (a_sConfiguration.equals("?")) {
            if (a_sTrivialName.startsWith("d/l-")) {
                a_sTrivialName = a_sTrivialName.replaceFirst("d/l-", "");
            }
            if (a_sTrivialName.startsWith("l/d-")) {
                a_sTrivialName = a_sTrivialName.replaceFirst("l/d-", "");
            }
        } else {
            a_sTrivialName = a_sTrivialName.replaceFirst(a_sConfiguration, "");
        }
        String str_prefix = a_sTrivialName.substring(0, 1);
        a_sTrivialName = a_sTrivialName.replaceFirst(str_prefix, str_prefix.toUpperCase());
        return a_sTrivialName;
    }

    private String defineDLcofiguration(String a_sConfiguration) {
        String ret = "?";
        if (a_sConfiguration.startsWith("l") || a_sConfiguration.startsWith("d")) {
            ret = a_sConfiguration.substring(0, 1);
        }
        if (a_sConfiguration.contains("d/l") || a_sConfiguration.contains("l/d")) {
            ret = "?";
        }
        return ret;
    }

    private char checkRingSize(MS a_oMS) {
        if (a_oMS.getMODs().size() == 0 || a_oMS.getAnomericPosition() == 0) {
            return ' ';
        }
        int a_cRingSize = 32;
        MOD a_oRing = a_oMS.getMODs().getFirst();
        int a_iStart = a_oRing.getListOfLIPs().getFirst().getLIPs().getFirst().getBackbonePosition();
        int a_iEnd = a_oRing.getListOfLIPs().getLast().getLIPs().getFirst().getBackbonePosition();
        if (a_oMS.getAnomericPosition() == a_iStart) {
            if (a_iEnd == -1) {
                a_cRingSize = 63;
            }
            if (a_iEnd - a_iStart == 3) {
                a_cRingSize = 102;
            }
            if (a_iEnd - a_iStart == 4) {
                a_cRingSize = 112;
            }
        }
        return (char)a_cRingSize;
    }

    private String checkDLconfiguration(String a_sStereo) {
        if (a_sStereo.startsWith("l") || a_sStereo.startsWith("d")) {
            a_sStereo = a_sStereo.replaceFirst("[ld]", "");
        }
        return a_sStereo;
    }
}

