/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

public class SubstituentAlias
extends ResourcesDbObject {
    private GlycanNamescheme namescheme = null;
    private LinkageType linktype1 = null;
    private LinkageType linktype2 = null;
    private SubstituentTemplate primaryTemplate = null;
    private int substituentPosition1 = -1;
    private int substituentPosition2 = -1;
    private boolean isPrimary = false;
    private String residueIncludedName = null;
    private String separateDisplayName = null;
    private int dbId = 0;

    public SubstituentAlias(GlycanNamescheme scheme, LinkageType linktype, String inclName, String sepDispl, boolean primary) {
        this(scheme, linktype, null, inclName, sepDispl, primary, null);
    }

    public SubstituentAlias(GlycanNamescheme scheme, LinkageType linktype, LinkageType linktype2, String inclName, String sepDispl, boolean primary) {
        this(scheme, linktype, linktype2, inclName, sepDispl, primary, null);
        this.setNamescheme(scheme);
        this.setLinktype1(linktype);
        this.setLinktype2(linktype2);
        this.setResidueIncludedName(inclName);
        this.setSeparateDisplayName(sepDispl);
        this.setIsPrimary(primary);
    }

    public SubstituentAlias(GlycanNamescheme scheme, LinkageType linktype, LinkageType linktype2, String inclName, String sepDispl, boolean primary, TemplateContainer container) {
        this.setNamescheme(scheme);
        this.setLinktype1(linktype);
        this.setLinktype2(linktype2);
        this.setResidueIncludedName(inclName);
        this.setSeparateDisplayName(sepDispl);
        this.setIsPrimary(primary);
        this.setTemplateContainer(container);
    }

    public SubstituentAlias(TemplateContainer container) {
        this(null, null, null, null, null, false, container);
    }

    public SubstituentAlias() {
        this(null, null, null, null, null, false);
    }

    public GlycanNamescheme getNamescheme() {
        return this.namescheme;
    }

    public String getNameschemeStr() {
        if (this.getNamescheme() == null) {
            return null;
        }
        return this.getNamescheme().name();
    }

    public void setNameschemeStr(String name) {
        if (name == null) {
            this.setNamescheme(null);
        } else {
            this.setNamescheme(GlycanNamescheme.forName(name));
        }
    }

    public void setNamescheme(GlycanNamescheme scheme) {
        this.namescheme = scheme;
    }

    public LinkageType getLinktype1() {
        return this.linktype1;
    }

    public void setLinktype1(LinkageType link) {
        this.linktype1 = link;
    }

    public LinkageType getLinktype2() {
        return this.linktype2;
    }

    public void setLinktype2(LinkageType link2) {
        this.linktype2 = link2;
    }

    public String getLinktype1Str() {
        if (this.getLinktype1() == null) {
            return null;
        }
        return this.getLinktype1().name();
    }

    public void setLinktype1Str(String linktypeStr) {
        if (linktypeStr == null) {
            this.setLinktype1(null);
        } else {
            this.setLinktype1(SubstituentTemplate.getLinkageTypeByLinkageName(linktypeStr));
        }
    }

    public String getLinktype2Str() {
        if (this.getLinktype2() == null) {
            return null;
        }
        return this.getLinktype2().name();
    }

    public void setLinktypeStr2(String linktypeStr) {
        if (linktypeStr == null) {
            this.setLinktype2(null);
        } else {
            this.setLinktype2(SubstituentTemplate.getLinkageTypeByLinkageName(linktypeStr));
        }
    }

    public int getSubstituentPosition1() {
        return this.substituentPosition1;
    }

    public void setSubstituentPosition1(int substPosition1) {
        this.substituentPosition1 = substPosition1;
    }

    public int getSubstituentPosition2() {
        return this.substituentPosition2;
    }

    public void setSubstituentPosition2(int substPosition2) {
        this.substituentPosition2 = substPosition2;
    }

    public SubstituentTemplate getPrimaryTemplate() {
        return this.primaryTemplate;
    }

    public void setPrimaryTemplate(SubstituentTemplate primaryTemplate) {
        this.primaryTemplate = primaryTemplate;
    }

    public String getPrimaryTemplateName() {
        if (this.getPrimaryTemplate() == null) {
            return null;
        }
        return this.getPrimaryTemplate().getName();
    }

    public void setPrimaryTemplateName(String name) throws ResourcesDbException {
        this.setPrimaryTemplate(this.getTemplateContainer().getSubstituentTemplateContainer().forName(this.getNamescheme(), name));
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean getIsPrimary() {
        return this.isPrimary();
    }

    public void setIsPrimary(boolean primary) {
        this.isPrimary = primary;
    }

    public String getResidueIncludedName() {
        return this.residueIncludedName;
    }

    public void setResidueIncludedName(String residueInclName) {
        this.residueIncludedName = residueInclName;
    }

    public String getSeparateDisplayName() {
        return this.separateDisplayName;
    }

    public void setSeparateDisplayName(String seperateDisplName) {
        this.separateDisplayName = seperateDisplName;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public boolean isSplit() {
        return this.getResidueIncludedName() != null && this.getSeparateDisplayName() != null;
    }

    public String toString() {
        String outStr = String.valueOf(this.getNamescheme().getNameStr()) + "::" + this.getLinktype1Str() + "::" + this.getResidueIncludedName() + "/" + this.getSeparateDisplayName();
        if (this.isPrimary()) {
            outStr = String.valueOf(outStr) + " (primary)";
        }
        return outStr;
    }
}

