/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonosaccharideExchangeObject
extends ResourcesDbObject {
    private EcdbMonosaccharide basetype = null;
    private ArrayList<SubstituentExchangeObject> substituents = new ArrayList();
    private boolean orientationChanged = false;
    private String monosaccharideName = null;
    private GlycanNamescheme monosaccharideNamescheme = null;
    private ArrayList<ResidueTypes> residueType;
    private Double avgMass;
    private Double monoMass;

    public MonosaccharideExchangeObject(EcdbMonosaccharide basetype, ArrayList<SubstituentExchangeObject> substituents) {
        this(basetype, substituents, null, null);
    }

    public MonosaccharideExchangeObject(EcdbMonosaccharide basetype, ArrayList<SubstituentExchangeObject> substituents, Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.setBasetype(basetype);
        this.setSubstituents(substituents);
        this.setMonosaccharideName(null);
        this.setMonosaccharideNamescheme(null);
        this.setOrientationChanged(false);
        this.residueType = new ArrayList();
    }

    public MonosaccharideExchangeObject(String name, GlycanNamescheme scheme) {
        this(name, scheme, null, null);
    }

    public MonosaccharideExchangeObject(String name, GlycanNamescheme scheme, Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.setBasetype(null);
        this.setSubstituents(new ArrayList<SubstituentExchangeObject>());
        this.setMonosaccharideName(name);
        this.setMonosaccharideNamescheme(scheme);
        this.setOrientationChanged(false);
        this.residueType = new ArrayList();
    }

    public MonosaccharideExchangeObject() {
        this(Config.getGlobalConfig(), null);
    }

    public MonosaccharideExchangeObject(Config conf) {
        this((String)null, (GlycanNamescheme)null, conf, (TemplateContainer)null);
    }

    public MonosaccharideExchangeObject(Config conf, TemplateContainer container) {
        this((String)null, (GlycanNamescheme)null, conf, container);
    }

    public EcdbMonosaccharide getBasetype() {
        return this.basetype;
    }

    public void setBasetype(EcdbMonosaccharide basetype) {
        this.basetype = basetype;
    }

    public boolean isOrientationChanged() {
        return this.orientationChanged;
    }

    public void setOrientationChanged(boolean orientationChanged) {
        this.orientationChanged = orientationChanged;
    }

    public ArrayList<SubstituentExchangeObject> getSubstituents() {
        if (this.substituents == null) {
            this.setSubstituents(new ArrayList<SubstituentExchangeObject>());
        }
        return this.substituents;
    }

    public void setSubstituents(ArrayList<SubstituentExchangeObject> substituents) {
        this.substituents = substituents;
    }

    public void addSubstituent(SubstituentExchangeObject subst) {
        this.getSubstituents().add(subst);
    }

    public boolean hasSubstituentsInList() {
        return this.substituents != null && this.substituents.size() > 0;
    }

    public String getMonosaccharideName() {
        return this.monosaccharideName;
    }

    public void setMonosaccharideName(String monosaccharideName) {
        this.monosaccharideName = monosaccharideName;
    }

    public GlycanNamescheme getMonosaccharideNamescheme() {
        return this.monosaccharideNamescheme;
    }

    public void setMonosaccharideNamescheme(GlycanNamescheme monosaccharideNamescheme) {
        this.monosaccharideNamescheme = monosaccharideNamescheme;
    }

    public ArrayList<ResidueTypes> getResidueType() {
        if (this.residueType == null) {
            this.residueType = new ArrayList();
        }
        return this.residueType;
    }

    public void addResidueType(ResidueTypes residueType) {
        this.getResidueType().add(residueType);
    }

    public void clearResidueType() {
        this.residueType.clear();
    }

    public Double getAvgMass() {
        return this.avgMass;
    }

    public void setAvgMass(Double avgMass) {
        this.avgMass = avgMass;
    }

    public Double getMonoMass() {
        return this.monoMass;
    }

    public void setMonoMass(Double monoMass) {
        this.monoMass = monoMass;
    }

    public String toString() {
        String outStr = "MonosaccharideExchangeObject [";
        outStr = String.valueOf(outStr) + "Scheme:" + (Object)((Object)this.getMonosaccharideNamescheme());
        outStr = String.valueOf(outStr) + " Name:" + this.getMonosaccharideName();
        outStr = String.valueOf(outStr) + " residueType:" + this.getResidueType().toString();
        if (this.getSubstituents() != null && this.getSubstituents().size() > 0) {
            outStr = String.valueOf(outStr) + " subst:" + this.getSubstituents().toString();
        }
        outStr = String.valueOf(outStr) + " Mass (avg/mono): " + this.getAvgMass() + "/" + this.getMonoMass();
        outStr = String.valueOf(outStr) + "]";
        return outStr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResidueTypes {
        monosaccharide,
        substituent,
        aglycon;

    }
}

