/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExporter;
import org.eurocarbdb.resourcesdb.io.StandardExporter;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;
import org.eurocarbdb.resourcesdb.monosaccharide.BasetypeConversion;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycoCTExporter
extends StandardExporter
implements MonosaccharideExporter {
    private EcdbMonosaccharide eurocarbDbMs = null;
    private String substitutionStr = null;
    private String msGlycoCTstr = null;

    public GlycoCTExporter(GlycanNamescheme scheme) {
        super(scheme);
    }

    public GlycoCTExporter(GlycanNamescheme scheme, Config conf, TemplateContainer container) {
        super(scheme, conf, container);
    }

    public EcdbMonosaccharide getEurocarbDbMs() {
        return this.eurocarbDbMs;
    }

    public void setEurocarbDbMs(EcdbMonosaccharide eurocarbDbMs) {
        this.eurocarbDbMs = eurocarbDbMs;
    }

    public String getSubstitutionStr() {
        return this.substitutionStr;
    }

    public void setSubstitutionStr(String substitutionStr) {
        this.substitutionStr = substitutionStr;
    }

    public String getMsGlycoCTstr() {
        return this.msGlycoCTstr;
    }

    public void setMsGlycoCTstr(String msNamestr) {
        this.msGlycoCTstr = msNamestr;
    }

    @Override
    public String export(Monosaccharide ms) throws MonosaccharideException {
        this.setEurocarbDbMs(null);
        try {
            this.eurocarbDbMs = BasetypeConversion.msdbToEurocarbdb(ms);
        }
        catch (GlycoconjugateException ge) {
            MonosaccharideException me = new MonosaccharideException("glycoconjugate exception in basetype conversion: " + ge.getMessage());
            me.initCause(ge);
            throw me;
        }
        this.setMsGlycoCTstr(this.getEurocarbDbMs().getGlycoCTName());
        String outStr = this.getMsGlycoCTstr();
        this.setSubstitutionStr(this.generateMsdbSubstituentsString(ms));
        if (this.getNamescheme().equals((Object)GlycanNamescheme.MONOSACCHARIDEDB)) {
            String substStr;
            String anhydroStr = this.generateAnhydroLactonoString(ms);
            if (anhydroStr != null && anhydroStr.length() > 0) {
                outStr = String.valueOf(outStr) + anhydroStr;
            }
            if ((substStr = this.getSubstitutionStr()) != null && substStr.length() > 0) {
                outStr = String.valueOf(outStr) + substStr;
            }
        }
        return outStr;
    }

    @Override
    public ArrayList<SubstituentExchangeObject> getSeparateDisplaySubstituents(Monosaccharide ms) throws ResourcesDbException {
        ArrayList<SubstituentExchangeObject> substList = super.getSeparateDisplaySubstituents(ms);
        if (this.getNamescheme().equals((Object)GlycanNamescheme.GLYCOCT)) {
            for (CoreModification mod : ms.getCoreModifications()) {
                if (!mod.getName().equals(CoreModificationTemplate.ANHYDRO.getName()) && !mod.getName().equals(CoreModificationTemplate.LACTONE.getName()) && !mod.getName().equals(CoreModificationTemplate.EPOXY.getName())) continue;
                SubstituentExchangeObject subst = new SubstituentExchangeObject(this.getNamescheme(), this.getConfig(), this.getTemplateContainer());
                subst.setName(mod.getName());
                subst.setPosition1(mod.getPosition1());
                subst.setPosition2(mod.getPosition2());
                subst.setLinkagetype1(LinkageType.DEOXY);
                subst.setLinkagetype1(LinkageType.H_AT_OH);
                subst.setSubstituentPosition1(new ArrayList<Integer>());
                subst.setSubstituentPosition2(new ArrayList<Integer>());
                substList.add(subst);
            }
        }
        return substList;
    }

    public String generateAnhydroLactonoString(Monosaccharide ms) throws MonosaccharideException {
        String anlacStr = "";
        for (CoreModification mod : ms.getCoreModifications(CoreModificationTemplate.ANHYDRO.getName())) {
            if (mod.getPositions().size() == 0 || mod.containsPosition(0)) {
                mod = mod.clone();
            }
            anlacStr = String.valueOf(anlacStr) + "|" + Utils.formatPositionsString(mod.getPosition1(), "/", "0") + "," + Utils.formatPositionsString(mod.getPosition2(), "/", "0") + ":" + CoreModificationTemplate.ANHYDRO.getName();
        }
        for (CoreModification mod : ms.getCoreModifications(CoreModificationTemplate.LACTONE.getName())) {
            if (mod.getPositions().size() == 0 || mod.containsPosition(0)) {
                mod = mod.clone();
            }
            anlacStr = String.valueOf(anlacStr) + "|" + Utils.formatPositionsString(mod.getPosition1(), "/", "0") + "," + Utils.formatPositionsString(mod.getPosition2(), "/", "0") + ":" + CoreModificationTemplate.LACTONE.getName();
        }
        return anlacStr;
    }

    public String generateMsdbSubstituentsString(Monosaccharide ms, GlycanNamescheme scheme) throws MonosaccharideException {
        String substStr = "";
        if (scheme.equals((Object)GlycanNamescheme.MONOSACCHARIDEDB)) {
            for (Substitution subst : ms.getSubstitutions()) {
                if (subst.getPositions().size() == 0 || subst.containsPosition(0)) {
                    subst = subst.clone();
                }
                substStr = String.valueOf(substStr) + "|" + this.generateSingleSubstituentString(subst, scheme);
            }
        } else if (!scheme.equals((Object)GlycanNamescheme.GLYCOCT)) {
            throw new MonosaccharideException("unsupported namescheme in generateSubstituentsString(): " + scheme.getNameStr());
        }
        if (substStr.length() > 0) {
            substStr = "|" + substStr;
        }
        return substStr;
    }

    public String generateMsdbSubstituentsString(Monosaccharide ms) throws MonosaccharideException {
        return this.generateMsdbSubstituentsString(ms, this.getNamescheme());
    }

    private String generateSingleSubstituentString(Substitution subst, GlycanNamescheme scheme) {
        String substStr = "";
        if (scheme.equals((Object)GlycanNamescheme.MONOSACCHARIDEDB)) {
            substStr = String.valueOf(substStr) + "(";
            substStr = String.valueOf(substStr) + Utils.formatPositionsString(subst.getPosition1(), "/", "0");
            substStr = String.valueOf(substStr) + subst.getLinkagetype1().getType() + ":";
            substStr = String.valueOf(substStr) + Utils.formatPositionsString(subst.getSubstituentPosition1(), "/", "0");
            if (subst.hasPosition2()) {
                substStr = String.valueOf(substStr) + "," + Utils.formatPositionsString(subst.getPosition2(), "/", "0");
                substStr = String.valueOf(substStr) + subst.getLinkagetype2().getType() + ":";
                substStr = String.valueOf(substStr) + Utils.formatPositionsString(subst.getSubstituentPosition2(), "/", "0");
            }
            substStr = String.valueOf(substStr) + ")" + subst.getName();
        }
        return substStr;
    }
}

