/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.io.MonosaccharideImporter;
import org.eurocarbdb.resourcesdb.io.NameParsingException;
import org.eurocarbdb.resourcesdb.io.StandardImporter;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CfgImporter
extends StandardImporter
implements MonosaccharideImporter {
    public CfgImporter() {
        this((Config)null, (TemplateContainer)null);
    }

    public CfgImporter(Config confObj) {
        this(confObj, null);
    }

    public CfgImporter(Config confObj, TemplateContainer container) {
        super(GlycanNamescheme.CFG, confObj, container);
    }

    @Override
    public Monosaccharide parseMsString(String name) throws ResourcesDbException {
        Monosaccharide ms = new Monosaccharide(this.getConfig(), this.getTemplateContainer());
        this.parseMsString(name, ms);
        return ms;
    }

    public Monosaccharide parseMsString(String name, Monosaccharide ms) throws ResourcesDbException {
        if (ms == null) {
            throw new NameParsingException("CfgImporter.parseMsString(String, Monosaccharide): Monosaccharide must not be null.");
        }
        this.init();
        this.setInputName(name);
        ms.init();
        ms.setCheckPositionsOnTheFly(false);
        String residueBaseStr = "";
        boolean hasNonStdConfig = false;
        boolean hasNonStdRingtype = false;
        Anomer anomeric = null;
        ArrayList<Substitution> substList = null;
        while (this.hasCurrentToken() && Character.isUpperCase(name.charAt(this.getParsingPosition()))) {
            residueBaseStr = String.valueOf(residueBaseStr) + name.charAt(this.getParsingPosition());
            this.increaseParsingPosition();
        }
        if (residueBaseStr.length() == 0) {
            throw new NameParsingException("Cfg residue name must start with uppercase letter.", this.getInputName(), this.getParsingPosition());
        }
        TrivialnameTemplate template = this.getTemplateContainer().getTrivialnameTemplateContainer().forBasetypeName(GlycanNamescheme.CFG, residueBaseStr);
        if (template == null) {
            throw new NameParsingException("unknown cfg base name: " + residueBaseStr, this.getInputName(), 0);
        }
        this.setDetectedTrivialname(template);
        if (name.length() > this.getParsingPosition() && name.charAt(this.getParsingPosition()) == '\'') {
            hasNonStdConfig = true;
            this.increaseParsingPosition();
        }
        if (name.length() > this.getParsingPosition() && name.charAt(this.getParsingPosition()) == '^') {
            hasNonStdRingtype = true;
            this.increaseParsingPosition();
        }
        if (name.length() > this.getParsingPosition() && name.charAt(this.getParsingPosition()) == '~') {
            hasNonStdRingtype = true;
            hasNonStdConfig = true;
            this.increaseParsingPosition();
        }
        if (name.length() > this.getParsingPosition()) {
            substList = this.parseSubstitutions();
        }
        if (name.length() > this.getParsingPosition()) {
            if (name.charAt(this.getParsingPosition()) == 'a') {
                anomeric = Anomer.ALPHA;
                this.increaseParsingPosition();
            } else if (name.charAt(this.getParsingPosition()) == 'b') {
                anomeric = Anomer.BETA;
                this.increaseParsingPosition();
            } else if (name.charAt(this.getParsingPosition()) == '?') {
                anomeric = Anomer.UNKNOWN;
                this.increaseParsingPosition();
            }
        } else {
            anomeric = Anomer.UNKNOWN;
        }
        if (name.length() > this.getParsingPosition()) {
            throw new NameParsingException("unexpected token: '" + name.charAt(this.getParsingPosition()) + "'", this.getInputName(), this.getParsingPosition());
        }
        ms.setSize(template.getSize());
        String stereoStr = String.valueOf('0') + template.getStereocode() + '0';
        if (template.getDefaultConfiguration().equals((Object)StereoConfiguration.Laevus)) {
            stereoStr = Stereocode.changeDLinStereoString(stereoStr);
        }
        ms.setStereoStr(stereoStr);
        ms.setAnomer(anomeric);
        ms.setAnomerInStereocode();
        if (hasNonStdConfig) {
            if (template.isDefaultConfigIsCompulsory()) {
                throw new NameParsingException("Change of configuration not allowed for " + template.getPrimaryName(this.getNamescheme()), this.getInputName(), this.getInputName().indexOf("'"));
            }
            ms.setConfiguration(StereoConfiguration.invert(template.getDefaultConfiguration()));
            ms.setStereoStr(Stereocode.changeDLinStereoString(ms.getStereoStr()));
        } else {
            ms.setConfiguration(template.getDefaultConfiguration());
        }
        int ringstart = template.getCarbonylPosition();
        ms.setDefaultCarbonylPosition(ringstart);
        ms.setRingStart(ringstart);
        int ringend = template.getDefaultRingend();
        if (hasNonStdRingtype) {
            ringend = ringend - ringstart == 4 ? --ringend : ++ringend;
        }
        ms.setRingEnd(ringend);
        ms.getBasetype().setCoreModifications(template.getCoreModifications());
        ms.setSubstitutions(template.getSubstitutionsClone());
        if (substList != null) {
            for (Substitution subst : substList) {
                ms.addSeparateDisplaySubstitution(subst, GlycanNamescheme.CFG, this.getTemplateContainer().getSubstituentTemplateContainer(), false);
            }
        }
        return ms;
    }

    private ArrayList<Substitution> parseSubstitutions() throws ResourcesDbException {
        ArrayList<Substitution> outList = new ArrayList<Substitution>();
        String parseStr = this.getInputName();
        if (parseStr.charAt(this.getParsingPosition()) == '[') {
            Substitution subst;
            this.increaseParsingPosition();
            while ((subst = this.parseSingleSubstitution()) != null) {
                outList.add(subst);
                if (parseStr.charAt(this.getParsingPosition()) == ',') {
                    this.increaseParsingPosition();
                    continue;
                }
                if (parseStr.charAt(this.getParsingPosition()) == ']') break;
            }
            if (parseStr.charAt(this.getParsingPosition()) != ']') {
                throw new NameParsingException("unexpected token '" + parseStr.charAt(this.getParsingPosition()) + "' (expected ']')", this.getInputName(), this.getParsingPosition());
            }
            this.increaseParsingPosition();
        }
        return outList;
    }

    private Substitution parseSingleSubstitution() throws ResourcesDbException {
        String parseStr = this.getInputName();
        Substitution subst = new Substitution();
        int pos = this.parseIntNumber(true);
        subst.addPosition1(pos);
        while (parseStr.charAt(this.getParsingPosition()) == '/') {
            this.increaseParsingPosition();
            pos = this.parseIntNumber(true);
            subst.addPosition1(pos);
        }
        if (parseStr.charAt(this.getParsingPosition()) == ',') {
            this.increaseParsingPosition();
            pos = this.parseIntNumber(true);
            subst.addPosition2(pos);
            while (parseStr.charAt(this.getParsingPosition()) == '/') {
                this.increaseParsingPosition();
                pos = this.parseIntNumber(true);
                subst.addPosition2(pos);
            }
        }
        String substName = "";
        while (Character.isUpperCase(parseStr.charAt(this.getParsingPosition()))) {
            substName = String.valueOf(substName) + parseStr.charAt(this.getParsingPosition());
            this.increaseParsingPosition();
        }
        if (substName.length() == 0) {
            throw new NameParsingException("substituent identifier expected", parseStr, this.getParsingPosition());
        }
        SubstituentTemplate substTmpl = this.getTemplateContainer().getSubstituentTemplateContainer().forResidueIncludedName(GlycanNamescheme.CFG, substName);
        if (substTmpl == null) {
            throw new NameParsingException("unknown substituent identifier", parseStr, this.getParsingPosition() - substName.length());
        }
        subst.setTemplate(substTmpl);
        subst.setLinkagetype1(substTmpl.getLinkageTypeBySubstituentName(GlycanNamescheme.CFG, substName));
        subst.setSubstituentPosition1(substTmpl.getDefaultLinkingPosition1());
        if (subst.hasPosition2()) {
            subst.setLinkagetype2(substTmpl.getDefaultLinkagetype2());
            subst.setSubstituentPosition2(substTmpl.getDefaultLinkingPosition2());
        }
        return subst;
    }
}

