/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Bond;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.util.EscapeDialog;
import org.glycoinfo.application.glycanbuilder.util.GlycanUtils;
import org.jdesktop.layout.GroupLayout;

public class ResiduePropertiesDialog
extends EscapeDialog
implements ActionListener,
ItemListener {
    private Linkage parent_link;
    private Residue current;
    private ArrayList<Residue> linked;
    private GlycanDocument theDoc;
    private JButton button_cancel;
    private JButton button_ok;
    private JComboBox field_anomeric_carbon;
    private JComboBox field_anomeric_state;
    private JComboBox field_chirality;
    private JList field_linkage_position;
    private JComboBox field_ring_size;
    private JCheckBox field_second_bond;
    private JComboBox field_second_child_position;
    private JList field_second_parent_position;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelh;
    private JLabel jLabelt;
    private JLabel jLabelph;
    private JLabel jLabelpl;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JComboBox field_LinkageType_tail;
    private JComboBox field_LinkageType_head;
    private JTextArea field_max;
    private JTextArea field_min;

    public ResiduePropertiesDialog(Frame parent, Residue _current, GlycanDocument _theDoc) {
        super(parent, true);
        this.parent_link = _current.getParentLinkage();
        this.current = _current;
        this.linked = null;
        this.theDoc = _theDoc;
        this.initComponents();
        this.fillComponents();
        this.setSelections();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    public ResiduePropertiesDialog(Frame parent, Residue _current, ArrayList<Residue> _linked, GlycanDocument _theDoc) {
        this(parent, _current, _theDoc);
        this.linked = _linked;
    }

    private void fillComponents() {
        this.field_linkage_position.setSelectionMode(2);
        this.field_second_parent_position.setSelectionMode(2);
        if (this.parent_link != null) {
            this.field_linkage_position.setModel(this.createPositions(this.parent_link.getParentResidue()));
        }
        this.field_anomeric_state.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "a", "b"}));
        this.field_anomeric_carbon.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "1", "2", "3"}));
        this.field_chirality.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "D", "L"}));
        this.field_ring_size.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "p", "f", "o"}));
        if (this.parent_link != null) {
            this.field_second_parent_position.setModel(this.createPositions(this.parent_link.getParentResidue()));
        }
        this.field_second_child_position.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "1", "2", "3"}));
        this.field_LinkageType_head.setModel(new DefaultComboBoxModel<String>(new String[]{"H_LOSE", "DEOXY", "H_AT_OH", "UNKNOWN", "NONMONOSACCHARID", "S_CONFIG", "R_CONFIG", "UNVALIDATED"}));
        this.field_LinkageType_tail.setModel(new DefaultComboBoxModel<String>(new String[]{"H_LOSE", "DEOXY", "H_AT_OH", "UNKNOWN", "NONMONOSACCHARID", "S_CONFIG", "R_CONFIG", "UNVALIDATED"}));
        this.field_max.setText("100");
        this.field_min.setText("100");
    }

    private ListModel<String> createPositions(Residue parent) {
        DefaultListModel<String> ret = new DefaultListModel<String>();
        char[] par_pos = null;
        par_pos = parent == null || parent.getType().getLinkagePositions().length == 0 ? new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'N'} : parent.getType().getLinkagePositions();
        String par_pos_temp = String.valueOf(par_pos);
        for (Linkage donorLinkage : parent.getChildrenLinkages()) {
            if (this.current == donorLinkage.getChildResidue()) continue;
            for (Bond donorBond : donorLinkage.getBonds()) {
                if (donorBond.getParentPositions().length > 1 || donorBond.getParentPositions()[0] == '?') continue;
                char donorPos = donorBond.getParentPositions()[0];
                par_pos_temp = par_pos_temp.replace(donorPos, ' ');
            }
        }
        if (parent.getRingSize() == 'o') {
            par_pos_temp = par_pos_temp + parent.getType().getAnomericCarbon();
        }
        if (parent.getRingSize() == 'p') {
            if (parent.getAnomericCarbon() == '1') {
                par_pos_temp = par_pos_temp.replace('5', ' ');
            }
            if (parent.getAnomericCarbon() == '2') {
                par_pos_temp = par_pos_temp.replace('6', ' ');
            }
        }
        if (parent.getRingSize() == 'f') {
            if (parent.getAnomericCarbon() == '1') {
                par_pos_temp = par_pos_temp.replace('4', ' ');
            }
            if (parent.getAnomericCarbon() == '2') {
                par_pos_temp = par_pos_temp.replace('5', ' ');
            }
        }
        if (!par_pos_temp.equals(String.valueOf(par_pos))) {
            par_pos_temp = par_pos_temp.replaceAll(" ", "");
            par_pos = par_pos_temp.toCharArray();
            Arrays.sort(par_pos);
        }
        ret.addElement("?");
        for (int i = 0; i < par_pos.length; ++i) {
            ret.addElement("" + par_pos[i]);
        }
        return ret;
    }

    private void setSelections() {
        if (this.parent_link != null) {
            this.selectPositions(this.field_linkage_position, this.parent_link.glycosidicBond().getParentPositions());
        }
        this.field_anomeric_state.setSelectedItem("" + this.current.getAnomericState());
        this.field_anomeric_carbon.setSelectedItem("" + this.current.getAnomericCarbon());
        this.field_chirality.setSelectedItem("" + this.current.getChirality());
        this.field_ring_size.setSelectedItem("" + this.current.getRingSize());
        if (this.parent_link != null) {
            this.field_second_bond.setSelected(this.parent_link.hasMultipleBonds());
            this.selectPositions(this.field_second_parent_position, this.parent_link.getBonds().get(0).getParentPositions());
            this.field_second_child_position.setSelectedItem("" + this.parent_link.getBonds().get(0).getChildPosition());
        }
        this.field_max.setText(String.valueOf(this.current.getParentLinkage().getBonds().get(0).getProbabilityHigh()));
        this.field_min.setText(String.valueOf(this.current.getParentLinkage().getBonds().get(0).getProbabilityLow()));
        this.field_LinkageType_head.setSelectedItem("UNVALIDATED");
        this.field_LinkageType_tail.setSelectedItem("UNVALIDATED");
    }

    private void selectPositions(JList field, char[] pos) {
        DefaultListModel dlm = (DefaultListModel)field.getModel();
        for (int i = 0; i < pos.length; ++i) {
            int ind = dlm.indexOf("" + pos[i]);
            field.addSelectionInterval(ind, ind);
        }
    }

    private void setTraversal() {
        boolean can_have_parent_linkage;
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        boolean bl = can_have_parent_linkage = this.parent_link != null && this.parent_link.getParentResidue() != null && (this.parent_link.getParentResidue().isSaccharide() || this.parent_link.getParentResidue().isBracket() || this.parent_link.getParentResidue().isRepetition() || this.parent_link.getParentResidue().isRingFragment());
        if (can_have_parent_linkage) {
            tp.addComponent(this.field_linkage_position);
        }
        if (this.current.isSaccharide()) {
            tp.addComponent(this.field_anomeric_state);
            tp.addComponent(this.field_anomeric_carbon);
            tp.addComponent(this.field_chirality);
            tp.addComponent(this.field_ring_size);
        }
        if (can_have_parent_linkage) {
            tp.addComponent(this.field_second_parent_position);
            tp.addComponent(this.field_second_child_position);
        }
        tp.addComponent(this.field_min);
        tp.addComponent(this.field_max);
        tp.addComponent(this.field_LinkageType_head);
        tp.addComponent(this.field_LinkageType_tail);
        tp.addComponent(this.button_ok);
        tp.addComponent(this.button_cancel);
        this.setFocusTraversalPolicy(tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.field_second_bond.addItemListener(this);
        this.field_ring_size.addItemListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
        boolean can_have_parent_linkage = this.parent_link != null && this.parent_link.getParentResidue() != null && (this.parent_link.getParentResidue().isSaccharide() || this.parent_link.getParentResidue().isBracket() || this.parent_link.getParentResidue().isRepetition() || this.parent_link.getParentResidue().isRingFragment());
        this.field_linkage_position.setEnabled(can_have_parent_linkage);
        this.field_anomeric_state.setEnabled(this.current.isSaccharide());
        this.field_anomeric_carbon.setEnabled(this.current.isSaccharide());
        this.field_chirality.setEnabled(this.current.isSaccharide());
        this.field_ring_size.setEnabled(this.current.isSaccharide());
        this.field_second_bond.setEnabled(can_have_parent_linkage);
        this.field_second_parent_position.setEnabled(can_have_parent_linkage && this.field_second_bond.isSelected());
        this.field_second_child_position.setEnabled(can_have_parent_linkage && this.field_second_bond.isSelected());
        this.field_max.setEnabled(this.current.hasParent() && !this.current.isRepetition());
        this.field_min.setEnabled(this.current.hasParent() && !this.current.isRepetition());
        this.field_LinkageType_head.setEnabled(this.current.hasParent());
        this.field_LinkageType_tail.setEnabled(this.current.hasChildren() && this.current.getType().getSuperclass().equals("Bridge"));
    }

    private void setProperties(Residue r) {
        Linkage plr;
        char sel_anomeric_state = this.getSelectedValueChar(this.field_anomeric_state);
        r.setAnomericState(sel_anomeric_state);
        char sel_anomeric_carbon = this.getSelectedValueChar(this.field_anomeric_carbon);
        r.setAnomericCarbon(sel_anomeric_carbon);
        char sel_chirality = this.getSelectedValueChar(this.field_chirality);
        r.setChirality(sel_chirality);
        char sel_ring_size = this.getSelectedValueChar(this.field_ring_size);
        r.setRingSize(sel_ring_size);
        if (r.isSaccharide() && !GlycanUtils.isFacingAnom(r)) {
            if (r.equals(r.getTreeRoot().firstChild()) && this.getSelectedValueChar(this.field_ring_size) == 'o') {
                r.setAlditol(true);
                r.setAnomericCarbon('?');
            }
            if (r.isAlditol() && (this.getSelectedValueChar(this.field_anomeric_state) != '?' || this.getSelectedValueChar(this.field_ring_size) != 'o')) {
                r.setAlditol(false);
                r.setRingSize(this.current.getRingSize() == 'o' ? (char)'?' : (char)r.getRingSize());
            }
        }
        if ((plr = r.getParentLinkage()) != null) {
            char[] sel_linkage_positions = this.getSelectedPositions(this.field_linkage_position);
            if (this.field_second_bond.isSelected()) {
                char[] sel_second_parent_positions = this.getSelectedPositions(this.field_second_parent_position);
                char sel_second_child_position = this.getSelectedValueChar(this.field_second_child_position);
                plr.setLinkagePositions(sel_linkage_positions, sel_second_parent_positions, sel_second_child_position);
            } else {
                plr.setLinkagePositions(sel_linkage_positions);
            }
        }
        try {
            int a_iHigh = Integer.parseInt(this.field_max.getText().equals("?") ? "-100" : this.field_max.getText());
            int a_iLow = Integer.parseInt(this.field_min.getText().equals("?") ? "-100" : this.field_min.getText());
            if (a_iHigh < 0 && a_iHigh != -100 || a_iHigh > 100) {
                throw new Exception("Probability high is illegal number");
            }
            if (a_iLow < 0 && a_iLow != -100 || a_iLow > 100) {
                throw new Exception("Probanility low is illegal number");
            }
            if (!this.field_max.getText().equals("?") && !this.field_min.getText().equals("?")) {
                if (a_iLow == 100 && a_iHigh < 100) {
                    a_iLow = a_iHigh;
                    a_iHigh = 100;
                }
                if (a_iHigh < a_iLow) {
                    int a_iTmp = a_iHigh;
                    a_iHigh = a_iLow;
                    a_iLow = a_iTmp;
                }
            }
            r.getParentLinkage().getBonds().get(0).setProbabilityLow(a_iLow);
            r.getParentLinkage().getBonds().get(0).setProbabilityHigh(a_iHigh);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String a_sLinkageType_head = (String)this.field_LinkageType_head.getSelectedItem();
            String a_sLinkageType_tail = (String)this.field_LinkageType_tail.getSelectedItem();
            for (LinkageType a : LinkageType.values()) {
                if (a.toString().equals(a_sLinkageType_head)) {
                    r.getParentLinkage().setParentLinkageType(a);
                }
                if (!a.toString().equals(a_sLinkageType_tail)) continue;
                r.getParentLinkage().setChildLinkageType(a);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void retrieveData() {
        this.setProperties(this.current);
        if (this.linked != null) {
            for (Residue r : this.linked) {
                this.setProperties(r);
            }
        }
        this.theDoc.fireDocumentChanged();
    }

    private char getSelectedValueChar(JComboBox field) {
        return ((String)field.getSelectedItem()).charAt(0);
    }

    private char[] getSelectedPositions(JList field) {
        Object[] sel = field.getSelectedValues();
        if (sel.length == 0) {
            return new char[]{'?'};
        }
        char[] ret = new char[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            ret[i] = ((String)sel[i]).charAt(0);
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.closeDialog();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.field_ring_size) {
            char ring_size = this.getSelectedValueChar(this.field_ring_size);
            if (ring_size == 'o') {
                this.field_anomeric_state.setSelectedItem("?");
                this.field_anomeric_carbon.setSelectedItem("?");
            } else {
                this.field_anomeric_state.setSelectedItem("" + this.current.getAnomericState());
                this.field_anomeric_carbon.setSelectedItem("" + this.current.getAnomericCarbon());
            }
        }
        this.enableItems();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.field_anomeric_state = new JComboBox();
        this.field_chirality = new JComboBox();
        this.field_anomeric_carbon = new JComboBox();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.field_ring_size = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.field_linkage_position = new JList();
        this.field_second_bond = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.field_second_parent_position = new JList();
        this.field_second_child_position = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabelh = new JLabel();
        this.jLabelt = new JLabel();
        this.field_LinkageType_head = new JComboBox();
        this.field_LinkageType_tail = new JComboBox();
        this.jLabelph = new JLabel();
        this.jLabelpl = new JLabel();
        this.field_max = new JTextArea();
        this.field_min = new JTextArea();
        this.setResizable(false);
        this.setTitle("Residue properties");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ResiduePropertiesDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Anomeric state");
        this.jLabel2.setText("Chirality");
        this.jLabel3.setText("Anomeric carbon");
        this.jLabel4.setText("Parent position");
        this.field_anomeric_state.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "a", "b"}));
        this.field_chirality.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "D", "L"}));
        this.field_anomeric_carbon.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "1", "2", "3"}));
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.field_ring_size.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "p", "f", "o"}));
        this.jLabel5.setText("Ring size");
        this.field_linkage_position.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.field_linkage_position.setVisibleRowCount(3);
        this.jScrollPane1.setViewportView(this.field_linkage_position);
        this.field_second_bond.setText("Second bond");
        this.field_second_bond.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_second_bond.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel6.setText("Linkage position");
        this.field_second_parent_position.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.field_second_parent_position.setVisibleRowCount(3);
        this.jScrollPane2.setViewportView(this.field_second_parent_position);
        this.field_second_child_position.setModel(new DefaultComboBoxModel<String>(new String[]{"?", "1", "2", "3"}));
        this.jLabel7.setText("Child position");
        this.jLabel7.getAccessibleContext().setAccessibleName("Child position");
        this.jLabelph.setText("Probability high");
        this.jLabelpl.setText("Probability low");
        this.jLabelh.setText("Linkage type(Parent)");
        this.field_LinkageType_head.setModel(new DefaultComboBoxModel<String>(new String[]{"H_LOSE", "DEOXY", "H_AT_OH", "UNKNOWN", "NONMONOSACCHARID", "S_CONFIG", "R_CONFIG", "UNVALIDATED"}));
        this.jLabelt.setText("Linkage type(Child)");
        this.field_LinkageType_tail.setModel(new DefaultComboBoxModel<String>(new String[]{"H_LOSE", "DEOXY", "H_AT_OH", "UNKNOWN", "NONMONOSACCHARID", "S_CONFIG", "R_CONFIG", "UNVALIDATED"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel6).add(15, 15, 15).add(this.jScrollPane1, -1, 66, Short.MAX_VALUE)).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.jLabel3).add(this.jLabel2)).add(15, 15, 15).add(layout.createParallelGroup(1).add(this.field_chirality, 0, 66, Short.MAX_VALUE).add(this.field_anomeric_carbon, 0, 66, Short.MAX_VALUE))).add(2, layout.createSequentialGroup().add(this.jLabel5).add(63, 63, 63).add(this.field_ring_size, 0, 66, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.jLabel1, -2, 108, -2).addPreferredGap(0).add(this.field_anomeric_state, 0, 66, Short.MAX_VALUE)))).add(layout.createSequentialGroup().addContainerGap().add(this.field_second_bond)).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel4).add(25, 25, 25).add(this.jScrollPane2, -1, 66, Short.MAX_VALUE)).add(2, layout.createSequentialGroup().addContainerGap().add(this.jLabel7, -1, 97, Short.MAX_VALUE).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.field_second_child_position, -2, 66, -2)).add(2, layout.createSequentialGroup().addContainerGap().add(this.jLabelpl, -1, 97, Short.MAX_VALUE).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.field_min, -2, 66, -2)).add(2, layout.createSequentialGroup().addContainerGap().add(this.jLabelph, -1, 97, Short.MAX_VALUE).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.field_max, -2, 66, -2)).add(2, layout.createSequentialGroup().addContainerGap().add(this.jLabelh, -1, 97, Short.MAX_VALUE).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.field_LinkageType_head, -2, 120, -2)).add(2, layout.createSequentialGroup().addContainerGap().add(this.jLabelt, -1, 97, Short.MAX_VALUE).addPreferredGap(0, 23, Short.MAX_VALUE).add(this.field_LinkageType_tail, -2, 120, -2)).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(12, 12, 12).add(this.button_ok).addPreferredGap(0).add(this.button_cancel)).add(this.jSeparator1, -1, 186, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jScrollPane1, -2, 53, -2).add(this.jLabel6)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel1).add(this.field_anomeric_state, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel3).add(this.field_anomeric_carbon, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.field_chirality, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.jLabel5).add(this.field_ring_size, -2, -1, -2)).add(6, 6, 6).add(this.field_second_bond).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel4).add(this.jScrollPane2, -2, 51, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.field_second_child_position, -2, -1, -2).add(this.jLabel7)).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.field_min, -2, -1, -2).add(this.jLabelpl)).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.field_max, -2, -1, -2).add(this.jLabelph)).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.field_LinkageType_head, -2, -1, -2).add(this.jLabelh)).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.field_LinkageType_tail, -2, -1, -2).add(this.jLabelt)).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.jSeparator1, -2, 10, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.button_ok).add(this.button_cancel)).add(27, 27, 27)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

