/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.util.EscapeDialog;
import org.jdesktop.layout.GroupLayout;

public class RepetitionPropertiesDialog
extends EscapeDialog
implements ActionListener,
ItemListener {
    private Residue current;
    private GlycanDocument theDoc;
    private JButton button_cancel;
    private JButton button_ok;
    private JTextField field_max_rep;
    private JTextField field_min_rep;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JLabel jLabel3;
    private JComboBox field_LinkageType_head;

    public RepetitionPropertiesDialog(Frame parent, Residue _current, GlycanDocument _theDoc) {
        super(parent, true);
        this.current = _current;
        this.theDoc = _theDoc;
        this.initComponents();
        this.fillComponents();
        this.setTraversal();
        this.setActions();
        this.setSelections();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    private void fillComponents() {
        this.field_min_rep.setText("" + this.current.getMinRepetitions());
        this.field_max_rep.setText("" + this.current.getMaxRepetitions());
        this.field_LinkageType_head.setModel(new DefaultComboBoxModel<String>(new String[]{"H_LOSE", "DEOXY", "H_AT_OH", "UNKNOWN", "NONMONOSACCHARID", "S_CONFIG", "R_CONFIG", "UNVALIDATED"}));
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent(this.field_min_rep);
        tp.addComponent(this.field_max_rep);
        tp.addComponent(this.field_LinkageType_head);
        tp.addComponent(this.button_ok);
        tp.addComponent(this.button_cancel);
        this.setFocusTraversalPolicy(tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setSelections() {
        this.field_LinkageType_head.setSelectedItem((Object)this.current.getParentLinkage().getParentLinkageType());
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
        this.field_LinkageType_head.setEnabled(true);
    }

    private void retrieveData() {
        String min_rep = this.field_min_rep.getText();
        String max_rep = this.field_max_rep.getText();
        this.current.setMinRepetitions(min_rep);
        this.current.setMaxRepetitions(max_rep);
        try {
            String a_sLinkageType_head = (String)this.field_LinkageType_head.getSelectedItem();
            for (LinkageType a : LinkageType.values()) {
                if (!a.toString().equals(a_sLinkageType_head)) continue;
                this.current.getParentLinkage().setParentLinkageType(a);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.theDoc.fireDocumentChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.closeDialog();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableItems();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.field_min_rep = new JTextField();
        this.field_max_rep = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.jLabel3 = new JLabel();
        this.field_LinkageType_head = new JComboBox();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RepetitionPropertiesDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Min repetitions");
        this.field_min_rep.setText("jTextField1");
        this.field_max_rep.setText("jTextField1");
        this.jLabel2.setText("Max repetitions");
        this.jLabel3.setText("Linkage type");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(12, 12, 12).add(this.button_ok).addPreferredGap(0).add(this.button_cancel)).add(this.jSeparator1, -1, 183, Short.MAX_VALUE).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.jLabel1).add(this.jLabel2).add(this.jLabel3)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.field_max_rep, -1, 74, Short.MAX_VALUE).add(this.field_min_rep, -1, 74, Short.MAX_VALUE).add(this.field_LinkageType_head, -2, 74, -2)))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel1).add(this.field_min_rep, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.field_max_rep, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel3).add(this.field_LinkageType_head, -2, -1, -2)).addPreferredGap(0).add(this.jSeparator1, -2, 10, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.button_ok).add(this.button_cancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

