/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.util.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.util.GraphicOptions;
import org.jdesktop.layout.GroupLayout;

public class GraphicOptionsDialog
extends EscapeDialog
implements ActionListener,
ItemListener,
ChangeListener {
    private GraphicOptions theGraphicOptions = null;
    private boolean ignore_change = false;
    private JButton button_cancel;
    private JButton button_ok;
    private JComboBox field_composition_font_face;
    private JSpinner field_composition_font_size;
    private JComboBox field_display;
    private JComboBox field_linkage_info_font_face;
    private JSpinner field_linkage_info_size;
    private JComboBox field_mass_text_font_face;
    private JSpinner field_mass_text_size;
    private JSpinner field_mass_text_space;
    private JComboBox field_node_font_face;
    private JSpinner field_node_font_size;
    private JSpinner field_node_size;
    private JSpinner field_node_space;
    private JSpinner field_node_sub_space;
    private JCheckBox field_show_info;
    private JSpinner field_structures_space;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;

    public GraphicOptionsDialog(Frame parent, GraphicOptions options) {
        super(parent, true);
        this.theGraphicOptions = options;
        this.initComponents();
        this.initData(this.theGraphicOptions);
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    private Object[] generateValues(int min, int max) {
        Object[] values = new Object[max - min + 1];
        for (int i = min; i <= max; ++i) {
            values[i - min] = i;
        }
        return values;
    }

    private void initData(GraphicOptions model) {
        Vector<String> availableFonts = GraphicOptions.getAllFontFaces();
        this.field_display.setModel(new DefaultComboBoxModel<String>(new String[]{"normalinfo", "normal", "compact", "custom"}));
        this.field_node_size.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.field_node_font_size.setModel(new SpinnerNumberModel(1, 1, 40, 1));
        this.field_node_font_face.setModel(new DefaultComboBoxModel<String>(availableFonts));
        this.field_composition_font_size.setModel(new SpinnerNumberModel(1, 1, 40, 1));
        this.field_composition_font_face.setModel(new DefaultComboBoxModel<String>(availableFonts));
        this.field_linkage_info_size.setModel(new SpinnerNumberModel(1, 1, 40, 1));
        this.field_linkage_info_font_face.setModel(new DefaultComboBoxModel<String>(availableFonts));
        this.field_node_space.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.field_node_sub_space.setModel(new SpinnerNumberModel(1, 1, 40, 1));
        this.field_structures_space.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.field_mass_text_space.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.field_mass_text_size.setModel(new SpinnerNumberModel(1, 1, 40, 1));
        this.field_mass_text_font_face.setModel(new DefaultComboBoxModel<String>(availableFonts));
        GraphicOptions options = new GraphicOptions(model);
        options.setScale(1.0);
        this.ignore_change = true;
        this.field_display.setSelectedItem(options.DISPLAY);
        this.field_show_info.setSelected(options.SHOW_INFO);
        this.field_node_size.setValue(options.NODE_SIZE);
        this.field_node_font_size.setValue(options.NODE_FONT_SIZE);
        this.field_node_font_face.setSelectedItem(options.NODE_FONT_FACE);
        this.field_composition_font_size.setValue(options.COMPOSITION_FONT_SIZE);
        this.field_composition_font_face.setSelectedItem(options.COMPOSITION_FONT_FACE);
        this.field_linkage_info_size.setValue(options.LINKAGE_INFO_SIZE);
        this.field_linkage_info_font_face.setSelectedItem(options.LINKAGE_INFO_FONT_FACE);
        this.field_node_space.setValue(options.NODE_SPACE);
        this.field_node_sub_space.setValue(options.NODE_SUB_SPACE);
        this.field_structures_space.setValue(options.STRUCTURES_SPACE);
        this.field_mass_text_space.setValue(options.MASS_TEXT_SPACE);
        this.field_mass_text_size.setValue(options.MASS_TEXT_SIZE);
        this.field_mass_text_font_face.setSelectedItem(options.MASS_TEXT_FONT_FACE);
        this.ignore_change = false;
        this.pack();
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent(this.field_display);
        tp.addComponent(this.field_show_info);
        tp.addComponent(this.field_node_size);
        tp.addComponent(this.field_node_font_size);
        tp.addComponent(this.field_node_font_face);
        tp.addComponent(this.field_composition_font_size);
        tp.addComponent(this.field_composition_font_face);
        tp.addComponent(this.field_linkage_info_size);
        tp.addComponent(this.field_linkage_info_font_face);
        tp.addComponent(this.field_node_space);
        tp.addComponent(this.field_node_sub_space);
        tp.addComponent(this.field_structures_space);
        tp.addComponent(this.field_mass_text_space);
        tp.addComponent(this.field_mass_text_size);
        tp.addComponent(this.field_mass_text_font_face);
        tp.addComponent(this.button_ok);
        tp.addComponent(this.button_cancel);
        this.setFocusTraversalPolicy(tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.field_display.addItemListener(this);
        this.field_show_info.addActionListener(this);
        this.field_node_size.addChangeListener(this);
        this.field_node_font_size.addChangeListener(this);
        this.field_node_font_face.addItemListener(this);
        this.field_composition_font_size.addChangeListener(this);
        this.field_composition_font_face.addItemListener(this);
        this.field_linkage_info_size.addChangeListener(this);
        this.field_linkage_info_font_face.addItemListener(this);
        this.field_node_space.addChangeListener(this);
        this.field_node_sub_space.addChangeListener(this);
        this.field_structures_space.addChangeListener(this);
        this.field_mass_text_space.addChangeListener(this);
        this.field_mass_text_size.addChangeListener(this);
        this.field_mass_text_font_face.addItemListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
    }

    private void retrieveData() {
        this.theGraphicOptions.setDisplay((String)this.field_display.getSelectedItem());
        if (this.field_display.getSelectedItem().equals("custom")) {
            this.theGraphicOptions.SHOW_INFO_CUSTOM = this.field_show_info.isSelected();
            this.theGraphicOptions.NODE_SIZE_CUSTOM = (Integer)this.field_node_size.getValue();
            this.theGraphicOptions.NODE_FONT_SIZE_CUSTOM = (Integer)this.field_node_font_size.getValue();
            this.theGraphicOptions.NODE_FONT_FACE_CUSTOM = (String)this.field_node_font_face.getSelectedItem();
            this.theGraphicOptions.COMPOSITION_FONT_SIZE_CUSTOM = (Integer)this.field_composition_font_size.getValue();
            this.theGraphicOptions.COMPOSITION_FONT_FACE_CUSTOM = (String)this.field_composition_font_face.getSelectedItem();
            this.theGraphicOptions.LINKAGE_INFO_SIZE_CUSTOM = (Integer)this.field_linkage_info_size.getValue();
            this.theGraphicOptions.LINKAGE_INFO_FONT_FACE_CUSTOM = (String)this.field_linkage_info_font_face.getSelectedItem();
            this.theGraphicOptions.NODE_SPACE_CUSTOM = (Integer)this.field_node_space.getValue();
            this.theGraphicOptions.NODE_SUB_SPACE_CUSTOM = (Integer)this.field_node_sub_space.getValue();
            this.theGraphicOptions.STRUCTURES_SPACE_CUSTOM = (Integer)this.field_structures_space.getValue();
            this.theGraphicOptions.MASS_TEXT_SPACE_CUSTOM = (Integer)this.field_mass_text_space.getValue();
            this.theGraphicOptions.MASS_TEXT_SIZE_CUSTOM = (Integer)this.field_mass_text_size.getValue();
            this.theGraphicOptions.MASS_TEXT_FONT_FACE_CUSTOM = (String)this.field_mass_text_font_face.getSelectedItem();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.ignore_change) {
            if (e.getSource() == this.field_display) {
                this.initData(new GraphicOptions((String)this.field_display.getSelectedItem()));
            } else {
                this.ignore_change = true;
                this.field_display.setSelectedItem("custom");
                this.ignore_change = false;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.ignore_change) {
            this.ignore_change = true;
            this.field_display.setSelectedItem("custom");
            this.ignore_change = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (e.getSource() == this.field_show_info) {
            if (!this.ignore_change) {
                this.ignore_change = true;
                this.field_display.setSelectedItem("custom");
                this.ignore_change = false;
            }
        } else if (action == "OK") {
            this.return_status = action;
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.field_show_info = new JCheckBox();
        this.field_node_size = new JSpinner();
        this.jLabel2 = new JLabel();
        this.field_node_font_size = new JSpinner();
        this.jLabel3 = new JLabel();
        this.field_node_font_face = new JComboBox();
        this.jLabel4 = new JLabel();
        this.field_linkage_info_size = new JSpinner();
        this.jLabel5 = new JLabel();
        this.field_linkage_info_font_face = new JComboBox();
        this.jLabel6 = new JLabel();
        this.field_node_space = new JSpinner();
        this.jLabel7 = new JLabel();
        this.field_node_sub_space = new JSpinner();
        this.jLabel8 = new JLabel();
        this.field_structures_space = new JSpinner();
        this.jLabel9 = new JLabel();
        this.field_mass_text_space = new JSpinner();
        this.jLabel10 = new JLabel();
        this.field_mass_text_size = new JSpinner();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.field_mass_text_font_face = new JComboBox();
        this.field_composition_font_face = new JComboBox();
        this.jLabel13 = new JLabel();
        this.field_composition_font_size = new JSpinner();
        this.jLabel14 = new JLabel();
        this.field_display = new JComboBox();
        this.jLabel15 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GraphicOptionsDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Show linkage info");
        this.field_show_info.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jLabel2.setText("Residue size");
        this.jLabel3.setText("Residue text size");
        this.field_node_font_face.setModel(new DefaultComboBoxModel<String>(new String[]{"Arial", "Serif"}));
        this.jLabel4.setText("Residue text font");
        this.jLabel5.setText("Linkage info text size");
        this.field_linkage_info_font_face.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel6.setText("Linkage info text font");
        this.jLabel7.setText("Space between residues");
        this.jLabel8.setText("Space between border residues");
        this.jLabel9.setText("Space between structures");
        this.jLabel10.setText("Space before mass text");
        this.jLabel11.setText("Mass text size");
        this.jLabel12.setText("Mass text font");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.field_mass_text_font_face.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.field_composition_font_face.setModel(new DefaultComboBoxModel<String>(new String[]{"Arial", "Serif"}));
        this.jLabel13.setText("Composition text font");
        this.jLabel14.setText("Composition text size");
        this.field_display.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel15.setText("Display type");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jSeparator1, -1, 315, Short.MAX_VALUE).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.jLabel1).add(this.jLabel2).add(this.jLabel3).add(this.jLabel4).add(this.jLabel14).add(this.jLabel13).add(this.jLabel15).add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.jLabel5).addPreferredGap(0)).add(this.jLabel6)).add(this.jLabel7).add(this.jLabel9).add(this.jLabel10).add(this.jLabel11).add(this.jLabel12).add(layout.createSequentialGroup().add(76, 76, 76).add(this.button_ok).addPreferredGap(0).add(this.button_cancel)).add(this.jLabel8)).addPreferredGap(0).add(layout.createParallelGroup(2).add(this.field_mass_text_font_face, 0, 113, Short.MAX_VALUE).add(this.field_linkage_info_size, -1, 113, Short.MAX_VALUE).add(1, this.field_show_info).add(1, this.field_node_font_size, -1, 113, Short.MAX_VALUE).add(1, this.field_node_font_face, 0, 113, Short.MAX_VALUE).add(this.field_composition_font_size, -1, 113, Short.MAX_VALUE).add(this.field_node_size, -1, 113, Short.MAX_VALUE).add(this.field_composition_font_face, 0, 113, Short.MAX_VALUE).add(this.field_linkage_info_font_face, 0, 113, Short.MAX_VALUE).add(this.field_node_space, -1, 113, Short.MAX_VALUE).add(this.field_structures_space, -1, 113, Short.MAX_VALUE).add(this.field_mass_text_space, -1, 113, Short.MAX_VALUE).add(this.field_mass_text_size, -1, 113, Short.MAX_VALUE).add(this.field_node_sub_space, -1, 113, Short.MAX_VALUE).add(this.field_display, 0, 113, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel15).add(this.field_display, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(1).add(this.jLabel1).add(this.field_show_info)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.field_node_size, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel3).add(this.field_node_font_size, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.field_node_font_face, -2, -1, -2).add(this.jLabel4)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.field_composition_font_size, -2, -1, -2).add(this.jLabel14)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel13).add(this.field_composition_font_face, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel5).add(this.field_linkage_info_size, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel6).add(this.field_linkage_info_font_face, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel7).add(this.field_node_space, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel8).add(this.field_node_sub_space, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel9).add(this.field_structures_space, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel10).add(this.field_mass_text_space, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel11).add(this.field_mass_text_size, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel12).add(this.field_mass_text_font_face, -2, -1, -2)).addPreferredGap(0).add(this.jSeparator1, -2, 10, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.button_cancel).add(this.button_ok)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

