/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.renderutil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.renderutil.AbstractGlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.renderutil.Geometry;
import org.eurocarbdb.application.glycanbuilder.renderutil.LinkageRendererAWT;
import org.eurocarbdb.application.glycanbuilder.renderutil.Paintable;
import org.eurocarbdb.application.glycanbuilder.renderutil.PositionManager;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResAngle;
import org.eurocarbdb.application.glycanbuilder.renderutil.ResidueRendererAWT;
import org.eurocarbdb.application.glycanbuilder.util.GraphicOptions;
import org.glycoinfo.application.glycanbuilder.util.GlycanUtils;

public class GlycanRendererAWT
extends AbstractGlycanRenderer {
    public GlycanRendererAWT() {
    }

    public GlycanRendererAWT(AbstractGlycanRenderer src) {
        super(src);
    }

    public GlycanRendererAWT(GlycanRendererAWT src) {
        super(src);
    }

    @Override
    protected void initialiseRenderers() {
        this.theResidueRenderer = new ResidueRendererAWT(this);
        this.theLinkageRenderer = new LinkageRendererAWT(this);
    }

    @Override
    public void paint(Paintable paintable, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        if (structure == null || structure.isEmpty()) {
            return;
        }
        boolean isAlditol = show_redend;
        if (!structure.isComposition()) {
            isAlditol = GlycanUtils.isShowRedEnd(structure, this.theGraphicOptions, show_redend);
        }
        this.assignID(structure);
        selected_residues = selected_residues != null ? selected_residues : new HashSet<Residue>();
        HashSet<Linkage> hashSet = selected_linkages = selected_linkages != null ? selected_linkages : new HashSet<Linkage>();
        if (!structure.isComposition()) {
            this.paintResidue(paintable, structure.getRoot(isAlditol), selected_residues, selected_linkages, null, posManager, bboxManager);
        }
        this.paintBracket(paintable, structure, selected_residues, selected_linkages, null, posManager, bboxManager);
        if (this.theGraphicOptions.NOTATION.equals("snfg")) {
            this.displayLegend(paintable, structure, show_redend, bboxManager);
        }
        if (show_mass) {
            this.displayMass(paintable, structure, show_redend, bboxManager);
        }
    }

    @Override
    protected void assignID(Glycan structure) {
        HashMap<String, Integer> nodeIndex = new HashMap<String, Integer>();
        int id = 1;
        for (Residue residue : structure.getAllResidues()) {
            if (residue.getType().getDescription().equals("no glycosidic linkages") || !residue.isSaccharide() || residue.getType().getSuperclass().equals("Bridge")) continue;
            if (this.theGraphicOptions.NOTATION.equals("snfg")) {
                if (this.theResidueStyleDictionary.containsResidue(residue)) continue;
                if (!nodeIndex.containsKey(residue.getType().getDescription())) {
                    nodeIndex.put(residue.getType().getDescription(), id);
                    ++id;
                }
                if (!nodeIndex.containsKey(residue.getType().getDescription())) continue;
                residue.setID((Integer)nodeIndex.get(residue.getType().getDescription()));
                continue;
            }
            if (residue.getID() == 0) continue;
            residue.setID(0);
        }
    }

    @Override
    protected void displayLegend(Paintable paintable, Glycan structure, boolean show_redend, BBoxManager bboxManager) {
        Graphics2D g2d = paintable.getGraphics2D();
        Rectangle structure_all_bbox = bboxManager.getComplete(structure.getRoot(show_redend));
        g2d.setColor(Color.black);
        g2d.setFont(new Font(this.theGraphicOptions.MASS_TEXT_FONT_FACE, 0, 10));
        TreeMap<Integer, String> nodeIndex = new TreeMap<Integer, String>();
        int id = 1;
        StringBuilder legend = new StringBuilder();
        for (Residue residue : structure.getAllResidues()) {
            if (!residue.isSaccharide() || residue.getType().getSuperclass().equals("Bridge")) continue;
            if (residue.getType().getDescription().equals("no glycosidic linkages")) {
                nodeIndex.put(0, residue.getType().getDescription());
                continue;
            }
            if (this.theResidueStyleDictionary.containsResidue(residue) || nodeIndex.containsValue(residue.getType().getDescription())) continue;
            nodeIndex.put(id, residue.getType().getDescription());
            ++id;
        }
        for (Integer number : nodeIndex.keySet()) {
            if (number != 0) {
                legend.append(number).append("=");
            }
            legend.append((String)nodeIndex.get(number)).append("|");
        }
        int y = Geometry.bottom(structure_all_bbox);
        for (String unit : legend.toString().split("\\|")) {
            g2d.drawString(unit, Geometry.left(structure_all_bbox), y += g2d.getFontMetrics().getHeight());
        }
    }

    @Override
    protected void displayMass(Paintable paintable, Glycan structure, boolean show_redend, BBoxManager bboxManager) {
        Graphics2D g2d = paintable.getGraphics2D();
        Rectangle structure_all_bbox = bboxManager.getComplete(structure.getRoot(show_redend));
        g2d.setColor(Color.black);
        g2d.setFont(new Font(this.theGraphicOptions.MASS_TEXT_FONT_FACE, 0, this.theGraphicOptions.MASS_TEXT_SIZE));
        String text = this.getMassText(structure);
        g2d.drawString(text, Geometry.left(structure_all_bbox), Geometry.bottom(structure_all_bbox) + this.theGraphicOptions.MASS_TEXT_SPACE + this.theGraphicOptions.MASS_TEXT_SIZE);
    }

    @Override
    protected void paintQuantity(Paintable paintable, Residue antenna, int quantity, BBoxManager bboxManager) {
        ResAngle orientation = this.theGraphicOptions.getOrientationAngle();
        Graphics2D g2d = paintable.getGraphics2D();
        String text = orientation.equals(0) || orientation.equals(-90) ? "x" + quantity : quantity + "x";
        Dimension text_dim = Geometry.textBounds(text, this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
        Rectangle antenna_bbox = bboxManager.getComplete(antenna);
        Rectangle text_rect = orientation.equals(0) ? new Rectangle(Geometry.right(antenna_bbox) + 3, Geometry.midy(antenna_bbox) - 1 - text_dim.height / 2, text_dim.width, text_dim.height) : (orientation.equals(180) ? new Rectangle(Geometry.left(antenna_bbox) - 3 - text_dim.width, Geometry.midy(antenna_bbox) - 1 - text_dim.height / 2, text_dim.width, text_dim.height) : (orientation.equals(90) ? new Rectangle(Geometry.midx(antenna_bbox) - text_dim.height / 2, Geometry.bottom(antenna_bbox) + 3, text_dim.height, text_dim.width) : new Rectangle(Geometry.midx(antenna_bbox) - text_dim.height / 2, Geometry.top(antenna_bbox) - 3 - text_dim.width, text_dim.height, text_dim.width)));
        g2d.setColor(Color.black);
        g2d.setFont(new Font(this.theGraphicOptions.NODE_FONT_FACE, 0, this.theGraphicOptions.NODE_FONT_SIZE));
        if (orientation.equals(0) || orientation.equals(180)) {
            g2d.drawString(text, Geometry.left(text_rect), Geometry.bottom(text_rect));
        } else {
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(text, -Geometry.bottom(text_rect), Geometry.right(text_rect));
            g2d.rotate(1.5707963267948966);
        }
    }

    @Override
    public BufferedImage getImage(Collection<Glycan> structures, boolean opaque, boolean show_masses, boolean show_redend, double scale, PositionManager posManager, BBoxManager bboxManager) {
        if (structures == null) {
            structures = new Vector<Glycan>();
        }
        GraphicOptions view_opt = this.theGraphicOptions;
        boolean old_flag = view_opt.SHOW_INFO;
        view_opt.SHOW_INFO = old_flag && scale == 1.0;
        view_opt.setScale(scale * view_opt.SCALE_CANVAS);
        Rectangle all_bbox = this.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager);
        Dimension d = this.computeSize(all_bbox);
        BufferedImage img = this.createCompatibleImage(d.width, d.height, opaque);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (opaque) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setBackground(Color.white);
            g2d.clearRect(0, 0, d.width, d.height);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setBackground(new Color(255, 255, 255, 0));
        }
        for (Glycan s : structures) {
            this.paint(new DefaultPaintable(g2d), s, null, null, show_masses, show_redend, posManager, bboxManager);
        }
        view_opt.setScale(1.0);
        view_opt.SHOW_INFO = old_flag;
        img.flush();
        return img;
    }

    public BufferedImage createCompatibleImage(int width, int height, boolean opaque) {
        if (GraphicsEnvironment.isHeadless()) {
            if (opaque) {
                return new BufferedImage(width, height, 1);
            }
            return new BufferedImage(width, height, 2);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        if (opaque) {
            return gc.createCompatibleImage(width, height);
        }
        return gc.createCompatibleImage(width, height, 2);
    }
}

